/**
 * Copyright (C), 2007-2014, eFuture 北京富基融通科技有限公司
 * FileName:	CacheUtilsMemcached.java
 * Author:		亮
 * Date:		2014-9-16 下午4:50:31
 * Description:
 * History:
 * <author>		<time>			<version>		<description>
 *
 */
package com.efuture.ocp.common.cache;


import com.efuture.ocp.common.SerializeUtil.SerializeUtil;
import net.rubyeye.xmemcached.GetsResponse;

import java.io.*;
import java.util.Date;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.LinkedTransferQueue;
import java.util.concurrent.TimeoutException;

/**
 * @author mux
 * @description
 *
 */
public class CacheUtilsInMemory extends CacheUtils implements Serializable
{

    private static final Map<String, byte[]> CACHE_MAP = new ConcurrentHashMap<String, byte[]>();
    private static final String EXPIREKEY = "_ExpireTime";

    @Override
    public String putData(String key, Object object, int timeout)
    {
        CACHE_MAP.put(key, SerializeUtil.serialize(object));
        CACHE_MAP.put(key.concat(EXPIREKEY), SerializeUtil.serialize(System.currentTimeMillis() + timeout * 1000L));
        return key;
    }

    @Override
    public Object getData(String key)
    {
        if (checkCacheName(key)) {
            return SerializeUtil.unserialize(CACHE_MAP.get(key));
        }

        return null;
    }
    @Override
    public Object getString(String key)
    {
        return null;
    }

    @Override
    public boolean deleteData(String key)
    {
        remove(key);
        return true;
    }

    @Override
    public long getCasValue(String key)
    {
        return 0;
    }

    @Override
    public GetsResponse getCasData(String key)
    {
        return null;
    }

    @Override
    public boolean putbyCas(String key, Object object, int timeout, long casvalue)
    {
        return false;
    }


    @Override
    public int deleteBatch(String key)
    {
        int result = 0;

        for (Map.Entry<String, byte[]> entry : CACHE_MAP.entrySet()) {
            if (entry.getKey().contains( key )) {
                synchronized (this) {
                    remove( entry.getKey() );
                    result ++;
                }
            }
        }

        return result;
    }

    public static void removeAll()
    {
        CACHE_MAP.clear();
    }

    public static void remove(String cacheName)
    {
        CACHE_MAP.remove(cacheName);
        CACHE_MAP.remove(cacheName.concat(EXPIREKEY));
    }

    public static boolean checkCacheName(String cacheName)
    {
        Long cacheHoldTime = (Long) SerializeUtil.unserialize(CACHE_MAP.get(cacheName.concat(EXPIREKEY)));

        if (cacheHoldTime == null || cacheHoldTime == 0L) {
            return false;
        }

        if (cacheHoldTime < System.currentTimeMillis()) {
            remove(cacheName);
            return false;
        }

        return true;
    }


}
