/**
 * Copyright (C), 2007-2014, eFuture 北京富基融通科技有限公司
 * FileName:	CacheUtilsMemcached.java
 * Author:		亮
 * Date:		2014-9-16 下午4:50:31
 * Description:
 * History:
 * <author>		<time>			<version>		<description>
 *
 */
package com.efuture.ocp.common.cache;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.util.*;
import java.util.concurrent.TimeUnit;

import com.efuture.ocp.common.util.Utils;
import com.efuture.ocp.common.util.WebPathUtils;
import net.rubyeye.xmemcached.GetsResponse;
import redis.clients.jedis.*;

import org.apache.log4j.Logger;
import org.springframework.util.StringUtils;

import com.efuture.ocp.common.SerializeUtil.SerializeUtil;


/**
 * @author 亮
 * @description
 *
 */

public class CacheUtilsRediscached extends CacheUtils implements Serializable
{
    private JedisPool jedispool;
    private String cfgFile = null;
    private int cachetime = -1;
    public Logger logger = Logger.getLogger(CacheUtilsRediscached.class);

    public CacheUtilsRediscached()
    {
        this(null);
    }

    public CacheUtilsRediscached(String config)
    {
        this(config, -1);
    }

    public CacheUtilsRediscached(String config, int cachetime)
    {
        this.cfgFile = config;
        this.cachetime = cachetime;
    }

    /**
     * 往缓存赋值
     *
     * @param key
     *            键值
     * @param object
     *            值对象
     * @param timeout
     *            超时：毫秒
     * @return
     */
    private Jedis getJedis()
    {
        if (jedispool == null) {
            try {
                jedispool = CreateJedisPool();
            }
            catch (FileNotFoundException e) {
                e.printStackTrace();
                return null;
            }
            catch (IOException e) {
                e.printStackTrace();
                return null;
            }
        }

        try {
            return jedispool.getResource();
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return null;
        }
    }
    /**
     *  返回释放Jedis
     * @param jedis
     */
    private void returnJedis(Jedis jedis)
    {
        //		if (jedis != null)
        //		{
        //			jedispool.returnResource(jedis);
        //			if(jedis != null && jedis.isConnected())
        //            {
        //			    try
        //			    {
        //			        jedis.disconnect();
        //			    }
        //			    catch (Exception ex)
        //			    {
        //			        //do Nothing
        //			    }
        //            }
        //		}
        if (jedis != null) {
            try {
                jedis.close();
            }
            catch (Exception ex) {
                //do Nothing
            }
        }
    }

    @Override
    public String putData(String key, Object object, int timeout)
    {
        Jedis jedis = getJedis();

        if (jedis == null) {
            return null;
        }

        // set
        try {
            if (timeout < 0) {
                timeout = (cachetime > 0 ? cachetime : 0);
            }

            jedis.setex( key.getBytes(), timeout, SerializeUtil.serialize( object ) );
            return key;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
        finally {
            returnJedis(jedis);
        }
    }

    /**
     * 缓存取值
     *
     * @param key
     *            键值
     * @return
     */
    @Override
    public Object getData(String key)
    {
        Jedis jedis = getJedis();

        if (jedis == null) {
            return null;
        }

        // get
        Object result = null;

        try {
            byte[] obj = jedis.get((key).getBytes());
            result = SerializeUtil.unserialize(obj);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            returnJedis(jedis);
        }

        return result;
    }
    @Override
    public Object getString(String key)
    {
        Jedis jedis = getJedis();

        if (jedis == null) {
            return null;
        }

        // get
        Object result = null;

        try {
            result = jedis.get(key);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            returnJedis(jedis);
        }

        return result;
    }

    /**
     * 缓存删除
     *
     * @param key
     *            键值
     */
    @Override
    public boolean deleteData(String key)
    {
        Jedis jedis = getJedis();

        if (jedis == null) {
            return false;
        }

        // delete
        try {
            jedis.del(key);
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
        finally {
            returnJedis(jedis);
        }

        return true;
    }

    /**
     * 创建redis缓存客户端
     *
     * @return Memcached客户端对象
     * @throws InvalidFileFormatException
     * @throws FileNotFoundException
     * @throws IOException
     */
    private synchronized JedisPool CreateJedisPool() throws FileNotFoundException, IOException
    {
        if (jedispool != null) {
            return jedispool;
        }

        if (this.config != null) {
            logger.info("Redis client is creating with configuration.");
            JedisPoolConfig poolConfig = new JedisPoolConfig();
            poolConfig.setTestOnBorrow(this.config.isRedisTestOnBorrow());
            poolConfig.setMaxTotal(this.config.getRedisMaxActive());
            poolConfig.setMaxIdle(this.config.getRedisMaxIdle());
            poolConfig.setMinIdle(this.config.getRedisMinIdle());
            poolConfig.setMaxWaitMillis(this.config.getRedisMaxWait());
            jedispool = new JedisPool(poolConfig, this.config.getRedisHost(), this.config.getRedisPort(),
                                      this.config.getRedisTimeout(), this.config.getRedisPassword(), this.config.getRedisDatabase());
            System.out.println("Redis server:" + this.config.getRedisHost() + ":" + this.config.getRedisPort());
        }
        else {
            // 取redis.ini中的redis服务器配置
            String ini = null, ini0 = null;

            if (StringUtils.isEmpty( cfgFile )) {
                String p = WebPathUtils.getWebRootClassPath();
                ini = p + "/redis.ini"; // （原来的）
                ini0 = p + "/conf/redis.ini";
                // *****************解决有的配置文件存储在/WEB-INF/classes/conf 下***********//
            }
            else {
                if (cfgFile.startsWith( "\\" ) || cfgFile.startsWith( "/" )) {
                    String p = WebPathUtils.getWebRootClassPath();
                    ini = p + cfgFile;
                    ini0 = p + "/conf" + cfgFile;
                }
                else {
                    ini = cfgFile;
                }
            }

            int maxActive = 100;
            int timeout = 5000;
            int maxIdle = 30;
            int minIdle = 10;
            boolean testOnBorrow = true;
            String host = "localhost";
            int port = 6379;
            int database = Protocol.DEFAULT_DATABASE;
            int maxWait = 5000;
            File input = new File( ini );

            // 如果classes目录下没有查找classes/conf目录
            if (ini0 != null && !input.exists()) {
                input = new File( ini0 );
            }

            logger.info( "redis.ini path:" + ini );

            if (input.exists()) {
                InputStream is = new FileInputStream( input );
                Properties p = new Properties();
                p.load( is );
                is.close();
                String sServer = Utils.getEnvValue( p.getProperty( "redis.host" ) );

                if (sServer != null) {
                    host = sServer.trim();
                }

                String smaxActive = p.getProperty( "redis.maxActive" );

                if (smaxActive != null) {
                    maxActive = Integer.parseInt( smaxActive );
                }

                String stimeout = p.getProperty( "redis.timeout" );

                if (stimeout != null) {
                    timeout = Integer.parseInt( stimeout );
                }

                String smaxIdle = p.getProperty( "redis.maxIdle" );

                if (smaxIdle != null) {
                    maxIdle = Integer.parseInt( smaxIdle );
                }

                String sminIdle = p.getProperty( "redis.minIdle" );

                if (sminIdle != null) {
                    minIdle = Integer.parseInt( sminIdle );
                }
                
                String stestOnBorrow = p.getProperty( "redis.testOnBorrow" );

                if (stestOnBorrow != null) {
                    testOnBorrow = ((stestOnBorrow != null && stestOnBorrow.equalsIgnoreCase( "false" )) ? false : true);
                }

                String sport = Utils.getEnvValue( p.getProperty( "redis.port" ) );

                if (sport != null) {
                    port = Integer.parseInt( sport );
                }

                String smaxWait = p.getProperty( "redis.maxWait" );

                if (smaxWait != null) {
                    maxWait = Integer.parseInt( smaxWait );
                }

                String password_prop = p.getProperty( "redis.password" );
                String password = Utils.getEnvValue( password_prop );

                if (password != null) {
                    password = password.trim();
                }

                String sdatabase = Utils.getEnvValue( p.getProperty( "redis.database" ) );

                if (sdatabase != null) {
                    database = Integer.parseInt( sdatabase );
                }

                //logger.info("rediscached server:" + host + ":" +sport + "(" + sdatabase + "):" + Utils.nvl(password_prop, "N/A") + "/" + Utils.nvl(password,"N/A"));
                logger.info( "rediscached server:" + host + ":" + sport + "(" + sdatabase + ")" );
                JedisPoolConfig config = new JedisPoolConfig();
                //config.setTestOnBorrow(true);
                //config.setMaxActive(maxActive);
                //config.setMaxIdle(maxIdle);
                //config.setMaxWait(maxWait);
                config.setTestOnBorrow( true );
                config.setMaxTotal( maxActive );
                config.setMaxIdle( maxIdle );
                config.setMinIdle( minIdle );
                config.setMaxWaitMillis( maxWait );
                jedispool = new JedisPool( config, host, port, timeout, password, database );
            }
            else {
                logger.warn( "redis.ini not exits!" );
                JedisPoolConfig config = new JedisPoolConfig();
                config.setTestOnBorrow( true );
                config.setMaxTotal( maxActive );
                config.setMaxIdle( maxIdle );
                config.setMinIdle( minIdle );
                config.setMaxWaitMillis( maxWait );
                jedispool = new JedisPool( config, host, port, timeout );
                System.out.println( "rediscached server-地址:" + "localhost:" + port );
            }
        }

        return jedispool;
    }

    @Override
    public long getCasValue(String key)
    {
        // TODO Auto-generated method stub
        return 0;
    }

    @Override
    public GetsResponse getCasData(String key)
    {
        return null;
    }

    @Override
    public boolean putbyCas(String key, Object object, int timeout, long casvalue)
    {
        // TODO Auto-generated method stub
        return false;
    }

    @Override
    public Map<String, Object> getBatchData(List<String> keys)
    {
        Jedis jedis = getJedis();

        if (jedis == null) {
            return null;
        }

        Map<String, Object> result = new HashMap<String, Object>();

        try {
            Pipeline pipeline = jedis.pipelined();
            pipeline.multi();
            Map<String, Response<byte[]>> resp_map = new HashMap<String, Response<byte[]>>();

            for (String key : keys) {
                resp_map.put(key, pipeline.get(key.getBytes()));
            }

            //Response<List<Object>> r = pipeline.exec();
            pipeline.exec();
            pipeline.sync();

            for (String key : keys) {
                result.put(key, SerializeUtil.unserialize(resp_map.get(key).get()));
            }

            return result;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            returnJedis(jedis);
        }

        return result;
    }

    @Override
    public boolean AddData(String key, Object object, int timeout)
    {
        Jedis jedis = getJedis();

        if (jedis == null) {
            return false;
        }

        // delete
        try {
            if ("OK".equalsIgnoreCase(jedis.set(key, object.toString(), "NX", "EX", timeout ))) {
                return true;
            }
            else {
                return false;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            return true;
        }
        finally {
            returnJedis(jedis);
        }
    }

    public Map<String, Object> getHashMap(int db, String key)
    {
        Jedis jedis = getJedis();

        if (jedis == null) {
            return null;
        }

        // get
        Map<String, Object> result = new HashMap<String, Object>();

        try {
            jedis.select( db );
            Map<String, String> val = jedis.hgetAll( key );

            for (Map.Entry e : val.entrySet()) {
                result.put( (String) e.getKey(), e.getValue() );
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            returnJedis( jedis );
        }

        return result;
    }

    @Override
    public int deleteBatch(String key)
    {
        Jedis jedis = getJedis();

        if (jedis == null) {
            return 0;
        }

        try {
            Set<String> keys = jedis.keys( key.concat( "*" ) );

            if (keys.size() <= 0) {
                return 0;
            }

            Pipeline pipeline = jedis.pipelined();
            pipeline.multi();

            for (String str : keys) {
                pipeline.del(str.getBytes());
            }

            pipeline.exec();
            pipeline.sync();
            return keys.size();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            returnJedis(jedis);
        }

        return 0;
    }

    @Override
    public Object getDataText(String key)
    {
        Jedis jedis = getJedis();

        if (jedis == null) {
            return null;
        }

        // get
        Object result = null;

        try {
            return jedis.get(key);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            returnJedis(jedis);
        }

        return result;
    }

    @Override
    public String putDataText(String key, Object object, int timeout)
    {
        Jedis jedis = getJedis();

        if (jedis == null) {
            return null;
        }

        // set
        try {
            if (timeout < 0) {
                timeout = (cachetime > 0 ? cachetime : 0);
            }

            jedis.setex( key, timeout, object.toString());
            return key;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
        finally {
            returnJedis(jedis);
        }
    }

    // 增加一种全局锁的实现，暂不支持锁重入
    public boolean tryLock(String lockKey, String lockId, int timeout, int waitTime)
    {
        Jedis jedis = getJedis();

        if (jedis == null) {
            return false;
        }

        Long start = System.currentTimeMillis();

        try {
            for (;;) {
                //SET命令返回OK ，则证明获取锁成功
                //				String lock = jedis.set(lockKey, lockId, "NX", "EX", timeout);
                //				if("OK".equalsIgnoreCase(lock))
                //				{
                //					return true;
                //				}
                // 支持重入
                String script = "if (redis.call('exists', KEYS[1]) == 0) then " +
                                "   redis.call('hset', KEYS[1], ARGV[2], 1); " +
                                "   redis.call('pexpire', KEYS[1], ARGV[1]); " +
                                "   return 0; " +
                                "end; " +
                                "if (redis.call('hexists', KEYS[1], ARGV[2]) == 1) then " +
                                "   redis.call('hincrby', KEYS[1], ARGV[2], 1); " +
                                "   redis.call('pexpire', KEYS[1], ARGV[1]); " +
                                "   return 0; " +
                                "end; " +
                                "return redis.call('pttl', KEYS[1]);";
                Object result = jedis.eval(script, Collections.singletonList(lockKey), Arrays.asList( String.valueOf(timeout * 1000), lockId ));

                if ("0".equals(result.toString())) {
                    return true;
                }

                //否则循环等待，在timeout时间内仍未获取到锁，则获取失败
                long l = System.currentTimeMillis() - start;

                if (l >= waitTime) {
                    return false;
                }

                try {
                    Thread.sleep(100);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            returnJedis(jedis);
        }

        return true;
    }

    public int releaseLock(String lockKey, int timeout, String lockId)
    {
        Jedis jedis = getJedis();

        if (jedis == null) {
            return 0;
        }

        try {
            //			String script = "if redis.call('get', KEYS[1]) == ARGV[1] then return redis.call('del', KEYS[1]) else return 0 end";
            //			Object result = jedis.eval(script, Collections.singletonList(lockKey), Collections.singletonList(lockId));
            //
            //			if ("1".equals(result.toString()))
            //			{
            //				return true;
            //			}
            //			return false;
            // 支持重入
            String script = "if (redis.call('hexists', KEYS[1], ARGV[2]) == 0) then " +
                            "   return 1; " +
                            "end; " +
                            "local counter = redis.call('hincrby', KEYS[1], ARGV[2], -1); " +
                            "if (counter > 0) then " +
                            "	redis.call('pexpire', KEYS[1], ARGV[1]); " +
                            "	return 0; " +
                            "else " +
                            "	redis.call('del', KEYS[1]); " +
                            "	return 1; " +
                            "end;" +
                            "return 1;";
            Object result = jedis.eval(script, Collections.singletonList(lockKey), Arrays.asList( String.valueOf(timeout * 1000), lockId ));
            return Integer.parseInt( result.toString() );
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            returnJedis(jedis);
        }

        return -1;
    }

}
