package com.efuture.ocp.common.component.ruleimpl;

import com.efuture.ocp.common.component.INORule;
import org.springframework.stereotype.Component;

import java.text.SimpleDateFormat;
import java.util.Map;

@Component
public class FullDayRuleImpl implements INORule {
    @Override
    public String getRuleCode() {
        return "FULLDAY";
    }

    @Override
    public String getCodeStr(String ruleCode, Map<String, Object> fields) {
        SimpleDateFormat df = new SimpleDateFormat("yyyyMMdd");
        return df.format(fields.get("NOW")).substring(0, 8);
    }
    @Override
    public boolean isDateRule() {
        return true;
    }
}

