package com.efuture.ocp.common.fileio;
import java.util.List;

import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.stereotype.Component;

import com.alibaba.fastjson.JSONObject;
import com.efuture.ocp.common.component.BasicComponentService;
import com.efuture.ocp.common.entity.ServiceResponse;
import com.efuture.ocp.common.entity.ServiceSession;
import com.efuture.ocp.common.fileio.DataImportConfigBean;

public class DataImportConfigServiceImpl extends BasicComponentService<DataImportConfigBean> {
	
	public DataImportConfigBean getConfig(long ent_id,String eid,String[] fields){
		Criteria criteria = Criteria.where("eid").is(eid).and("ent_id").is(ent_id);
		Query query = new Query(criteria);
		if (fields != null) {
			for (int i = 0; i < fields.length; i++) {
				query.fields().include(fields[i]);
			}
		}
		
		List<DataImportConfigBean> rtn = getStorageOperations().select(query, DataImportConfigBean.class);
		if(rtn != null && rtn.size() > 0){
			return rtn.get(0);
		}
		return null;
	}
	
	public List<DataImportConfigBean> getConfigByModule(long ent_id,String modulecode){
		Criteria criteria = Criteria.where("moduleid").is(modulecode).and("ent_id").is(ent_id);
		Query query = new Query(criteria);
		List<DataImportConfigBean> rtn = getStorageOperations().select(query, DataImportConfigBean.class);
		return rtn;
	}
}
