package com.efuture.ocp.common.filter;

import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.util.zip.GZIPOutputStream;

import javax.servlet.ServletOutputStream;
import javax.servlet.WriteListener;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpServletResponseWrapper;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/**
 * 调整了原gzip输出
 * 
 * @author xzw
 *
 */
public class GzipResponseWrapper extends HttpServletResponseWrapper {
	public static final Logger LOGGER = LoggerFactory.getLogger(GzipRequestWrapper.class);
	private GZIPServletOutputStream outputStream;
	private PrintWriter writer;

	public GzipResponseWrapper(HttpServletResponse request) {
		super(request);
	}

	@Override
	public synchronized ServletOutputStream getOutputStream() throws IOException {
		if (this.writer != null)
			throw new IllegalStateException("getWriter() already called.");
		if (this.outputStream == null)
			this.outputStream = new GZIPServletOutputStream(super.getOutputStream());
		return this.outputStream;
	}

	@Override
	public synchronized PrintWriter getWriter() throws IOException {
		if (this.writer == null && this.outputStream != null)
			throw new IllegalStateException("getOutputStream() already called.");
		if (this.writer == null) {
			this.outputStream = new GZIPServletOutputStream(super.getOutputStream());
			this.writer = new PrintWriter(new OutputStreamWriter(this.outputStream, "UTF-8"));
			
		}
		return this.writer;
	}

	@Override
	public void flushBuffer() throws IOException {
		if (this.writer != null)
			this.writer.flush();
		else if (this.outputStream != null)
			this.outputStream.flush();
		super.flushBuffer();
	}

	@Override
	public void setContentLength(int length) {
	}

	@Override
	public void setContentLengthLong(long length) {
	}

	@Override
	public void setHeader(String name, String value) {
		if (!"content-length".equalsIgnoreCase(name))
			super.setHeader(name, value);
	}

	@Override
	public void addHeader(String name, String value) {
		if (!"content-length".equalsIgnoreCase(name))
			super.setHeader(name, value);
	}

	@Override
	public void setIntHeader(String name, int value) {
		if (!"content-length".equalsIgnoreCase(name))
			super.setIntHeader(name, value);
	}

	@Override
	public void addIntHeader(String name, int value) {
		if (!"content-length".equalsIgnoreCase(name))
			super.setIntHeader(name, value);
	}

	public void finishResponse() throws IOException {
		if (this.writer != null)
			this.writer.close();
		else if (this.outputStream != null)
			this.outputStream.finish();
	}
	
	public class GZIPServletOutputStream extends ServletOutputStream {
		private final ServletOutputStream servletOutputStream;
		private final GZIPOutputStream gzipStream;

		public GZIPServletOutputStream(ServletOutputStream servletOutputStream) throws IOException {
			this.servletOutputStream = servletOutputStream;
			this.gzipStream = new GZIPOutputStream(servletOutputStream);
		}

		@Override
		public boolean isReady() {
			return this.servletOutputStream.isReady();
		}

		@Override
		public void setWriteListener(WriteListener writeListener) {
			this.servletOutputStream.setWriteListener(writeListener);
		}

		@Override
		public void write(int b) throws IOException {
			this.gzipStream.write(b);
		}

		@Override
		public void close() throws IOException {
			this.gzipStream.close();
		}

		@Override
		public void flush() throws IOException {
			this.gzipStream.flush();
		}

		public void finish() throws IOException {
			this.gzipStream.finish();
		}
	}
}



//package com.efuture.ocp.common.filter;
//
//import java.io.ByteArrayOutputStream;
//import java.io.IOException;
//import java.io.OutputStreamWriter;
//import java.io.PrintWriter;
//import java.util.zip.GZIPOutputStream;
//
//import javax.servlet.ServletOutputStream;
//import javax.servlet.WriteListener;
//import javax.servlet.http.HttpServletResponse;
//import javax.servlet.http.HttpServletResponseWrapper;
//
//import org.slf4j.Logger;
//import org.slf4j.LoggerFactory;
//
//public class GzipResponseWrapper extends HttpServletResponseWrapper {
//	public static final Logger LOGGER = LoggerFactory.getLogger(GzipRequestWrapper.class);
//	private HttpServletResponse response;
//
//	private GZipOutputStream gzipOutputStream;
//	private PrintWriter writer;
//
//	public GzipResponseWrapper(HttpServletResponse response) {
//		super(response);
//		this.response = response;
//	}
//
//	public ServletOutputStream getOutputStream() throws IOException {
//		if (gzipOutputStream == null)
//			gzipOutputStream = new GZipOutputStream(response);
//		return gzipOutputStream;
//	}
//
//	public PrintWriter getWriter() throws IOException {
//		if (writer == null)
//			writer = new PrintWriter(new OutputStreamWriter(new GZipOutputStream(response), "UTF-8"));
//		return writer;
//	}
//
//	// 压缩后数据长度会发生变化 因此将该方法内容置空
//	public void setContentLength(int contentLength) {
//	}
//
//	public void flushBuffer() throws IOException {
//		gzipOutputStream.flush();
//	}
//
//	public void finishResponse() throws IOException {
//		if (gzipOutputStream != null)
//			gzipOutputStream.close();
//		if (writer != null)
//			writer.close();
//	}
//
//	public class GZipOutputStream extends ServletOutputStream {
//		private HttpServletResponse response;
//		private GZIPOutputStream gzipOutputStream;
//		private ByteArrayOutputStream byteArrayOutputStream;
//
//		public GZipOutputStream(HttpServletResponse response) throws IOException {
//			this.response = response;
//			byteArrayOutputStream = new ByteArrayOutputStream();
//			gzipOutputStream = new GZIPOutputStream(byteArrayOutputStream);
//		}
//
//		public void write(int b) throws IOException {
//			gzipOutputStream.write(b);
//		}
//
//		public void close() throws IOException {
//			gzipOutputStream.finish();
//
//			byte[] content = byteArrayOutputStream.toByteArray();
//
//			response.addHeader("Content-Encoding", "gzip");
//			response.addHeader("Content-Length", Integer.toString(content.length));
//
//			ServletOutputStream out = response.getOutputStream();
//			out.write(content);
//			out.close();
//		}
//
//		public void flush() throws IOException {
//			gzipOutputStream.flush();
//		}
//
//		public void write(byte[] b, int off, int len) throws IOException {
//			gzipOutputStream.write(b, off, len);
//		}
//
//		public void write(byte[] b) throws IOException {
//			gzipOutputStream.write(b);
//		}
//
//		@Override
//		public boolean isReady() {
//			try {
//				return response.getOutputStream().isReady();
//			} catch (IOException e) {
//				throw new RuntimeException(e);
//			}
//		}
//
//		@Override
//		public void setWriteListener(WriteListener writeListener) {
//			// TODO Auto-generated method stub
//		}
//	}
//}

