package com.efuture.ocp.common.listener;

import com.alibaba.fastjson.JSONObject;
import com.efuture.ocp.common.component.OperationLogService;
import com.efuture.ocp.common.component.OperationLogServiceImpl;
import com.efuture.ocp.common.entity.AbstractEntityBean;
import com.efuture.ocp.common.util.SpringBeanFactory;
import org.springframework.stereotype.Component;
import org.springframework.transaction.event.TransactionPhase;
import org.springframework.transaction.event.TransactionalEventListener;
import org.springframework.util.StringUtils;

@Component
public class OperLogListener
{

    @TransactionalEventListener(phase = TransactionPhase.BEFORE_COMMIT)
    private void onHandleBeforeEvent(BeanChangeEvent event) throws Exception
    {
        Object source = event.getSource();
        JSONObject json = (JSONObject) source;
        String op = json.get("op").toString();
        String usercode = StringUtils.isEmpty(json.get("usercode")) ? "0" : json.get("usercode").toString();
        String username = StringUtils.isEmpty(json.get("username")) ? "0" : json.get("username").toString();
        AbstractEntityBean originalbean = (AbstractEntityBean) json.get("originalbean");
        AbstractEntityBean newbean = (AbstractEntityBean) json.get("newbean");
        String beantype = json.get("beantype").toString();
        insOperLog(op, usercode, username, originalbean, newbean, beantype);
    }

    @TransactionalEventListener(phase = TransactionPhase.AFTER_COMMIT)
    private void onHandleAfterEvent(BeanChangeEvent event) throws Exception
    {
        if (!SpringBeanFactory.containsBean("OperLogSrv")) {
            return;
        }

        OperationLogServiceImpl.getLogList().remove();
    }

    public void insOperLog(String op, String usercode, String username, AbstractEntityBean originalbean, AbstractEntityBean newbean,
                           String beantype) throws Exception
    {
        if (!check(originalbean, newbean)) {
            return;
        }

        OperationLogService operationLogSrv = SpringBeanFactory.getBean("OperLogSrv", OperationLogService.class);
        operationLogSrv.insOperLog(op, usercode, username, null, originalbean, newbean, beantype);
    }

    public boolean check(AbstractEntityBean originalbean, AbstractEntityBean newbean)
    {
        if (!SpringBeanFactory.containsBean("OperLogSrv")) {
            return false;
        }

        if (StringUtils.isEmpty(originalbean)) {
            return false;
        }

        if (StringUtils.isEmpty(newbean)) {
            return false;
        }

        return true;
    }
}
