package com.efuture.ocp.common.proxy;

import com.alibaba.fastjson.JSONObject;
import com.efuture.ocp.common.entity.AbstractEntityBean;
import com.efuture.ocp.common.util.DataUtils;
import org.springframework.data.annotation.Transient;
import org.springframework.data.mongodb.core.mapping.Document;
import org.springframework.util.StringUtils;

import java.sql.Date;

@Document(collection="sys_enterprise")
public class EnterpriseConfigBean extends AbstractEntityBean
{
    private static final long serialVersionUID = -5056542499635144654L;
    private long ent_id; 
    private String ent_name; 
    private String proxy_objects ;
    private String srv_para; 
    private long ph_key; 
    private Date ph_timestamp; 
    
    @Transient
    private String bizKey;
    
    public String getBizKey()
    {
        return bizKey;
    }
    public void setBizKey(String bizKey)
    {
        this.bizKey = bizKey;
    }
    public long getEnt_id()
    {
        return ent_id;
    }
    public void setEnt_id(long ent_id)
    {
        this.ent_id = ent_id;
    }
    public String getEnt_name()
    {
        return ent_name;
    }
    public void setEnt_name(String ent_name)
    {
        this.ent_name = ent_name;
    }
    public String getSrv_para()
    {
        return srv_para;
    }
    public void setSrv_para(String srv_para)
    {
        this.srv_para = srv_para;
    }
    public long getPh_key()
    {
        return ph_key;
    }
    public void setPh_key(long ph_key)
    {
        this.ph_key = ph_key;
    }
    public Date getPh_timestamp()
    {
        return ph_timestamp;
    }
    public void setPh_timestamp(Date ph_timestamp)
    {
        this.ph_timestamp = ph_timestamp;
    }
    public String getProxy_objects()
    {
        return proxy_objects;
    }
    public void setProxy_objects(String proxy_objects)
    {
        this.proxy_objects = proxy_objects;
    }
    
    protected String getProxyObject(String bizKey) throws Exception
    {
        JSONObject proxyObjects = JSONObject.parseObject(this.getProxy_objects());
        if (StringUtils.isEmpty(proxyObjects) || StringUtils.isEmpty(bizKey))
        {
            throw new Exception("PROXY OBJECT NOT DEFINE!");
        }
        else if (!proxyObjects.containsKey(bizKey))
        {
            if (proxyObjects.containsKey("base"))
            {
                return proxyObjects.getString("base");
            }
            else
            {
                throw new Exception("PROXY OBJECT IS NULL " + bizKey);
            }
        }
        else
        {
            return proxyObjects.getString(bizKey);
        }
    }
    
    private String getBizExcepKey(String key)
    {
        //return key.concat("_").concat(EnterpriseProxy.getInstance().getBizKey());
        return key.concat("_").concat(DataUtils.nvl(bizKey, EnterpriseProxy.getInstance().getBizKey()));
    }
    
    public String getSrvConfigVal(String key, boolean checkNull, String defValue) throws Exception
    {
        JSONObject srvConfig = JSONObject.parseObject(this.getSrv_para());
        if (StringUtils.isEmpty(srvConfig) || StringUtils.isEmpty(key) || !srvConfig.containsKey(key))
        {
            if (checkNull)
            {
                throw new Exception("PROXY CONFIG IS NULL " + key);
            }
            else
            {
                return defValue;
            }
        }
        else
        {
            return srvConfig.getString(key);
        }
    }
    
    public String getSrvConfig(String key, boolean checkNull, String defValue) throws Exception
    {
        String result = this.getSrvConfigVal(getBizExcepKey(key), false, null);
        if (StringUtils.isEmpty(result))
        {
            result = this.getSrvConfigVal(key, checkNull, defValue);
        }
        return result;
    }
    
    public String getSrvConfig(String key, boolean checkNull) throws Exception
    {
        return getSrvConfig(key, checkNull, null);
    }
    
    public String getBase_url() throws Exception
    {
        return DataUtils.nvl(this.getSrvConfig(getBizExcepKey("baseUrl"), false), getSrvConfig("baseUrl", true));
    }
    
}
