package com.efuture.ocp.common.restclientext;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.efuture.ocp.common.entity.ServiceResponse;
import com.efuture.ocp.common.entity.ServiceSession;
import com.efuture.ocp.common.exception.ServiceException;
import com.efuture.ocp.common.language.ResponseCode;
import com.efuture.ocp.common.proxy.EnterpriseConfigBean;
import com.efuture.ocp.common.cache.CacheUtils;
import com.efuture.ocp.common.rest.ServiceLogs;
import com.efuture.ocp.common.util.RestClientUtils;
import com.efuture.ocp.common.util.UniqueID;
import com.sun.jersey.api.client.Client;
import com.sun.jersey.api.client.WebResource;
import com.sun.jersey.core.util.MultivaluedMapImpl;
import org.apache.commons.lang3.StringUtils;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Component;

import javax.ws.rs.core.MultivaluedMap;
import java.io.BufferedReader;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URL;
@Lazy(true)
@Component("RestClientUtils_TianJi")
public class RestClientUtils_TianJi extends RestClientUtils
{

    public RestClientUtils_TianJi()
    {
        super();
    }

    public RestClientUtils_TianJi(int poolSize, long maxWait, String config)
    {
        super(poolSize, maxWait, config);
    }

    public RestClientUtils_TianJi(String config)
    {
        super(config);
    }

    private String getData(JSONObject json, String key, String defval)
    {
        if (json.containsKey(key)) {
            return json.getString(key);
        }
        else {
            return defval;
        }
    }

    @Override
    public ServiceResponse sendRequest(ServiceSession session, String baseUrl, JSONObject param, String dataNode) throws Exception
    {
        String urlstr = getUrl(session, baseUrl, ent.getSrvConfig("authUrl", true), ent.getSrvConfig("authKey", false), false);
        String result;

        try {
            result = PostDataLog(session, urlstr, param.toJSONString());
        }
        catch (ServiceException e) {
            ServiceLogs.errLog("", e, "PostDataLog请求失败");
            //            logger.error(e.getMessage());
            //token失效，重新获取token后再请求一次接口
            urlstr = getUrl(session, baseUrl, ent.getSrvConfig("authUrl", true), ent.getSrvConfig("authKey", false), true);
            result = PostDataLog(session, urlstr, param.toJSONString());
        }

        if (StringUtils.isEmpty(result)) {
            return ServiceResponse.buildFailure(session, ResponseCode.FAILURE, "没有返回数据!");
        }

        JSONObject ret = JSONObject.parseObject(result);
        String retcode = this.getData(ret, "code", "0");

        if (!"0000".equals(retcode)) {
            return ServiceResponse.buildFailure(session, ResponseCode.FAILURE, getData(ret, "message", "N/A"));
        }

        if (ret.containsKey(dataNode)) {
            JSONObject retData = ret.getJSONObject(dataNode);
            retcode = getData(retData, "retcode", "0");

            if (!"0".equals(retcode)) {
                return ServiceResponse.buildFailure(session, ResponseCode.FAILURE, getData(ret, "retmsg", "N/A"));
            }

            return ServiceResponse.buildSuccess(retData);
        }
        else {
            return ServiceResponse.buildFailure(session, ResponseCode.FAILURE, "没有返回数据!");
        }
    }

    public String getTokenStr(ServiceSession session, String authUrl, boolean force) throws Exception
    {
        String memKey = "TianJi" + session.getEnt_id();
        String accessToken = (String) CacheUtils.getCacheUtils().getData(memKey);
        JSONObject remote_token = new JSONObject();

        if (StringUtils.isEmpty(accessToken) || force) {
            Object result = RestClientUtils.getRestUtils().sendRequest(session, authUrl, "",
                            new RestClientUtils_TianJi.defaultRequestCallback(), "notrace");

            if (result != null) {
                remote_token = JSON.parseObject((String) result);
            }

            //            remote_token = JSONObject.parseObject(getRemoteToken(authUrl, authKey));
            if (remote_token.containsKey("access_token")) {
                accessToken = remote_token.getString("access_token");
                int expires_in = remote_token.getIntValue("expires_in");
                CacheUtils.getCacheUtils().putData(memKey, accessToken, expires_in - 10);
            }
            else {
                throw new ServiceException( ResponseCode.FAILURE, "获取代理TOKEN错误,请联系系统管理员！");
            }
        }

        return "?access_token=".concat(accessToken);
    }

    public String getUrl(ServiceSession session, String baseUrl, String authUrl, String authKey, boolean force) throws Exception
    {
        if (!StringUtils.isEmpty(authUrl)) {
            String tokenStr = getTokenStr(session, authUrl, force);
            return baseUrl.concat(tokenStr);
        }
        else {
            return baseUrl;
        }
    }

    protected String PostDataLog(ServiceSession session, String urlStr, String content) throws Exception
    {
        //        long logkey = UniqueID.getUniqueID();
        //        this.logger.info(String.format("[%d] REQUEST: %s, %s", logkey, urlStr, content));
        Object result = RestClientUtils.getRestUtils().sendRequest(session, urlStr, content,
                        new RestClientUtils_TianJi.defaultRequestCallback(), "notrace");
        //        String result = PostData(urlStr, authKey, content, encoding);
        //        this.logger.info(String.format("[%d] RESPONSE: %s", logkey, result));
        return (String) result;
    }

    //    protected String PostData(String urlStr, String authKey, String content, String encoding) throws IOException
    //    {
    //        URL url;
    //        HttpURLConnection connection = null;
    //        try
    //        {
    //            url = new URL(urlStr);
    //            connection = (HttpURLConnection) url.openConnection();
    //            connection.setConnectTimeout(10000);
    //            connection.setReadTimeout(10000);
    //            connection.setDoOutput(true);
    //            connection.setDoInput(true);
    //            connection.setRequestMethod("POST");
    //            connection.setUseCaches(false);
    //            connection.setRequestProperty("Content-Type", "application/json;charset=UTF-8");
    //            connection.setRequestProperty("Accept", "application/json");
    //            connection.connect();
    //
    //            DataOutputStream out = new DataOutputStream(connection.getOutputStream());
    //            out.write(content.getBytes(encoding));
    //            out.flush();
    //            out.close();
    //            //获取http response code
    //            int statusCode = connection.getResponseCode();
    //            //invalid_token
    //            if (statusCode == 401) {
    //                throw new ServiceException( ResponseCode.FAILURE, "当前token无效，需要重新获取！");
    //            }
    //
    //            BufferedReader reader = new BufferedReader(new InputStreamReader(connection.getInputStream(), encoding));
    //            StringBuffer buffer = new StringBuffer();
    //            String line = "";
    //            while ((line = reader.readLine()) != null)
    //            {
    //                buffer.append(line);
    //            }
    //            reader.close();
    //            return buffer.toString();
    //        } catch (IOException e)
    //        {
    //            throw e;
    //        } finally
    //        {
    //            if (connection != null)
    //            {
    //                connection.disconnect();
    //            }
    //        }
    //    }

    //    protected String getRemoteToken(String authUrl, String authKey) throws IOException
    //    {
    //        URL url;
    //        HttpURLConnection connection = null;
    //        try
    //        {
    //            url = new URL(authUrl);
    //            connection = (HttpURLConnection) url.openConnection();
    //            connection.setConnectTimeout(10000);
    //            connection.setReadTimeout(10000);
    //            connection.setDoOutput(true);
    //            connection.setDoInput(true);
    //            connection.setRequestMethod("GET");
    //            connection.setUseCaches(false);
    //            connection.setRequestProperty("Accept", "application/json");
    //            connection.connect();
    //
    //            DataOutputStream out = new DataOutputStream(connection.getOutputStream());
    //            out.flush();
    //            out.close();
    //
    //            BufferedReader reader = new BufferedReader(new InputStreamReader(connection.getInputStream(), "UTF-8"));
    //            StringBuffer buffer = new StringBuffer();
    //            String line = "";
    //            while ((line = reader.readLine()) != null)
    //            {
    //                buffer.append(line);
    //            }
    //            reader.close();
    //            return buffer.toString();
    //        } catch (IOException e)
    //        {
    //            throw e;
    //        } finally
    //        {
    //            if (connection != null)
    //            {
    //                connection.disconnect();
    //            }
    //        }
    //    }

    public class defaultRequestCallback implements requestCallback
    {
        @Override
        public Object onSend(String url, Client client, Object param) throws Exception
        {
            WebResource webResource = client.resource(url);
            MultivaluedMap<String, String> queryParams = new MultivaluedMapImpl();
            Object resp;
            resp = webResource.queryParams(queryParams)
                   .header("Content-Type", "application/json")
                   .header("Accept", "application/json")
                   .post(String.class, param);
            return resp;
        }
    }

}
