package com.efuture.ocp.common.restclientext;

import com.alibaba.fastjson.JSONObject;
import com.efuture.ocp.common.entity.ServiceResponse;
import com.efuture.ocp.common.entity.ServiceSession;
import com.efuture.ocp.common.language.ResponseCode;
import com.efuture.ocp.common.util.RestClientUtils;
import com.efuture.ocp.common.util.UniqueID;
import com.efuture.ocp.common.util.Utils;

import com.sun.jersey.api.client.Client;
import com.sun.jersey.api.client.WebResource;
import com.sun.jersey.core.util.MultivaluedMapImpl;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Component;
import org.springframework.util.StringUtils;

import javax.ws.rs.core.MultivaluedMap;
import java.io.BufferedReader;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URL;
@Lazy(true)
@Component("RestClientUtils_Wechat")
public class RestClientUtils_Wechat extends RestClientUtils
{

    public RestClientUtils_Wechat()
    {
        super();
    }

    public RestClientUtils_Wechat(int poolSize, long maxWait, String config)
    {
        super(poolSize, maxWait, config);
    }

    public RestClientUtils_Wechat(String config)
    {
        super(config);
    }

    private String getData(JSONObject json, String key, String defval)
    {
        if (json.containsKey(key)) {
            return json.getString(key);
        }
        else {
            return defval;
        }
    }

    @Override
    public ServiceResponse sendRequest(Object session, String method, Object param, String traceprex) throws Exception
    {
        String urlstr = null;

        if (!method.startsWith("http")) {
            urlstr = this.queryServiceURI(method);
        }
        else {
            urlstr = method;
        }

        urlstr = Utils.getEnvValue(urlstr);
        String result = PostDataLog(urlstr, param.toString(), "UTF-8", traceprex);
        JSONObject ret = JSONObject.parseObject(result);
        String return_code = this.getData(ret, "return_code", "FAILURE");
        String result_code = this.getData(ret, "result_code", "FAILURE");

        if ("SUCCESS".equalsIgnoreCase(return_code) && "SUCCESS".equalsIgnoreCase(result_code)) {
            return ServiceResponse.buildSuccess(ret);
        }
        else {
            return ServiceResponse.buildFailure((ServiceSession) session, ResponseCode.FAILURE, result, null);
        }
    }

    protected String PostDataLog(Object session, String urlStr, Object param, String traceprex) throws Exception
    {
        Object result = RestClientUtils.getRestUtils().sendRequest(session, urlStr, param,
                        new RestClientUtils_Wechat.defaultRequestCallback(), traceprex);
        return (String) result;
        //        if (!StringUtils.isEmpty(traceprex))
        //        {
        //            long logkey = UniqueID.getUniqueID();
        //            this.logger.info(String.format("%s [%d] REQUEST: %s, %s", traceprex, logkey, urlStr, content));
        //            String result = PostData(urlStr, content, encoding);
        //            this.logger.info(String.format("%s [%d] RESPONSE: %s", traceprex, logkey, result));
        //            return result;
        //        }
        //        else
        //        {
        //            return PostData(urlStr, content, encoding);
        //        }
    }

    public class defaultRequestCallback implements requestCallback
    {
        @Override
        public Object onSend(String url, Client client, Object param) throws Exception
        {
            WebResource webResource = client.resource(url);
            MultivaluedMap<String, String> queryParams = new MultivaluedMapImpl();
            Object resp;
            resp = webResource.queryParams(queryParams)
                   .header("Content-Type", "application/json")
                   //                    .header("Accept", "application/json")
                   .post(String.class, param);
            return resp;
        }
    }

    //    public static String PostData(String urlStr, String content, String encoding) throws IOException
    //    {
    //        URL realUrl = null;
    //        HttpURLConnection connection = null;
    //        try
    //        {
    //            realUrl = new URL(urlStr);
    //            connection = (HttpURLConnection) realUrl.openConnection();
    //            connection.setConnectTimeout(10000);
    //            connection.setReadTimeout(10000);
    //
    //            /**
    //             * Output to the connection. Default is false, set to true because post method must write something to the connection 设置是否向connection输出，因为这个是post请求，参数要放在http正文内，因此需要设为true
    //             */
    //            connection.setDoOutput(true);
    //            connection.setDoInput(true);
    //            connection.setRequestMethod("POST");
    //            //connection.setRequestProperty("Accept", "application/json"); // 设置接收数据的格式
    //            connection.setRequestProperty("Content-Type", "application/json"); // 设置发送数据的格式
    //            connection.setUseCaches(false);
    //            connection.connect();
    //
    //            DataOutputStream out = new DataOutputStream(connection.getOutputStream());
    //            out.write(content.getBytes(encoding));
    //            out.flush();
    //            out.close();
    //
    //            BufferedReader reader = new BufferedReader(new InputStreamReader(connection.getInputStream(), encoding));
    //            StringBuffer buffer = new StringBuffer();
    //            String line = "";
    //            while ((line = reader.readLine()) != null)
    //            {
    //                buffer.append(line);
    //            }
    //            reader.close();
    //            return buffer.toString();
    //        } catch (IOException e)
    //        {
    //            throw e;
    //        } finally
    //        {
    //            if (connection != null)
    //            {
    //                connection.disconnect();
    //            }
    //        }
    //    }
}
