package com.efuture.ocp.common.user;

import java.util.List;

import org.springframework.util.StringUtils;

import com.efuture.ocp.common.cache.CacheUtils;
import com.efuture.ocp.common.util.SpringBeanFactory;
import com.efuture.ocp.user.DataRange;
import com.efuture.ocp.user.UserService;
import com.efuture.ocp.user.UserTokenInfo;
/**
 * 数据范围上下文服务 
 * 根据token设置当前进程的用户和数据范围，供SQL处理时调用
 * @author zhouwudong
 *
 */
public class UserDataRangeSrv {
	//上下文 用户信息
	private static final InheritableThreadLocal<UserTokenInfo> LOCAL_USERINFO = new InheritableThreadLocal<UserTokenInfo>();
	//上下文 数据范围
	private static final InheritableThreadLocal<List<DataRange>> LOCAL_DataRange = new InheritableThreadLocal<List<DataRange>>();
	//上下文 token
	private static final InheritableThreadLocal<String> LOCAL_TOKEN = new InheritableThreadLocal<String>();
	//上下文 是否启用数据范围
	private static final InheritableThreadLocal<Boolean> LOCAL_ISRANGE = new InheritableThreadLocal<Boolean>();
	
	//上下文是否已执行过数据范围
	private static final InheritableThreadLocal<Boolean> RangeIsExec = new InheritableThreadLocal<Boolean>();

	//整个是否启用数据范围上下文服务
	private static boolean OPENRANGE;
	// 数据范围 portal key
	private static String PORTALKEY;
	// 用户服务
	private static UserService us;
	//缓存前缀
	private static final String TOKEN_MEMKEY = "OCP:TOKEN:";

	private interface PortalKey
	{
		final String CLOUD = "cloud";
		final String CONGOU = "congou";
	}

	/**
	 * 设置当前进程的TOKEN,并初始化 在rest入口调用
	 * @param token
	 */
	public static void setlocaltoken(String token) {
		LOCAL_TOKEN.set(token);
		LOCAL_DataRange.remove();
		LOCAL_USERINFO.remove();
		RangeIsExec.set(false);
		if (StringUtils.isEmpty(token)) {
			LOCAL_ISRANGE.set(false);
		} else {
			LOCAL_ISRANGE.set(true);
		}

	}

	public static boolean getlocalisrange() {
		if (!OPENRANGE)
			return OPENRANGE;
		Boolean b = LOCAL_ISRANGE.get();
		if (null == b)
			return false;
		return b;
	}

	public static boolean getRangeisexec() {
		Boolean b = RangeIsExec.get();
		if (null == b)
			return false;
		return b;
	}
	public static void setRangeisexec(boolean exec) {
		RangeIsExec.set(exec);
	}

	public static void setlocalisrange(boolean isrange) {
		LOCAL_ISRANGE.set(isrange);
	}

	public static String getlocaltoken() {
		return LOCAL_TOKEN.get();
	}

	public static UserTokenInfo getlocaluser() {
		if (!OPENRANGE)
			return null;
		return getuserinfo();
	}

	public static UserTokenInfo getuserinfo() {
		UserTokenInfo info = LOCAL_USERINFO.get();
		if (null == info) {
			String token = getlocaltoken();
			if (token.isEmpty()) {
				return null;
			}
			info = getuserinfo(token);
			LOCAL_USERINFO.set(info);
		}
		return LOCAL_USERINFO.get();
	}

	public static List<DataRange> getlocaldatarange() {
		if (!OPENRANGE)
			return null;
		List<DataRange> dr = LOCAL_DataRange.get();
		if (null == dr || dr.size() < 1) {
			UserTokenInfo info = getlocaluser();
			if (null == info) {
				return null;
			}
			dr = getDataRangeBytoken(info.getToken());
			LOCAL_DataRange.set(dr);
		}
		return dr;
	}

	public static UserTokenInfo getuserinfo(String token) {
		if (!OPENRANGE){return null;}
		if (StringUtils.isEmpty(token)){ return null;}
		String key = TOKEN_MEMKEY + token;
		//UserTokenInfo info = (UserTokenInfo) CacheUtils.getCacheUtils().getData(key);
		UserTokenInfo info = null;
		if (!PORTALKEY.equalsIgnoreCase(PortalKey.CLOUD))
		{
			info = (UserTokenInfo) CacheUtils.getCacheUtils().getData(key);
		}
		
		if (null == info) {
			UserService us = getServerSrv();
			info = us.getuserinfo(token);
			if (null == info)
			{
				return null;
			}
			// CLOUD 模式的缓存，在对应的对象中获取
			if (!PORTALKEY.equalsIgnoreCase(PortalKey.CLOUD))
			{
				CacheUtils.getCacheUtils().putData( key, info, CacheUtils.CacheTimeOut.Day );
			}
		}
		return info;
	}

	private static UserService getServerSrv() {
		if (null == us) {
//			String protalKey = EnvironmentParaUtils.getEnvPra("com.efuture.portalkey", "");
			// String userService = userService_cloud
			String userService = "UserServerSrv_" + PORTALKEY;
			System.out.println("portalkey:".concat(PORTALKEY));
			System.out.println("userService:".concat(userService));
			if (SpringBeanFactory.containsBean(userService)) {
				us = SpringBeanFactory.getBean(userService, UserService.class);
			} else {
				us = SpringBeanFactory.getBean("UserServerSrv", UserService.class);
			}

		}
		return us;
	}

	public static List<DataRange> getDataRangeBytoken(String token) {
		if (!OPENRANGE) { return null;}
		UserTokenInfo info = getuserinfo(token);
		if (null == info) { return null;}
		return info.getDatarange();
	}

	public static boolean isOpenrange() {
		return OPENRANGE;
	}

	public static void setOpenrange(boolean openrange) {
		OPENRANGE = openrange;
	}

	public static String getPortalkey() {
		return PORTALKEY;
	}

	public static void setPortalkey(String portalkey) {
		UserDataRangeSrv.PORTALKEY = portalkey;
	}

}
