package com.efuture.ocp.common.util;

import org.apache.commons.lang3.StringUtils;
import org.springframework.context.EnvironmentAware;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.env.Environment;

@Configuration
public class EnviromentUtil implements EnvironmentAware {

	private static Environment environment;

	@Override
	public void setEnvironment(Environment environment) {
		EnviromentUtil.environment = environment;
	}

	public static String getProperty(String key) {

		return EnviromentUtil.environment.getProperty(key);
	}

	public static String getProperty(String key, String defaultValue) {
		String propertyValue = EnviromentUtil.environment.getProperty(key);
		if (StringUtils.isEmpty(propertyValue))
			return defaultValue;
		else
			return propertyValue;
	}
}
