package com.efuture.ocp.common.component.excel;

import com.alibaba.fastjson.JSONObject;
import com.efuture.ocp.common.annotation.AutoCache;
import com.efuture.ocp.common.component.MasterSlaveComponent;
import org.springframework.stereotype.Component;
import org.springframework.util.StringUtils;

import java.util.List;

@Component
public class ModuleImpConfigServiceImpl extends MasterSlaveComponent<ModuleImpConfigHeadBean>
{
    public ModuleImpConfigServiceImpl()
    {
        super();
        this.setStorageOperation_other("GlobalStorageOperation");
    }

    /**
     * 获取模板导入导出配置
     *
     * @param ent_id
     * @param eid
     * @return
     * @throws Exception
     */
    @AutoCache(Readable = true)
    public ModuleImpConfigHeadBean getModuleImpConfig(long ent_id, String eid) throws Exception
    {
        JSONObject json = new JSONObject();
        json.put("ent_id", ent_id);
        json.put("eid", eid);
        json.put("status", "Y");
        ModuleImpConfigHeadBean head = doSearchOne(json, ModuleImpConfigHeadBean.class);
        return head;
    }

    /**
     * 获取模板导入导出配置
     *
     * @param ent_id
     * @param eid
     * @return
     * @throws Exception
     */
    @AutoCache(Readable = true)
    public ModuleImpConfigHeadBean getModuleImpConfig(long ent_id, String eid, String moduleid) throws Exception
    {
        JSONObject json = new JSONObject();
        json.put("ent_id", ent_id);

        if (!StringUtils.isEmpty(eid)) {
            json.put("eid", eid);
        }

        json.put("moduleid", moduleid);
        json.put("status", "Y");
        ModuleImpConfigHeadBean head = doSearchOne(json, ModuleImpConfigHeadBean.class);
        return head;
    }

    public List<ModuleImpConfigHeadBean> getModuleImpConfigList(long ent_id, String moduleid) throws Exception
    {
        JSONObject json = new JSONObject();
        json.put("ent_id", ent_id);
        json.put("moduleid", moduleid);
        json.put("status", "Y");
        json.put("page_size", 0);
        StringBuffer total = new StringBuffer();
        List<ModuleImpConfigHeadBean> list = doSearch(json, ModuleImpConfigHeadBean.class, total);
        return list;
    }
}
