package com.efuture.ocp.common.datasync;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.data.mongodb.core.query.Update;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.StringUtils;

import com.alibaba.fastjson.JSONObject;
import com.efuture.ocp.common.component.BasicComponent;
import com.efuture.ocp.common.entity.AbstractEntityBean;
import com.efuture.ocp.common.util.SpringBeanFactory;
import com.efuture.ocp.common.util.UniqueID;
import com.efuture.omd.storage.FStorageOperations;

public class DxpDataSync extends BasicComponent implements DataSyncService
{
    private Map<String, Map<String, Object>> cmdconfig = new HashMap<String, Map<String, Object>>();

    private boolean ibinit = false;
    private boolean initerror = false;
    private boolean ibcanuse = false;

    public boolean isIbcanuse()
    {
        return ibcanuse;
    }

    public void setIbcanuse(boolean ibcanuse)
    {
        this.ibcanuse = ibcanuse;
    }

    private synchronized void init()
    {
        try
        {
            if (!ibinit)
            {
                Criteria criteria = Criteria.where("1").is("1");
                Query query = new Query(criteria);
                List<Map<String, Object>> list = this.getStorageOperations().select(query, "trans_cmddef");
                for (int i = 0; i < list.size(); i++)
                {
                    String cmdid = (String) list.get(i).get("cmdid");
                    cmdconfig.put(cmdid, list.get(i));
                }
                ibinit = true;
            }
        }
        catch (Exception e)
        {
            initerror = true;
            this.getLogger().error("初始化数据同步参数错误->" + e.getMessage());
        }

    }

    /**
     * @param bean
     * @throws IllegalArgumentException
     * @throws IllegalAccessException
     * @see com.efuture.ocp.common.datasync.DataSyncService#sync(com.efuture.ocp.common.entity.AbstractEntityBean)
     */
    @Override
    @Transactional(propagation = Propagation.REQUIRED)
    public void sync(AbstractEntityBean bean) throws IllegalArgumentException, IllegalAccessException
    {
        if (!ibcanuse) return;
        // 找表名
        String tablename = AbstractEntityBean.fetchAnnotationTableName(bean.getClass());
        sync(bean, tablename);
    }

    /**
     * @param bean
     * @param cmdid
     * @throws IllegalArgumentException
     * @throws IllegalAccessException
     * @see com.efuture.ocp.common.datasync.DataSyncService#sync(com.efuture.ocp.common.entity.AbstractEntityBean,
     *      java.lang.String)
     */
    @Override
    @Transactional(propagation = Propagation.REQUIRED)
    public void sync(AbstractEntityBean bean, String cmdid) throws IllegalArgumentException, IllegalAccessException
    {
        if (!ibcanuse) return;
        if (findCmdConfig(cmdid, "keycol") == null) { return; }
        String keycols = findCmdConfig(cmdid, "keycol").toString();
        if (StringUtils.isEmpty(keycols)) { return; }
        java.lang.reflect.Field fld = bean.fetchDeclaredField(keycols);
        Object value = fld.get(bean);
        String keyvalue = null;
        if (!StringUtils.isEmpty(value))
        {
            keyvalue = value.toString();
        }

        sync(keyvalue, cmdid);
    }

    /**
     * @param keyvalue
     * @param cmdid
     * @see com.efuture.ocp.common.datasync.DataSyncService#sync(java.lang.String,
     *      java.lang.String)
     */
    @Override
    @Transactional(propagation = Propagation.REQUIRED)
    public void sync(String keyvalue, String cmdid)
    {
        if (!ibcanuse) return;
        // 找到要表对应有没有同步命令，有则同步，没有则不同步
        Map<String, Object> cmdconfig = findCmdConfig(cmdid);
        if (cmdconfig == null) { return; }
        if (StringUtils.isEmpty(keyvalue)) { return; }
        List<String> targets = getTargets(cmdconfig, keyvalue);
        if (targets.size() <= 0) { return; }
        // 根据配置，生成dxs同步命令
        DxpTransReq req = createReq(cmdconfig, keyvalue);
        // 插入命令
        insertcmd(req, targets);
    }

    private void insertcmd(DxpTransReq req, List<String> targets)
    {
        List<Map<String, Object>> reqitem = req.getItems();
        JSONObject reqjson = (JSONObject) JSONObject.toJSON(req);
        reqjson.remove("items");
        for (int i = 0; i < targets.size(); i++)
        {
            req.setTargetid(targets.get(i));
            reqjson.put("targetid", targets.get(i));
            insertcmd(reqjson, reqitem);
        }
    }

    /**
     * 得到序列ID
     * 
     * @description
     * @param key
     * @return
     */
    @Transactional(propagation = Propagation.REQUIRES_NEW)
    public int getId(String key)
    {
        FStorageOperations fso = getStorageOperations();
        Criteria criteria = Criteria.where("term").is(key);
        Query query = new Query(criteria);
        Update upt = new Update();
        upt.set("term", key);
        int rtnid = 0;
        if (fso.update(query, upt, "trans_next_value") <= 0)
        {
            Map<String, Object> data = new HashMap<String, Object>();
            data.put("term", key);
            rtnid = rtnid + 1;
            data.put("next_value", rtnid);
            fso.insert(data, "trans_next_value");
        }
        else
        {
            Map<String, Object> map = fso.selectOne(query, "trans_next_value");
            rtnid = (Integer) map.get("next_value");
            rtnid = rtnid + 1;
            upt = new Update();
            upt.set("next_value", rtnid);
            fso.update(query, upt, "trans_next_value");
        }
        return rtnid;
    }

    private void insertcmd(JSONObject req, List<Map<String, Object>> items)
    {
        FStorageOperations fso = getStorageOperations();
        DxpDataSync dds = SpringBeanFactory.getBean("efuture.com.datasync", DxpDataSync.class);
        long reqid = dds.getId("term");
        req.put("reqid", reqid);
        fso.insert(req, "trans_req");
        for (Map<String, Object> map : items)
        {
            map.put("reqid", reqid);
            fso.insert(map, "trans_reqitems");
        }
    }

    /**
     * 查找要分片的其他的发送节点 需要自定义
     * 
     * @description
     * @param cmdconfig
     * @param bean
     * @return
     */
    private List<String> findOtherTargets(Map<String, Object> cmdconfig, String keyvalue)
    {
        if (cmdconfig.get("targetsobj") == null) { return null; }
        String objname = cmdconfig.get("targetsobj").toString();
        if (StringUtils.isEmpty(objname)) { return null; }
        FindTargets obj = null;
        List<String> rtn = null;
        // 按分类创建模型对象
        if (SpringBeanFactory.containsBean(objname))
        {
            obj = SpringBeanFactory.getBean(objname, FindTargets.class);
            rtn = obj.find(cmdconfig, keyvalue);
        }
        return rtn;
    }

    /**
     * 得到要发送的节点列表
     * 
     * @description
     * @param cmdconfig
     * @param bean
     * @return
     */
    public List<String> getTargets(Map<String, Object> cmdconfig, String keyvalue)
    {
        // 查找默认的配置targetid
        String[] targets = cmdconfig.get("targets").toString().split(",");
        List<String> rtn = Arrays.asList(targets);
        // 查找其他要发送的节点
        List<String> others = findOtherTargets(cmdconfig, keyvalue);
        if (others != null && others.size() > 0)
        {
            rtn.addAll(others);
        }
        return rtn;

    }

    private String concat(Object src, String para)
    {
        if (!StringUtils.isEmpty(src))
        {
            String rtn = src.toString().trim() + para;
            return rtn;
        }
        else
        {
            return null;
        }

    }

    /**
     * 生成命令
     * 
     * @description
     * @param cmdConfig
     * @param keyvalue
     * @param targetid
     */
    private DxpTransReq createReq(Map<String, Object> cmdConfig, String keyvalue)
    {
        String keystr;
        if (StringUtils.isEmpty(keyvalue))
        {
            keystr = "()";
        }
        else
        {
            keystr = "('" + keyvalue + "')";
        }
        Date now = new Date();
        String OPSql = concat(cmdConfig.get("opsql"), keystr);
        String OASql = concat(cmdConfig.get("oasql"), keystr);
        String IPSql = concat(cmdConfig.get("ipsql"), keystr);
        String IASql = concat(cmdConfig.get("iasql"), keystr);
        DxpTransReq req = new DxpTransReq();
        req.setReqtype(Integer.parseInt(cmdConfig.get("reqtype").toString()));
        req.setReqdate(now);
        req.setSheettype(cmdConfig.get("sheettype").toString());
        req.setLocaltype(cmdConfig.get("localtype").toString());
        req.setExecuteflag(0);
        req.setOpsql(OPSql);
        req.setOasql(OASql);
        req.setIpsql(IPSql);
        req.setIasql(IASql);
        req.setDescription(cmdConfig.get("cmdname").toString());
        req.setCmdid(cmdConfig.get("cmdid").toString());

        req.setKeyvalue(keyvalue);
        String[] fromTables = cmdConfig.get("fromtables").toString().split(",");
        String[] toTables = cmdConfig.get("totables").toString().split(",");
        String[] keyCols = cmdConfig.get("fromkeycols").toString().split(",");
        List<Map<String, Object>> itemlist = new ArrayList<Map<String, Object>>();
        for (int i = 0; i < fromTables.length; i++)
        {
            String ft = fromTables[i];
            String tt = toTables[i];
            String col = keyCols[i];
            String sql = "select * from " + ft + "";
            if (!StringUtils.isEmpty(keyvalue))
            {
                sql = sql + " where " + col + " = '" + keyvalue + "'";
            }
            Map<String, Object> map = new HashMap<String, Object>();
            map.put("id", i + 1);
            map.put("nodename", tt);
            map.put("outsql", sql);
            itemlist.add(map);
        }
        req.setItems(itemlist);
        return req;
    }

    private Object findCmdConfig(String cmdid, String configkey)
    {
        Map<String, Object> config = findCmdConfig(cmdid);
        if (config == null) { return null; }
        return config.get(configkey);
    }

    /**
     * 查找命令配置
     * 
     * @description
     * @param tablename
     * @return
     */
    private Map<String, Object> findCmdConfig(String cmdid)
    {
        return getCmdconfig().get(cmdid.toUpperCase());
    }

    /**
     * 得到命令列表
     * 
     * @description
     * @return
     */
    public Map<String, Map<String, Object>> getCmdconfig()
    {
        if (initerror) return cmdconfig;
        if (!ibinit)
        {
            init();
        }
        return cmdconfig;
    }

}
