package com.efuture.ocp.common.distributedLock;

public interface DistributedLockHandle {

	/**
	 * 获取分布式锁
	 *
	 * @param key
	 *            锁Key
	 * @param lockExpire
	 *            锁的缓存时间（单位：秒）
	 * @param waitMillSeconds
	 * @return boolean
	 */
	boolean tryLock(String key, int lockExpire, int waitMillSeconds);

	/**
	 * 释放锁
	 *
	 * @param key
	 *            锁Key
	 */
	boolean unlock(String key, int lockExpire);
	boolean unlock(String key);
	/**
	 * 强制解锁
	 * @param key
	 * @author 肖志文
	 * 2020年10月29日 上午10:48:04
	 */
	boolean forceUnlock(String key);

}
