/**
 * Copyright (C), 2007-2014, eFuture 北京富基融通科技有限公司
 * FileName:	ServiceReturn.java
 * Author:		亮
 * Date:		2014-3-27 下午4:36:10
 * Description:	
 * History:
 * <author>		<time>			<version>		<description>
 * 
 */
package com.efuture.ocp.common.entity;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;

import com.alibaba.fastjson.JSONObject;
import com.efuture.ocp.common.language.MessageSourceHelper;
import com.efuture.ocp.common.language.ResponseCode;



/**
 * @author		亮
 * @description	API应答
 * 
 */
public class ServiceResponse  implements Serializable
{
	String returncode;
	Object data;
	
	// 辅助信息
	List<String> elapsed;
	List<String> warnmsg;

    String logkey;

	/**
	 * @return returncode
	 */
	public String getReturncode()
	{
		return returncode;
	}

    /**
	 * @param returncode 要设置的 returncode
	 */
	public void setReturncode(String returncode)
	{
		this.returncode = returncode;
	}
	/**
	 * @return data
	 */
	public Object getData()
	{
		return data;
	}

	/**
	 * @param respdata 要设置的 data
	 */
	public void setData(Object data)
	{
		this.data = data;
	}

    /**
     * @return elapsed
     */
    public List<String> getElapsed()
    {
        return elapsed;
    }

    /**
     * @param elapsed 要设置的 elapsed
     */
    public void setElapsed(List<String> elapsed)
    {
        this.elapsed = elapsed;
    }

    public void addElapsed(String msg,long start_time,long end_time)
    {
        if (this.elapsed == null) this.elapsed = new ArrayList<String>();
        this.elapsed.add(msg+": " + (end_time - start_time) + " ms");
    }

    /**
     * @return warnmsg
     */
    public List<String> getWarnmsg()
    {
        return warnmsg;
    }

    /**
     * @param warnmsg 要设置的 warnmsg
     */
    public void setWarnmsg(List<String> warnmsg)
    {
        this.warnmsg = warnmsg;
    }
    public void addWarnmsg(String msg,Object... args)
    {
        if (this.warnmsg == null) this.warnmsg = new ArrayList<String>();
        warnmsg.add(MessageSourceHelper.formatMessage(msg,args));
    }

    //////////////////////////////////////////////////////////////

    public static ServiceResponse buildSuccess(Object obj)
    {
        ServiceResponse response = new ServiceResponse();
        response.setReturncode(ResponseCode.SUCCESS);
        response.setData(obj);
        return response;
    }
	public static ServiceResponse buildFailure(ServiceSession session, String returncode)
	{
	    return buildFailure(session,returncode,null);
	}

	public static ServiceResponse buildFailure(ServiceSession session, String returncode, String formatmsg, Object... args)
    {
        ServiceResponse response = new ServiceResponse();

        response.setReturncode(returncode);
        response.setData(MessageSourceHelper.getDefault().getMessage(returncode, formatmsg,
                         session != null && session.getLocale() != null ? new Locale(session.getLocale()) : null,args));
        return response;
    }

	public static ServiceResponse buildFailure_ex(ServiceSession session, String returncode, String formatmsg, Object... args)
    {
        ServiceResponse response = new ServiceResponse();

        response.setReturncode(returncode);
        String msg = MessageSourceHelper.getDefault().getMessage(returncode, formatmsg,
                session != null && session.getLocale() != null ? new Locale(session.getLocale()) : null,args);
        JSONObject json = new JSONObject();
        json.put("errMsg",msg);
        response.setData(json);
        return response;
    }


    public String getLogkey()
    {
        return logkey;
    }

    public void setLogkey(String logkey)
    {
        this.logkey = logkey;
    }
}
