package com.efuture.ocp.common.component.excel;

import com.efuture.ocp.common.billservice.BillAbstractBean;
import org.springframework.data.annotation.Transient;
import org.springframework.data.mongodb.core.mapping.Document;

import java.util.List;
import java.util.Map;

@Document(collection = ("moduleimpconfighead"))
public class ModuleImpConfigHeadBean extends BillAbstractBean {
    static final String ID_KEY = "ph_key";
    static final String[] UNIQUE_KEYS = new String[] { "eid,moduleid" };
    static final Map<String, Object> DEPENDENCY = null;
    static final String MASTER_SLAVE_KEY = "eid";

    String eid;//代码
    String ename;//名称
    String temptable;
    String workservice;
    String multithread;
    String esubmit;//出错时，是否部分提交（Y-成功直接insert，失败记错误日志，N-失败达到一定行数停止校验）
    String uniquecolumn;//唯一列(多字段以逗号分隔)
    String isnorepeatfield;//不允许重复列(多字段以逗号分隔)
    String status;//状态
    String isbilldet;//是否单据
    String moduleid;//模块号
    String tiprowcol;//提示行号列

    @Transient
    private List<ModuleImpConfigDetBean> moduleimpconfigdet;

    public String getEid() {
        return eid;
    }

    public void setEid(String eid) {
        this.eid = eid;
    }

    public String getEname() {
        return ename;
    }

    public void setEname(String ename) {
        this.ename = ename;
    }

    public String getTemptable() {
        return temptable;
    }

    public void setTemptable(String temptable) {
        this.temptable = temptable;
    }

    public String getWorkservice() {
        return workservice;
    }

    public void setWorkservice(String workservice) {
        this.workservice = workservice;
    }

    public String getMultithread() {
        return multithread;
    }

    public void setMultithread(String multithread) {
        this.multithread = multithread;
    }

    public String getEsubmit() {
        return esubmit;
    }

    public void setEsubmit(String esubmit) {
        this.esubmit = esubmit;
    }

    @Override
    public String getStatus() {
        return status;
    }

    @Override
    public void setStatus(String status) {
        this.status = status;
    }

    public String getIsbilldet() {
        return isbilldet;
    }

    public void setIsbilldet(String isbilldet) {
        this.isbilldet = isbilldet;
    }

    public String getModuleid() {
        return moduleid;
    }

    public void setModuleid(String moduleid) {
        this.moduleid = moduleid;
    }

    public String getIsnorepeatfield() {
        return isnorepeatfield;
    }

    public void setIsnorepeatfield(String isnorepeatfield) {
        this.isnorepeatfield = isnorepeatfield;
    }

    public String getUniquecolumn() {
        return uniquecolumn;
    }

    public void setUniquecolumn(String uniquecolumn) {
        this.uniquecolumn = uniquecolumn;
    }

    public String getTiprowcol() {
        return tiprowcol;
    }

    public void setTiprowcol(String tiprowcol) {
        this.tiprowcol = tiprowcol;
    }

    public List<ModuleImpConfigDetBean> getModuleimpconfigdet() {
        return moduleimpconfigdet;
    }

    public void setModuleimpconfigdet(List<ModuleImpConfigDetBean> moduleimpconfigdet) {
        this.moduleimpconfigdet = moduleimpconfigdet;
    }
}
