package com.efuture.ocp.common.util;

import com.alibaba.fastjson.JSONObject;
import org.apache.commons.httpclient.HttpStatus;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.NameValuePair;
import org.apache.http.StatusLine;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.protocol.HTTP;
import org.apache.http.util.EntityUtils;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;

import javax.net.ssl.HttpsURLConnection;
import java.io.*;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

/**
 * @author 穆轩 用于HTTP访问的封装
 * @date 2018/02/13
 */
public class HttpUtils {

	public static String getFullURL(JSONObject para) {
		String result = null;

		for (String key : para.keySet()) {
			if (StringUtils.isEmpty(result)) {
				result = key.concat("=").concat(para.getString(key));
			} else {
				result = result.concat("&").concat(key).concat("=").concat(para.getString(key));
			}
		}

		return result;
	}

	public static String getRequest(String url) throws Exception {
		BufferedReader in = null;
		try {
			URL realUrl = new URL(Utils.getEnvValue(url));
			// 打开和URL之间的连接
			URLConnection connection = realUrl.openConnection();
			// 设置通用的请求属性
			connection.setRequestProperty("accept", "*/*");
			connection.setRequestProperty("connection", "Keep-Alive");
			connection.setRequestProperty("user-agent", "Mozilla/4.0 (compatible; MSIE 6.0; Windows NT 5.1;SV1)");
			connection.setConnectTimeout(5000);
			connection.setReadTimeout(5000);
			// 建立实际的连接
			connection.connect();
			// 定义 BufferedReader输入流来读取URL的响应
			in = new BufferedReader(new InputStreamReader(connection.getInputStream()));
			StringBuffer sb = new StringBuffer();
			String line;
			while ((line = in.readLine()) != null) {
				sb.append(line);
			}
			return sb.toString();
		} catch (Exception e) {
			throw e;
		}
		// 使用finally块来关闭输入流
		finally {
			try {
				if (in != null) {
					in.close();
				}
			} catch (Exception e2) {
				e2.printStackTrace();
			}
		}
	}

	public static String postRequest(String url, String content, String encoding) throws IOException {
		URL realUrl = null;
		HttpURLConnection connection = null;
		try {
			realUrl = new URL(Utils.getEnvValue(url));
			connection = (HttpURLConnection) realUrl.openConnection();
			connection.setConnectTimeout(10000);
			connection.setReadTimeout(10000);

			/**
			 * Output to the connection. Default is false, set to true because
			 * post method must write something to the connection
			 * 设置是否向connection输出，因为这个是post请求，参数要放在http正文内，因此需要设为true
			 */
			connection.setDoOutput(true);
			connection.setDoInput(true);
			connection.setRequestMethod("POST");
			// 设置接收数据的格式
			connection.setRequestProperty("Accept", "application/json");
			// 设置发送数据的格式
			connection.setRequestProperty("Content-Type", "application/json");

			connection.setUseCaches(false);
			connection.connect();

			DataOutputStream out = new DataOutputStream(connection.getOutputStream());
			out.write(content.getBytes(encoding));
			out.flush();
			out.close();

			BufferedReader reader = new BufferedReader(new InputStreamReader(connection.getInputStream(), encoding));
			StringBuffer buffer = new StringBuffer();
			String line = "";
			while ((line = reader.readLine()) != null) {
				buffer.append(line);
			}
			reader.close();
			return buffer.toString();
		} catch (IOException e) {
			throw e;
		} finally {
			if (connection != null) {
				connection.disconnect();
			}
		}
	}

//	=  =P~ 2019.05.07 xml格式
	public static String postRequestxml(String urlStr, String content, String encoding_send,String encoding_return) throws IOException {
		URL realUrl = null;
		HttpURLConnection connection = null;
		try {
			realUrl = new URL(Utils.getEnvValue(urlStr));
			connection = (HttpURLConnection) realUrl.openConnection();
			connection.setConnectTimeout(30000);
			connection.setReadTimeout(30000);

			/**
			 * Output to the connection. Default is false, set to true because
			 * post method must write something to the connection
			 * 设置是否向connection输出，因为这个是post请求，参数要放在http正文内，因此需要设为true
			 */
			connection.setDoOutput(true);
			connection.setDoInput(true);
			connection.setRequestMethod("POST");
			// 设置接收数据的格式
			connection.setRequestProperty("Accept", "text/xml");
			// 设置发送数据的格式
			connection.setRequestProperty("Content-Type", "text/xml");

			connection.setUseCaches(false);
			connection.connect();

			DataOutputStream out = new DataOutputStream(connection.getOutputStream());
			out.write(content.getBytes(encoding_send));
			out.flush();
			out.close();

			BufferedReader reader = new BufferedReader(new InputStreamReader(connection.getInputStream(), encoding_return));
			StringBuffer buffer = new StringBuffer();
			String line = "";
			while ((line = reader.readLine()) != null) {
				buffer.append(line);
			}
			reader.close();
			return buffer.toString();
		} catch (IOException e) {
			throw e;
		} finally {
			if (connection != null) {
				connection.disconnect();
			}
		}
	}


	public static String postRequest(String url, String content, String auth, String encoding) throws IOException {
		URL realUrl = null;
		HttpsURLConnection connection = null;
		try {
			realUrl = new URL(Utils.getEnvValue(url));
			connection = (HttpsURLConnection) realUrl.openConnection();
			connection.setConnectTimeout(10000);
			connection.setReadTimeout(10000);

			/**
			 * Output to the connection. Default is false, set to true because
			 * post method must write something to the connection
			 * 设置是否向connection输出，因为这个是post请求，参数要放在http正文内，因此需要设为true
			 */
			connection.setDoOutput(true);
			connection.setDoInput(true);
			connection.setRequestMethod("POST");
			// 设置接收数据的格式
			connection.setRequestProperty("Accept", "application/json");
			// 设置发送数据的格式
			connection.setRequestProperty("Content-Type", "application/json");
			// 设置Authorization认证
			connection.setRequestProperty("Authorization", auth);
			connection.setUseCaches(false);
			connection.connect();

			DataOutputStream out = new DataOutputStream(connection.getOutputStream());
			out.write(content.getBytes(encoding));
			out.flush();
			out.close();

			BufferedReader reader = new BufferedReader(new InputStreamReader(connection.getInputStream(), encoding));
			StringBuffer buffer = new StringBuffer();
			String line = "";
			while ((line = reader.readLine()) != null) {
				buffer.append(line);
			}
			reader.close();
			return buffer.toString();
		} catch (IOException e) {
			throw e;
		} finally {
			if (connection != null) {
				connection.disconnect();
			}
		}
	}

	public static String postRequestHttp(String url, String content, String auth, String encoding) throws IOException {
		URL realUrl = null;
		HttpURLConnection connection = null;
		try {
			realUrl = new URL(Utils.getEnvValue(url));
			connection = (HttpURLConnection) realUrl.openConnection();
			connection.setConnectTimeout(10000);
			connection.setReadTimeout(10000);

			/**
			 * Output to the connection. Default is false, set to true because
			 * post method must write something to the connection
			 * 设置是否向connection输出，因为这个是post请求，参数要放在http正文内，因此需要设为true
			 */
			connection.setDoOutput(true);
			connection.setDoInput(true);
			connection.setRequestMethod("POST");
			// 设置接收数据的格式
			connection.setRequestProperty("Accept", "application/json");
			// 设置发送数据的格式
			connection.setRequestProperty("Content-Type", "application/json");
			// 设置Authorization认证
			connection.setRequestProperty("Authorization", auth);
			connection.setUseCaches(false);
			connection.connect();

			DataOutputStream out = new DataOutputStream(connection.getOutputStream());
			out.write(content.getBytes(encoding));
			out.flush();
			out.close();

			BufferedReader reader = new BufferedReader(new InputStreamReader(connection.getInputStream(), encoding));
			StringBuffer buffer = new StringBuffer();
			String line = "";
			while ((line = reader.readLine()) != null) {
				buffer.append(line);
			}
			reader.close();
			return buffer.toString();
		} catch (IOException e) {
			throw e;
		} finally {
			if (connection != null) {
				connection.disconnect();
			}
		}
	}

	public static JSONObject postRequestWithAuthorization(String url, Map map, String Authorization, String[] fields) throws IOException, DocumentException {
		// POST的URL
		JSONObject json = new JSONObject();
		try {
			BufferedReader in = null;
			StringBuffer sb = new StringBuffer("");
			HttpPost httppost = new HttpPost(Utils.getEnvValue(url));
			httppost.addHeader("Authorization", Authorization);
			// 建立HttpPost对象
			List<NameValuePair> params = new ArrayList<NameValuePair>();
			// 建立一个NameValuePair数组，用于存储欲传送的参数
			for (Iterator iter = map.keySet().iterator(); iter.hasNext();) {
				String name = (String) iter.next();
				String value = String.valueOf(map.get(name));
				params.add(new BasicNameValuePair(name, value));
			}

			// 添加参数

			httppost.setEntity(new UrlEncodedFormEntity(params, HTTP.UTF_8));

			// 设置编码
			HttpResponse response = new DefaultHttpClient().execute(httppost);
			// 发送Post,并返回一个HttpResponse对象
			if (response.getStatusLine().getStatusCode() == 200) {// 如果状态码为200,就是正常返回
				// String result = EntityUtils.toString(response.getEntity());
				in = new BufferedReader(new InputStreamReader(response.getEntity().getContent(), "utf-8"));

				String line = "";
				String NL = System.getProperty("line.separator");
				while ((line = in.readLine()) != null) {
					sb.append(line + NL);
				}

				in.close();
				System.out.println(sb.toString());

			}
			Document document = DocumentHelper.parseText(sb.toString());
			Element rootElt = document.getRootElement();
			for (String filed : fields) {
				json.put(filed, rootElt.elementText(filed));
			}

			return json;
		} catch (UnsupportedEncodingException e) {
			// TODO Auto-generated catch block
			throw e;
		} catch (IOException e) {
			// TODO Auto-generated catch block
			throw e;
		} catch (DocumentException e) {
			// TODO Auto-generated catch block
			throw e;
		}

	}

	public static String doPost(String url, String params, String auth) throws Exception {

		CloseableHttpClient httpclient = new DefaultHttpClient();
		HttpPost httpPost = new HttpPost(Utils.getEnvValue(url));// 创建httpPost
		httpPost.setHeader("Accept", "application/json");
		httpPost.setHeader("Content-Type", "application/json");
		httpPost.setHeader("Authorization", auth);
		String charSet = "UTF-8";
		StringEntity entity = new StringEntity(params, charSet);
		httpPost.setEntity(entity);
		CloseableHttpResponse response = null;

		try {

			response = httpclient.execute(httpPost);
			StatusLine status = response.getStatusLine();
			int state = status.getStatusCode();
			if (state == HttpStatus.SC_OK) {
				HttpEntity responseEntity = response.getEntity();
				String jsonString = EntityUtils.toString(responseEntity);
				return jsonString;
			} else {
				throw new Exception("错误代码：" + String.valueOf(state));
			}
		} finally {
			if (response != null) {
				try {
					response.close();
				} catch (IOException e) {
					e.printStackTrace();
					throw e;
				}
			}
			try {
				httpclient.close();
			} catch (IOException e) {
				e.printStackTrace();
			}
		}
	}

}
