/*
 * Decompiled with CFR 0.152.
 */
package com.efuture.ocp.common.component;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.efuture.ocp.common.component.BasicComponentService;
import com.efuture.ocp.common.component.MasterSlaveIntf;
import com.efuture.ocp.common.entity.AbstractEntityBean;
import com.efuture.ocp.common.entity.ServiceResponse;
import com.efuture.ocp.common.entity.ServiceSession;
import com.efuture.ocp.common.exception.ServiceException;
import com.efuture.ocp.common.util.StorageUtils;
import com.efuture.ocp.common.util.Utils;
import com.efuture.omd.storage.FMybatisTemplate;
import java.lang.reflect.Field;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.CriteriaDefinition;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.StringUtils;

public class MasterSlaveComponent<T extends AbstractEntityBean>
extends BasicComponentService<T>
implements MasterSlaveIntf {
    @Autowired
    private ApplicationEventPublisher applicationEventPublisher;

    @Override
    @Transactional(propagation=Propagation.REQUIRED)
    public long doAdd(AbstractEntityBean bean, String id, String ... uniques) throws Exception {
        long masterid = super.doAdd(bean, id, uniques);
        Field fld = this.getMasterSlaveField(bean.getClass());
        if (fld == null) {
            return masterid;
        }
        String masterkey = (String)fld.get(null);
        if (StringUtils.isEmpty((Object)masterkey)) {
            return masterid;
        }
        Object masterval = AbstractEntityBean.fetchDeclaredField(bean.getClass(), masterkey).get(bean);
        Map<String, Class<?>> flds = this.getSlaveFields(bean.getClass());
        for (String key : flds.keySet()) {
            fld = bean.fetchDeclaredField(key);
            fld.setAccessible(true);
            Object obj = fld.get(bean);
            if (obj == null) continue;
            Class<?> clazz = flds.get(key);
            String slavekey = (String)this.getMasterSlaveField(clazz).get(null);
            List detlist = (List)obj;
            for (AbstractEntityBean slaveBean : detlist) {
                Object detkey = slaveBean.fetchDeclaredField(this.getIdKey(clazz)).get(slaveBean);
                if (detkey != null && !"0".equals(detkey.toString())) {
                    this.getLogger().info((Object)("\u6570\u636e\u884c\u72b6\u6001\u4e0d\u6b63\u786e:" + detkey.toString()));
                    continue;
                }
                slaveBean.fetchDeclaredField(this.getIdKey(clazz)).set(slaveBean, 0);
                slaveBean.fetchDeclaredField(slavekey).set(slaveBean, masterval);
                slaveBean.initInsertMember(bean);
                super.doAdd(slaveBean, this.getIdKey(clazz), this.getUniqueKeys(clazz));
            }
        }
        return masterid;
    }

    @Override
    @Transactional(propagation=Propagation.REQUIRED)
    public JSONArray doSave(ServiceSession session, JSONArray jsonarray) throws Exception {
        jsonarray = this.beforeMasterSavebatch(session, jsonarray);
        JSONArray returnarray = super.doSave(session, jsonarray);
        this.afterMasterSavebatch(session, jsonarray);
        Field fld = this.getMasterSlaveField(this.getBeanClass());
        if (fld == null) {
            return returnarray;
        }
        String masterkey = (String)fld.get(null);
        if (StringUtils.isEmpty((Object)masterkey)) {
            return returnarray;
        }
        String flag = "flag";
        Map flds = this.getSlaveFields(this.getBeanClass());
        for (int i = 0; i < jsonarray.size(); ++i) {
            JSONObject json = jsonarray.getJSONObject(i);
            if (!"U".equalsIgnoreCase(json.getString(flag))) continue;
            for (String key : flds.keySet()) {
                if (!json.containsKey((Object)key)) continue;
                JSONArray slaveArray = json.getJSONArray(key);
                slaveArray.sort(Comparator.comparing(obj -> ((JSONObject)obj).getString("flag")));
                for (int j = 0; slaveArray != null && j < slaveArray.size(); ++j) {
                    JSONObject slavejson = slaveArray.getJSONObject(j);
                    if (!slavejson.containsKey((Object)flag)) continue;
                    Class clazz = flds.get(key);
                    String slavekey = (String)this.getMasterSlaveField(clazz).get(null);
                    AbstractEntityBean slaveBean = (AbstractEntityBean)StorageUtils.parseBeanObject(slavejson, clazz);
                    slaveBean.fetchDeclaredField(slavekey).set(slaveBean, json.get((Object)masterkey));
                    if ("I".equalsIgnoreCase(slavejson.getString(flag))) {
                        AbstractEntityBean.fetchDeclaredField(clazz, this.getIdKey(clazz)).set(slaveBean, 0);
                        slaveBean.initInsertMember(session);
                        super.doAdd(slaveBean, this.getIdKey(clazz), this.getUniqueKeys(clazz));
                        continue;
                    }
                    if ("U".equalsIgnoreCase(slavejson.getString(flag))) {
                        slaveBean.initUpdateMember(session);
                        super.doUpdate(slaveBean, slavejson.keySet(), this.getIdKey(clazz), this.getUniqueKeys(clazz));
                        continue;
                    }
                    if (!"D".equalsIgnoreCase(slavejson.getString(flag))) continue;
                    slaveBean.initUpdateMember(session);
                    this.doDeleteBefore(slaveBean, session);
                    super.doDelete(slaveBean, this.getIdKey(clazz), new String[0]);
                }
            }
        }
        return returnarray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Transactional(propagation=Propagation.REQUIRED)
    public Object doDelete(AbstractEntityBean bean, String id, String ... keys) throws Exception {
        Field fld = this.getMasterSlaveField(bean.getClass());
        if (fld == null) {
            return super.doDelete(bean, id, keys);
        }
        String masterkey = (String)fld.get(null);
        if (StringUtils.isEmpty((Object)masterkey)) {
            return super.doDelete(bean, id, keys);
        }
        Object masterval = AbstractEntityBean.fetchDeclaredField(bean.getClass(), masterkey).get(bean);
        if (StringUtils.isEmpty((Object)masterval)) {
            throw new ServiceException("50004", "{0} {1} is empty", bean.fetchAnnotationTableName(), masterkey);
        }
        FMybatisTemplate storage = null;
        try {
            storage = this.getStorageOperations(FMybatisTemplate.class);
            Map<String, Class<?>> flds = this.getSlaveFields(bean.getClass());
            for (String key : flds.keySet()) {
                Class<?> clazz = flds.get(key);
                String slavekey = (String)this.getMasterSlaveField(clazz).get(null);
                Criteria criteria = Criteria.where((String)"ent_id").is((Object)bean.getEnt_id()).and(slavekey).is(masterval);
                Query query = new Query((CriteriaDefinition)criteria);
                storage.delete(query, clazz);
            }
        }
        finally {
            if (storage != null) {
                storage.destroy();
            }
        }
        Object obj = super.doDelete(bean, id, keys);
        return obj;
    }

    private void formatSlaveCondition(Object ent_id, JSONObject jsonparam, Class<?> objClass, String masterkey, String qkey) throws Exception {
        String[] ss = qkey.split(":");
        String slvtable = ss[0];
        String slvfield = ss[1];
        String slvkey = this.getSalveKey(slvtable, objClass);
        StringBuffer sb = new StringBuffer();
        sb.append("(select " + slvkey + " from " + slvtable + " where ent_id = " + ent_id + " and " + slvkey + " = " + AbstractEntityBean.fetchAnnotationTableName(objClass) + "." + masterkey);
        Object slvobj = jsonparam.get((Object)qkey);
        if (slvobj instanceof JSONObject) {
            JSONObject jo = (JSONObject)slvobj;
            for (String s : jo.keySet()) {
                Object o;
                String op = this.convertOperator(s);
                sb.append(" and " + slvfield);
                sb.append(" " + op + " ");
                if (op.equalsIgnoreCase("in") || op.equalsIgnoreCase("not in")) {
                    sb.append("(");
                    o = jo.get((Object)s);
                    if (o instanceof JSONArray) {
                        JSONArray array = (JSONArray)o;
                        for (int i = 0; i < array.size(); ++i) {
                            if (array.get(i) instanceof String && !((String)array.get(i)).startsWith("'")) {
                                sb.append("'" + array.get(i) + "',");
                                continue;
                            }
                            sb.append(array.get(i) + ",");
                        }
                    } else if (o instanceof String) {
                        String[] os;
                        for (String sk : os = ((String)o).split(",")) {
                            if (!sk.startsWith("'")) {
                                sb.append("'" + sk + "',");
                                continue;
                            }
                            sb.append(sk + ",");
                        }
                    } else {
                        sb.append(o + ",");
                    }
                    sb.setCharAt(sb.length() - 1, ')');
                    continue;
                }
                o = jo.get((Object)s);
                if (o instanceof String && !((String)o).startsWith("'")) {
                    sb.append("'" + o + "'");
                    continue;
                }
                sb.append(o);
            }
        } else if (slvobj instanceof JSONArray) {
            JSONArray array = (JSONArray)slvobj;
            sb.append(" and " + slvfield + " in (");
            for (int i = 0; i < array.size(); ++i) {
                Object o = array.get(i);
                if (o instanceof String && !((String)o).startsWith("'")) {
                    sb.append("'" + o + "',");
                    continue;
                }
                sb.append(o + ",");
            }
            sb.setCharAt(sb.length() - 1, ')');
        } else {
            sb.append(" and " + slvfield);
            if (slvobj instanceof String && !((String)slvobj).startsWith("'")) {
                sb.append(" = '" + slvobj + "'");
            } else {
                sb.append(" = " + slvobj);
            }
        }
        sb.append(")");
        jsonparam.remove((Object)qkey);
        String instr = sb.toString();
        if (!jsonparam.containsKey((Object)masterkey)) {
            JSONObject json = new JSONObject();
            json.put("$in", (Object)instr);
            jsonparam.put(masterkey, (Object)json);
        } else {
            Object obj = jsonparam.get((Object)masterkey);
            if (obj instanceof JSONObject) {
                JSONArray array = new JSONArray();
                JSONObject json = new JSONObject();
                json.put("$in", (Object)instr);
                JSONObject jsn = new JSONObject();
                jsn.put(masterkey, (Object)json);
                array.add((Object)jsn);
                jsn = new JSONObject();
                jsn.put(masterkey, obj);
                array.add((Object)jsn);
                JSONArray ary = jsonparam.getJSONArray("$and");
                if (ary == null) {
                    jsonparam.put("$and", (Object)array);
                } else {
                    ary.addAll((Collection)array);
                }
                jsonparam.remove((Object)masterkey);
            } else {
                JSONObject json = new JSONObject();
                json.put("$in", (Object)instr);
                json.put("=", obj);
                jsonparam.put(masterkey, (Object)json);
            }
        }
    }

    private String getSalveKey(String slvtable, Class<?> objClass) throws Exception {
        Map<String, Class<?>> flds = this.getSlaveFields(objClass);
        for (String key : flds.keySet()) {
            Class<?> clazz = flds.get(key);
            if (!slvtable.equals(AbstractEntityBean.fetchAnnotationTableName(clazz))) continue;
            String slavekey = (String)this.getMasterSlaveField(clazz).get(null);
            return slavekey;
        }
        return null;
    }

    @Override
    protected List<?> doGet(JSONObject jsonparam, Class<?> objClass, StringBuffer total) throws Exception {
        List<Map<String, Object>> masterList;
        String slavetables = null;
        String ignorefilter = this.getParamWithCheck(jsonparam, "ignorefilter", false, "N");
        if (jsonparam.containsKey((Object)"ignorefilter")) {
            jsonparam.remove((Object)"ignorefilter");
        }
        if (!StringUtils.isEmpty((Object)jsonparam.get((Object)"slavetables"))) {
            slavetables = (String)jsonparam.get((Object)"slavetables");
            slavetables = this.makeSlavetables(objClass, slavetables);
            jsonparam.remove((Object)"slavetables");
        }
        String masterkey = null;
        Field fld = this.getMasterSlaveField(objClass);
        if (fld != null) {
            masterkey = (String)fld.get(null);
        }
        if (jsonparam != null && !StringUtils.isEmpty(masterkey)) {
            JSONObject json;
            JSONArray arr_or;
            ArrayList<String> removekeys = new ArrayList<String>();
            for (String qkey : jsonparam.keySet()) {
                if (qkey.indexOf(":") <= 0) continue;
                removekeys.add(qkey);
            }
            for (String qkey : removekeys) {
                this.formatSlaveCondition(jsonparam.get((Object)"ent_id"), jsonparam, objClass, masterkey, qkey);
            }
            if (jsonparam.containsKey((Object)"$or") && jsonparam.get((Object)"$or") instanceof JSONArray) {
                arr_or = jsonparam.getJSONArray("$or");
                for (int i = 0; i < arr_or.size(); ++i) {
                    removekeys.clear();
                    json = arr_or.getJSONObject(i);
                    for (String qkey : json.keySet()) {
                        if (qkey.indexOf(":") <= 0) continue;
                        removekeys.add(qkey);
                    }
                    for (String qkey : removekeys) {
                        this.formatSlaveCondition(jsonparam.get((Object)"ent_id"), json, objClass, masterkey, qkey);
                    }
                }
            }
            if (jsonparam.containsKey((Object)"$and") && jsonparam.get((Object)"$and") instanceof JSONArray) {
                arr_or = jsonparam.getJSONArray("$and");
                for (int i = 0; i < arr_or.size(); ++i) {
                    removekeys.clear();
                    json = arr_or.getJSONObject(i);
                    for (String qkey : json.keySet()) {
                        if (qkey.indexOf(":") <= 0) continue;
                        removekeys.add(qkey);
                    }
                    for (String qkey : removekeys) {
                        this.formatSlaveCondition(jsonparam.get((Object)"ent_id"), json, objClass, masterkey, qkey);
                    }
                }
            }
        }
        if ((masterList = super.doGet(jsonparam, objClass, total)) == null || masterList.size() <= 0) {
            return masterList;
        }
        if ("N".equals(ignorefilter)) {
            masterList = (List<Map<String, Object>>)this.filter(masterList, objClass);
        }
        if (StringUtils.isEmpty((Object)masterkey)) {
            return masterList;
        }
        Field[] masterFlds = AbstractEntityBean.fetchDeclaredFields(objClass, masterkey);
        if (!StringUtils.isEmpty((Object)slavetables)) {
            masterList = this.makelist(masterList);
        }
        Map<String, Class<?>> flds = this.getSlaveFields(objClass);
        for (String key : flds.keySet()) {
            int page_no = -1;
            int page_size = -1;
            String slaveField = null;
            if (!StringUtils.isEmpty((Object)jsonparam.get((Object)"fields")) || !StringUtils.isEmpty((Object)slavetables)) {
                String slavetable = null;
                if (!StringUtils.isEmpty((Object)slavetables)) {
                    if (slavetables.indexOf(key) < 0) continue;
                    slavetable = slavetables;
                } else {
                    if (jsonparam.getString("fields").indexOf(key) < 0) continue;
                    slavetable = jsonparam.getString("fields");
                }
                slaveField = StorageUtils.parseChildParamKeyFields(slavetable, key);
                if (!StringUtils.isEmpty((Object)slaveField)) {
                    StringBuffer sb = new StringBuffer();
                    String[] ss = slaveField.split(",");
                    for (int i = 0; i < ss.length; ++i) {
                        if (ss[i].toLowerCase().startsWith("page_no=")) {
                            page_no = Integer.parseInt(ss[i].split("=")[1]);
                            continue;
                        }
                        if (ss[i].toLowerCase().startsWith("page_size=")) {
                            page_size = Integer.parseInt(ss[i].split("=")[1]);
                            continue;
                        }
                        sb.append(ss[i] + ",");
                    }
                    if (sb.length() > 0) {
                        sb.setLength(sb.length() - 1);
                    }
                    slaveField = sb.toString();
                    if (page_size > 0 && page_no <= 0) {
                        page_no = 1;
                    }
                }
            } else if (total != null) continue;
            Class<?> clazz = flds.get(key);
            String slavekey = (String)this.getMasterSlaveField(clazz).get(null);
            Field slavefld = AbstractEntityBean.fetchDeclaredField(objClass, key);
            Field[] slavekeys = AbstractEntityBean.fetchDeclaredFields(clazz, slavekey);
            slavefld.setAccessible(true);
            for (Map<String, Object> map : masterList) {
                List lst;
                Field masterFld;
                StringBuffer sbtotal = null;
                JSONObject json = new JSONObject();
                if (page_no > 0 && page_size > 0) {
                    json.put("page_no", (Object)page_no);
                    json.put("page_size", (Object)page_size);
                    sbtotal = new StringBuffer();
                }
                String orderFld = "";
                orderFld = this.getOrderFld(clazz);
                if (!StringUtils.isEmpty((Object)orderFld)) {
                    json.put("order_field", (Object)orderFld);
                    String orderDir = "";
                    orderDir = this.getOrderDir(clazz);
                    if (!StringUtils.isEmpty((Object)orderDir)) {
                        json.put("order_direction", (Object)orderDir);
                    }
                } else {
                    json.put("order_field", (Object)this.getIdKey(clazz));
                }
                if (!StringUtils.isEmpty((Object)slaveField)) {
                    json.put("fields", (Object)slaveField);
                }
                if (map instanceof AbstractEntityBean) {
                    AbstractEntityBean bean = (AbstractEntityBean)((Object)map);
                    json.put("ent_id", (Object)bean.getEnt_id());
                    for (int i = 0; i < masterFlds.length; ++i) {
                        masterFld = masterFlds[i];
                        Object masterval = masterFld.get(bean);
                        json.put(slavekeys[i].getName(), masterval);
                    }
                    if (!StringUtils.isEmpty((Object)slaveField)) {
                        lst = super.doSearchForMap(json, clazz, sbtotal);
                        if ("N".equals(ignorefilter)) {
                            lst = (List)this.filter(lst, clazz);
                        }
                        if (lst == null) continue;
                        slavefld.set(bean, StorageUtils.toJavaObject(lst, clazz));
                        continue;
                    }
                    lst = super.doSearch(json, clazz, sbtotal);
                    if ("N".equals(ignorefilter)) {
                        lst = (List)this.filter(lst, clazz);
                    }
                    slavefld.set(bean, lst);
                    continue;
                }
                if (!(map instanceof Map)) continue;
                Map<String, Object> map2 = map;
                json.put("ent_id", map2.containsKey("ent_id") ? map2.get("ent_id") : jsonparam.get((Object)"ent_id"));
                for (int i = 0; i < masterFlds.length; ++i) {
                    masterFld = masterFlds[i];
                    json.put(slavekeys[i].getName(), map2.get(masterFld.getName()));
                }
                lst = super.doSearchForMap(json, clazz, sbtotal);
                if ("N".equals(ignorefilter)) {
                    lst = (List)this.filter(lst, clazz);
                }
                map2.put(key, lst);
                if (sbtotal == null) continue;
                map2.put(key + "_total_results", Long.parseLong(sbtotal.toString()));
            }
        }
        if (!StringUtils.isEmpty((Object)slavetables)) {
            String[] slavearr = slavetables.split(",");
            for (String spec : slavearr) {
                String[] specarr = spec.split(":");
                if (specarr.length <= 1 || specarr[0].charAt(0) != '$') continue;
                String speckey = specarr[0].substring(1);
                if (specarr[1].indexOf("slave") < 0) continue;
                String[] param = specarr[1].split("\\|");
                JSONObject searchparam = new JSONObject();
                String tablename = null;
                for (String para : param) {
                    String[] par = para.split("=");
                    if (par.length <= 1) continue;
                    if (par[0].equals("slave")) {
                        tablename = par[1];
                        continue;
                    }
                    searchparam.put(par[0], (Object)par[1]);
                }
                if (StringUtils.isEmpty(tablename)) continue;
                Class<?> clazz = flds.get(tablename);
                String slavekey = (String)this.getMasterSlaveField(clazz).get(null);
                StringBuffer sbtotal = new StringBuffer();
                for (Map<String, Object> obj : masterList) {
                    if (!(obj instanceof Map)) continue;
                    Map<String, Object> map = obj;
                    searchparam.put(slavekey, map.get(masterkey));
                    searchparam.put("ent_id", map.containsKey("ent_id") ? map.get("ent_id") : jsonparam.get((Object)"ent_id"));
                    List lst = super.doSearchForMap(searchparam, clazz, sbtotal);
                    if ("N".equals(ignorefilter)) {
                        lst = (List)this.filter(lst, clazz);
                    }
                    map.put(speckey, lst);
                    map.put(speckey + "_total_results", Long.parseLong(sbtotal.toString()));
                }
            }
        }
        return masterList;
    }

    protected String convertOperator(String s) {
        if ("$in".equalsIgnoreCase(s) || "in".equalsIgnoreCase(s)) {
            return "in";
        }
        if ("$nin".equalsIgnoreCase(s) || "notin".equalsIgnoreCase(s)) {
            return "not in";
        }
        if ("$is".equalsIgnoreCase(s) || "==".equalsIgnoreCase(s) || "=".equalsIgnoreCase(s)) {
            return "=";
        }
        if ("$ne".equalsIgnoreCase(s) || "<>".equalsIgnoreCase(s) || "!=".equalsIgnoreCase(s)) {
            return "<>";
        }
        if ("like".equalsIgnoreCase(s)) {
            return "like";
        }
        if ("$gt".equalsIgnoreCase(s) || ">".equalsIgnoreCase(s)) {
            return ">";
        }
        if ("$gte".equalsIgnoreCase(s) || ">=".equalsIgnoreCase(s)) {
            return ">=";
        }
        if ("$lt".equalsIgnoreCase(s) || "<".equalsIgnoreCase(s)) {
            return "<";
        }
        if ("$lte".equalsIgnoreCase(s) || "<=".equalsIgnoreCase(s)) {
            return "<=";
        }
        return s;
    }

    protected Field getMasterSlaveField(Class<?> cl) {
        return AbstractEntityBean.fetchDeclaredField(cl, "MASTER_SLAVE_KEY");
    }

    protected Map<String, Class<?>> getSlaveFields(Class<?> masterClazz) throws Exception {
        HashMap map = new HashMap();
        Field[] fields = masterClazz.getDeclaredFields();
        for (int i = 0; i < fields.length; ++i) {
            String slavekey;
            ParameterizedType parameterizedType;
            Field fld;
            Field field = fields[i];
            Type type = field.getGenericType();
            if (!(type instanceof ParameterizedType) || (fld = this.getMasterSlaveField((Class)(type = (parameterizedType = (ParameterizedType)type).getActualTypeArguments()[0]))) == null || StringUtils.isEmpty((Object)(slavekey = (String)fld.get(null)))) continue;
            map.put(field.getName(), (Class)type);
        }
        return map;
    }

    @Transactional(propagation=Propagation.REQUIRED)
    public void doDeleteBefore(AbstractEntityBean bean, ServiceSession session) throws Exception {
    }

    public String makeSlavetables(Class<?> objClass, String slavetables) throws Exception {
        String tempSlavetables = "," + slavetables + ",";
        String result = slavetables;
        Field[] fields = objClass.getDeclaredFields();
        for (int i = 0; i < fields.length; ++i) {
            Field field = fields[i];
            Type type = field.getGenericType();
            if (!(type instanceof ParameterizedType)) continue;
            String fieldname = this.getfieldname(field.getName());
            if (tempSlavetables.indexOf("," + fieldname + ",") >= 0 || tempSlavetables.indexOf("," + fieldname + ":") >= 0) continue;
            result = result + "," + fieldname;
        }
        return result;
    }

    private String getfieldname(String fieldname) {
        if (fieldname.split("[.]").length != 0) {
            String[] sa = fieldname.split("[.]");
            return sa[sa.length - 1];
        }
        return "";
    }

    private List<Map<String, Object>> makelist(List<?> masterList) throws Exception {
        ArrayList<Map<String, Object>> result = new ArrayList<Map<String, Object>>();
        for (Object obj : masterList) {
            if (obj instanceof AbstractEntityBean) {
                Map row = (Map)Utils.toNormalJSONObject(obj);
                result.add(row);
                continue;
            }
            if (!(obj instanceof Map)) continue;
            Map map = (Map)obj;
            result.add(map);
        }
        return result;
    }

    public JSONArray beforeMasterSavebatch(ServiceSession session, JSONArray jsonarray) throws Exception {
        for (int i = 0; i < jsonarray.size(); ++i) {
            JSONObject json = jsonarray.getJSONObject(i);
            this.beforeMasterSave(session, json);
        }
        return jsonarray;
    }

    public JSONObject beforeMasterSave(ServiceSession session, JSONObject json) throws Exception {
        return json;
    }

    public void afterMasterSavebatch(ServiceSession session, JSONArray jsonarray) throws Exception {
        for (int i = 0; i < jsonarray.size(); ++i) {
            JSONObject json = jsonarray.getJSONObject(i);
            this.afterMasterSave(session, json);
        }
    }

    public void afterMasterSave(ServiceSession session, JSONObject json) throws Exception {
    }

    @Override
    public void postBeanChangeEvent(String oper, String usercode, String username, AbstractEntityBean originalbean, AbstractEntityBean newbean, String type) throws Exception {
        String beanType = "";
        beanType = newbean.getClass().equals(this.getBeanClass()) ? "Master" : "Slave";
        super.postBeanChangeEvent(oper, usercode, username, originalbean, newbean, beanType);
    }

    @Override
    public ServiceResponse getslave(ServiceSession session, JSONObject jsonparam) throws Exception {
        if (StringUtils.isEmpty((Object)jsonparam.get((Object)"slave"))) {
            throw new ServiceException("10000", "{0} is null", "slave");
        }
        String slave = jsonparam.getString("slave");
        jsonparam.remove((Object)"slave");
        StringBuffer sbtotal = new StringBuffer();
        if (StringUtils.isEmpty((Object)jsonparam.get((Object)"ent_id"))) {
            jsonparam.put("ent_id", (Object)session.getEnt_id());
        }
        Map flds = this.getSlaveFields(this.getBeanClass());
        Class clazz = flds.get(slave);
        List<Map<String, Object>> lst = super.doSearchForMap(jsonparam, clazz, sbtotal);
        JSONObject json = new JSONObject();
        json.put(slave, lst);
        json.put("total_results", (Object)sbtotal.toString());
        return ServiceResponse.buildSuccess(json);
    }
}

