/*
 * Decompiled with CFR 0.152.
 */
package com.efuture.ocp.common.filter;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.zip.GZIPInputStream;
import javax.servlet.ReadListener;
import javax.servlet.ServletInputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;

public class GzipRequestWrapper
extends HttpServletRequestWrapper {
    public GzipRequestWrapper(HttpServletRequest request) {
        super(request);
    }

    public ServletInputStream getInputStream() throws IOException {
        return new GZIPServletInputStream((InputStream)super.getInputStream());
    }

    public BufferedReader getReader() throws IOException {
        return new BufferedReader(new InputStreamReader((InputStream)((Object)new GZIPServletInputStream((InputStream)super.getInputStream()))));
    }

    class GZIPServletInputStream
    extends ServletInputStream {
        private InputStream input;

        public GZIPServletInputStream(InputStream input) throws IOException {
            this.input = new GZIPInputStream(input);
        }

        public int read() throws IOException {
            return this.input.read();
        }

        public boolean isFinished() {
            boolean finished = false;
            try {
                if (this.input.available() == 0) {
                    finished = true;
                }
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            return finished;
        }

        public boolean isReady() {
            boolean ready = false;
            try {
                if (this.input.available() > 0) {
                    ready = true;
                }
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            return ready;
        }

        public void setReadListener(ReadListener listener) {
        }
    }
}

