/*
 * Decompiled with CFR 0.152.
 */
package com.efuture.ocp.common.listener;

import com.alibaba.fastjson.JSONObject;
import com.efuture.ocp.common.component.OperationLogService;
import com.efuture.ocp.common.component.OperationLogServiceImpl;
import com.efuture.ocp.common.entity.AbstractEntityBean;
import com.efuture.ocp.common.listener.BeanChangeEvent;
import com.efuture.ocp.common.util.SpringBeanFactory;
import org.springframework.stereotype.Component;
import org.springframework.transaction.event.TransactionPhase;
import org.springframework.transaction.event.TransactionalEventListener;
import org.springframework.util.StringUtils;

@Component
public class OperLogListener {
    @TransactionalEventListener(phase=TransactionPhase.BEFORE_COMMIT)
    private void onHandleBeforeEvent(BeanChangeEvent event) throws Exception {
        Object source = event.getSource();
        JSONObject json = (JSONObject)source;
        String op = StringUtils.isEmpty((Object)json.get((Object)"op")) ? "" : json.get((Object)"op").toString();
        String usercode = StringUtils.isEmpty((Object)json.get((Object)"usercode")) ? "0" : json.get((Object)"usercode").toString();
        String username = StringUtils.isEmpty((Object)json.get((Object)"username")) ? "0" : json.get((Object)"username").toString();
        AbstractEntityBean originalbean = (AbstractEntityBean)json.get((Object)"originalbean");
        AbstractEntityBean newbean = (AbstractEntityBean)json.get((Object)"newbean");
        String beantype = json.get((Object)"beantype").toString();
        this.insOperLog(op, usercode, username, originalbean, newbean, beantype);
    }

    @TransactionalEventListener(phase=TransactionPhase.AFTER_COMMIT)
    private void onHandleAfterEvent(BeanChangeEvent event) throws Exception {
        if (!SpringBeanFactory.containsBean("OperLogSrv")) {
            return;
        }
        OperationLogServiceImpl.getLogList().remove();
    }

    public void insOperLog(String op, String usercode, String username, AbstractEntityBean originalbean, AbstractEntityBean newbean, String beantype) throws Exception {
        if (!this.check(originalbean, newbean)) {
            return;
        }
        OperationLogService operationLogSrv = SpringBeanFactory.getBean("OperLogSrv", OperationLogService.class);
        operationLogSrv.insOperLog(op, usercode, username, null, originalbean, newbean, beantype);
    }

    public boolean check(AbstractEntityBean originalbean, AbstractEntityBean newbean) {
        if (!SpringBeanFactory.containsBean("OperLogSrv")) {
            return false;
        }
        if (StringUtils.isEmpty((Object)originalbean)) {
            return false;
        }
        return !StringUtils.isEmpty((Object)newbean);
    }
}

