/**
 * Copyright (C), 2007-2015, eFuture 北京富基融通科技有限公司
 * FileName:	TopicService.java
 * Author:		亮
 * Date:		2015-7-8 下午2:58:22
 * Description:
 * History:
 * <author>		<time>			<version>		<description>
 *
 */
package com.efuture.ocp.common.billservice;

import com.alibaba.fastjson.JSONObject;
import com.efuture.ocp.common.component.BaseServiceIntf;
import com.efuture.ocp.common.entity.ServiceResponse;
import com.efuture.ocp.common.entity.ServiceSession;

/**
 * @author 亮
 * @description
 *
 */
public interface BillCommonService extends BaseServiceIntf
{
    // 申请单号
    ServiceResponse applybillno(ServiceSession session, JSONObject jsonparam) throws Exception;

    // 审核单据
    ServiceResponse billaudit(ServiceSession session, JSONObject jsonparam) throws Exception;

    // 取消单据
    ServiceResponse billcancel(ServiceSession session, JSONObject jsonparam) throws Exception;

    // 作废单据
    ServiceResponse billvoid(ServiceSession session, JSONObject jsonparam) throws Exception;

    // 提交单据到审批流
    ServiceResponse billsubmit(ServiceSession session, JSONObject jsonparam) throws Exception;

    // 提交保存同时提交审批流
    ServiceResponse billsaveandsubmit(ServiceSession session, JSONObject jsonparam) throws Exception;

    // 审批
    public ServiceResponse billapproval(ServiceSession session, JSONObject jsonparam) throws Exception;

    // 驳回
    public ServiceResponse billreject(ServiceSession session, JSONObject jsonparam) throws Exception;

    // 撤回
    public ServiceResponse billrepeal(ServiceSession session, JSONObject jsonparam) throws Exception;

    // 获取审批日志
    public ServiceResponse sheetAuditLog(ServiceSession session, JSONObject jsonparam) throws Exception;

    // 移动端单据审批流程
    public ServiceResponse getProcessList(ServiceSession session, JSONObject jsonparam) throws Exception;

    // 获取审批人员列表
    public ServiceResponse getUserList(ServiceSession session, JSONObject jsonparam) throws Exception;

    // 获取审批人员分组列表
    public ServiceResponse getUserGroupList(ServiceSession session, JSONObject jsonparam) throws Exception;

    // 审批流加签
    public ServiceResponse billaddtask(ServiceSession session, JSONObject jsonparam) throws Exception;

    public ServiceResponse gettask(ServiceSession session, JSONObject jsonparam) throws Exception;

    //对接第三方审批流审批通过后调用审核
    public ServiceResponse billapproveforthird(ServiceSession session, JSONObject jsonparam) throws Exception;

}
