/**
 * Copyright (C), 2007-2014, eFuture 北京富基融通科技有限公司
 * FileName:	CacheUtils.java
 * Author:		亮
 * Date:		2014-9-16 下午4:43:00
 * Description:
 * History:
 * <author>		<time>			<version>		<description>
 *
 */
package com.efuture.ocp.common.cache;

import java.util.*;

import com.efuture.ocp.common.util.SpringBeanFactory;
import net.rubyeye.xmemcached.GetsResponse;



/**
 * @author		亮
 * @description
 *
 */
public abstract class CacheUtils
{

    protected CacheConfig config ;
    public CacheConfig getConfig()
    {
        return config;
    }
    public void setConfig(CacheConfig config)
    {
        this.config = config;
    }


    public interface CacheTimeOut
    {
        final int Min  = 60;
        final int HalfHour = 1800;
        final int Hour = 3600;
        final int Day = 86400;
    }

    public interface CacheType
    {
        final String INMEMORY = "memory";
        final String MEMCACHED = "memcached";
        final String REDIS_SINGLE = "redis";
        final String REDIS_SENTINEL = "redis_sentinel";
        final String REDIS_CLUSTER = "redis_cluster";
    }

    public interface CacheMemoryMode
    {
        final String BIN = "BIN";
        final String OBJ = "OBJ";
    }

    public interface CacheLevel
    {
        final String Cache = "CACHE";   // Redis or Memcached
        final String Memory = "MEM";    // Memory
    }

    // 设置数据(timeout单位秒,0=长期)
    public abstract String putData(String key, Object object, int timeout);

    // 得到数据
    public abstract Object getData(String key);

    // 得到数据
    public abstract Object getCacheData(String key);

    // 删除数据
    public abstract boolean deleteData(String key);

    // 获取数据的版本号
    public abstract long getCasValue(String key) ;

    // 获取数据的版本号
    public abstract GetsResponse getCasData(String key) ;

    // 根据版本号更新
    public abstract boolean putbyCas(String key, Object object, int timeout, long casvalue);

    //////////////////////
    public String putData(Object object)
    {
        return putData(object, CacheTimeOut.Day);
    }

    public String putData(Object object, int timeout)
    {
        //String key = MD5Utils.MD5(String.valueOf(UniqueID.getUniqueID()));
        String key = UUID.randomUUID().toString().replace("-", "").toUpperCase();
        return getCacheUtils().putData(key, object, timeout);
    }

    public String putDataPrefix(String prefix, Object object, int timeout)
    {
        String key = prefix.concat(UUID.randomUUID().toString().replace("-", "").toUpperCase());
        return getCacheUtils().putData(key, object, timeout);
    }

    public Map<String, Object> getBatchData(List<String> keys)
    {
        Map<String, Object> result = new HashMap<String, Object>();

        for (String key : keys) {
            result.put(key, getData(key));
        }

        return result;
    }

    ///////////////////////////////////
    public static CacheUtils getCacheUtils()
    {
        return SpringBeanFactory.getBean("CacheUtils", CacheUtils.class);
    }
    public static CacheUtils getInMemUtils()
    {
        return SpringBeanFactory.getBean( "CacheInMemory", CacheUtils.class );
    }
    public static CacheUtils getInMemUtils(String cacheMemoryMode)
    {
        if (CacheMemoryMode.BIN.equalsIgnoreCase( cacheMemoryMode ))
        {
            return SpringBeanFactory.getContext().getBean( CacheUtilsInMemory.class );
        }
        else
        {
            return SpringBeanFactory.getContext().getBean( CacheUtilsInMemoryObject.class );
        }
    }
    public static CacheUtilsRediscached getRedisUtils()
    {
        return SpringBeanFactory.getBean( "CacheRedis", CacheUtilsRediscached.class );
    }
    public static CacheUtils getCacheUtils(String cacheLevel)
    {
        if (CacheLevel.Memory.equalsIgnoreCase( cacheLevel )) {
            return getInMemUtils();
        }
        else {
            return getCacheUtils();
        }
    }

    public boolean AddData(String key, Object object, int timeout)
    {
        return false;
    }

    public int deleteBatch(String key)
    {
        return 0;
    }

    public String putDataText(String key, Object object, int timeout)
    {
        return putData(key, object, timeout );
    }

    public Object getDataText(String key)
    {
        return getData(key);
    }

}

