package com.efuture.ocp.common.cache;

import com.efuture.ocp.common.annotation.CallTime;
import net.rubyeye.xmemcached.GetsResponse;

import java.io.Serializable;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

/**
 * @title: CacheUtilsInMemoryObject
 * @description: TODO
 * @author: wangf
 * @date: 2021/04/20
 */

public class CacheUtilsInMemoryObject extends CacheUtils implements Serializable {

    private static final Map<String, Object> CACHE_MAP = new ConcurrentHashMap<String, Object>();
    private static final String EXPIREKEY = "_ExpireTime";

    @Override
    @CallTime(Service = "OCP", KeyArgIndex = 0)
    public String putData(String key, Object object, int timeout)
    {
        CACHE_MAP.put(key, object);
        CACHE_MAP.put(key.concat(EXPIREKEY), System.currentTimeMillis() + timeout * 1000L);
        return key;
    }

    @Override
    @CallTime(Service = "OCP", KeyArgIndex = 0)
    public Object getData(String key)
    {
        if (checkCacheName(key)) {
            return CACHE_MAP.get(key);
        }

        return null;
    }

    @Override
    public Object getCacheData(String key) {
        return null;
    }

    @Override
    public boolean deleteData(String key)
    {
        remove(key);
        return true;
    }

    @Override
    public long getCasValue(String key)
    {
        return 0;
    }


    public GetsResponse getCasData(String key)
    {
        return null;
    }

    public boolean putbyCas(String key, Object object, int timeout, long casvalue)
    {
        return false;
    }

    public Object getCacheType()
    {
        return null;
    }


    @Override
    public int deleteBatch(String key)
    {
        int result = 0;

        for (Map.Entry<String, Object> entry : CACHE_MAP.entrySet()) {
            if (entry.getKey().contains( key )) {
                synchronized (this) {
                    remove( entry.getKey() );
                    result ++;
                }
            }
        }

        return result;
    }

    public static void removeAll()
    {
        CACHE_MAP.clear();
    }

    public static void remove(String cacheName)
    {
        CACHE_MAP.remove(cacheName);
        CACHE_MAP.remove(cacheName.concat(EXPIREKEY));
    }

    public static boolean checkCacheName(String cacheName)
    {
        Long cacheHoldTime = (Long) CACHE_MAP.get(cacheName.concat(EXPIREKEY));

        if (cacheHoldTime == null || cacheHoldTime == 0L) {
            return false;
        }

        if (cacheHoldTime < System.currentTimeMillis()) {
            remove(cacheName);
            return false;
        }

        return true;
    }


}
