package com.efuture.ocp.common.slice.filter;

import com.efuture.ocp.common.rest.ServiceLogs;
import com.efuture.ocp.common.rest.ServiceRestReflect;
import com.efuture.ocp.common.slice.entity.SplitConfigBean;
import com.efuture.ocp.common.slice.entity.SplitTableConfigBean;
import com.efuture.ocp.common.util.EnviromentUtil;
import com.efuture.ocp.common.util.SpringBeanFactory;
import com.efuture.omd.storage.FStorageOperations;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.stereotype.Component;

import javax.annotation.PostConstruct;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.*;

public class SliceBase
{
    public static int MAPPED_STATEMENT_INDEX = 0;
    public static int PARAMETER_INDEX = 1;
    public static int ROWBOUNDS_INDEX = 2;
    public static int RESULT_HANDLER_INDEX = 3;
    public static int CACHEKEY_INDEX = 4;
    public static int BOUNDSQL_INDEX = 5;

    protected static Logger logger = LoggerFactory.getLogger( SliceBase.class);
    private DateFormat formatter = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
    private static Map<String, String> organizationMap ;
    private static Map<String, String> collectionMap ;
    private static Boolean isDebugLog = null;
    private static Boolean isEnableSlice = null;

    public interface SliceStatus
    {
        final String READ = "read";
        final String TRUE = "true";
        final String FALSE = "false";
    }

    private List<String> LIST_ParaTable = Arrays.asList("splitconfig", "splittableconfig");

    public static FStorageOperations getStorageOperations()
    {
        return SpringBeanFactory.getBean("GlobalStorageOperation", FStorageOperations.class);
    }

    private static void initOrganizationMap(FStorageOperations conn)
    {
        Query qur = new Query();
        List<SplitConfigBean> list = conn.select(qur, SplitConfigBean.class);

        if (list != null && list.size() > 0) {
            organizationMap.clear();

            for (SplitConfigBean scb : list) {
                String key = String.valueOf(scb.getEnt_id()).concat("-").concat(scb.getShopCode());
                organizationMap.put(key, scb.getSplitCode());
            }
        }
    }

    private static void initCollectionMap(FStorageOperations conn)
    {
        Query qur = new Query();
        List<SplitTableConfigBean> list = conn.select(qur, SplitTableConfigBean.class);

        if (list != null && list.size() > 0) {
            collectionMap.clear();

            for (SplitTableConfigBean scb : list) {
                String key = scb.getSplitTableName();
                collectionMap.put(key, scb.getFieldName());
            }
        }
    }

    @PostConstruct
    private static synchronized void init()
    {
        if (organizationMap == null) {
            organizationMap = new HashMap();
        }

        if (collectionMap == null) {
            collectionMap = new HashMap();
        }

        FStorageOperations conn = null;

        try {
            conn = getStorageOperations();
            initOrganizationMap(conn);
            initCollectionMap(conn);
        }
        finally {
            if (conn != null) {
                conn.destroy();
            }
        }
    }

    public static Map<String, String> getCollectionMap()
    {
        if ((collectionMap == null) || (organizationMap == null)) {
            init();
        }

        if ((collectionMap.isEmpty()) || (organizationMap.isEmpty())) {
            init();
        }

        return collectionMap;
    }

    public static Map<String, String> getOrganizationMap()
    {
        if ((collectionMap == null) || (organizationMap == null)) {
            init();
        }

        if ((collectionMap.isEmpty()) || (organizationMap.isEmpty())) {
            init();
        }

        return organizationMap;
    }

    public static Set<String> getAllSlice()
    {
        Map<String, String> all_orgs = getOrganizationMap();

        if (all_orgs == null || all_orgs.size() <= 0) {
            return null;
        }

        Set<String> result = new HashSet<>(  );

        for (Map.Entry<String, String> entry : all_orgs.entrySet()) {
            result.add( entry.getValue() );
        }

        return result;
    }


    public boolean isEnableSlice()
    {
        if (isEnableSlice == null) {
            isEnableSlice = SliceStatus.TRUE.equalsIgnoreCase( EnviromentUtil.getProperty( "efuture.slice.enable", "false" ));
        }

        return isEnableSlice;
    }

    public static boolean isDebugLog()
    {
        if (isDebugLog == null) {
            isDebugLog = SliceStatus.TRUE.equalsIgnoreCase( EnviromentUtil.getProperty( "efuture.slice.debuglog", "false"));
        }

        return isDebugLog;
    }

    //    public void setEnableSlice(String enableSlice)
    //    {
    //        this.enableSlice = enableSlice;
    //    }

    public boolean isParaTable(String sqlStatement)
    {
        for (String table : LIST_ParaTable) {
            if (sqlStatement.indexOf( table ) > 0) {
                return true;
            }
        }

        return false;
    }

    protected static void sliceFilterLog(String logmsg, Object... args)
    {
        if (isDebugLog()) {
            logger.info( logmsg, args );
        }
    }

    public static void setCurrentSlice(String slice)
    {
        ServiceRestReflect.getLocale().get().setSlice( slice );
    }

    public static String getCurrentSlice()
    {
        return ServiceRestReflect.getLocale().get().getSlice();
    }

    public static String getCurrentEntMarket()
    {
        return ServiceRestReflect.getLocale().get().getEntMarket();
    }
}
