package com.efuture.ocp.common.trans;

import com.efuture.ocp.common.util.DataUtils;
import com.efuture.ocp.common.util.OcpApplicationContext;
import org.springframework.jdbc.datasource.DataSourceTransactionManager;
import org.springframework.transaction.TransactionDefinition;
import org.springframework.transaction.TransactionStatus;
import org.springframework.transaction.support.DefaultTransactionDefinition;

public class TransactionManager
{
    final static String DEFAULT_TX_NAME = "transactionManager";

    public static DataSourceTransactionManager getTxManager(String... txName){
        String txManagerName = null;
        if (txName != null && txName.length > 0)
        {
            txManagerName = DataUtils.nvl(txName[0], DEFAULT_TX_NAME);
        }
        else
        {
            txManagerName = DEFAULT_TX_NAME;
        }
        DataSourceTransactionManager transactionManager = (DataSourceTransactionManager) OcpApplicationContext.getInstance().getBean( txManagerName );
        return transactionManager;
    }

    public static TransactionStatus newTransaction(String... txName){
        DefaultTransactionDefinition def = new DefaultTransactionDefinition();
        def.setPropagationBehavior( TransactionDefinition.PROPAGATION_REQUIRES_NEW); // 事物隔离级别，开启新事务，这样会比较安全些。
        TransactionStatus status = getTxManager(txName).getTransaction(def); // 获得事务状态
        return status ;
    }

    public static void commit(TransactionStatus status, String... txName) {
        if ( status != null) {
            getTxManager(txName).commit(status);
        }
    }

    public static void rollback(TransactionStatus status, String... txName) {
        if( status != null) {
            getTxManager(txName).rollback(status);
        }
    }
}
