package com.efuture.ocp.common.util;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.core.env.Environment;
import org.springframework.stereotype.Component;

import com.efuture.ocp.common.util.SpringBeanFactory;


/**
 * 注册spring应用程序上下文
 * @author 肖志文
 *
 */
@Component
public class OcpApplicationContextRegister implements ApplicationContextAware
{
    @Autowired
    protected Environment env;

    public void setApplicationContext(ApplicationContext context)
    {
        if (OcpApplicationContext.getInstance().getContext() == null) {
            String[] active = (env != null ? env.getActiveProfiles() : null);
            System.out.println("开始注册 " + (env != null ? env.getProperty("spring.application.name") : "OCP") + " 上下文 [" + (active != null && active.length > 0 ? active[0] : "") + "]......");
            OcpApplicationContext.getInstance().setContext(context);
            SpringBeanFactory.setContext(context);

            // 打印关注的属性配置
            if (env != null) {
                EnviromentUtil.followEnvironment(env);
            }
        }
    }
}
