/*
 * Decompiled with CFR 0.152.
 */
package com.efuture.ocp.common.component;

import com.efuture.ocp.common.component.BasicComponentService;
import com.efuture.ocp.common.component.OperationLogService;
import com.efuture.ocp.common.entity.AbstractEntityBean;
import com.efuture.ocp.common.entity.OperationLogBean;
import com.efuture.ocp.common.util.BatchInsService;
import com.efuture.ocp.common.util.UniqueID;
import com.efuture.omd.storage.FMybatisTemplate;
import com.efuture.omd.storage.Virtual;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.springframework.data.annotation.Transient;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.StringUtils;

public class OperationLogServiceImpl
extends BasicComponentService<OperationLogBean>
implements OperationLogService {
    private String modulecol = "billmoduleid,moduleid";
    private static final ThreadLocal<Map<String, Object>> logList = new ThreadLocal();

    public static ThreadLocal<Map<String, Object>> getLogList() {
        return logList;
    }

    public OperationLogServiceImpl() {
        this.setStorageOperation_other("GlobalStorageOperation");
    }

    @Override
    public void insOperLog(String oper, String usercode, String username, String moduleid, AbstractEntityBean originalbean, AbstractEntityBean newbean, String type) throws Exception {
        String key;
        List<Object> list = new ArrayList();
        boolean logflag = false;
        Class<?> clazz = originalbean.getClass();
        Object islog = this.getBeanDefineKey(clazz, "ISLOG");
        if (StringUtils.isEmpty((Object)islog) || !((Boolean)islog).booleanValue()) {
            return;
        }
        if (StringUtils.isEmpty((Object)moduleid)) {
            moduleid = this.getModuleId(originalbean);
        }
        if (StringUtils.isEmpty((Object)moduleid)) {
            return;
        }
        if (StringUtils.isEmpty((Object)type)) {
            type = "Master";
        }
        if (this.checkIsLog(key = this.getBusinessKeyValue(originalbean), oper, type)) {
            return;
        }
        if ("U".equalsIgnoreCase(oper)) {
            list = this.compareObject(originalbean, newbean, type);
        } else if ("I".equalsIgnoreCase(oper) || "D".equalsIgnoreCase(oper)) {
            OperationLogBean log = this.getMasterLog(oper, originalbean);
            list.add(log);
        }
        String masterkey = this.getMasterSlaveKey(clazz);
        String idkey = this.getIdKey(clazz);
        Object businesscode = this.getFieldValue(clazz, originalbean, masterkey);
        Object businesskey = this.getFieldValue(clazz, originalbean, idkey);
        if (!StringUtils.isEmpty(list) && list.size() > 0) {
            this.batchHandleLog(list, originalbean.getEnt_id(), moduleid, usercode, username, oper, businesscode, businesskey);
        }
        Map<String, Object> map = new HashMap<String, String>();
        if (!StringUtils.isEmpty(logList.get())) {
            map = logList.get();
        }
        map.put(originalbean.getEnt_id() + "-" + businesscode + "-" + oper, moduleid);
        logList.set(map);
    }

    @Transactional(propagation=Propagation.REQUIRED)
    public void batchHandleLog(List<OperationLogBean> list, long ent_id, String billmoduleid, String usercode, String username, String oper, Object businesscode, Object businesskey) throws Exception {
        list.forEach(e -> {
            if (!StringUtils.isEmpty((Object)businesscode)) {
                e.setBussinesscode(businesscode.toString());
            }
            if (!StringUtils.isEmpty((Object)businesskey)) {
                e.setBussinesskey(businesskey.toString());
            }
            e.setEnt_id(ent_id);
            e.setBillmoduleid(billmoduleid);
            e.setOperdate(new Date());
            e.setUsercode(usercode);
            e.setUsername(username);
            e.setPh_key(UniqueID.getUniqueID());
        });
        BatchInsService batchInsSrv = new BatchInsService();
        batchInsSrv.batchInsert(this.getGlobalStorageOperations(FMybatisTemplate.class), OperationLogBean.class, list);
    }

    public List<OperationLogBean> compareObject(Object oldBean, Object newBean, String type) {
        ArrayList<OperationLogBean> list = new ArrayList<OperationLogBean>();
        try {
            Class<?> clazz = oldBean.getClass();
            Field[] fields = clazz.getDeclaredFields();
            String memo = "";
            for (Field field : fields) {
                Map<String, Object> map;
                if (!this.check(field, clazz) || StringUtils.isEmpty(map = this.getDiffField(clazz, field, oldBean, newBean))) continue;
                if ("Master".equals(type)) {
                    OperationLogBean log = new OperationLogBean();
                    log.setOpertype("U");
                    log.setCode(field.getName());
                    log.setOldvalue(StringUtils.isEmpty((Object)map.get("oldvalue")) ? "" : map.get("oldvalue").toString());
                    log.setNewvalue(StringUtils.isEmpty((Object)map.get("newvalue")) ? "" : map.get("newvalue").toString());
                    log.setMemo(map.get("memo").toString());
                    list.add(log);
                    continue;
                }
                memo = memo + map.get("memo") + ";";
            }
            if ("Slave".equals(type)) {
                OperationLogBean log = new OperationLogBean();
                log.setOpertype("U");
                log.setCode(AbstractEntityBean.fetchAnnotationTableName(clazz));
                log.setMemo(memo);
                list.add(log);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return list;
    }

    public String getDiff(Object oldBean, Object newBean) throws Exception {
        Class<?> clazz = oldBean.getClass();
        Field[] fields = clazz.getDeclaredFields();
        String str = "";
        for (Field field : fields) {
            Map<String, Object> map;
            if (!this.check(field, clazz) || StringUtils.isEmpty(map = this.getDiffField(clazz, field, oldBean, newBean))) continue;
            str = str + map.get("memo") + ";";
        }
        return str;
    }

    public Map<String, Object> getDiffField(Class clazz, Field field, Object oldBean, Object newBean) throws Exception {
        Object o1 = this.getFieldValue(clazz, oldBean, field.getName());
        Object o2 = this.getFieldValue(clazz, newBean, field.getName());
        if (o1 == null && o2 == null) {
            return null;
        }
        if (StringUtils.isEmpty((Object)o1) && StringUtils.isEmpty((Object)o2)) {
            return null;
        }
        if (field.getGenericType().toString().equals("class java.util.Date")) {
            Date d1 = null;
            Date d2 = null;
            if (o1 != null) {
                d1 = (Date)o1;
            }
            if (o2 != null) {
                d2 = (Date)o2;
            }
            if (!StringUtils.isEmpty((Object)d1) && !StringUtils.isEmpty((Object)d2) && d1.compareTo(d2) == 0) {
                return null;
            }
        } else if (!StringUtils.isEmpty((Object)o1) && !StringUtils.isEmpty((Object)o2) && o1.equals(o2)) {
            return null;
        }
        String memo = "\u5b57\u6bb5\u540d\u79f0" + field.getName() + ",\u65e7\u503c:" + o1 + ",\u65b0\u503c:" + o2;
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("oldvalue", o1);
        map.put("newvalue", o2);
        map.put("memo", memo);
        return map;
    }

    public boolean check(Field field, Class<?> cl) throws Exception {
        Object ignorecols = this.getBeanDefineKey(cl, "IGNORECOLS");
        if (field.toString().contains("static final")) {
            return false;
        }
        if (!StringUtils.isEmpty((Object)ignorecols) && ignorecols.toString().contains(field.getName())) {
            return false;
        }
        if (!StringUtils.isEmpty((Object)field.getAnnotation(Transient.class))) {
            return false;
        }
        return StringUtils.isEmpty((Object)field.getAnnotation(Virtual.class));
    }

    public String getModuleId(Object bean) throws Exception {
        String[] cols;
        AbstractEntityBean entity = (AbstractEntityBean)bean;
        Class<?> clazz = entity.getClass();
        for (String col : cols = this.modulecol.split(",")) {
            try {
                Object object = this.getFieldValue(clazz, bean, col);
                if (StringUtils.isEmpty((Object)object)) continue;
                return object.toString();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        Map<String, Object> map = logList.get();
        if (!StringUtils.isEmpty(map)) {
            String filters = this.getBusinessKeyValue(entity);
            map = map.entrySet().stream().filter(e -> ((String)e.getKey()).indexOf(filters) >= 0).collect(Collectors.toMap(e -> (String)e.getKey(), e -> e.getValue()));
        }
        if (!StringUtils.isEmpty(map) && map.size() > 0) {
            String mapkey = map.keySet().iterator().next();
            return map.get(mapkey).toString();
        }
        return null;
    }

    public Object getFieldValue(Class clazz, Object bean, String col) throws Exception {
        PropertyDescriptor pd = new PropertyDescriptor(col, clazz);
        Method getMethod = pd.getReadMethod();
        Object o1 = getMethod.invoke(bean, new Object[0]);
        return o1;
    }

    public String getUniqueKeyValue(Object bean) throws Exception {
        Class<?> clazz = bean.getClass();
        String[] uks = this.getUniqueKeys(clazz);
        String memo = "";
        for (String uk : uks) {
            String[] k;
            for (String s : k = uk.split(",")) {
                Object o1 = this.getFieldValue(clazz, bean, s);
                memo = memo + s + ":" + o1 + ";";
            }
        }
        return memo;
    }

    public OperationLogBean getMasterLog(String oper, Object bean) throws Exception {
        Class<?> clazz = bean.getClass();
        OperationLogBean log = new OperationLogBean();
        log.setOpertype(oper);
        String businesscode = this.getMasterSlaveKey(clazz);
        log.setCode(businesscode);
        if ("I".equalsIgnoreCase(oper)) {
            log.setNewvalue(this.getFieldValue(clazz, bean, businesscode).toString());
        } else if ("D".equalsIgnoreCase(oper)) {
            log.setOldvalue(this.getFieldValue(clazz, bean, businesscode).toString());
        }
        String memo = this.getUniqueKeyValue(bean);
        log.setMemo(memo);
        return log;
    }

    public boolean checkIsLog(String key, String oper, String type) {
        if ("Slave".equals(type) && ("I".equals(oper) || "D".equals(oper))) {
            String filters = key + "-" + oper;
            Map<String, Object> map = logList.get();
            if (!StringUtils.isEmpty(map) && !StringUtils.isEmpty(map = map.entrySet().stream().filter(e -> ((String)e.getKey()).equals(filters)).collect(Collectors.toMap(e -> (String)e.getKey(), e -> e.getValue()))) && map.size() > 0) {
                return true;
            }
        }
        return false;
    }

    public String getBusinessKeyValue(AbstractEntityBean originalbean) throws Exception {
        String businesscode = this.getMasterSlaveKey(originalbean.getClass());
        return originalbean.getEnt_id() + "-" + this.getFieldValue(originalbean.getClass(), originalbean, businesscode).toString();
    }
}

