/*
 * Decompiled with CFR 0.152.
 */
package com.efuture.ocp.common.util;

import com.alibaba.fastjson.JSONObject;
import com.efuture.ocp.common.util.Utils;
import java.io.BufferedReader;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.Map;
import javax.net.ssl.HttpsURLConnection;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.HttpEntity;
import org.apache.http.StatusLine;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.util.EntityUtils;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;

public class HttpUtils {
    public static String getFullURL(JSONObject para) {
        String result = null;
        for (String key : para.keySet()) {
            if (StringUtils.isEmpty(result)) {
                result = key.concat("=").concat(para.getString(key));
                continue;
            }
            result = result.concat("&").concat(key).concat("=").concat(para.getString(key));
        }
        return result;
    }

    public static String getRequest(String url) throws Exception {
        BufferedReader in = null;
        try {
            String line;
            URL realUrl = new URL(Utils.getEnvValue(url));
            URLConnection connection = realUrl.openConnection();
            connection.setRequestProperty("accept", "*/*");
            connection.setRequestProperty("connection", "Keep-Alive");
            connection.setRequestProperty("user-agent", "Mozilla/4.0 (compatible; MSIE 6.0; Windows NT 5.1;SV1)");
            connection.setConnectTimeout(5000);
            connection.setReadTimeout(5000);
            connection.connect();
            in = new BufferedReader(new InputStreamReader(connection.getInputStream()));
            StringBuffer sb = new StringBuffer();
            while ((line = in.readLine()) != null) {
                sb.append(line);
            }
            String string = sb.toString();
            return string;
        }
        catch (Exception e) {
            throw e;
        }
        finally {
            try {
                if (in != null) {
                    in.close();
                }
            }
            catch (Exception e2) {
                e2.printStackTrace();
            }
        }
    }

    public static String postRequest(String url, String content, String encoding) throws IOException {
        URL realUrl = null;
        HttpURLConnection connection = null;
        try {
            realUrl = new URL(Utils.getEnvValue(url));
            connection = (HttpURLConnection)realUrl.openConnection();
            connection.setConnectTimeout(10000);
            connection.setReadTimeout(10000);
            connection.setDoOutput(true);
            connection.setDoInput(true);
            connection.setRequestMethod("POST");
            connection.setRequestProperty("Accept", "application/json");
            connection.setRequestProperty("Content-Type", "application/json");
            connection.setUseCaches(false);
            connection.connect();
            DataOutputStream out = new DataOutputStream(connection.getOutputStream());
            out.write(content.getBytes(encoding));
            out.flush();
            out.close();
            BufferedReader reader = new BufferedReader(new InputStreamReader(connection.getInputStream(), encoding));
            StringBuffer buffer = new StringBuffer();
            String line = "";
            while ((line = reader.readLine()) != null) {
                buffer.append(line);
            }
            reader.close();
            String string = buffer.toString();
            return string;
        }
        catch (IOException e) {
            throw e;
        }
        finally {
            if (connection != null) {
                connection.disconnect();
            }
        }
    }

    public static String postRequestxml(String urlStr, String content, String encoding_send, String encoding_return) throws IOException {
        URL realUrl = null;
        HttpURLConnection connection = null;
        try {
            realUrl = new URL(Utils.getEnvValue(urlStr));
            connection = (HttpURLConnection)realUrl.openConnection();
            connection.setConnectTimeout(30000);
            connection.setReadTimeout(30000);
            connection.setDoOutput(true);
            connection.setDoInput(true);
            connection.setRequestMethod("POST");
            connection.setRequestProperty("Accept", "text/xml");
            connection.setRequestProperty("Content-Type", "text/xml");
            connection.setUseCaches(false);
            connection.connect();
            DataOutputStream out = new DataOutputStream(connection.getOutputStream());
            out.write(content.getBytes(encoding_send));
            out.flush();
            out.close();
            BufferedReader reader = new BufferedReader(new InputStreamReader(connection.getInputStream(), encoding_return));
            StringBuffer buffer = new StringBuffer();
            String line = "";
            while ((line = reader.readLine()) != null) {
                buffer.append(line);
            }
            reader.close();
            String string = buffer.toString();
            return string;
        }
        catch (IOException e) {
            throw e;
        }
        finally {
            if (connection != null) {
                connection.disconnect();
            }
        }
    }

    public static String postRequest(String url, String content, String auth, String encoding) throws IOException {
        URL realUrl = null;
        HttpURLConnection connection = null;
        try {
            realUrl = new URL(Utils.getEnvValue(url));
            connection = (HttpsURLConnection)realUrl.openConnection();
            connection.setConnectTimeout(10000);
            connection.setReadTimeout(10000);
            connection.setDoOutput(true);
            connection.setDoInput(true);
            connection.setRequestMethod("POST");
            connection.setRequestProperty("Accept", "application/json");
            connection.setRequestProperty("Content-Type", "application/json");
            connection.setRequestProperty("Authorization", auth);
            connection.setUseCaches(false);
            connection.connect();
            DataOutputStream out = new DataOutputStream(connection.getOutputStream());
            out.write(content.getBytes(encoding));
            out.flush();
            out.close();
            BufferedReader reader = new BufferedReader(new InputStreamReader(connection.getInputStream(), encoding));
            StringBuffer buffer = new StringBuffer();
            String line = "";
            while ((line = reader.readLine()) != null) {
                buffer.append(line);
            }
            reader.close();
            String string = buffer.toString();
            return string;
        }
        catch (IOException e) {
            throw e;
        }
        finally {
            if (connection != null) {
                connection.disconnect();
            }
        }
    }

    public static String postRequestHttp(String url, String content, String auth, String encoding) throws IOException {
        URL realUrl = null;
        HttpURLConnection connection = null;
        try {
            realUrl = new URL(Utils.getEnvValue(url));
            connection = (HttpURLConnection)realUrl.openConnection();
            connection.setConnectTimeout(10000);
            connection.setReadTimeout(10000);
            connection.setDoOutput(true);
            connection.setDoInput(true);
            connection.setRequestMethod("POST");
            connection.setRequestProperty("Accept", "application/json");
            connection.setRequestProperty("Content-Type", "application/json");
            connection.setRequestProperty("Authorization", auth);
            connection.setUseCaches(false);
            connection.connect();
            DataOutputStream out = new DataOutputStream(connection.getOutputStream());
            out.write(content.getBytes(encoding));
            out.flush();
            out.close();
            BufferedReader reader = new BufferedReader(new InputStreamReader(connection.getInputStream(), encoding));
            StringBuffer buffer = new StringBuffer();
            String line = "";
            while ((line = reader.readLine()) != null) {
                buffer.append(line);
            }
            reader.close();
            String string = buffer.toString();
            return string;
        }
        catch (IOException e) {
            throw e;
        }
        finally {
            if (connection != null) {
                connection.disconnect();
            }
        }
    }

    public static JSONObject postRequestWithAuthorization(String url, Map map, String Authorization, String[] fields) throws IOException, DocumentException {
        JSONObject json = new JSONObject();
        try {
            BufferedReader in = null;
            StringBuffer sb = new StringBuffer("");
            HttpPost httppost = new HttpPost(Utils.getEnvValue(url));
            httppost.addHeader("Authorization", Authorization);
            ArrayList<BasicNameValuePair> params = new ArrayList<BasicNameValuePair>();
            for (String name : map.keySet()) {
                String value = String.valueOf(map.get(name));
                params.add(new BasicNameValuePair(name, value));
            }
            httppost.setEntity((HttpEntity)new UrlEncodedFormEntity(params, "UTF-8"));
            CloseableHttpResponse response = new DefaultHttpClient().execute((HttpUriRequest)httppost);
            if (response.getStatusLine().getStatusCode() == 200) {
                in = new BufferedReader(new InputStreamReader(response.getEntity().getContent(), "utf-8"));
                String line = "";
                String NL = System.getProperty("line.separator");
                while ((line = in.readLine()) != null) {
                    sb.append(line + NL);
                }
                in.close();
                System.out.println(sb.toString());
            }
            Document document = DocumentHelper.parseText((String)sb.toString());
            Element rootElt = document.getRootElement();
            for (String filed : fields) {
                json.put(filed, (Object)rootElt.elementText(filed));
            }
            return json;
        }
        catch (UnsupportedEncodingException e) {
            throw e;
        }
        catch (IOException e) {
            throw e;
        }
        catch (DocumentException e) {
            throw e;
        }
    }

    public static String doPost(String url, String params, String auth) throws Exception {
        DefaultHttpClient httpclient = new DefaultHttpClient();
        HttpPost httpPost = new HttpPost(Utils.getEnvValue(url));
        httpPost.setHeader("Accept", "application/json");
        httpPost.setHeader("Content-Type", "application/json");
        httpPost.setHeader("Authorization", auth);
        String charSet = "UTF-8";
        StringEntity entity = new StringEntity(params, charSet);
        httpPost.setEntity((HttpEntity)entity);
        CloseableHttpResponse response = null;
        try {
            response = httpclient.execute((HttpUriRequest)httpPost);
            StatusLine status = response.getStatusLine();
            int state = status.getStatusCode();
            if (state == 200) {
                String jsonString;
                HttpEntity responseEntity = response.getEntity();
                String string = jsonString = EntityUtils.toString((HttpEntity)responseEntity);
                return string;
            }
            throw new Exception("\u9519\u8bef\u4ee3\u7801\uff1a" + String.valueOf(state));
        }
        finally {
            if (response != null) {
                try {
                    response.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                    throw e;
                }
            }
            try {
                httpclient.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }
}

