/*
 * Decompiled with CFR 0.152.
 */
package com.efuture.ocp.common.annotation;

import com.alibaba.fastjson.JSONObject;
import com.efuture.ocp.common.annotation.AutoCache;
import com.efuture.ocp.common.cache.CacheUtils;
import com.efuture.ocp.common.distributedLock.DistributedLockHandle;
import com.efuture.ocp.common.util.MD5Utils;
import java.util.Map;
import org.apache.log4j.Logger;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.StringUtils;

@Aspect
@Component
public class AutoCacheAspect {
    private static final Logger logger = Logger.getLogger(AutoCacheAspect.class);
    @Autowired
    DistributedLockHandle dLockSrv;

    private String getKey(ProceedingJoinPoint point, AutoCache around) {
        String Service2 = around.Service();
        String keyname = around.KeyName();
        String[] ExpKeys = around.ExpKeys().split(",");
        int argindex = around.KeyArgIndex();
        String className = point.getTarget().getClass().getSimpleName();
        String methodName = point.getSignature().getName();
        Object[] args = point.getArgs();
        StringBuffer sb = new StringBuffer();
        if (argindex != -1 && args.length > argindex) {
            JSONObject jsonarg;
            Object arg = args[argindex];
            if (arg instanceof JSONObject) {
                jsonarg = (JSONObject)arg;
            } else if (arg instanceof String) {
                jsonarg = new JSONObject();
                jsonarg.put(String.valueOf(argindex), arg);
            } else {
                jsonarg = (JSONObject)JSONObject.toJSON((Object)arg);
            }
            if (StringUtils.isEmpty((Object)keyname)) {
                if (ExpKeys != null && ExpKeys.length > 0) {
                    jsonarg = (JSONObject)jsonarg.clone();
                    for (String expKey : ExpKeys) {
                        if (!jsonarg.containsKey((Object)expKey)) continue;
                        jsonarg.remove((Object)expKey);
                    }
                    sb.append("_").append(JSONObject.toJSON((Object)jsonarg));
                } else {
                    sb.append("_").append(JSONObject.toJSON((Object)arg));
                }
            } else {
                String[] keys = keyname.split(",");
                StringBuffer sbkey = new StringBuffer();
                for (String key : keys) {
                    Object value;
                    if (key == null || (value = jsonarg.get((Object)key)) == null) continue;
                    sbkey.append("-").append(key).append(":").append(value.toString());
                }
                if (sbkey.length() > 0) {
                    sb.append("_").append(sbkey.toString());
                } else {
                    sb.append("_").append(jsonarg.toJSONString());
                }
            }
        } else if (argindex == 99 && !StringUtils.isEmpty((Object)keyname)) {
            String[] keys = keyname.split(",");
            StringBuffer sbkey = new StringBuffer();
            for (String key : keys) {
                String keyVal = null;
                if (ExpKeys != null && ExpKeys.length > 0) {
                    if (args[Integer.valueOf(key)] instanceof Map) {
                        Map dummy = (Map)args[Integer.valueOf(key)];
                        for (String expKey : ExpKeys) {
                            dummy.remove(expKey);
                        }
                        keyVal = dummy.toString();
                    } else {
                        keyVal = args[Integer.valueOf(key)].toString();
                    }
                } else {
                    keyVal = args[Integer.valueOf(key)].toString();
                }
                if (sbkey.length() > 0) {
                    sb.append("_").append(args[Integer.valueOf(key)].toString());
                    continue;
                }
                sb.append(args[Integer.valueOf(key)].toString());
            }
        } else if (argindex == 100) {
            sb.append("0");
        } else {
            for (Object arg : args) {
                if (arg == null) continue;
                sb.append("_").append(JSONObject.toJSON((Object)arg));
            }
        }
        return Service2.concat(":").concat(className).concat(":").concat(methodName).concat(":").concat(MD5Utils.MD5(sb.toString()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Around(value="@annotation(around)")
    public Object round(ProceedingJoinPoint point, AutoCache around) throws Throwable {
        String lockKey;
        String className = point.getTarget().getClass().getSimpleName();
        String methodName = point.getSignature().getName();
        long starttime = System.currentTimeMillis();
        String cacheKey = this.getKey(point, around);
        Object result = CacheUtils.getCacheUtils(around.CacheLevel()).getData(cacheKey);
        if (!StringUtils.isEmpty((Object)result)) {
            if (!"NULL".equals(result)) return result;
            return null;
        }
        String string = lockKey = cacheKey.concat("-LOCK");
        synchronized (string) {
            try {
                if (!"MEM".equalsIgnoreCase(around.CacheLevel())) {
                    this.dLockSrv.tryLock(lockKey, 60, 1000);
                    result = com.efuture.ocp.common.util.CacheUtils.getCacheUtils(around.CacheLevel()).getData(cacheKey);
                    if (!StringUtils.isEmpty((Object)result)) {
                        if ("NULL".equals(result)) {
                            result = null;
                        }
                        Object object = result;
                        return object;
                    }
                }
                if (StringUtils.isEmpty((Object)(result = point.proceed()))) {
                    CacheUtils.getCacheUtils(around.CacheLevel()).putData(cacheKey, "NULL", 3600);
                } else {
                    int timeout = around.TimeOut() + (int)Math.round(Math.random() * 360.0);
                    CacheUtils.getCacheUtils(around.CacheLevel()).putData(cacheKey, result, timeout);
                    if (!around.Readable()) return result;
                    String readKey = cacheKey.concat("-READABLE");
                    CacheUtils.getCacheUtils(around.CacheLevel()).putDataText(readKey, result.toString(), timeout);
                }
            }
            catch (Throwable e) {
                throw e;
            }
            finally {
                if (!"MEM".equalsIgnoreCase(around.CacheLevel())) {
                    this.dLockSrv.unlock(lockKey);
                }
            }
            return result;
        }
    }
}

