/*
 * Decompiled with CFR 0.152.
 */
package com.efuture.ocp.common.billservice;

import com.alibaba.druid.pool.DruidDataSource;
import com.alibaba.fastjson.JSONObject;
import com.efuture.ocp.common.billservice.ReportService;
import com.efuture.ocp.common.component.BasicComponent;
import com.efuture.ocp.common.entity.ServiceResponse;
import com.efuture.ocp.common.entity.ServiceSession;
import com.efuture.ocp.common.exception.ServiceException;
import com.efuture.omd.storage.FMybatisTemplate;
import com.efuture.omd.storage.mybatis.HashMapCase;
import com.github.pagehelper.Page;
import com.github.pagehelper.PageHelper;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.regex.Matcher;
import javax.sql.DataSource;
import org.apache.ibatis.mapping.BoundSql;
import org.apache.ibatis.mapping.MappedStatement;
import org.apache.ibatis.mapping.ParameterMapping;
import org.apache.ibatis.reflection.MetaObject;
import org.apache.ibatis.session.Configuration;
import org.apache.ibatis.session.RowBounds;
import org.apache.ibatis.type.TypeHandlerRegistry;
import org.mybatis.spring.SqlSessionTemplate;
import org.springframework.util.StringUtils;

public class ReportServiceImpl
extends BasicComponent
implements ReportService {
    protected Map<String, String> dbMap;

    public ReportServiceImpl() {
    }

    public ReportServiceImpl(Map<String, String> dbMap) {
        this.dbMap = dbMap;
    }

    @Override
    public ServiceResponse query(ServiceSession session, JSONObject jsonparam) throws Exception {
        return this.query(session, jsonparam, "report");
    }

    @Override
    public ServiceResponse query(ServiceSession session, JSONObject jsonparam, String datakey) throws Exception {
        if (session == null) {
            return ServiceResponse.buildFailure(session, "50001");
        }
        if (StringUtils.isEmpty((Object)jsonparam)) {
            return ServiceResponse.buildFailure(session, "50003");
        }
        if (StringUtils.isEmpty((Object)jsonparam.get((Object)"queryid"))) {
            return ServiceResponse.buildFailure(session, "50000", "{0} {1} is empty", "", "queryid");
        }
        int pageno = -1;
        int pagesize = 40;
        if (jsonparam.containsKey((Object)"page_no") && !StringUtils.isEmpty((Object)jsonparam.get((Object)"page_no"))) {
            pageno = jsonparam.getInteger("page_no");
            if (pageno <= 0) {
                pageno = 1;
            }
            jsonparam.remove((Object)"page_no");
        }
        if (jsonparam.containsKey((Object)"page_size") && !StringUtils.isEmpty((Object)jsonparam.get((Object)"page_size"))) {
            pagesize = jsonparam.getInteger("page_size");
            if (pagesize <= 0) {
                pagesize = 40;
            }
            if (pagesize > 10000) {
                pagesize = 10000;
            }
            jsonparam.remove((Object)"page_size");
            if (pageno <= 0) {
                pageno = 1;
            }
        }
        RowBounds rowBounds = null;
        if (pageno >= 1) {
            rowBounds = new RowBounds((pageno - 1) * pagesize, pagesize);
        }
        HashMapCase map = new HashMapCase();
        map.put("ent_id", session.getEnt_id());
        for (String key : jsonparam.keySet()) {
            map.put(key, jsonparam.get((Object)key));
        }
        StringBuffer total = new StringBuffer();
        JSONObject json = new JSONObject();
        json.put(datakey, this.doQuery(jsonparam.getString("queryid"), map, rowBounds, total));
        if (total.toString() != "") {
            json.put("total_results", (Object)total.toString());
        } else {
            json.put("total_results", (Object)"0");
        }
        this.queryReportSum(jsonparam.getString("queryid"), map, json);
        this.getReportTot(session, json, jsonparam, total);
        return ServiceResponse.buildSuccess(json);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Map<String, Object>> doQuery(String queryid, Object param, RowBounds rowBounds, StringBuffer total) {
        FMybatisTemplate storage = null;
        try {
            if (this.dbMap != null && param instanceof Map && ((Map)param).containsKey("business")) {
                String dbkey = this.dbMap.get(((Map)param).get("business").toString());
                storage = this.getStorageOperations(dbkey, FMybatisTemplate.class);
            } else {
                storage = this.getStorageOperations(FMybatisTemplate.class);
            }
            SqlSessionTemplate db = storage.getSqlSessionTemplate();
            ArrayList<Map<String, Object>> list = new ArrayList();
            if (rowBounds == null) {
                list = db.selectList(queryid, param);
                this.filter(db, queryid, list);
            } else {
                list = db.selectList(queryid, param, rowBounds);
                this.filter(db, queryid, list);
                if (total != null) {
                    total.append(((Page)list).getTotal());
                }
            }
            ArrayList<Map<String, Object>> arrayList = list;
            return arrayList;
        }
        finally {
            if (storage != null) {
                storage.destroy();
            }
        }
    }

    public void queryReportSum(String queryid, Object param, JSONObject json) throws Exception {
        if (param instanceof Map && ((Map)param).containsKey("summary_fld")) {
            String summary_fld = ((Map)param).get("summary_fld").toString();
            String[] summary_flds = summary_fld.split(",");
            if (!StringUtils.isEmpty((Object)summary_fld)) {
                FMybatisTemplate storage = null;
                if (this.dbMap != null && param instanceof Map && ((Map)param).containsKey("business")) {
                    String dbkey = this.dbMap.get(((Map)param).get("business").toString());
                    storage = this.getStorageOperations(dbkey, FMybatisTemplate.class);
                } else {
                    storage = this.getStorageOperations(FMybatisTemplate.class);
                }
                SqlSessionTemplate db = storage.getSqlSessionTemplate();
                MappedStatement mappedStatement = db.getConfiguration().getMappedStatement(queryid);
                BoundSql boundSql = mappedStatement.getBoundSql(param);
                Configuration configuration = mappedStatement.getConfiguration();
                String sql = this.showSql(configuration, boundSql);
                String sumcols = this.sumcol_sql(summary_fld);
                String newsql = "select " + sumcols + " from (" + sql + ") tabsummary";
                Map rs = (Map)db.selectOne("mybatis.sql.select", (Object)newsql);
                if (!StringUtils.isEmpty((Object)rs)) {
                    JSONObject jsonsum = new JSONObject();
                    for (String fld : summary_flds) {
                        jsonsum.put(fld, rs.get(fld));
                    }
                    if (!StringUtils.isEmpty((Object)jsonsum)) {
                        json.put("total_summary", (Object)jsonsum);
                    }
                }
            }
        }
    }

    public void filter(SqlSessionTemplate db, String queryid, List<Map<String, Object>> list) {
    }

    public String sumcol_sql(String cols) throws Exception {
        String sumcols = "";
        for (String col : cols.split(",")) {
            sumcols = sumcols + "sum(" + col + ") " + col + ",";
        }
        return sumcols.substring(0, sumcols.length() - 1);
    }

    public String showSql(Configuration configuration, BoundSql boundSql) {
        Object parameterObject = boundSql.getParameterObject();
        List parameterMappings = boundSql.getParameterMappings();
        String sql = boundSql.getSql().replaceAll("[\\s]+", " ");
        if (parameterMappings.size() > 0 && parameterObject != null) {
            TypeHandlerRegistry typeHandlerRegistry = configuration.getTypeHandlerRegistry();
            if (typeHandlerRegistry.hasTypeHandler(parameterObject.getClass())) {
                sql = sql.replaceFirst("\\?", Matcher.quoteReplacement(this.getParameterValue(parameterObject)));
            } else {
                MetaObject metaObject = configuration.newMetaObject(parameterObject);
                for (ParameterMapping parameterMapping : parameterMappings) {
                    Object obj;
                    String propertyName = parameterMapping.getProperty();
                    if (metaObject.hasGetter(propertyName)) {
                        obj = metaObject.getValue(propertyName);
                        sql = sql.replaceFirst("\\?", Matcher.quoteReplacement(this.getParameterValue(obj)));
                        continue;
                    }
                    if (!boundSql.hasAdditionalParameter(propertyName)) continue;
                    obj = boundSql.getAdditionalParameter(propertyName);
                    sql = sql.replaceFirst("\\?", Matcher.quoteReplacement(this.getParameterValue(obj)));
                }
            }
        }
        return sql;
    }

    private String getParameterValue(Object obj) {
        String value = null;
        if (obj instanceof String) {
            value = "'" + obj.toString() + "'";
        } else if (obj instanceof Date) {
            DateFormat formatter = DateFormat.getDateTimeInstance(2, 2, Locale.CHINA);
            value = "'" + formatter.format((Date)obj) + "'";
        } else {
            value = obj != null ? obj.toString() : "";
        }
        return value;
    }

    protected void getReportTot(ServiceSession session, JSONObject json, JSONObject jsonparam, StringBuffer total) {
        try {
            if (!StringUtils.isEmpty((Object)jsonparam.get((Object)"tot_cols")) && !StringUtils.isEmpty((Object)jsonparam.get((Object)"tot_queryid"))) {
                String tot_cols = jsonparam.getString("tot_cols");
                jsonparam.put("tot_cols", (Object)this.sumcol_sql(tot_cols));
                HashMapCase map = new HashMapCase();
                map.put("ent_id", session.getEnt_id());
                for (String key : jsonparam.keySet()) {
                    map.put(key, jsonparam.get((Object)key));
                }
                List<Map<String, Object>> tot_row = this.doQuery(jsonparam.getString("tot_queryid"), map, new RowBounds(0, 100), total);
                if (tot_row.size() > 0) {
                    Map<String, Object> row = tot_row.get(0);
                    for (String key : tot_cols.split(",")) {
                        json.put(key, row.get(key));
                    }
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public String export(ServiceSession session, JSONObject jsonparam) throws Exception {
        if (session == null) {
            throw new ServiceException("50001", "session is empty", new Object[0]);
        }
        if (StringUtils.isEmpty((Object)jsonparam)) {
            throw new ServiceException("50003", "param is empty", new Object[0]);
        }
        if (StringUtils.isEmpty((Object)jsonparam.get((Object)"fields"))) {
            throw new ServiceException("50000", "{0} {1} is empty", "", "fields");
        }
        StringBuffer flds = new StringBuffer();
        ArrayList<String> fldlst = new ArrayList<String>();
        HashMap<String, String> disps = new HashMap<String, String>();
        HashMap<String, String> fmts = new HashMap<String, String>();
        this.analyzeExportFields(jsonparam.getString("fields"), flds, fldlst, disps, fmts);
        jsonparam.put("fields", (Object)flds.toString());
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("ent_id", session.getEnt_id());
        for (String key : jsonparam.keySet()) {
            map.put(key, jsonparam.get((Object)key));
        }
        List<Map<String, Object>> list = this.doQuery(jsonparam.getString("queryid"), map, null, null);
        this.createExportLog(session, jsonparam.toJSONString(), jsonparam.getString("modulecode"), "export.xls", list.size());
        return this.createExportXLS(list, fldlst, disps, fmts);
    }

    public void createExportLog(ServiceSession session, String param, String modulecode, String fileName, long dataNum) throws Exception {
        String token = session.getToken();
        String userid = "";
        String usercode = "";
        String postid = "";
        if (!StringUtils.isEmpty((Object)token)) {
            try {
                if (!StringUtils.isEmpty((Object)Long.toString(session.getUser_id()))) {
                    userid = Long.toString(session.getUser_id());
                }
                if (!StringUtils.isEmpty((Object)session.getUser_code())) {
                    usercode = session.getUser_code();
                }
                if (!StringUtils.isEmpty((Object)session.getPostid())) {
                    postid = session.getPostid();
                }
                HashMap<String, Object> exportlog = new HashMap<String, Object>();
                exportlog.put("opdate", new Date());
                exportlog.put("userid", userid);
                exportlog.put("usercode", usercode);
                exportlog.put("postid", postid);
                exportlog.put("moduleid", modulecode);
                exportlog.put("param", param);
                exportlog.put("total", dataNum);
                exportlog.put("expfilename", fileName);
                this.logger.info((Object)((Object)exportlog).toString());
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    @Override
    public long count(String statement, Object parameter) {
        Page page = PageHelper.startPage((int)1, (int)-1);
        List<Map<String, Object>> list = this.doQuery(statement, parameter, null, null);
        long count = page.getTotal();
        return count;
    }

    @Override
    public ServiceResponse getrptinfo(ServiceSession session, JSONObject jsonparam) throws Exception {
        this.checkPara(session, jsonparam);
        this.getParamWithCheck(jsonparam, "queryid", true, "");
        this.getParamWithCheck(jsonparam, "moduleCode", true, "");
        String info = this.doGetRptInfo(session, jsonparam);
        JSONObject json = new JSONObject();
        json.put("rptinfo", (Object)info);
        json.put("modulecode", (Object)jsonparam.getString("moduleCode"));
        return ServiceResponse.buildSuccess(json);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String doGetRptInfo(ServiceSession session, JSONObject jsonparam) {
        FMybatisTemplate storage = null;
        try {
            if (this.dbMap != null && !StringUtils.isEmpty((Object)jsonparam.get((Object)"business"))) {
                String dbkey = this.dbMap.get(jsonparam.getString("business"));
                storage = this.getStorageOperations(dbkey, FMybatisTemplate.class);
            } else {
                storage = this.getStorageOperations(FMybatisTemplate.class);
            }
            SqlSessionTemplate db = storage.getSqlSessionTemplate();
            StringBuffer str = new StringBuffer();
            this.getRptDbConfig(db, str);
            this.getRptSql(session, db, jsonparam, str);
            if (!StringUtils.isEmpty((Object)str)) {
                String string = str.toString();
                return string;
            }
            String string = null;
            return string;
        }
        finally {
            if (storage != null) {
                storage.destroy();
            }
        }
    }

    public void getRptDbConfig(SqlSessionTemplate db, StringBuffer str) {
        DataSource dataSource = db.getConfiguration().getEnvironment().getDataSource();
        DruidDataSource druiddataSource = (DruidDataSource)dataSource;
        str.append("# jdbc\u8fde\u63a5\u4fe1\u606f").append("\n");
        str.append("driver=" + druiddataSource.getDriverClassName()).append("\n");
        str.append("url=" + druiddataSource.getUrl()).append("\n");
        str.append("username=" + druiddataSource.getUsername()).append("\n").append("\n");
    }

    public void getRptSql(ServiceSession session, SqlSessionTemplate db, JSONObject jsonparam, StringBuffer str) {
        MappedStatement mappedStatement = db.getConfiguration().getMappedStatement(jsonparam.getString("queryid"));
        HashMapCase map = new HashMapCase();
        map.put("ent_id", session.getEnt_id());
        for (String key : jsonparam.keySet()) {
            map.put(key, jsonparam.get((Object)key));
        }
        BoundSql boundSql = mappedStatement.getBoundSql((Object)map);
        str.append("\u8d44\u6e90\u6587\u4ef6\uff1a" + mappedStatement.getResource()).append("\n");
        str.append("select id:" + jsonparam.getString("queryid")).append("\n");
        str.append("\u62a5\u8868sql:").append("\n");
        str.append(boundSql.getSql());
    }
}

