/*
 * Decompiled with CFR 0.152.
 */
package com.efuture.ocp.common.filter;

import com.efuture.ocp.common.filter.GzipRequestWrapper;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.util.zip.GZIPOutputStream;
import javax.servlet.ServletOutputStream;
import javax.servlet.WriteListener;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpServletResponseWrapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GzipResponseWrapper
extends HttpServletResponseWrapper {
    public static final Logger LOGGER = LoggerFactory.getLogger(GzipRequestWrapper.class);
    private GZIPServletOutputStream outputStream;
    private PrintWriter writer;

    public GzipResponseWrapper(HttpServletResponse request) {
        super(request);
    }

    public synchronized ServletOutputStream getOutputStream() throws IOException {
        if (this.writer != null) {
            throw new IllegalStateException("getWriter() already called.");
        }
        if (this.outputStream == null) {
            this.outputStream = new GZIPServletOutputStream(super.getOutputStream());
        }
        return this.outputStream;
    }

    public synchronized PrintWriter getWriter() throws IOException {
        if (this.writer == null && this.outputStream != null) {
            throw new IllegalStateException("getOutputStream() already called.");
        }
        if (this.writer == null) {
            this.outputStream = new GZIPServletOutputStream(super.getOutputStream());
            this.writer = new PrintWriter(new OutputStreamWriter((OutputStream)((Object)this.outputStream), "UTF-8"));
        }
        return this.writer;
    }

    public void flushBuffer() throws IOException {
        if (this.writer != null) {
            this.writer.flush();
        } else if (this.outputStream != null) {
            this.outputStream.flush();
        }
        super.flushBuffer();
    }

    public void setContentLength(int length) {
    }

    public void setContentLengthLong(long length) {
    }

    public void setHeader(String name, String value) {
        if (!"content-length".equalsIgnoreCase(name)) {
            super.setHeader(name, value);
        }
    }

    public void addHeader(String name, String value) {
        if (!"content-length".equalsIgnoreCase(name)) {
            super.setHeader(name, value);
        }
    }

    public void setIntHeader(String name, int value) {
        if (!"content-length".equalsIgnoreCase(name)) {
            super.setIntHeader(name, value);
        }
    }

    public void addIntHeader(String name, int value) {
        if (!"content-length".equalsIgnoreCase(name)) {
            super.setIntHeader(name, value);
        }
    }

    public void finishResponse() throws IOException {
        if (this.writer != null) {
            this.writer.close();
        } else if (this.outputStream != null) {
            this.outputStream.finish();
        }
    }

    public class GZIPServletOutputStream
    extends ServletOutputStream {
        private final ServletOutputStream servletOutputStream;
        private final GZIPOutputStream gzipStream;

        public GZIPServletOutputStream(ServletOutputStream servletOutputStream) throws IOException {
            this.servletOutputStream = servletOutputStream;
            this.gzipStream = new GZIPOutputStream((OutputStream)servletOutputStream);
        }

        public boolean isReady() {
            return this.servletOutputStream.isReady();
        }

        public void setWriteListener(WriteListener writeListener) {
            this.servletOutputStream.setWriteListener(writeListener);
        }

        public void write(int b) throws IOException {
            this.gzipStream.write(b);
        }

        public void close() throws IOException {
            this.gzipStream.close();
        }

        public void flush() throws IOException {
            this.gzipStream.flush();
        }

        public void finish() throws IOException {
            this.gzipStream.finish();
        }
    }
}

