/*
 * Decompiled with CFR 0.152.
 */
package com.efuture.ocp.common.restclientext;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.efuture.ocp.common.entity.ServiceResponse;
import com.efuture.ocp.common.entity.ServiceSession;
import com.efuture.ocp.common.exception.ServiceException;
import com.efuture.ocp.common.proxy.EnterpriseConfigBean;
import com.efuture.ocp.common.rest.ServiceLogs;
import com.efuture.ocp.common.util.CacheUtils;
import com.efuture.ocp.common.util.RestClientUtils;
import com.sun.jersey.api.client.Client;
import com.sun.jersey.api.client.WebResource;
import com.sun.jersey.core.util.MultivaluedMapImpl;
import javax.ws.rs.core.MultivaluedMap;
import org.apache.commons.lang3.StringUtils;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Component;

@Lazy(value=true)
@Component(value="RestClientUtils_MyShop")
public class RestClientUtils_MyShop
extends RestClientUtils {
    private String getData(JSONObject json, String key, String defval) {
        if (json.containsKey((Object)key)) {
            return json.getString(key);
        }
        return defval;
    }

    @Override
    public ServiceResponse sendRequest(ServiceSession session, String baseUrl, EnterpriseConfigBean ent, JSONObject param, String dataNode) throws Exception {
        String urlstr = this.getUrl(session, baseUrl, ent.getSrvConfig("authUrl", true), ent.getSrvConfig("authKey", true));
        String result = this.PostDataLog(session, urlstr, ent.getSrvConfig("authKey", true), param, "UTF-8");
        ServiceLogs.debuglog("", "myshop.client.url:".concat(urlstr), 0L);
        ServiceLogs.debuglog("", "myshop.client.authKey:".concat(ent.getSrvConfig("authKey", true)), 0L);
        ServiceLogs.debuglog("", "myshop.client.param:".concat(param.toJSONString()), 0L);
        JSONObject ret = JSONObject.parseObject((String)result);
        ServiceLogs.debuglog("", "myshop.client.result:".concat(ret.toJSONString()), 0L);
        String retcode = this.getData(ret, "code", "0");
        if (!"0".equals(retcode)) {
            return ServiceResponse.buildFailure(session, "10000", this.getData(ret, "msg", "N/A"));
        }
        retcode = this.getData(ret, "returncode", "0");
        if (!"0".equals(retcode)) {
            return ServiceResponse.buildFailure(session, "10000", this.getData(ret, "data", "N/A"));
        }
        if (!StringUtils.isEmpty((CharSequence)dataNode) && ret.containsKey((Object)dataNode)) {
            return ServiceResponse.buildSuccess(ret.get((Object)dataNode));
        }
        return ServiceResponse.buildSuccess(ret);
    }

    public String getTokenStr(ServiceSession session, String authUrl, String authKey) throws Exception {
        ServiceLogs.debuglog("go getTokenStr", "entid:" + session.getEnt_id() + ",authUrl:" + authUrl + ",authKey: authKey", 0L);
        String memKey = "MyShop:token:" + session.getEnt_id();
        String accessToken = null;
        JSONObject remote_token = new JSONObject();
        if (StringUtils.isEmpty(accessToken)) {
            JSONObject param = new JSONObject();
            param.put("authorization", (Object)authKey);
            Object result = RestClientUtils.getRestUtils().sendRequest((Object)session, authUrl, param, new defaultRequestCallback(), "notrace");
            if (result != null) {
                remote_token = JSON.parseObject((String)((String)result));
                ServiceLogs.debuglog("getTokenStr", remote_token.toJSONString(), 0L);
            }
            if (remote_token.containsKey((Object)"access_token")) {
                accessToken = remote_token.getString("access_token");
                int expires_in = remote_token.getIntValue("expires_in");
                CacheUtils.getCacheUtils().putData(memKey, accessToken, expires_in - 10);
            } else {
                throw new ServiceException("10000", "\u83b7\u53d6\u4ee3\u7406TOKEN\u9519\u8bef,\u8bf7\u8054\u7cfb\u7cfb\u7edf\u7ba1\u7406\u5458\uff01", new Object[0]);
            }
        }
        return "&access_token=".concat(accessToken);
    }

    public String getUrl(ServiceSession session, String baseUrl, String authUrl, String authKey) throws Exception {
        if (!StringUtils.isEmpty((CharSequence)authUrl)) {
            String tokenStr = this.getTokenStr(session, authUrl, authKey);
            return baseUrl.concat(tokenStr);
        }
        return baseUrl;
    }

    protected String PostDataLog(ServiceSession session, String urlStr, String authKey, JSONObject jsonparam, String encoding) throws Exception {
        String result = this.PostData(session, urlStr, authKey, jsonparam, encoding);
        return result;
    }

    protected String PostData(ServiceSession session, String urlStr, String authKey, JSONObject jsonparam, String encoding) throws Exception {
        jsonparam.put("authorization", (Object)authKey);
        Object result = RestClientUtils.getRestUtils().sendRequest((Object)session, urlStr, jsonparam, new defaultRequestCallback(), "notrace");
        if (result != null) {
            JSONObject json = JSON.parseObject((String)((String)result));
            return json.toJSONString();
        }
        throw new ServiceException("10000", "\u8bf7\u6c42\u65e0\u54cd\u5e94", new Object[0]);
    }

    public class defaultRequestCallback
    implements RestClientUtils.requestCallback {
        @Override
        public Object onSend(String url, Client client, Object param) throws Exception {
            WebResource webResource = client.resource(url);
            MultivaluedMapImpl queryParams = new MultivaluedMapImpl();
            JSONObject jsonparam = new JSONObject();
            String authorization = null;
            if (param instanceof JSONObject && ((JSONObject)param).containsKey((Object)"authorization")) {
                authorization = ((JSONObject)param).getString("authorization");
                jsonparam = (JSONObject)param;
                jsonparam.remove((Object)"authorization");
            }
            Object resp = ((WebResource.Builder)((WebResource.Builder)webResource.queryParams((MultivaluedMap)queryParams).header("Content-Type", (Object)"application/json").header("Accept", (Object)"application/json")).header("Authorization", (Object)authorization)).post(String.class, (Object)jsonparam);
            return resp;
        }
    }
}

