package com.efuture.ocp.common.component;

import org.apache.log4j.Logger;

import com.efuture.ocp.common.language.MessageSourceHelper;

/**
 * 原始基类，用于处理错误信息
 * 
 * @author QianHB
 * @description
 * 
 */
public class BaseService
{
    private String lastErrMessage = "";
    private int lastErrCode = 0;

    protected Logger logger = null;
    
    public Logger getLogger() 
    {
        if (logger == null) this.logger = Logger.getLogger(this.getClass().getName());
        return this.logger;
    }
        
    public String getLastErrMessage()
    {
        return lastErrMessage;
    }

    public void setLastErrMessage(String lastErrMessage)
    {
        this.lastErrMessage = lastErrMessage;
    }

    public void setLastErrMessage(String returncode, String formatmsg, Object... args)
    {
        this.setLastErrCode(-1);
        this.setLastErrMessage(MessageSourceHelper.getDefault().getMessage(returncode, formatmsg, null, args));
    }

    public int getLastErrCode()
    {
        return lastErrCode;
    }

    public void setLastErrCode(int lastErrCode)
    {
        this.lastErrCode = lastErrCode;
    }
    
    public void printDebug(Object message)
    {
        if (getLogger().isDebugEnabled()) 
        {
            getLogger().debug(message);
        }
    }
}
