/**
 * Copyright (C), 2007-2014, eFuture 北京富基融通科技有限公司
 * FileName:	BasicComponentService.java
 * Author:		亮
 * Date:		2014-5-5 上午10:24:50
 * Description:
 * History:
 * <author>		<time>			<version>		<description>
 */
package com.efuture.ocp.common.component;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.efuture.ocp.common.billservice.BillCommonServiceImpl;
import com.efuture.ocp.common.component.excel.*;
import com.efuture.ocp.common.entity.*;
import com.efuture.ocp.common.exception.ServiceException;
import com.efuture.ocp.common.language.MessageSourceHelper;
import com.efuture.ocp.common.language.ResponseCode;
import com.efuture.ocp.common.user.UserDataRangeSrv;
import com.efuture.ocp.common.util.*;
import com.efuture.omd.storage.FMybatisTemplate;
import com.efuture.omd.storage.FStorageOperations;
import com.lmax.disruptor.*;
import com.lmax.disruptor.dsl.Disruptor;
import com.sun.jersey.multipart.FormDataBodyPart;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.GenericTypeResolver;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.data.mongodb.core.query.Update;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.StringUtils;

import java.lang.reflect.Field;
import java.util.*;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;

/**
 * @author 亮
 * @description
 */
public class BasicComponentService<T extends AbstractEntityBean> extends BasicComponent implements BaseServiceIntf
{
    static final String PARENT_ID_KEY = "parent_id";

    @Autowired
    private GlobRuleSrv globrulesrv;

    @SuppressWarnings("unchecked")
    final Class<T> beanClass = (Class<T>) GenericTypeResolver.resolveTypeArgument(this.getClass(), BasicComponentService.class);

    protected Class<T> getBeanClass()
    {
        return beanClass;
    }

    protected String getBeanTable()
    {
        return AbstractEntityBean.fetchAnnotationTableName(getBeanClass());
    }

    protected String getIdKey() throws IllegalArgumentException, IllegalAccessException
    {
        return getIdKey(null);
    }

    protected String getIdKey(Class<?> cl) throws IllegalArgumentException, IllegalAccessException
    {
        return (String) AbstractEntityBean.fetchDeclaredField(cl == null ? getBeanClass() : cl, "ID_KEY").get(null);
    }

    protected String getOrderFld(Class<?> cl) throws IllegalArgumentException, IllegalAccessException
    {
        Field fld = AbstractEntityBean.fetchDeclaredField(cl == null ? getBeanClass() : cl, "ORDER_FLD");

        if (fld == null) {
            return null;
        }

        return (String) fld.get(null);
    }

    protected String getOrderDir(Class<?> cl) throws IllegalArgumentException, IllegalAccessException
    {
        Field fld = AbstractEntityBean.fetchDeclaredField(cl == null ? getBeanClass() : cl, "ORDER_DIR");

        if (fld == null) {
            return null;
        }

        return (String) fld.get(null);
    }

    protected String[] getUniqueKeys() throws IllegalArgumentException, IllegalAccessException
    {
        return getUniqueKeys(null);
    }

    protected String[] getUniqueKeys(Class<?> cl) throws IllegalArgumentException, IllegalAccessException
    {
        Field fld = AbstractEntityBean.fetchDeclaredField(cl == null ? getBeanClass() : cl, "UNIQUE_KEYS");

        if (fld == null) {
            return null;
        }
        else {
            return (String[]) fld.get(null);
        }
    }

    protected String[] getReturnFields() throws IllegalArgumentException, IllegalAccessException
    {
        return getReturnFields(null);
    }

    protected String[] getReturnFields(Class<?> cl) throws IllegalArgumentException, IllegalAccessException
    {
        Field fld = AbstractEntityBean.fetchDeclaredField(cl == null ? getBeanClass() : cl, "RETURN_FIELDS");

        if (fld == null) {
            return null;
        }
        else {
            return (String[]) fld.get(null);
        }
    }

    @SuppressWarnings("unchecked")
    protected Map<String, Object> getDependency(Class<?> cl) throws IllegalArgumentException, IllegalAccessException
    {
        Field fld = AbstractEntityBean.fetchDeclaredField(cl == null ? getBeanClass() : cl, "DEPENDENCY");

        if (fld == null) {
            return null;
        }
        else {
            return (Map<String, Object>) fld.get(null);
        }
    }

    protected Field getIdField() throws IllegalArgumentException, IllegalAccessException
    {
        Field idfld = AbstractEntityBean.fetchDeclaredField(getBeanClass(), getIdKey());
        return idfld;
    }

    protected String getMasterSlaveKey() throws IllegalArgumentException, IllegalAccessException
    {
        return getMasterSlaveKey(null);
    }

    protected String getMasterSlaveKey(Class<?> cl) throws IllegalArgumentException, IllegalAccessException
    {
        return (String) AbstractEntityBean.fetchDeclaredField(cl == null ? getBeanClass() : cl, "MASTER_SLAVE_KEY")
               .get(null);
    }

    /**
     * 获取bean中定义的属性
     *
     * @param cl
     * @param key
     * @return
     * @throws Exception
     */
    protected Object getBeanDefineKey(Class<?> cl, String key) throws Exception
    {
        try {
            Object obj = AbstractEntityBean.fetchDeclaredField(cl == null ? getBeanClass() : cl, key)
                         .get(null);
            return obj;
        }
        catch (Exception e) {
            return null;
        }
    }

    protected void checkDependency(FStorageOperations storage, AbstractEntityBean bean, Set<String> keys) throws Exception
    {
        if (storage == null) {
            return;
        }

        Map<String, Object> dependencys = getDependency(bean.getClass());

        if (dependencys == null) {
            return;
        }

        Set<String> depkeys = dependencys.keySet();

        for (String key : depkeys) {
            Object depobj = dependencys.get(key);

            if (depobj == null) {
                continue;
            }

            if (keys != null && !keys.contains(key)) {
                continue;
            }

            // 引用依赖值为0表示没有该数据则不检查
            Field depfld = AbstractEntityBean.fetchDeclaredField(bean.getClass(), key);
            Object depval = depfld.get(bean);

            if (StringUtils.isEmpty(depval)) {
                continue;
            }

            if ((depval instanceof Long || depval instanceof Integer) && Long.parseLong(depval.toString()) <= 0) {
                // 依赖引用值<0强制设置为0表示未引用
                depfld.set(bean, 0);
                continue;
            }

            // 查询依赖表数据是否存在
            String deptable = null;
            String idkey = null;
            String[] ohkey = null;

            if (depobj instanceof String) {
                // 依赖定义格式: dict:did,dict_group_code=goods_tag
                String[] ss = ((String) depobj).split(":");

                if (ss.length > 0) {
                    deptable = ss[0].trim();
                }

                if (ss.length > 1) {
                    ohkey = ss[1].split(",");
                    idkey = ohkey[0].trim();
                }
            }
            else if (depobj instanceof Class) {
                idkey = (String) AbstractEntityBean.fetchDeclaredField((Class<?>) depobj, "ID_KEY").get(null);
                deptable = AbstractEntityBean.fetchAnnotationTableName((Class<?>) depobj);
            }

            if (StringUtils.isEmpty(idkey)) {
                throw new ServiceException(ResponseCode.Failure.DEPENDENCY_IS_ILLEGAL, "{0} 's dependency {1} is illegal key in {2}", key, idkey,
                                           MessageSourceHelper.getMessage(deptable, bean.getLang()));
            }

            Criteria criteria = Criteria.where("ent_id").is(bean.getEnt_id()).and(idkey).is(depval);

            if (ohkey != null && ohkey.length > 1) {
                for (int i = 1; i < ohkey.length; i++) {
                    String[] ss = ohkey[i].split("=");

                    if (ss.length <= 1) {
                        continue;
                    }

                    criteria = criteria.and(ss[0].trim()).is(ss[1].trim());
                }
            }

            Query query = new Query(criteria);
            query.fields().include(idkey);

            if (key.endsWith("_id")) {
                query.fields().include("code");
                query.fields().include("name");
            }

            // 查询依赖对象是否存在
            Map<String, Object> depbean = storage.selectOne(query, deptable);

            if (depbean == null) {
                throw new ServiceException(ResponseCode.Failure.DEPENDENCY_NOT_EXIST, "{0} [{1}] does not exist with {2} of {3}", key, depval, idkey,
                                           MessageSourceHelper.getMessage(deptable, bean.getLang()));
            }

            // 刷新Bean对象中对依赖对象code,name的冗余引用
            if (key.endsWith("_id")) {
                // 刷code引用
                if (!StringUtils.isEmpty(depbean.get("code"))) {
                    // xxxx_code
                    String codekey = key.replace("_id", "_code");
                    Field codefld = AbstractEntityBean.fetchDeclaredField(bean.getClass(), codekey);

                    if (codefld != null) {
                        codefld.set(bean, depbean.get("code"));

                        if (keys != null) {
                            keys.add(codekey);
                        }
                    }
                }

                // 刷name引用
                if (!StringUtils.isEmpty(depbean.get("name"))) {
                    // xxxx_name
                    String codekey = key.replace("_id", "_name");
                    Field codefld = AbstractEntityBean.fetchDeclaredField(bean.getClass(), codekey);

                    if (codefld != null) {
                        codefld.set(bean, depbean.get("name"));

                        if (keys != null) {
                            keys.add(codekey);
                        }
                    }
                    else {
                        // xxxx
                        codekey = key.replace("_id", "");
                        codefld = AbstractEntityBean.fetchDeclaredField(bean.getClass(), codekey);

                        if (codefld != null) {
                            codefld.set(bean, depbean.get("name"));

                            if (keys != null) {
                                keys.add(codekey);
                            }
                        }
                    }
                }
            }
        }
    }

    protected boolean haveParentDependency() throws IllegalArgumentException, IllegalAccessException
    {
        Map<String, Object> dependencys = getDependency(null);
        return dependencys != null && dependencys.keySet().contains(PARENT_ID_KEY);
    }

    @Override
    protected void onAddValid(FStorageOperations storage, AbstractEntityBean bean, String id, String... uniques) throws Exception
    {
        super.onAddValid(storage, bean, id, uniques);
        // 检查依赖字段
        checkDependency(storage, bean, null);
    }
    @Transactional(propagation = Propagation.REQUIRED)
    public ServiceResponse add(ServiceSession session, String param) throws Exception
    {
        try {
            // 参数检查
            if (session == null) {
                return ServiceResponse.buildFailure(session, ResponseCode.Exception.SESSION_IS_EMPTY);
            }

            if (StringUtils.isEmpty(param)) {
                return ServiceResponse.buildFailure(session, ResponseCode.Exception.PARAM_IS_EMPTY);
            }

            // 构造Bean
            T bean = StorageUtils.parseBeanObject(param, getBeanClass());
            getIdField().set(bean, UniqueID.getUniqueID());
            bean.initInsertMember(session);
            // 新增
            String idkey = getIdKey();
            long id = doAdd(bean, idkey, getUniqueKeys());
            // 如果有父级数据则更新父级标志
            updateIsParent(bean);
            // 返回应答对象
            JSONObject respdata = new JSONObject();
            respdata.put(idkey, id);
            return ServiceResponse.buildSuccess(respdata);
        }
        /*      异常向外抛才能回滚事务
        		catch(ServiceException ex)
        		{
        			this.getLogger().error(ex.getMessage(),ex);
        			return ServiceResponse.buildFailure(session,ex.getErrorCode(),ex.getMessage(),ex.getErrorArgs());
        		}
        */ finally {
        }
    }

    @Override
    protected AbstractEntityBean onUpdateValid(FStorageOperations storage, AbstractEntityBean bean, Set<String> keys, String id,
            String... uniques) throws Exception
    {
        AbstractEntityBean original = super.onUpdateValid(storage, bean, keys, id, uniques);
        // 检查依赖字段
        checkDependency(storage, bean, keys);
        return original;
    }
    @Transactional(propagation = Propagation.REQUIRED)
    public ServiceResponse update(ServiceSession session, String param) throws Exception
    {
        try {
            // 参数检查
            if (session == null) {
                return ServiceResponse.buildFailure(session, ResponseCode.Exception.SESSION_IS_EMPTY);
            }

            if (StringUtils.isEmpty(param)) {
                return ServiceResponse.buildFailure(session, ResponseCode.Exception.PARAM_IS_EMPTY);
            }

            // 构造Bean
            T bean = StorageUtils.parseBeanObject(param, getBeanClass());
            bean.initUpdateMember(session);
            // 更新
            Set<String> keys = new HashSet<String>(JSON.parseObject(param).keySet());
            String idkey = getIdKey();
            Object id = null;

            // 如果有父级数据则更新父级标志
            if (haveParentDependency() && keys.contains(PARENT_ID_KEY)) {
                AbstractEntityBean original = execUpdate(bean, keys, idkey, getUniqueKeys());
                // 更新新父级
                updateIsParent(bean);

                // 更新原父级
                if (original != null) {
                    updateIsParent(original);
                    java.lang.reflect.Field fld = bean.fetchDeclaredField(idkey);
                    id = fld.getLong(original);
                }
            }
            else {
                id = doUpdate(bean, keys, idkey, getUniqueKeys());
            }

            // 返回应答对象
            JSONObject respdata = new JSONObject();
            respdata.put(idkey, id);
            return ServiceResponse.buildSuccess(respdata);
        }
        /*      异常向外抛才能回滚事务
        		catch(ServiceException ex)
        		{
        			this.getLogger().error(ex.getMessage(),ex);
        			return ServiceResponse.buildFailure(session,ex.getErrorCode(),ex.getMessage(),ex.getErrorArgs());
        		}
        */ finally {
        }
    }

    //更新bean的指定列，keys为空时更新所有列
    public int updateBean(AbstractEntityBean bean, Set<String> keys) throws Exception
    {
        if (keys == null) {
            keys = new HashSet<String>();
            StringBuffer sb = new StringBuffer();
            bean.fetchAllDeclaredField(sb);
            String[] ss = sb.toString().split(",");

            for (int i = 0; i < ss.length; i++) {
                keys.add(ss[i]);
            }
        }

        //移除主键
        String idKey = getIdKey(bean.getClass());
        keys.remove("ent_id");
        keys.remove(idKey);

        try {
            String masterSlaveKey = getMasterSlaveKey(bean.getClass());
            String[] slaveKeys = masterSlaveKey.split(",");

            for (int i = 0; i < slaveKeys.length; i++) {
                keys.remove(slaveKeys[i]);
            }
        }
        catch (Exception e) {
        }

        Update upt = StorageUtils.createUpdateFormBean(bean, keys);
        JSONObject json = (JSONObject) JSONObject.toJSON(bean);
        Criteria criteria = Criteria.where(idKey).is(json.get(idKey));
        Query query = new Query(criteria);
        int row = getStorageOperations().update(query, upt, bean.getClass());
        return row;
    }

    public int updateBeanKeys(AbstractEntityBean bean, String fields) throws Exception
    {
        Set<String> keys = new HashSet<String>();
        String[] ss = fields.split(",");

        for (int i = 0; i < ss.length; i++) {
            keys.add(ss[i]);
        }

        return updateBean(bean, keys);
    }

    public AbstractEntityBean onDeleteValid(FStorageOperations storage, AbstractEntityBean bean, String id, String... keys) throws Exception
    {
        AbstractEntityBean original = super.onDeleteValid(storage, bean, id, keys);

        // 父级数据不允许直接删除
        if (storage != null) {
            Map<String, Object> dependencys = getDependency(bean.getClass());

            if (dependencys == null || !dependencys.keySet().contains(PARENT_ID_KEY)) {
                return original;
            }

            if (original != null) {
                Field idfld = bean.fetchDeclaredField(id);

                if (bean.fetchDeclaredField("is_parent").getBoolean(original)) {
                    throw new ServiceException(ResponseCode.Failure.IS_PARENT, "{0} {1} [{2}] is parent,can not delete",
                                               MessageSourceHelper.getMessage(bean.fetchAnnotationTableName(), bean.getLang()), id, idfld.get(bean));
                }
            }
        }

        return original;
    }
    @Transactional(propagation = Propagation.REQUIRED)
    public ServiceResponse delete (ServiceSession session, String param) throws Exception
    {
        try {
            // 参数检查
            if (session == null) {
                return ServiceResponse.buildFailure(session, ResponseCode.Exception.SESSION_IS_EMPTY);
            }

            if (StringUtils.isEmpty(param)) {
                return ServiceResponse.buildFailure(session, ResponseCode.Exception.PARAM_IS_EMPTY);
            }

            // 构造Bean
            T bean = StorageUtils.parseBeanObject(param, getBeanClass());
            bean.initUpdateMember(session);
            // 删除
            String idkey = getIdKey();
            Object id = null;

            // 如果有父级数据则更新父级标志
            if (haveParentDependency()) {
                AbstractEntityBean original = execDelete(bean, idkey);

                if (original != null) {
                    updateIsParent(original);
                    java.lang.reflect.Field fld = bean.fetchDeclaredField(idkey);
                    id = fld.getLong(original);
                }
            }
            else {
                id = doDelete(bean, idkey);
            }

            // 返回应答对象
            JSONObject respdata = new JSONObject();
            respdata.put(idkey, id);
            return ServiceResponse.buildSuccess(respdata);
        }
        /*      异常向外抛才能回滚事务
        		catch(ServiceException ex)
        		{
        			this.getLogger().error(ex.getMessage(),ex);
        			return ServiceResponse.buildFailure(session,ex.getErrorCode(),ex.getMessage(),ex.getErrorArgs());
        		}
        */ finally {
        }
    }



    protected void updateIsParent(AbstractEntityBean bean) throws Exception
    {
        String idkey = getIdKey();

        if (!haveParentDependency()) {
            return;
        }

        // 得到父ID
        Object parent_id = bean.fetchDeclaredField(PARENT_ID_KEY).get(bean);

        if ((parent_id instanceof Long || parent_id instanceof Integer) && Long.parseLong(parent_id.toString()) <= 0) {
            return;
        }

        if (parent_id instanceof String && StringUtils.isEmpty(parent_id)) {
            return;
        }

        // 确定父对象是否有子对象
        JSONObject json = new JSONObject();
        json.put("ent_id", bean.getEnt_id());
        json.put(PARENT_ID_KEY, parent_id);
        T childbean = doSearchOne(json, getBeanClass());
        // 修改父对象的父级标志
        json.clear();
        json.put("ent_id", bean.getEnt_id());
        json.put(idkey, parent_id);
        json.put("is_parent", childbean != null);
        doUpdate(JSON.toJavaObject(json, getBeanClass()), json.keySet(), idkey);
    }

    @Override
    @Transactional(propagation = Propagation.REQUIRED)
    public ServiceResponse genRuleCode(ServiceSession session, JSONObject jsonparam)
    {
        if (session == null) {
            return ServiceResponse.buildFailure(session, ResponseCode.Exception.SESSION_IS_EMPTY);
        }

        if (StringUtils.isEmpty(jsonparam)) {
            return ServiceResponse.buildFailure(session, ResponseCode.Exception.PARAM_IS_EMPTY);
        }

        String ruleid = jsonparam.getString("ruleid");
        JSONObject json = new JSONObject();
        String prestr = StringUtils.isEmpty(jsonparam.get("prestr")) ? "" : jsonparam.getString("prestr");
        String level = StringUtils.isEmpty(jsonparam.get("level")) ? "" : jsonparam.getString("level");
        JSONObject beanjson = new JSONObject();

        if (!StringUtils.isEmpty(jsonparam.get(getBeanTable()))) {
            beanjson = (JSONObject) jsonparam.get(getBeanTable());
        }

        AbstractEntityBean entity = StorageUtils.parseBeanObject(beanjson, getBeanClass());
        List<String> codes = genRuleCodeBatch(entity, ruleid, prestr, level, 1);
        json.put("code", codes.get(0));
        return ServiceResponse.buildSuccess(json);
    }

    @Override
    public String genRuleCode(AbstractEntityBean bean, String ruleid, String prestr, String level)
    {
        List<String> codes = genRuleCodeBatch(bean, ruleid, prestr, level, 1);
        return codes.get(0);
    }

    @Override
    public List<String> genRuleCodeBatch(AbstractEntityBean bean, String ruleid, String prestr, String level, int nums)
    {
        JSONObject json = (JSONObject) JSONObject.toJSON(bean);
        List<String> codes = globrulesrv.doGenRuleCodeBatch(bean.getEnt_id(), ruleid, prestr, level, nums, json);
        return codes;
    }

    @Override
    public ServiceResponse genUniqueID(ServiceSession session, JSONObject jsonparam)
    {
        JSONObject json = new JSONObject();
        long uid = UniqueID.getUniqueID();
        json.put("data", uid);
        return ServiceResponse.buildSuccess(json);
    }
    @Transactional(propagation = Propagation.REQUIRED)
    public ServiceResponse save(ServiceSession session, String param) throws Exception
    {
        try {
            UserDataRangeSrv.setlocalisrange(false);

            // 参数检查
            if (session == null) {
                return ServiceResponse.buildFailure(session, ResponseCode.Exception.SESSION_IS_EMPTY);
            }

            if (StringUtils.isEmpty(param)) {
                return ServiceResponse.buildFailure(session, ResponseCode.Exception.PARAM_IS_EMPTY);
            }

            // 取参数
            JSONArray jsonarray = null;
            Object obj = JSON.parse(param);

            if (obj instanceof JSONArray) {
                jsonarray = (JSONArray) obj;
            }
            else if (obj instanceof JSONObject) {
                jsonarray = ((JSONObject) obj).getJSONArray(getBeanTable());

                if (jsonarray == null) {
                    jsonarray = new JSONArray();
                    jsonarray.add(obj);
                }
            }

            if (jsonarray == null) {
                return ServiceResponse.buildFailure(session, ResponseCode.Exception.PARAM_IS_EMPTY);
            }

            // 循环保存
            JSONArray returnarray = doSave(session, jsonarray);
            // 返回应答对象
            return ServiceResponse.buildSuccess(returnarray);
        }
        /*      异常向外抛才能回滚事务
        		catch(ServiceException ex)
        		{
        			this.getLogger().error(ex.getMessage(),ex);
        			return ServiceResponse.buildFailure(session,ex.getErrorCode(),ex.getMessage(),ex.getErrorArgs());
        		}
        */ finally {
        }
    }
    @Transactional(propagation = Propagation.REQUIRED)
    public JSONArray doSave(ServiceSession session, JSONArray jsonarray) throws Exception
    {
        JSONArray returnarray = new JSONArray();
        String flag = "flag";
        String idkey = getIdKey();

        for (int i = 0; i < jsonarray.size(); i++) {
            JSONObject json = jsonarray.getJSONObject(i);

            if (!json.containsKey(flag)) {
                returnarray.add(new JSONObject());
                continue;
            }

            T bean = StorageUtils.parseBeanObject(json, getBeanClass());

            if ("I".equalsIgnoreCase(json.getString(flag))) {
                getIdField().set(bean, UniqueID.getUniqueID());
                bean.initInsertMember(session);
                JSONObject jsn = new JSONObject();
                jsn.put(idkey, doAdd(bean, idkey, getUniqueKeys()));
                String[] rtnfields = getReturnFields();

                if (!StringUtils.isEmpty(rtnfields)) {
                    for (String rtnfield : rtnfields) {
                        java.lang.reflect.Field fld = bean.fetchDeclaredField(rtnfield);
                        Object obj = fld.get(bean);
                        jsn.put(rtnfield, obj);
                    }
                }

                returnarray.add(jsn);
            }
            else if ("U".equalsIgnoreCase(json.getString(flag))) {
                bean.initUpdateMember(session);
                JSONObject jsn = new JSONObject();
                jsn.put(idkey, doUpdate(bean, json.keySet(), idkey, getUniqueKeys()));
                String[] rtnfields = getReturnFields();

                if (!StringUtils.isEmpty(rtnfields)) {
                    for (String rtnfield : rtnfields) {
                        java.lang.reflect.Field fld = bean.fetchDeclaredField(rtnfield);
                        Object obj = fld.get(bean);
                        jsn.put(rtnfield, obj);
                    }
                }

                returnarray.add(jsn);
            }
            else if ("D".equalsIgnoreCase(json.getString(flag))) {
                bean.initUpdateMember(session);
                JSONObject jsn = new JSONObject();
                jsn.put(idkey, doDelete(bean, idkey));
                returnarray.add(jsn);
            }
        }

        return returnarray;
    }

    public ServiceResponse get(ServiceSession session, JSONObject jsonparam) throws Exception
    {
        try {
            // 参数检查
            if (session == null) {
                return ServiceResponse.buildFailure(session, ResponseCode.Exception.SESSION_IS_EMPTY);
            }

            if (StringUtils.isEmpty(jsonparam)) {
                return ServiceResponse.buildFailure(session, ResponseCode.Exception.PARAM_IS_EMPTY);
            }

            String ignorefilter = getParamWithCheck(jsonparam, "ignorefilter", false, "N");

            String idkey = getIdKey();
            String table = getBeanTable();
            String masterkey = getMasterSlaveKey();

            if (!jsonparam.containsKey(idkey) || StringUtils.isEmpty(jsonparam.get(idkey))) {
                if (!jsonparam.containsKey(masterkey) || StringUtils.isEmpty(jsonparam.get(masterkey))) {
                    return ServiceResponse.buildFailure(session, ResponseCode.Exception.SPECDATA_IS_EMPTY,
                                                        "{0} {1} is empty", table, idkey);
                }
            }

            // 按ID查询
            jsonparam.put("ent_id", session.getEnt_id());
            // 查询
            Object obj = null;

            if (StringUtils.isEmpty(jsonparam.get(BeanConstant.QueryField.PARAMKEY_FIELDS))) {
                obj = doSearchOne(jsonparam, getBeanClass());
            }
            else {
                obj = doSearchOneForMap(jsonparam, getBeanClass());
            }

            if (obj == null) {
                return ServiceResponse.buildFailure(session, ResponseCode.Failure.NOT_EXIST, "{0} {1} [{2}] does not exist", table, idkey, jsonparam.getLong(idkey));
            }

            if ("N".equals(ignorefilter)) {
                obj = filter(obj, getBeanClass());
            }

            // 返回应答对象
            JSONObject respdata = new JSONObject();
            respdata.put(table, obj);
            return ServiceResponse.buildSuccess(respdata);
        }
        catch (ServiceException ex) {
            this.getLogger().error(ex.getMessage(), ex);
            return ServiceResponse.buildFailure(session, ex.getErrorCode(), ex.getMessage(), ex.getErrorArgs());
        }
    }

    public ServiceResponse search(ServiceSession session, JSONObject jsonparam) throws Exception
    {
        try {
            // 参数检查
            if (session == null) {
                return ServiceResponse.buildFailure(session, ResponseCode.Exception.SESSION_IS_EMPTY);
            }

            if (StringUtils.isEmpty(jsonparam)) {
                return ServiceResponse.buildFailure(session, ResponseCode.Exception.PARAM_IS_EMPTY);
            }

            String ignorefilter = getParamWithCheck(jsonparam, "ignorefilter", false, "N");

            // 按条件查
            jsonparam.put("ent_id", session.getEnt_id());
            // 查询
            StringBuffer total = new StringBuffer();
            List<?> list = null;
            //处理模块场景的默认过滤条件
            filterScene(jsonparam);

            if (StringUtils.isEmpty(jsonparam.get(BeanConstant.QueryField.PARAMKEY_FIELDS))) {
                list = doSearch(jsonparam, getBeanClass(), total);
            }
            else {
                list = doSearchForMap(jsonparam, getBeanClass(), total);
            }

            if ("N".equals(ignorefilter)) {
                list = (List<?>) filter(list, getBeanClass());
            }

            // 返回应答对象
            JSONObject respdata = new JSONObject();
            respdata.put("total_results", Long.parseLong(total.toString()));
            respdata.put(getBeanTable(), list);
            return ServiceResponse.buildSuccess(respdata);
        }
        catch (ServiceException ex) {
            this.getLogger().error(ex.getMessage(), ex);
            return ServiceResponse.buildFailure(session, ex.getErrorCode(), ex.getMessage(), ex.getErrorArgs());
        }
    }
    //参数中传入场景
    public void filterScene(JSONObject jsonparam)
    {
        if (!StringUtils.isEmpty(jsonparam.get("scene")) && !StringUtils.isEmpty(jsonparam.get("module"))) {

            Criteria criteria = Criteria.where("ent_id").is(jsonparam.get("ent_id")).and("moduleid").is(jsonparam.get("module")).and("scene").is(jsonparam.get("scene"));
            Query query = new Query(criteria);

            try {
                FMybatisTemplate storage = getGlobalStorageOperations(FMybatisTemplate.class);

                Map<String, Object> map = storage.selectOne(query, "modulesceneconfig");

                if (!StringUtils.isEmpty(map)) {
                    JSONObject condition = JSONObject.parseObject(map.get("condition").toString());

                    if (!StringUtils.isEmpty(condition)) {
                        jsonparam.putAll(condition);
                    }
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }

            jsonparam.remove("scene");
            jsonparam.remove("module");
        }
    }
    public ServiceResponse getchildren(ServiceSession session, JSONObject jsonparam) throws Exception
    {
        try {
            // 参数检查
            if (session == null) {
                return ServiceResponse.buildFailure(session, ResponseCode.Exception.SESSION_IS_EMPTY);
            }

            if (StringUtils.isEmpty(jsonparam)) {
                return ServiceResponse.buildFailure(session, ResponseCode.Exception.PARAM_IS_EMPTY);
            }

            String ignorefilter = getParamWithCheck(jsonparam, "ignorefilter", false, "N");

            if (jsonparam.containsKey("ignorefilter")) {
                jsonparam.remove("ignorefilter");
            }

            String idkey = getIdKey();
            String table = getBeanTable();

            // 按条件查
            if (!jsonparam.containsKey(idkey) || StringUtils.isEmpty(jsonparam.get(idkey))) {
                return ServiceResponse.buildFailure(session, ResponseCode.Exception.SPECDATA_IS_EMPTY, "{0} {1} is empty", table, idkey);
            }

            jsonparam.put("ent_id", session.getEnt_id());
            jsonparam.put(PARENT_ID_KEY, jsonparam.get(idkey));
            jsonparam.remove(idkey);
            // 查询,不限制返回行数
            List<?> list = null;

            if (StringUtils.isEmpty(jsonparam.get(BeanConstant.QueryField.PARAMKEY_FIELDS))) {
                list = doSearch(jsonparam, getBeanClass(), null);
            }
            else {
                list = doSearchForMap(jsonparam, getBeanClass(), null);
            }

            if ("N".equals(ignorefilter)) {
                list = (List<?>) filter(list, getBeanClass());
            }

            // 返回应答对象
            JSONObject respdata = new JSONObject();
            respdata.put(table, list);
            return ServiceResponse.buildSuccess(respdata);
        }
        catch (ServiceException ex) {
            this.getLogger().error(ex.getMessage(), ex);
            return ServiceResponse.buildFailure(session, ex.getErrorCode(), ex.getMessage(), ex.getErrorArgs());
        }
    }

    public Object export(ServiceSession session, JSONObject jsonparam) throws Exception
    {
        // 参数检查
        if (session == null) {
            throw new ServiceException(ResponseCode.Exception.SESSION_IS_EMPTY, "session is empty");
        }

        if (StringUtils.isEmpty(jsonparam)) {
            throw new ServiceException(ResponseCode.Exception.PARAM_IS_EMPTY, "param is empty");
        }

        // 导出必须指定字段
        if (StringUtils.isEmpty(jsonparam.get(BeanConstant.QueryField.PARAMKEY_FIELDS))) {
            throw new ServiceException(ResponseCode.EXCEPTION, "{0} {1} is empty", "", BeanConstant.QueryField.PARAMKEY_FIELDS);
        }

        // 解析字段名
        // fields="fld1:XXXX:fmt,fld2:XXXXX:fmt,fld3:XXXXX:fmt";
        StringBuffer flds = new StringBuffer();
        List<String> fldlst = new ArrayList<String>();
        Map<String, String> disps = new HashMap<String, String>();
        Map<String, String> fmts = new HashMap<String, String>();
        analyzeExportFields(jsonparam.getString(BeanConstant.QueryField.PARAMKEY_FIELDS), flds, fldlst, disps, fmts);
        jsonparam.put(BeanConstant.QueryField.PARAMKEY_FIELDS, flds.toString());
        // 查询数据
        jsonparam.put("ent_id", session.getEnt_id());
        StringBuffer total = null;

        if ((jsonparam.containsKey(BeanConstant.QueryField.PARAMKEY_PAGESIZE) && jsonparam.getInteger(BeanConstant.QueryField.PARAMKEY_PAGESIZE) < 0) ||
            (jsonparam.containsKey(BeanConstant.QueryField.PARAMKEY_PAGENO) && jsonparam.getInteger(BeanConstant.QueryField.PARAMKEY_PAGENO) < 0)) {
            // 查全部
            jsonparam.remove(BeanConstant.QueryField.PARAMKEY_PAGESIZE);
            jsonparam.remove(BeanConstant.QueryField.PARAMKEY_PAGENO);
        }
        else {
            total = new StringBuffer();
        }

        List<Map<String, Object>> list = doSearchForMap(jsonparam, getBeanClass(), total);
        // 生成XLS文件的XML
        return createExportXLS(list, fldlst, disps, fmts);
    }

    // 导入EXCEL
    public Object importexcel(ServiceSession session, String param, List<FileImportObject> list) throws Exception
    {
        String outkey = "exceldata";
        String fields = null;
        long maxrow = -1;

        if (!StringUtils.isEmpty(param)) {
            JSONObject json = JSON.parseObject(param);

            if (!StringUtils.isEmpty(json.get("outkey"))) {
                outkey = json.getString("outkey");
            }

            if (!StringUtils.isEmpty(json.get("fields"))) {
                fields = json.getString("fields");
            }

            if (!StringUtils.isEmpty(json.get("maxrow"))) {
                maxrow = Long.parseLong(json.get("maxrow").toString());
            }
        }

        JSONArray array = null;

        for (FileImportObject fio : list) {
            JSONArray ary = null;

            if (fio.getFilename().toLowerCase().endsWith(".xlsx")) {
                ary = ExcelUtils.XLSXtoJSONArray(fio.getStream(), fields, maxrow);
            }
            else {
                ary = ExcelUtils.XLStoJSONArray(fio.getStream(), fields, maxrow);
            }

            if (array != null) {
                array.addAll(ary);
            }
            else {
                array = ary;
            }
        }

        JSONObject json = new JSONObject();
        json.put(outkey, array);
        return json;
    }

    /**
     * 单行excel记录处理
     *
     * @param session
     * @param param
     * @param json
     * @return
     * @throws Exception
     */
    public Object importExcelSingle(ServiceSession session, Object param, JSONObject json) throws Exception
    {
        ExecutorService executor = Executors.newCachedThreadPool();
        EventFactory<ExcelImpData> factory = new ExcelFactory();
        int bufferSize = 1024;
        Disruptor<ExcelImpData> disruptor = new Disruptor<ExcelImpData>(factory, bufferSize, executor);
        disruptor.start();
        RingBuffer<ExcelImpData> ringBuffer = disruptor.getRingBuffer();
        excelpublishEvent(ringBuffer, session, param, json, ((JSONObject) param).get("initvar"));
        executor.shutdown();
        disruptor.shutdown();
        return json;
    }

    public void checkFileUploadDelete(ServiceSession session, JSONObject jsonparam, List<FormDataBodyPart> fileparts)
    {
        checkPara(session, jsonparam);

        if (StringUtils.isEmpty(fileparts) || fileparts.size() == 0) {
            throw new ServiceException(ResponseCode.FAILURE, "{0} is NULL ", "附件列表为空");
        }
    }


    public void excelpublishEvent(RingBuffer<ExcelImpData> ringBuffer, ServiceSession session, Object param, JSONObject json, Object obj)
    {
    }
    /**
     * 导入前操作
     *
     * @param session
     * @param param
     */
    public Object beforeExcelImport(ServiceSession session, String param) throws Exception
    {
        return null;
    }

    /**
     * 导入后操作
     *
     * @param session
     * @param param
     */
    public void afterExcelImport(ServiceSession session, String param) throws Exception
    {
    }

    @Transactional(propagation = Propagation.REQUIRED)
    public ServiceResponse copy(ServiceSession session, JSONObject jsonparam) throws Exception
    {
        // 循环保存
        JSONArray returnarray = new JSONArray();
        ServiceResponse response = get(session, jsonparam);
        JSONObject data = (JSONObject) response.getData();
        String datas = data.toJSONString();
        int s = getFirstMatchingIndex(datas, ":");
        String subst = datas.substring(s + 1, datas.length() - 1);
        JSONObject json = JSON.parseObject(subst);
        JSONObject newjson = new JSONObject();
        JSONArray newJsonArray = null;
        String[] removefields =  { "billno", "billsgno", "ph_key", "billstatus", "ph_timestamp", "auditor", "auditor_name", "auditdate", "canceler", "canceler_name", "canceldate", "inputer", "inputer_name" };

        for (int i = 0; i < removefields.length; i++) {
            json.remove(removefields[i]);
        }

        if (json.containsKey("tid")) {
            json.remove("tid");
            String moduleid = json.getString("billmoduleid");
            String ruleid = null;

            if (moduleid.equals("6006002")) {
                ruleid = "mztid";
            }
            else if (moduleid.equals("6006003")) {
                ruleid = "lptid";
            }
            else if (moduleid.equals("6006004")) {
                ruleid = "zktid";
            }
            else if (moduleid.equals("6006005")) {
                ruleid = "mjtid";
            }
            else if (moduleid.equals("6006006")) {
                ruleid = "gmtid";
            }
            else if (moduleid.equals("6006007")) {
                ruleid = "qytid";
            }
            else if (moduleid.equals("6006008")) {
                ruleid = "thtid";
            }
            else if (moduleid.equals("6006020")) {
                ruleid = "qbtid";
            }
            else if (moduleid.equals("6006009")) {
                ruleid = "tctid";
            }

            if (ruleid != null) {
                BillCommonServiceImpl<?> billCommon = new BillCommonServiceImpl<>();
                String tid = billCommon.doApplyBillNo(session.getEnt_id(), ruleid, moduleid, null, null);
                json.put("tid", tid);
            }
        }

        json.put("inputer", session.getUser_code());
        json.put("inputer_name", "[" + session.getUser_code() + "]" + session.getUser_name());
        json.put("billstatus", "N");
        doCopyBillHead(json);

        Set<String> keySet = json.keySet();

        for (String key : keySet) {
            String detailjson = json.get(key).toString();

            if (detailjson.contains("[{")) {
                JSONArray jsonArray = JSON.parseArray(detailjson);
                newJsonArray = new JSONArray();

                for (int i = 0; i < jsonArray.size(); i++) {
                    JSONObject parseObject = JSON.parseObject(jsonArray.get(i).toString());
                    parseObject.remove("ph_key");
                    parseObject.remove("billno");
                    parseObject.remove("ph_timestamp");
                    newJsonArray.add(parseObject);
                }

                if (!newjson.containsKey(key)) {
                    newjson.put(key, newJsonArray);
                }
            }
            else {
                if (!newjson.containsKey(key)) {
                    newjson.put(key, json.get(key));
                }
            }
        }

        // dosave方式，
        T bean = StorageUtils.parseBeanObject(newjson, getBeanClass());
        String idkey = getIdKey();
        getIdField().set(bean, UniqueID.getUniqueID());
        bean.initInsertMember(session);
        JSONObject jsn = new JSONObject();
        jsn.put(idkey, doAdd(bean, idkey, getUniqueKeys()));
        String[] rtnfields = getReturnFields();

        if (!StringUtils.isEmpty(rtnfields)) {
            for (String rtnfield : rtnfields) {
                java.lang.reflect.Field fld = bean.fetchDeclaredField(rtnfield);
                Object obj = fld.get(bean);
                jsn.put(rtnfield, obj);
            }
        }

        returnarray.add(jsn);
        return ServiceResponse.buildSuccess(returnarray);
    }
    public void doCopyBillHead(JSONObject json)
    {

    }

    private int getFirstMatchingIndex(String input, String query)
    {
        char[] inputChars = input.toCharArray();
        char[] queryChars = query.toCharArray();
        int inputLength = input.length();
        int queryLength = query.length();
        int inputIndex = 0;
        int queryIndex = 0;

        while (inputIndex < inputLength && queryIndex < queryLength) {
            if (inputChars[inputIndex] == queryChars[queryIndex]) {
                queryIndex++;
                inputIndex++;
            }
            else {
                inputIndex = inputIndex - queryIndex + 1;
                queryIndex = 0;
            }
        }

        int index = queryIndex == queryLength ? (queryLength > 1 ? inputIndex - queryLength : inputIndex - 1) : -1;
        return index;
    }

    public Map<String, Object> getIsUseFlag(FMybatisTemplate storage, String tabname, String tabcol, String colval)
    {
        String isuse = "N";
        Map<String, Object> map = new HashMap<String, Object>();
        map.put("tabname", tabname);
        map.put("tabcol", tabcol);
        map.put("colval", colval);
        List<Map<String, Object>> tablist = storage.getSqlSessionTemplate().selectList("select_tablecolcheck", map);

        if (tablist == null || tablist.isEmpty()) {
            isuse = "N";
        }
        else {
            for (Map<String, Object> tab : tablist) {
                tab.put("colval", colval);
                //                 isuse = storage.getSqlSessionTemplate().selectOne("selectdeletecheck",tab);
                Map<String, Object> mapisuse = new HashMap<String, Object>();
                mapisuse = storage.getSqlSessionTemplate().selectOne("selectdeletecheck", tab);

                if (mapisuse == null) {
                    break;
                }
                else {
                    isuse = mapisuse.get("isuse").toString();

                    if ("Y".equals(isuse)) {
                        break;
                    }
                }

                isuse = "N";
            }
        }

        map.put("isuse", isuse);
        return map;
    }


    @Override
    @Transactional(propagation = Propagation.REQUIRES_NEW)
    public void onDeleteValid(AbstractEntityBean bean, String id, String... keys)
    {
        FMybatisTemplate storage = null;
        String tabname = AbstractEntityBean.fetchAnnotationTableName(bean.getClass());
        Object colval = null;

        try {
            String tabcol = getMasterSlaveKey(bean.getClass());
            java.lang.reflect.Field fld = bean.fetchDeclaredField(tabcol);
            colval = fld.get(bean);
            storage = getGlobalStorageOperations(FMybatisTemplate.class);
            Criteria criteria = Criteria.where("tabname").is(tabname).and("colname").is(tabcol);
            Query query = new Query(criteria);
            String tablecolcheck = "tablecolcheck";
            List<Map<String, Object>> tablist = storage.select(query, tablecolcheck);

            if (!StringUtils.isEmpty(tablist) && tablist.size() > 0) {
                for (Map<String, Object> tab : tablist) {
                    tab.put("colval", colval);
                    String sql = "select 'Y' isuse from " + tab.get("ctabname") + " where " + tab.get("ccolname") + "='"
                                 + colval.toString() + "'";
                    List<Map<String, Object>> uselist = new ArrayList<Map<String, Object>>();

                    try {
                        uselist = storage.getSqlSessionTemplate().selectList("mybatis.sql.select", sql);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }

                    if (!StringUtils.isEmpty(uselist) && uselist.size() > 0 && !StringUtils.isEmpty(uselist.get(0).get("isuse"))
                        && "Y".equals(uselist.get(0).get("isuse").toString())) {
                        throw new ServiceException(ResponseCode.Failure.BE_USE, "has {0} [{1}] use it,can not delete", tabname, colval);
                    }
                }
            }
        }
        catch (ServiceException e) {
            throw new ServiceException(ResponseCode.Failure.BE_USE, "has {0} [{1}] use it,can not delete", tabname, colval);
        }
        catch (Exception e) {
        }
        finally {
            if (storage != null) {
                storage.destroy();
            }
        }
    }

    protected Object filter(Object data, Class<?> clz)
    {
        return data;
    }
}


