package com.efuture.ocp.common.component;

import com.alibaba.fastjson.JSONObject;
import com.efuture.ocp.common.annotation.AutoCache;
import com.efuture.ocp.common.component.ruleimpl.MappedRuleImpl;
import com.efuture.ocp.common.distributedLock.DLock;
import com.efuture.ocp.common.entity.ServiceResponse;
import com.efuture.ocp.common.entity.ServiceSession;
import com.efuture.ocp.common.exception.ServiceException;
import com.efuture.ocp.common.language.ResponseCode;
import com.efuture.ocp.common.rest.ServiceLogs;
import com.efuture.ocp.common.util.MapUtils;
import com.efuture.ocp.common.util.SpringBeanFactory;
import com.efuture.omd.storage.FMybatisTemplate;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanInitializationException;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.data.mongodb.core.query.Update;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.StringUtils;

import java.util.*;


public class GlobRuleSrvimpl extends BasicComponent implements GlobRuleSrv, ApplicationContextAware, InitializingBean {

    public static GlobRuleSrv getInstance() {
        return SpringBeanFactory.getContext().getBean(GlobRuleSrv.class);
    }

    @Transactional(propagation = Propagation.REQUIRES_NEW)
    @Override
    @DLock(key = "#args[0].toString() +'-' + #args[1] + '-' + #args[2]", lockExpire = 120, waitMillSeconds = 5)
    public long getlast(long ent_id, String ruleid, String ruletypestr, String datestr, long keynum) {
        String globruledet = "globruledet";
        long startseqno = 0;
        long endseqno = 0;
        Criteria criteria = Criteria.where("ent_id").is(ent_id).and("ruleid").is(ruleid).and("ruletypestr").is(ruletypestr);
        Query query = new Query(criteria);
        FMybatisTemplate storage = getGlobalStorageOperations(FMybatisTemplate.class);

        Map<String, Object> map = storage.selectOne(query, globruledet);
        if (map != null) {
            if (!StringUtils.isEmpty(datestr) && !datestr.equals(MapUtils.getString(map, "ruletypeday"))) {
                endseqno = keynum;
            } else {
                startseqno = MapUtils.getLongValue(map, "rulecurseqno");
                endseqno = startseqno + keynum;
            }
            Update upt = new Update();
            upt.set("rulecurseqno", String.valueOf(endseqno));
            upt.set("ruletypeday", datestr);
            storage.update(query, upt, globruledet);
        } else {
            Map<String, Object> data = new HashMap<String, Object>();
            data.put("ent_id", ent_id);
            data.put("ruleid", ruleid);
            data.put("ruletypestr", ruletypestr);
            endseqno = keynum;
            data.put("rulecurseqno", String.valueOf(endseqno));
            data.put("ruletypeday", datestr);
            storage.insert(data, globruledet);
        }

        return startseqno;
    }


    @Override
    @Transactional(propagation = Propagation.REQUIRES_NEW)
    public long getnext(long ent_id, String ruleid, String ruletypestr, String datestr) {
        return GlobRuleSrvimpl.getInstance().getlast(ent_id, ruleid, ruletypestr, datestr, 1L) + 1;
    }

    @Override
    @Transactional(propagation = Propagation.REQUIRES_NEW)
    public String getrulekey(long ent_id, String ruleid, String moduleid,
                             String type, String level) {
        //查找规则
        GlobRuleBean rule = GlobRuleSrvimpl.getInstance().getrule(ent_id, ruleid);
        //设置参数
        rule.setEnt_id(ent_id);
        rule.setPreStr(moduleid);
        rule.setLevelStr(level);
        Map<String, Object> filds = new HashMap<>();
        filds.put("TYPE", type);
        rule.setFields(filds);
        return getRuleCodeList(rule, 1).get(0);
    }

    @Override
    @AutoCache(Readable = true)
    public GlobRuleBean getrule(long ent_id, String ruleid) {
        FMybatisTemplate storage = getGlobalStorageOperations(FMybatisTemplate.class);
        Criteria criteria = Criteria.where("ent_id").is(ent_id).and("ruleid").is(ruleid);
        Query query = new Query(criteria);
        String globruled = "globrule";
        GlobRuleBean rule = storage.selectOne(query, GlobRuleBean.class, "globrule");
        if (rule == null) {
            throw new ServiceException("90001", "没有找到编码规则[{0}]", ruleid);
        }
        return rule;
    }

    @Override
    public ServiceResponse getRuleDef(ServiceSession session, JSONObject jsonparam) throws Exception {
        JSONObject jsonrtn = new JSONObject();

        checkPara(session, jsonparam);
        String ruleId = jsonparam.getString("ruleid");
        GlobRuleBean globrule = GlobRuleSrvimpl.getInstance().getrule(session.getEnt_id(), jsonparam.getString("ruleid"));
        jsonrtn.put("globrule", globrule);
        return ServiceResponse.buildSuccess(jsonrtn);
    }

    @Override
    public ServiceResponse getRuleList(ServiceSession session, JSONObject jsonparam) throws Exception {
        JSONObject jsonrtn = new JSONObject();

        checkPara(session, jsonparam);
        String ruleId = jsonparam.getString("ruleid");
        if (ruleId == null || ruleId.equalsIgnoreCase("")) {
            ServiceResponse.buildFailure(session, "90001", "ruleid 不能为空");
        }
        String[] rules = ruleId.split(",");
        List<GlobRuleBean> ruleList = new ArrayList<>();
        for (String rid : rules) {
            GlobRuleBean globrule = GlobRuleSrvimpl.getInstance().getrule(session.getEnt_id(), rid);
            if (globrule != null) {
                ruleList.add(globrule);
            }
        }

        jsonrtn.put("globrule", ruleList);
        return ServiceResponse.buildSuccess(jsonrtn);
    }


    public Map<String, INORule> ruleHandles = new HashMap<String, INORule>();

    private INORule getRuleHandle(String ruleCode) {
        INORule handle = ruleHandles.get(ruleCode);
        if (handle == null) {
            handle = new MappedRuleImpl();
        }
        return handle;
    }


    /**
     * 返回只剩下#SEQ的规则字符串,如果包含日期字段，会在GlobRuleBean 中返回
     *
     * @param rule
     * @param prestr
     * @param level
     * @param fields
     * @return
     */
    public void getRuleCodeTemplate(GlobRuleBean rule) {


        String prestr = rule.getPreStr();
        String level = rule.getLevelStr();
        Map<String, Object> fields = rule.getFields();

        String[] ruledefs = rule.getRuledef().split("\\|");
        StringBuilder ruleCodeStr = new StringBuilder();
        StringBuilder ruleTypeStr = new StringBuilder();

        if (fields == null) {
            fields = new HashMap<>();
        }
        if (fields.get("NOW") == null) {
            fields.put("NOW", new Date());
        }

        if (!StringUtils.isEmpty(prestr)) {
            ruleTypeStr.append(prestr);
            fields.put("PRESTR", prestr);
        } else {
            prestr = "#";
        }
        if (!StringUtils.isEmpty(level)) {
            fields.put("LEVEL", level);
        } else {
            level = "#";
        }

        String DateStr = null;

        if (rule.getRuleisrule().equalsIgnoreCase("L")) {
            if (!StringUtils.isEmpty(prestr) && !prestr.equalsIgnoreCase("#")) {
                ruleCodeStr.append(prestr);
            }
            ruleCodeStr.append("#SEQ");
            // 判断前缀级次是否符合规则定义
            String[] levels = rule.getRuledef().toString().split("\\-");
            // 获取当前级次长度
            int prelevel = 0;
            int seqlen = 0;
            for (int i = 0; i < levels.length; i++) {
                if (i + 1 == Integer.parseInt(level)) {
                    seqlen = Integer.parseInt(levels[i]);
                    break;
                }
                prelevel += Integer.parseInt(levels[i]);
            }
            seqlen = seqlen + ruleCodeStr.length() - 4;
            rule.setRulesyslen(seqlen);

            rule.setRuleTypeDay("");
            rule.setRuleCodeStr(ruleCodeStr.toString());
            rule.setRuleTypeStr(ruleTypeStr.toString());

            return;
        }

        for (String def : ruledefs) {
            //SEQ 不处理,等后面处理
            if ("#SEQ".equalsIgnoreCase(def)) {
                ruleCodeStr.append("#SEQ");
                //如果是#号的，则表示是规则，查找规则
            } else if (def.startsWith("#")) {
                String codeStr = def;
                String ruleCode = def.substring(1).toLowerCase();
                INORule handle = getRuleHandle(ruleCode);
                codeStr = handle.getCodeStr(ruleCode, fields);
                if (codeStr == null) {
                    codeStr = def;
                }
                if (handle.isDateRule()) {
                    DateStr = codeStr;
                } else if (!codeStr.equalsIgnoreCase(prestr) && !codeStr.equalsIgnoreCase(level)) {
                    ruleTypeStr.append("-" + codeStr);
                }
                ruleCodeStr.append(codeStr);
            } else {
                ruleCodeStr.append(def);
                ruleTypeStr.append(def);
            }
        }
        rule.setRuleTypeDay(DateStr);
        rule.setRuleCodeStr(ruleCodeStr.toString());
        rule.setRuleTypeStr(ruleTypeStr.toString());

    }


    public ServiceResponse getRuleCodeStrTest(ServiceSession session, JSONObject jsonparam) {
        return ServiceResponse.buildSuccess(doGenRuleCodeBatch(session.getEnt_id(), jsonparam.getString("ruleid"), jsonparam.getString("prestr"), jsonparam.getString("level"), jsonparam.getIntValue("num"),
                jsonparam));
    }


    private List<String> getRuleCodeList(GlobRuleBean rule, int num) {
        List<String> rulecodelist = new ArrayList<String>();
        //生成模板字符串，类型字符串和日期字符串
        getRuleCodeTemplate(rule);

        //独立事物获取 对应的序号
        //GlobRuleSrv ruleSrv = SpringBeanFactory.getContext().getBean(GlobRuleSrv.class);
        //SpringBeanFactory.getBean("globRuleService", GlobRuleSrv.class);
        long startSeqNo = GlobRuleSrvimpl.getInstance().getlast(rule.getEnt_id(), rule.ruleid, rule.getRuleTypeStr(), rule.getRuleTypeDay(), num);
        // 批量生成编号
        long lastNum = startSeqNo + num;
        String baseCode = rule.getRuleCodeStr();
        int seqlen = rule.getRulesyslen() - baseCode.length() + 4;
        for (int i = 0; i < num; i++) {
            startSeqNo = startSeqNo + 1;
            String seqNo = String.valueOf(startSeqNo);

            int len = seqlen - String.valueOf(seqNo).length();
            if (len < 0) {
                throw new ServiceException(ResponseCode.FAILURE, "seqno [{0}] length is max [{1}]",
                        seqNo, seqlen);
            } else {
                len = len + String.valueOf(seqNo).length();
                seqNo = ("00000000000000000000" + seqNo);
                seqNo = seqNo.substring(seqNo.length() - len);
            }
            String code = rule.getRuleCodeStr().replace("#SEQ", seqNo);
            rulecodelist.add(code);
        }
        return rulecodelist;
    }

    @Override
    @Transactional(propagation = Propagation.REQUIRED)
    public List<String> doGenRuleCodeBatch(long ent_id, String ruleid, String prestr, String level, int num,
                                           Map<String, Object> fields) {


        //查找规则
        GlobRuleBean rule = GlobRuleSrvimpl.getInstance().getrule(ent_id, ruleid);
        //设置参数
        rule.setEnt_id(ent_id);
        rule.setPreStr(prestr);
        rule.setLevelStr(level);
        rule.setFields(fields);

        return getRuleCodeList(rule, num);
    }

    /**
     * Invoked by a BeanFactory after it has set all bean properties supplied
     * (and satisfied BeanFactoryAware and ApplicationContextAware).
     * <p>This method allows the bean instance to perform initialization only
     * possible when all bean properties have been set and to throw an
     * exception in the event of misconfiguration.
     *
     * @throws Exception in the event of misconfiguration (such
     *                   as failure to set an essential property) or if initialization fails.
     */
    @Override
    public void afterPropertiesSet() throws Exception {
        //ServiceLogs.debuglog("GlobRule", "开始查找规则编码生成器", 0);
        Objects.nonNull(this.applicationContext);
        Map<String, INORule> rules = this.applicationContext.getBeansOfType(INORule.class);
        if (Objects.nonNull(rules)) {
            for (INORule rule : rules.values()) {
                ServiceLogs.debuglog("GlobRule", "注册规则编码生成器[{0}]", 0, rule.getRuleCode());
                ruleHandles.put(rule.getRuleCode().toLowerCase(), rule);
            }
        }
        //ServiceLogs.debuglog("GlobRule", "注册规则编码生成器,注册[{0}]个", 0, rules.size());
    }

    ApplicationContext applicationContext;

    /**
     * Set the ApplicationContext that this object runs in.
     * Normally this call will be used to initialize the object.
     * <p>Invoked after population of normal bean properties but before an init callback such
     * as {@link InitializingBean#afterPropertiesSet()}
     * or a custom init-method. Invoked after {@link ResourceLoaderAware#setResourceLoader},
     * {@link ApplicationEventPublisherAware#setApplicationEventPublisher} and
     * {@link MessageSourceAware}, if applicable.
     *
     * @param applicationContext the ApplicationContext object to be used by this object
     * @throws ApplicationContextException in case of context initialization errors
     * @throws BeansException              if thrown by application context methods
     * @see BeanInitializationException
     */
    @Override
    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }
}
