package com.efuture.ocp.common.component.ruleimpl;

import com.efuture.ocp.common.component.INORule;
import org.springframework.stereotype.Component;

import java.text.SimpleDateFormat;
import java.util.Map;

@Component
public class YearRuleImpl implements INORule {
    @Override
    public String getRuleCode() {
        return "YEAR";
    }

    @Override
    public String getCodeStr(String ruleCode, Map<String, Object> fields) {
        SimpleDateFormat df = new SimpleDateFormat("yyyy");
        return df.format(fields.get("NOW")).substring(0, 4);
    }

    @Override
    public boolean isDateRule() {
        return true;
    }

}
