package com.efuture.ocp.common.fileio;
import java.io.*;
import java.net.URLEncoder;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;

import com.efuture.ocp.common.entity.*;
import com.efuture.ocp.common.util.*;
import com.efuture.omd.storage.FStorageOperations;
import org.apache.poi.hssf.usermodel.HSSFCellStyle;
import org.apache.poi.hssf.usermodel.HSSFFont;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.DataFormat;
import org.apache.poi.ss.usermodel.Font;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.xssf.streaming.SXSSFWorkbook;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.StringUtils;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.efuture.ocp.common.component.BasicComponentService;
import com.efuture.ocp.common.exception.ServiceException;
import com.efuture.ocp.common.language.ResponseCode;

public class FileImportSrvl extends BasicComponentService implements FileImportService {
	
	private static final String STATIC_XLS = "XLS";
	private static final String STATIC_XLSX = "XLSX";

	private static final String SimpleDateFormat = null;
	private SXSSFWorkbook xlsx = null;
	private HSSFWorkbook xls = null;

	private String createfilepath = null;
	public String getCreatefilepath() {
		return createfilepath;
	}
	public void setCreatefilepath(String createfilepath) {
		this.createfilepath = createfilepath;
	}


	
	interface separator {
		final String array = ",";
		final String field = "#";
	}
	
	interface errCode {
		final String TYPE = "format is wrong";	//数据格式不对
		final String ISNULL = "is null";		//为空
		final String ISREPEAT = "is repeat";	//有重复的
	}

	@Override
	public ServiceResponse getConfig(ServiceSession session, JSONObject jsonparam) throws Exception {
		DataImportConfigServiceImpl dataImportConfig = new DataImportConfigServiceImpl();
		return dataImportConfig.search(session, jsonparam);
	}

	@Override
	public JSONObject beforeFileImport(ServiceSession session,JSONObject jsonparam,List<FileImportObject> list) throws Exception
	{
		long starttime = System.currentTimeMillis();
        getLogger().info("import start: " + starttime);
        if(StringUtils.isEmpty(jsonparam.get("eid"))) 
        	if(!StringUtils.isEmpty(jsonparam.get("billmoduleid"))) jsonparam.put("eid", jsonparam.get("billmoduleid"));
        	else throw new ServiceException(ResponseCode.FAILURE,"{0} or {1} does not exist", "eid", "billmoduleid");

		//保存文件
		String filepath = savefile(session,list);

        DataImportConfigServiceImpl dataImportConfig = new DataImportConfigServiceImpl();
        DataImportConfigBean exportConfig = dataImportConfig.getConfig(session.getEnt_id(),jsonparam.getString("eid"),null);
        if(exportConfig == null) throw new ServiceException(ResponseCode.FAILURE,"导入配置不存在"); 
        String impfields = exportConfig.getImpfields();
        String imptype = exportConfig.getEid();
        long maxrow = -1;

        //导入配置检查
        checkConfig(exportConfig);

        getLogger().info("import start: " + starttime + " imptype: "+imptype);
        //配置转json对象
        JSONObject jsonconfig = (JSONObject) Utils.toNormalJSONObject(exportConfig);
        JSONArray errList = new JSONArray();
        JSONArray successList = new JSONArray();
        JSONArray ary = null;
        JSONArray array = null;
        //得到文档内容
		String filename = "";
        for (FileImportObject fio : list)
        {
			filename = new String(fio.getFilename().getBytes("iso-8859-1"));
        	if (filename.toLowerCase().endsWith(".xlsx")) ary = ExcelUtils.XLSXtoJSONArray(fio.getStream(), impfields, maxrow);
            else ary = ExcelUtils.XLStoJSONArray(fio.getStream(), impfields, maxrow);
            if (array != null) array.addAll(ary);
            else array = ary;
        }
        
        //初步处理从excel读到的数据（去空格）
        array = impToRegular(array);
        //文档格式检验,通过则保存
        checkStyle(array,jsonconfig,successList,errList);
        array = (JSONArray)successList.clone();
        successList.clear();
        
        JSONObject out = new JSONObject();
        if(array.size() > 0) 	out.put("imparray", array);
        if(errList.size() > 0) 	out.put("errList", errList);
        out.put("filename",filename);
        out.put("filepath",filepath);
        out.put("impconfig", jsonconfig);
        
		return out;
	}

	public String savefile(ServiceSession session,List<FileImportObject> list) throws Exception{
		//拷贝list
		List<FileImportObject> newList = new ArrayList<FileImportObject>();
		for(FileImportObject fio : list){
			FileImportObject newfio = new FileImportObject();
			newfio.setFilename(fio.getFilename());

			ByteArrayOutputStream baos = new ByteArrayOutputStream();
			byte[] buffer = new byte[1024];
			int len;
			while ((len = fio.getStream().read(buffer)) > -1 ) {
				baos.write(buffer, 0, len);
			}
			baos.flush();

			fio.setStream(new ByteArrayInputStream(baos.toByteArray()));
			newfio.setStream(new ByteArrayInputStream(baos.toByteArray()));
			newList.add(newfio);
		}

		//将newList保存为文件
		String filepath = "";
		for (FileImportObject fio : newList){
			filepath = writeToLocal(fio.getFilename(),fio.getStream());
		}

		return filepath;
	}


	public String writeToLocal(String filename, InputStream input)
			throws IOException {
		String filePath = getFilePath();
		File dir = new File(filePath);
		if (!dir.exists()) {
			dir.mkdirs();
		}

		SimpleDateFormat sdfymdCard = new SimpleDateFormat("yyyyMMddHHmmss");
		String tempExcelFile = filePath +sdfymdCard.format(new Date()) ;
		if (filename.toUpperCase().endsWith(STATIC_XLSX)) {
			tempExcelFile = tempExcelFile + ".xlsx";
		} else if (filename.toUpperCase().endsWith(STATIC_XLS)) {
			tempExcelFile = tempExcelFile + ".xls";
		} else{
			tempExcelFile = tempExcelFile + ".xls";
		}

//		int index;
//		byte[] bytes = new byte[1024];
//		FileOutputStream downloadFile = new FileOutputStream(tempExcelFile);
//		while ((index = input.read(bytes)) != -1) {
//			downloadFile.write(bytes, 0, index);
//			downloadFile.flush();
//		}
//		input.close();
//		downloadFile.close();

		BufferedInputStream in=null;
		BufferedOutputStream out=null;
		in=new BufferedInputStream(input);
		out=new BufferedOutputStream(new FileOutputStream(tempExcelFile));
		int len=-1;
		byte[] b=new byte[1024];
		while((len=in.read(b))!=-1){
			out.write(b,0,len);
		}
		in.close();
		out.close();


		return tempExcelFile;

	}

	public void checkConfig(DataImportConfigBean config) throws Exception{
		String impfields = config.getImpfields();
		String impname =  config.getImpfields_name();
		String imptype = config.getImpfields_datatype();
		String defaultparam = config.getDefaultparam();
		String defaultvalue = config.getDefaultvalue();
		if(StringUtils.isEmpty(impfields) || StringUtils.isEmpty(impname) || StringUtils.isEmpty(imptype) ){
			throw new ServiceException(ResponseCode.FAILURE,"导入配置:impfields、impfields_name、impfields_datatype 不能为空");
		}
		if(impfields.split(separator.array).length != impname.split(separator.array).length ){
			throw new ServiceException(ResponseCode.FAILURE,"导入配置:impfields、impfields_name 不匹配");
		}
		if(impfields.split(separator.array).length != imptype.split(separator.array).length ){
			throw new ServiceException(ResponseCode.FAILURE,"导入配置:impfields、impfields_datatype 不匹配");
		}

		if(!StringUtils.isEmpty(defaultparam)){
			if(defaultparam.split(separator.array).length != defaultvalue.split(separator.array).length ){
				throw new ServiceException(ResponseCode.FAILURE,"导入配置:defaultparam、defaultvalue 不匹配");
			}
		}
	}
	
	/**
     * 功能：判断字符串是否为日期格式
     * 
     * @param str
     * @return
     */
	public boolean isDate(String strDate) {
        Pattern pattern = Pattern
                .compile("^((\\d{2}(([02468][048])|([13579][26]))[\\-\\/\\s]?((((0?[13578])|(1[02]))[\\-\\/\\s]?((0?[1-9])|([1-2][0-9])|(3[01])))|(((0?[469])|(11))[\\-\\/\\s]?((0?[1-9])|([1-2][0-9])|(30)))|(0?2[\\-\\/\\s]?((0?[1-9])|([1-2][0-9])))))|(\\d{2}(([02468][1235679])|([13579][01345789]))[\\-\\/\\s]?((((0?[13578])|(1[02]))[\\-\\/\\s]?((0?[1-9])|([1-2][0-9])|(3[01])))|(((0?[469])|(11))[\\-\\/\\s]?((0?[1-9])|([1-2][0-9])|(30)))|(0?2[\\-\\/\\s]?((0?[1-9])|(1[0-9])|(2[0-8]))))))(\\s(((0?[0-9])|([1-2][0-3]))\\:([0-5]?[0-9])((\\s)|(\\:([0-5]?[0-9])))))?$");
        Matcher m = pattern.matcher(strDate);
        if (m.matches()) {
            return true;
        } else {
            return false;
        }
    }
	
	/**
     * 功能：判断字符串是否为整数
     * 
     * @param str
     * @return
     */
    private boolean isLong(String str) {
        //Pattern pattern = Pattern.compile("[0-9]*");
     // 就是判断是否为整数(正负)  
        Pattern pattern =   
        		Pattern.compile("[0-9]*"); 
        Matcher isNum = pattern.matcher(str);
        if (isNum.matches()) {
            return true;
        } else {
            return false;
        }
    }
	
    /**
     * 判断一个字符串是否是数字。
     * 
     * @param string
     * @return
     */
    public boolean isNumber(String string) {
        if (string == null)
            return false;
        Pattern pattern = Pattern.compile("^-?\\d+(\\.\\d+)?$");
        return pattern.matcher(string).matches();
    }
    
    public boolean isequal(Object value1,Object value2){
		return ((value1 == null) ? "" : value1.toString().trim()).equals((value2 == null) ? "" : value2.toString().trim());
	}
    
    public String geterr(JSONArray array){
    	String errmsg = "";
    	for (int i=0;i<array.size();i++){
    		JSONObject errrow = array.getJSONObject(i);
    		if(i == array.size() -1 ){
    			errmsg += "["+errrow.getString("column")+"] "+errrow.getString("msg");
    		}else{
    			errmsg += "["+errrow.getString("column")+"] "+errrow.getString("msg")+",";
    		}
    	}
    	return errmsg;
    }
	
	//校验数据格式、非空列、不可重复数据、
	public String checkRow(JSONObject row,JSONObject jsonparam,JSONArray array) throws Exception{
		JSONArray result = new JSONArray();
		
		String fields = jsonparam.getString("impfields");
		String fields_name = jsonparam.getString("impfields_name");
		String fields_type = jsonparam.getString("impfields_datatype");
		String fields_nonull = getParamWithCheck(jsonparam ,"uniquecolumn" , false,"" )  + separator.array + getParamWithCheck(jsonparam ,"nonullfields" , false,"" );
		String field_norepeat = getParamWithCheck(jsonparam ,"uniquecolumn" , false,"" ) + separator.array + getParamWithCheck(jsonparam ,"norepeatfields" , false,"" );
		String defaultparam = getParamWithCheck(jsonparam ,"defaultparam" , false,"" );
		String defaultvalue = getParamWithCheck(jsonparam ,"defaultvalue" , false,"" );
		
		String [] columns = fields.split(separator.array);
		String [] columns_name = fields_name.split(separator.array);
		String [] columns_type = fields_type.split(separator.array);
		String [] columns_nonull = fields_nonull.split(separator.array);
		String [] columns_norepeat = field_norepeat.split(separator.array);
		String [] arr_defaultparam = defaultparam.split(separator.array);
		String [] arr_defaultvalue = defaultvalue.split(separator.array);

		for (int i=0;i<columns.length;i++){
			String field = columns[i];
			String field_name = columns_name[i];
			JSONObject result_row = new JSONObject();
			result_row.put("column", field_name);

			//检验数据类型
			if(!field.equals("")){
				//检验非空列
				for(String column_nonull : columns_nonull){
					if(!column_nonull.equals("")){
						if (field.equals(column_nonull)){
							if(row.get(field) == null) {
								result_row.put("msg", errCode.ISNULL);
								result.add(result_row) ;
							}
							if(row.getString(field).trim().equals("")) {
								result_row.put("msg", errCode.ISNULL);
								result.add(result_row);
							}
						}
					}
				}

				//数据类型
				if (row.get(field) != null ) {
					for(String nonull_fie : columns_nonull){
						if(field.equals(nonull_fie)){
							if(columns_type[i].equals("D")){
								if(!isDate(row.getString(field).trim())){
									result_row.put("msg", errCode.TYPE);
									result.add(result_row);
								}
							}else if(columns_type[i].equals("N")){
								if(!isNumber(row.getString(field).trim())) {
									result_row.put("msg", errCode.TYPE);
									result.add(result_row);
								}
							}else if(columns_type[i].equals("L")){
								if(!isLong(row.getString(field).trim())) {
									result_row.put("msg", errCode.TYPE);
									result.add(result_row);
								}
							}
						}
					}
				}else{
					result_row.put("msg", errCode.TYPE);
					result.add(result_row);
				}
			}
		}
		
		//数据判重
		for(String column_repeat : columns_norepeat){
			if(column_repeat.equals("")) continue;
			JSONObject result_row = new JSONObject();
			
			String [] column_r = column_repeat.split(separator.field);
			
			//取重复列配置的名称
			String column_name = "";
			for(String column : column_r){
				for(int i=0;i<columns.length;i++){
					if (column.equals(columns[i])){
						if(column == column_r[column_r.length-1] ) column_name += columns_name[i];
						else column_name += columns_name[i]+",";
					}
				}
			}
			result_row.put("column", column_name);
			
			int isrepeat = 0;	//0-不重复/其他-重复
			for(int j=0;j<array.size();j++){
				int isrepeat_row = 0;	//单号是否重复,0-不重复/其他-重复
				JSONObject json_row = array.getJSONObject(j);
				for(String column : column_r){
					if(isequal(row.get(column),json_row.getString(column))){
						isrepeat_row++;
					}
				}
				
				if(isrepeat_row == column_r.length){
					isrepeat++;
				}
			}
			
			if(isrepeat > 1){
				result_row.put("msg",errCode.ISREPEAT);
				result.add(result_row);
			}
			
		}

		//增加默认参数
		for(int i=0;i<arr_defaultparam.length;i++){
			String paramrow = arr_defaultparam[i];
			if(!paramrow.equals("")) row.put(paramrow,arr_defaultvalue[i]);
		}
		
		String flag = "Y";
		if(result.size() > 0)  flag = geterr(result);
		
		return flag;
	}
	
	//导入文档格式检验
	public void checkStyle(JSONArray array,JSONObject jsonparam,JSONArray successList,JSONArray errList) throws Exception {
		for(int i=0;i<array.size();i++){
			JSONObject json_row = array.getJSONObject(i);
			String flag = checkRow(json_row,jsonparam,array);
			if(flag.equals("Y")) {
				successList.add(json_row);
			}else{
				json_row.put("errmsg", flag);
				errList.add(json_row);
			}
		}
		//return errList;
	}
	
	//格式化-去空格
	public Object colTotrim(Object colvalue){
		if(colvalue == null) return null;
		if(colvalue.toString().trim().equalsIgnoreCase("")) return "";
		Pattern pattern = Pattern.compile("^[-\\+]?[.\\d]*$"); 
		if (pattern.matcher(colvalue.toString()).matches())  return colvalue;
		return colvalue.toString().trim();
	}

	//格式化-数值时，尽量清除小数点(100.00 --> 100)
	public Object colTocleanpoint(Object colvalue){
		if(colvalue == null) return null;
		if(isNumber(colvalue.toString()) && colvalue.toString().indexOf(".") > 0) {
			if(Double.parseDouble(colvalue.toString()) ==  Double.parseDouble( colvalue.toString().substring(0,colvalue.toString().indexOf(".")) ) ){
				return colvalue.toString().substring(0,colvalue.toString().indexOf("."));
			}
		}
		return colvalue;
	}
	
	//处理读取到的excel数据
	public JSONArray impToRegular(JSONArray array){
		JSONArray newarray = new JSONArray();
		for (int i = 0; i < array.size(); i++){
			JSONObject item = new JSONObject(array.getJSONObject(i));
			Set<String> keys = item.keySet();
			Iterator iterator = keys.iterator();
			while(iterator.hasNext()){
				String keyname = iterator.next().toString();
				item.put(keyname, colTocleanpoint(colTotrim(item.get(keyname)) ));
			}
			newarray.add(item);
		}
		return newarray;
	}
	
	@Transactional(propagation = Propagation.REQUIRED)
	public void doResponseServiceImp(ServiceSession session,String eid,String method,JSONObject impdata,JSONArray successList,JSONArray errList) throws Exception{
		ServiceResponse resp;
		//resp = RestClientUtils.getRestUtils().sendRequest(session,method, impdata.toJSONString(),"DataImp_"+eid+"->");
		resp = RestClientUtils.getRestUtils().sendRequest(session,method, impdata.toJSONString());
		if (resp.getReturncode().equals("0")) {
			JSONObject jsonout = (JSONObject) resp.getData();
			errList.addAll(jsonout.getJSONArray("errList"));
			successList.addAll(jsonout.getJSONArray("successList"));
		}
	}
	
    public String downloadTemplate(ServiceSession session, JSONObject jsonparam) throws Exception{

        String modulecode = jsonparam.getString("billmoduleid");
        getLogger().info("下载导入模版，"+modulecode+",start....");
    	DataImportConfigServiceImpl dataImportConfig = new DataImportConfigServiceImpl();
    	List<DataImportConfigBean> importconfigbean =  dataImportConfig.getConfigByModule(session.getEnt_id(), modulecode);
    	if (importconfigbean.size() <= 0)  return "";
    	
    	String exceltype = null;
		if (StringUtils.isEmpty(jsonparam.get("filetype"))) {
			exceltype =STATIC_XLSX;
		} else {
			String excel = jsonparam.get("filetype").toString();
			if ("1".equals(excel)) {
				exceltype = STATIC_XLS;
			} else {
				exceltype =STATIC_XLSX;
			}
		}
		
		List<String> filelist = new ArrayList<String>();
		if (importconfigbean.size() > 1) {
			int i = 0;
			for(DataImportConfigBean row : importconfigbean ){
				i++;
				String[] fldlst = row.getImpfields().split(",");
				String[] disps = row.getImpfields_name().split(",");
				String tempfileName = "";
				tempfileName = row.getEname()+ tempfileName + i ;
				String file = createExcel( tempfileName,fldlst,disps, exceltype);
				filelist.add(file);
			}
		} else {
				String[] fldlst = importconfigbean.get(0).getImpfields().split(",");
				String[] disps = importconfigbean.get(0).getImpfields_name().split(",");
				String tempfileName = "";
				tempfileName = importconfigbean.get(0).getEname() + tempfileName;
				String file = createExcel( tempfileName, fldlst, disps ,exceltype);
				filelist.add(file);
		}
    
		String reFile = "";
		if (filelist.size() > 1) {
			reFile = makezip(filelist);
		} else {
			reFile = filelist.get(0);
		}
		return reFile;
    	
    }
    
    public String getFilePath() {
		String osname = System.getProperties().getProperty("os.name");
		String head = createfilepath;
		if (osname.startsWith("Windows")) {
			head = "D:\\file\\";
			File dir = new File(head);
			if (!dir.exists()) {
				if (!dir.mkdirs()) {
					head = "C:\\file\\";
				}
			}
		}else{
			if(StringUtils.isEmpty(head)) head = "/opt/file/";
			File dir = new File(head);
			if (!dir.exists()) {
				dir.mkdirs();
			}
		}
		return head;
	}
    
    public String makezip(List<String> filelist) throws IOException {

		SimpleDateFormat sdfymdCard = new SimpleDateFormat("yyyyMMddHHmmss");
		String trackkey = sdfymdCard.format(new Date());

		String filename = trackkey;

		List<File> files = new ArrayList<File>();
		for (int i = 0; i < filelist.size(); i++) {
			File file = new File(filelist.get(i));
			files.add(file);
		}

		String head = getFilePath();
		String name = head + filename + ".rar";
		File file = new File(name);
		if (!file.exists()) {
			file.createNewFile();
		}
		FileOutputStream fous = new FileOutputStream(file);
		/**
		 * 打包的方法我们会用到ZipOutputStream这样一个输出流, 所以这里我们把输出流转换一下
		 */
		ZipOutputStream zipOut = new ZipOutputStream(fous);
		/**
		 * 这个方法接受的就是一个所要打包文件的集合， 还有一个ZipOutputStream
		 */
		zipFile(files, zipOut);
		zipOut.close();
		fous.close();

		// 删除文件
		for (File temp : files) {
			if (temp.isFile() && temp.exists()) {
				temp.delete();
			}
		}
		return name;

	}
    
    /**
	 * 把接受的全部文件打成压缩包
	 * 
	 * @param List
	 *            <File>;
	 * @param org
	 *            .apache.tools.zip.ZipOutputStream
	 */
	private void zipFile(List files, ZipOutputStream outputStream) {
		int size = files.size();
		for (int i = 0; i < size; i++) {
			File file = (File) files.get(i);
			zipFile(file, outputStream);
		}
	}
	
	/**
	 * 根据输入的文件与输出流对文件进行打包
	 * 
	 * @param File
	 * @param org
	 *            .apache.tools.zip.ZipOutputStream
	 */
	private void zipFile(File inputFile, ZipOutputStream ouputStream) {
		try {
			if (inputFile.exists()) {
				/**
				 * 如果是目录的话这里是不采取操作的， 至于目录的打包正在研究中
				 */
				if (inputFile.isFile()) {
					FileInputStream IN = new FileInputStream(inputFile);
					BufferedInputStream bins = new BufferedInputStream(IN, 512);
					// org.apache.tools.zip.ZipEntry
					ZipEntry entry = new ZipEntry(inputFile.getName());
					ouputStream.putNextEntry(entry);
					// 向压缩文件中输出数据
					int nNumber;
					byte[] buffer = new byte[512];
					while ((nNumber = bins.read(buffer)) != -1) {
						ouputStream.write(buffer, 0, nNumber);
					}
					// 关闭创建的流对象
					bins.close();
					IN.close();
				} else {
					try {
						File[] files = inputFile.listFiles();
						for (int i = 0; i < files.length; i++) {
							zipFile(files[i], ouputStream);
						}
					} catch (Exception e) {
						e.printStackTrace();
					}
				}
			}
		} catch (Exception e) {
			e.printStackTrace();
		}
	}
    
    private void exportDataToExcel (String[] fldlst,String[] disps,String exceltype) {
		Sheet sheet = null;
		CellStyle columnHeadStyle = null;
		CellStyle cellStyle = null;
		Font f = null;
		if (fldlst == null) {
			fldlst = "".split(",");
		} 
		if (disps == null) {
			disps = "".split(",");
		}

		DataFormat format = null;
		if (STATIC_XLSX.equals(exceltype)) {
			columnHeadStyle = xlsx.createCellStyle();
			format = xlsx.createDataFormat();
			f =xlsx.createFont();// 字体
			sheet = xlsx.createSheet("sheet");
			cellStyle = xlsx.createCellStyle();
		} else {
			columnHeadStyle = xls.createCellStyle();
			format = xls.createDataFormat();
			f =xls.createFont();// 字体
			sheet = xls.createSheet("sheet");
			cellStyle = xls.createCellStyle();
		}
		columnHeadStyle.setBorderBottom(HSSFCellStyle.BORDER_THIN);// 下边框
		columnHeadStyle.setBorderLeft(HSSFCellStyle.BORDER_THIN);// 左边框
		columnHeadStyle.setBorderRight(HSSFCellStyle.BORDER_THIN);// 右边框
		columnHeadStyle.setBorderTop(HSSFCellStyle.BORDER_THIN);// 上边框
		columnHeadStyle.setAlignment(HSSFCellStyle.ALIGN_CENTER);
		columnHeadStyle.setVerticalAlignment(HSSFCellStyle.VERTICAL_CENTER);
		columnHeadStyle.setWrapText(true);
		f.setFontHeightInPoints((short) 9);// 字号
		f.setBoldweight(HSSFFont.BOLDWEIGHT_BOLD);// BOLDWEIGHT_BOLD);// 加粗
		columnHeadStyle.setFont(f);

		//设置文本格式
		columnHeadStyle.setDataFormat(format.getFormat("@"));
		
		
		Row row;
		Cell cell;
		row = sheet.createRow(0);
		sheet.createFreezePane(0, 1, 0, 1);
		int i = 0;
		for (String s : fldlst) {
			cell = row.createCell(i);
			cell.setCellStyle(columnHeadStyle);
			cell.setCellValue(disps[i]);
			sheet.setColumnWidth(i, (int) 7000);
			sheet.setDefaultColumnStyle(i,columnHeadStyle);
			i++;
		}
		
	}



	protected void setCellsValueTyle(Cell cell, Object obj, String style,CellStyle cellStyle) {
		if (obj != null) {
			if (obj instanceof Date) {
				if (StringUtils.isEmpty(style))
					style = "yyyy-MM-dd";
				SimpleDateFormat sdfymdCard = new SimpleDateFormat(style);
				cellStyle.setAlignment(HSSFCellStyle.ALIGN_CENTER);
				cell.setCellStyle(cellStyle);
				cell.setCellValue(sdfymdCard.format(obj));
			} else {

				if (obj instanceof Integer || obj instanceof Long || obj instanceof Short) {
					cellStyle.setAlignment(HSSFCellStyle.ALIGN_RIGHT);
					cell.setCellStyle(cellStyle);
					DecimalFormat df = (DecimalFormat) NumberFormat.getInstance();
					df.setMaximumFractionDigits(0);
					cell.setCellValue(df.format(obj));
				} else if (obj instanceof Double || obj instanceof Float) {
					cellStyle.setAlignment(HSSFCellStyle.ALIGN_RIGHT);
					cell.setCellStyle(cellStyle);
					DecimalFormat df2 = (DecimalFormat) DecimalFormat.getInstance();
					if (StringUtils.isEmpty(style))
						style = "n2";
					if (style.startsWith("n")) {
						Integer p = Integer.valueOf(style.substring(style.length() - 1, style.length()));
						StringBuffer sb = new StringBuffer();
						if (p == 0) {
							sb.append("0");
						} else {
							sb.append("0.");
							for (int j = 0; j < p; j++) {
								sb.append("0");
							}
						}

						df2.setGroupingSize(3);
						df2.applyPattern(sb.toString());
						cell.setCellValue(df2.format(obj));
					} else if (style.startsWith("p")) {
						DecimalFormat df3 = (DecimalFormat) DecimalFormat.getInstance();
						df3.applyPattern("##.##%");
						cell.setCellValue(df3.format(obj));
					}

				} else {
					cellStyle.setAlignment(HSSFCellStyle.ALIGN_LEFT);
					cellStyle.setWrapText(true);
					cell.setCellStyle(cellStyle);
					cell.setCellValue(obj.toString());
				}
			}
		} else {
			cell.setCellStyle(cellStyle);
			cell.setCellValue("");
		}

	}
    
    protected String createExcel(String fileName, String[] fldlst,
    		String[] disps,String exceltype) throws Exception {
		String filePath = getFilePath();
		File dir = new File(filePath);
		if (!dir.exists()) {  
			dir.mkdirs();
        }
		String tempExcelFile = "";
		SimpleDateFormat sdfymdCard = new SimpleDateFormat("yyyyMMddHHmmss");
		fileName = fileName + sdfymdCard.format(new Date());
		if (STATIC_XLSX.equals(exceltype)) {
			tempExcelFile = filePath + fileName + ".xlsx";
		} else  {
			tempExcelFile = filePath + fileName + ".xls";
		}
		
		int rowMemory = 100;
		FileOutputStream fos = new FileOutputStream(tempExcelFile);
		if (STATIC_XLSX.equals(exceltype)) {
			try {
				xlsx = new SXSSFWorkbook(rowMemory);
				exportDataToExcel(fldlst, disps,STATIC_XLSX);
				xlsx.write(fos);
				fos.flush();
				fos.close();
			} finally {
				fos.flush();
				fos.close();
			}
		} else {
			try {
				xls = new HSSFWorkbook();
			    exportDataToExcel(fldlst, disps, STATIC_XLS);
				xls.write(fos);
				fos.flush();
				fos.close();
			} finally {
				fos.flush();
				fos.close();
			}
		}
		
		// 返回
		return tempExcelFile;
	}

	public void savelog(ServiceSession session, JSONObject jsonparam) throws Exception{
		ImportLogBean implog = JSON.toJavaObject(jsonparam,ImportLogBean.class);
		implog.setPh_key(UniqueID.getUniqueID());
		implog.setPh_timestamp(new Date());
		implog.setEnt_id(session.getEnt_id());
		getStorageOperations().insert(implog);
	}

	public String downFile(ServiceSession session, JSONObject jsonparam) throws Exception{
		//指定服务器和url地址
		if(jsonparam.containsKey("client")){
			String url = "http://".concat( jsonparam.getString("client"));
			if(!StringUtils.isEmpty(jsonparam.get("url"))) url = url.concat(jsonparam.getString("url"));
			JSONObject json = (JSONObject)jsonparam.clone();
			json.remove("client");
			json.remove("url");
			return getRequest(session,url,json);
		}

		//本地
		String path = jsonparam.getString("filepath");
		return path;
	}


	private String postRequest(ServiceSession session, String url, JSONObject para) throws Exception {
		String FullUrl = url;
			FullUrl = FullUrl.concat("&").concat("param=%7B%22filepath%22:%22//opt//efuture//tmp//%E4%B8%8B%E8%BD%BD%E6%96%87%E4%BB%B6%E6%A1%88%E4%BE%8B.xlsx%22,%22url%22:%22/omp-work-webin/exportbyfile?method=omp.work.fileimport.downFile%22,%22modulecode%22:%226001230%22%7D");
		this.getLogger().info("请求:".concat(url).concat(":").concat(para.toString()));
		String ret = "";

		try{
			ret = HttpUtils.postRequest(FullUrl,para.toJSONString(),"UTF-8");
		} catch(Exception ex){
			throw new Exception("请求错误:".concat(url).concat(":").concat(para.toString()).concat(" ---error:").concat(ex.getMessage()) );
		}

		this.getLogger().info("RES:".concat(ret));
		return ret;
	}

	private String getRequest(ServiceSession session, String url, JSONObject para) throws Exception {
		String FullUrl = url;
		JSONObject param = new JSONObject();
		param.put("param",para);

		String ParaList = HttpUtils.getFullURL(param);
		//ParaList = ParaList.replace("{","%7B").replace("}","%7D").replace("\"","%22");
		ParaList = URLEncoder.encode(ParaList , "UTF-8");
		ParaList = ParaList.replace("param%3D","param=");
		FullUrl = FullUrl.concat("&").concat(ParaList);

		this.getLogger().info("GET请求:".concat(FullUrl) );
		String ret = HttpUtils.getRequest(FullUrl);
		this.getLogger().info("RES返回:".concat(ret));
		return ret;
	}

	public ServiceResponse searchimportlog(ServiceSession session, JSONObject jsonparam) throws Exception{
		FStorageOperations fso = getStorageOperations();
		// 按条件查
		jsonparam.put("ent_id", session.getEnt_id());

		JSONObject param = (JSONObject)jsonparam.clone();
		for(String key : jsonparam.keySet()){
			if(StringUtils.isEmpty(jsonparam.get(key))) param.remove(key);
		}

		// 查询
		StringBuffer total = new StringBuffer();
		List<?> list = null;
		if (org.springframework.util.StringUtils.isEmpty(param.get(BeanConstant.QueryField.PARAMKEY_FIELDS))) list = doSearch(param,ImportLogBean.class,total);
		else list = doSearchForMap(param,ImportLogBean.class,total);

		// 返回应答对象
		JSONObject respdata = new JSONObject();
		respdata.put("total_results", Long.parseLong(total.toString()));
		respdata.put("importlog", list);
		return ServiceResponse.buildSuccess(respdata);

	}

}
