package com.efuture.ocp.common.sysparam;

import com.efuture.ocp.common.util.EnvironmentParaUtils;

public interface SystemParam {

	public String getKey();

	public String getDesc();

	public String getPreParaStr();

	public String getDefaultVal();

	default public int getDefaultIntVal() {
		if (getDefaultVal() != null) {
			return Integer.valueOf(getDefaultVal());
		} else {
			return 0;
		}
	}

	default public String getVal(long entId) {
		String key = this.getPreParaStr() + "." + this.getKey();
		return EnvironmentParaUtils.getEnvPra(entId, key.toLowerCase(), this.getDefaultVal());
	}

	default public int convertToint(String val) {
		if (val != null) {
			return Integer.valueOf(val);
		} else {
			return 0;
		}
	}
	
	default public int getIntVal(long entId) {
		String val = getVal(entId);
		return convertToint(val);
	}
	
	
	default public int getIntVal(long entId, String postfix, String defaultVal) {
		String val = getVal(entId,postfix,defaultVal);
		return convertToint(val);
	}
	
	default public int getIntVal(long entId, String postfix) {
		String val = getVal(entId,postfix);
		return convertToint(val);
	}
	
	default public String getVal(long entId, String postfix, String defaultVal) {
		String key = this.getPreParaStr() + "." + this.getKey() + "." + postfix;
		return EnvironmentParaUtils.getEnvPra(entId, key.toLowerCase(), defaultVal);
	}

	default public String getVal(long entId, String postfix) {
		String key = this.getPreParaStr() + "." + this.getKey() + "." + postfix;
		return EnvironmentParaUtils.getEnvPra(entId, key.toLowerCase(), this.getDefaultVal());
	}

}
