package com.efuture.ocp.common.util;

import java.io.File;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.net.Inet4Address;
import java.net.InetAddress;
import java.net.InterfaceAddress;
import java.net.NetworkInterface;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
/**
 * 
 * @author 肖志文
 * 2020年11月6日 下午2:26:03
 *
 */
/*
 * 
 * 默认情况下有41个bit可以供使用，那么一共有T（1llu << 41）毫秒供你使用分配，年份 = T / (3600 * 24 * 365 * 1000) = 69.7年。
 * 如果你只给时间戳分配39个bit使用，那么根据同样的算法最后年份 = 17.4年。
   40位则34年(7+8+8 23位)
   
 */
public class UUID {

	private static Map<String, String> IPS = new HashMap<String, String>();
	private static String port = "";
	private static String ipAddr0 = "000";
	private static String ipAddr1 = "000";
	private static String ip = "";
	
    /** 开始时间截 (2016-01-01) */
    private static long twepoch    = 1451577600000L;
    private static int splitStart = 2010; 
    private static int splitEnd = 2020;

    /** 机器id所占的位数 */
    private static long workerIdBits = 8L;

    /** 数据标识id所占的位数 */
    private static long processIdBits = 8L;

    /** 支持的最大机器id，结果是256 (这个移位算法可以很快的计算出几位二进制数所能表示的最大十进制数) */
    private static long maxWorkerId = -1L ^ (-1L << workerIdBits);

    /** 支持的最大数据标识id，结果是256 */
    private static long maxProcessId = -1L ^ (-1L << processIdBits);

    /** 序列在id中占的位数 */
    private static long sequenceBits = 6L; //12L;

    /** 机器ID向左移6位 */
    private static long workerIdShift = sequenceBits;

    /** 数据标识id向左移13位(6+8) */
    private static long processIdShift = sequenceBits + workerIdBits;

    /** 时间截向左移22位(6+8+8) */
    private static long timestampLeftShift = sequenceBits + workerIdBits + processIdBits;

    /** 生成序列的掩码，这里为63 (0b111111=0xf3=63) */
    private static long sequenceMask = -1L ^ (-1L << sequenceBits);
    /**
     * 最大容忍时间, 单位毫秒, 即如果时钟只是回拨了该变量指定的时间, 那么等待相应的时间即可;
     * 考虑到sequence服务的高性能, 这个值不易过大
     */
    private static final long MAX_BACKWARD_MILLS = 5;
    
    /** 工作机器ID(0~255) ip地址第4部分*/
    private static Long workerId;

    /** 处理进程ID(0~255) port后两位或ip地址第3部分*/
    private static Long processId;
    
    /**
     * 回拨时间后 可选区域
     */
    private static List<Long> BACKWARD = new ArrayList<Long>();
    private static int BACKWARD_SIZE = 0;
    
    
	private static class LazyHolder {    
		private static final UUID INSTANCE = new UUID();
	} 
	public static UUID getInstance() {
		return LazyHolder.INSTANCE;  
	}
	
	
	private static Map<String, WorkerId> allIds = new HashMap<String, WorkerId>();
	private static List<String> ENV_APPID = new ArrayList<String>();
	private static List<String> ENV_PREFIX= new ArrayList<String>();
	private static List<String> ENV_START = new ArrayList<String>();
	static {
		ENV_APPID.add("GLOBAL_APPID");
		ENV_APPID.add("COMMON_APPID");
		ENV_START.add("GLOBAL_TIME_SET");
		ENV_START.add("COMMON_TIME_SET");
		ENV_PREFIX.add("GLOBAL_APPID_PREFIX");
		ENV_PREFIX.add("COMMON_APPID_PREFIX");

        Calendar calendar = Calendar.getInstance();
        calendar.set(splitStart, Calendar.JANUARY, 1, 0, 0, 0);
        calendar.set(Calendar.MILLISECOND, 0);
        // EPOCH是服务器第一次上线时间点, 设置后不允许修改
        twepoch = calendar.getTimeInMillis();
        
        for(int i = splitStart; i < splitEnd; i++) {
	        calendar.set(i, Calendar.JANUARY, 1, 0, 0, 0);
	        calendar.set(Calendar.MILLISECOND, 0);
	        BACKWARD.add(calendar.getTimeInMillis());
        }
        BACKWARD_SIZE = BACKWARD.size();
	};
	
	private static String getEnv(String key) {
		String val = System.getProperty(key);
		if (val == null) {
			val = System.getenv(key);
		}
		if (val == null) val = "";
		val = val.trim();
		return val;
	}
	
	public static long getId(final String key) {
		WorkerId workerId = allIds.get(key);
		if (workerId == null) {
			synchronized (allIds) {
				workerId = allIds.get(key);
				if (workerId == null) {
					initId();
					workerId = UUID.getInstance().getWorkerId();
					allIds.put(key, workerId);
				}
			}
		}
		return workerId.value();
	}
	

	private static void initId() {
		if (workerId != null) {
			return;
		}
		for(String key : ENV_APPID) {
			String val = getEnv(key);
			if (val.isEmpty()) continue;
			if (val.length() > 3) {
				val = val.substring(val.length() - 3);
			}
			workerId  = Long.valueOf(val);
			processId = 0L;
			return;
		}
		String port = parsePath();
		String prefixId = "";
		for(String key : ENV_PREFIX) {
			prefixId = getEnv(key);
			if (prefixId.isEmpty()) continue;
			break;
		}
		String[] addr = getIpAddr(prefixId);
		if (port == null || "".equals(port)) { //一般是实体机器运行几个tomcat不同目录
			workerId = Long.valueOf(addr[2]);
			processId= Long.valueOf(addr[1]);
		} else {
			if (port.length() > 2) {//只能取两位<256
				port = port.substring(port.length() - 2);//最后2位
			}
			workerId = Long.valueOf(addr[2]);
			processId = Long.valueOf(port);
		}
		logger.warn("workerId:[" + workerId + "], processId:[" + processId + "]");
	}
	
	private static String parsePath() {
		String path = getPath();
//		try {
//			path = Thread.currentThread().getContextClassLoader().getResource("").getPath();
//			path = URLDecoder.decode(path, "UTF-8");
//		} catch (Exception e) {
//			logger.error("获取app运行路径失败[" + path + "]:" + getTrace(e));
//			path = null;
//		}
		String regex = "\\d+";
		Pattern pattern = Pattern.compile(regex);
		Matcher matcher = pattern.matcher(path);
		while (matcher.find()) {
			String s = matcher.group();
			if (s.length() > 3) {
				port = matcher.group();// 匹配最后的数字
			}
		}
		if (port != null && port.length() > 3) {
			port = port.substring(port.length() - 4);
		} else {
			port = null;
		}
		logger.warn("port:[" + port + "]");
		return port;
	}
	
	/**
	 * 获取当前运行路径
	 * @return
	 */
	public static String getPath() {
		// String p1 = UUID.class.getResource("/").getPath();
		
			//String path = ResourceUtils.getURL("classpath:").getPath();
			//String path = UUID.class.getProtectionDomain().getCodeSource().getLocation().getFile();
			//URL url = UUID.class.getProtectionDomain().getCodeSource().getLocation();
			
			//curPath = path; //Thread.currentThread().getContextClassLoader().getResource("").getPath();
		String cpath = null;
			
		ClassLoader cl = getDefaultClassLoader();
		URL url = (cl != null ? cl.getResource("") : ClassLoader.getSystemResource(""));
		File sp = getFile(url);
		File fp = new File(sp.getAbsolutePath());
		while(!fp.exists() || !fp.isDirectory()) {
			fp = fp.getParentFile();
		}
		cpath = fp.getPath();
		cpath = cpath.replace('\\', '/').toLowerCase();
		logger.warn("path:[" + cpath + "]");
		return cpath;
	}
	private static ClassLoader getDefaultClassLoader() {
		ClassLoader cl = null;
		try {
			cl = Thread.currentThread().getContextClassLoader();
		}catch (Throwable ex) {
		}
		if (cl == null) {
			cl = UUID.class.getClassLoader();
			if (cl == null) {
				try {
					cl = ClassLoader.getSystemClassLoader();
				}
				catch (Throwable ex) {
				}
			}
		}
		return cl;
	}
	public static File getFile(URL resourceUrl) {
		try {
			return new File(toURI(resourceUrl).getSchemeSpecificPart());
		}
		catch (URISyntaxException ex) {
			return new File(resourceUrl.getFile());
		}
	}
	private static URI toURI(URL url) throws URISyntaxException {
		return new URI(url.toString().replace(" ", "%20"));
	}
	
	public static String getHostname() {
		InetAddress netAddress;
		try {
			netAddress = InetAddress.getLocalHost();
			return netAddress.getHostName();
		} catch (UnknownHostException e) {
			logger.warn("警告:getLocalHost系统获取hostname异常:" + getTrace(e));
		}
		return null;
	}

	public static String[] getIpAddr(String prefix) {
		try {
			// InetAddress.getLocalHost().getHostAddress();
			/* 获取所有IP地址 如果存在所需要内网ip就退出了 */
			InetAddress lo = InetAddress.getLocalHost();
			if (!lo.isAnyLocalAddress() && !lo.isLoopbackAddress() && lo instanceof Inet4Address) {
				String key = lo.getHostAddress();
				IPS.put(key, lo.getHostName());
				if (key.startsWith(prefix)) {// IPV4 同时内网
					ip = key;
				}
			}
		} catch (UnknownHostException e) {
			logger.warn("警告:getLocalHost系统获取IP地址异常:" + getTrace(e));
		}
		if ("".equals(ip)) {
			try {
				// InetAddress.getLocalHost().getHostAddress();
				/* 获取所有IP地址 如果存在所需要内网ip就退出了 */
				Enumeration<NetworkInterface> nets = NetworkInterface.getNetworkInterfaces();
//				
//				 while (nets.hasMoreElements()) {
//			            NetworkInterface ni = nets.nextElement();
//			            if (ni.isLoopback()) {
//			                continue;
//			            }
//
//			            Enumeration<InetAddress> addressEnumeration = ni.getInetAddresses();
//			            while (addressEnumeration.hasMoreElements()) {
//			                InetAddress address = addressEnumeration.nextElement();
//
//			                // ignores all invalidated addresses
//			                if (address.isLinkLocalAddress() || address.isLoopbackAddress() || address.isAnyLocalAddress()) {
//			                    continue;
//			                }
//
//			                return address;
//			            }
//			        }

				for (NetworkInterface netint : Collections.list(nets)) {
					// 去掉虚拟网卡
					if (netint.isLoopback() || !netint.isUp() || netint.isVirtual() || netint.isPointToPoint()) { // ||
																													// netint.isPointToPoint()
																													// (VPN也可以包含在里面)
						continue;
					}
					List<InterfaceAddress> netips = netint.getInterfaceAddresses();
					for (InterfaceAddress addr : netips) {
						InetAddress ia = addr.getAddress();
						if (ia instanceof Inet4Address) {
							String key = ia.getHostAddress();
							IPS.put(key, ia.getHostName());
							if (isInternalIp(key) && key.startsWith(prefix)) {// IPV4 同时内网
								ip = key;
								break;
							}
						}
					}
				}
			} catch (java.net.SocketException e) {
				logger.warn("警告:系统获取IP地址异常," + getTrace(e));
			}
		}
		String[] rtn = null, address = null;
		if ("".equals(ip)) {
			IPS.put("127.0.0.1", "localhost");
			IPS.put("0.0.0.0", "localhost");

			for (String key : IPS.keySet()) {
				if (isIpv4(key) && isInternalIp(key) && key.startsWith(prefix)) {// IPV4 同时内网
					ip = key;  
					break;
				}
			}
			if ("".equals(ip) || "0.0.0.0".equals(ip)) {
				for (String key : IPS.keySet()) {// 只要是IPV4
					if (isIpv4(key) && key.startsWith(prefix)) {
						ip = key;
						break;
					}
				}
			}
			if ("".equals(ip)) {
				ip = "127.0.0.1";
			}
		}
		address = ip.split("\\.");
		ipAddr0 = address[3];
		ipAddr1 = address[2];

		rtn = new String[] { ip, String.format("%03d", Integer.parseInt(ipAddr1)),
				String.format("%03d", Integer.parseInt(ipAddr0)) };
		logger.warn("ip 地址[" + rtn[0] + "], [" + rtn[1] + "], [" + rtn[2] + "]");
		return rtn;
	}

	// ipv4是32位地址，分成4段，每段之间都有 "." 分开，而每段之间有8位，从 0 - 255.
	// pv6是128位地址，每个数目等于4位（0-F）16位进制，4个一组，每段之间由 ":"隔开，共有8段
	private static boolean isIpv4(String ip) {
		if (ip.indexOf('.') != -1)
			return true;
		else
			return false;
	}

	private static boolean isInternalIp(String ip) {
		byte[] addr = textToNumericFormatV4(ip);
		return isInternalIp(addr);
	}

	/**
	 * tcp/ip协议中，专门保留了三个IP地址区域作为私有地址，其地址范围如下：
	 * 
	 * 10.0.0.0/8：10.0.0.0～10.255.255.255  172.16.0.0/12：172.16.0.0～172.31.255.255 
	 * 192.168.0.0/16：192.168.0.0～192.168.255.255
	 * 
	 * @param addr
	 * @return
	 */
	private static boolean isInternalIp(byte[] addr) {
		final byte b0 = addr[0];
		final byte b1 = addr[1];
		// 10.x.x.x/8
		final byte SECTION_1 = 0x0A;
		// 172.16.x.x/12
		final byte SECTION_2 = (byte) 0xAC;
		final byte SECTION_3 = (byte) 0x10;
		final byte SECTION_4 = (byte) 0x1F;
		// 192.168.x.x/16
		final byte SECTION_5 = (byte) 0xC0;
		final byte SECTION_6 = (byte) 0xA8;
		switch (b0) {
		case SECTION_1:
			return true;
		case SECTION_2:
			if (b1 >= SECTION_3 && b1 <= SECTION_4) {
				return true;
			}
		case SECTION_5:
			switch (b1) {
			case SECTION_6:
				return true;
			}
		default:
			return false;
		}
	}

	private final static int INADDR4SZ = 4;

	public static byte[] textToNumericFormatV4(String src) {
		if (src.length() == 0) {
			return null;
		}
		byte[] res = new byte[INADDR4SZ];
		String[] s = src.split("\\.", -1);
		long val;
		try {
			switch (s.length) {
			case 1:
				val = Long.parseLong(s[0]);
				if (val < 0 || val > 0xffffffffL)
					return null;
				res[0] = (byte) ((val >> 24) & 0xff);
				res[1] = (byte) (((val & 0xffffff) >> 16) & 0xff);
				res[2] = (byte) (((val & 0xffff) >> 8) & 0xff);
				res[3] = (byte) (val & 0xff);
				break;
			case 2:
				val = Integer.parseInt(s[0]);
				if (val < 0 || val > 0xff)
					return null;
				res[0] = (byte) (val & 0xff);
				val = Integer.parseInt(s[1]);
				if (val < 0 || val > 0xffffff)
					return null;
				res[1] = (byte) ((val >> 16) & 0xff);
				res[2] = (byte) (((val & 0xffff) >> 8) & 0xff);
				res[3] = (byte) (val & 0xff);
				break;
			case 3:
				for (int i = 0; i < 2; i++) {
					val = Integer.parseInt(s[i]);
					if (val < 0 || val > 0xff)
						return null;
					res[i] = (byte) (val & 0xff);
				}
				val = Integer.parseInt(s[2]);
				if (val < 0 || val > 0xffff)
					return null;
				res[2] = (byte) ((val >> 8) & 0xff);
				res[3] = (byte) (val & 0xff);
				break;
			case 4:
				for (int i = 0; i < 4; i++) {
					val = Integer.parseInt(s[i]);
					if (val < 0 || val > 0xff)
						return null;
					res[i] = (byte) (val & 0xff);
				}
				break;
			default:
				return null;
			}
		} catch (NumberFormatException e) {
			e.printStackTrace();
			return null;
		}
		return res;
	}

	/**
	 * 获取异常中的所有信息
	 * 
	 * @param t
	 * @return
	 */
	public static String getTrace(Throwable t) {
		StringWriter stringWriter = new StringWriter();
		PrintWriter writer = new PrintWriter(stringWriter);
		t.printStackTrace(writer);
		StringBuffer buffer = stringWriter.getBuffer();
		return buffer.toString();
	}

	private static class Logger {
		public void info(String msg) {
			int level = 1;
			StackTraceElement[] stacks = new Throwable().getStackTrace();
			int line = stacks[level].getLineNumber();
			System.out.println(String.format("%4d-%s", line, msg));
		}

		public void warn(String msg) {
			int level = 1;
			StackTraceElement[] stacks = new Throwable().getStackTrace();
			int line = stacks[level].getLineNumber();
			System.out.println(String.format("%4d-%s", line, msg));
		}
	}

	public static Logger logger = new Logger();
	
	public static Logger getLogger() {
		return logger;
	}
	public WorkerId getWorkerId() {
		WorkerId b = new WorkerId();
		return b;
	}
	
	class WorkerId {
	    /** 毫秒内序列(0~63) */
	    private long sequence = 0L;
	    
	    /** 上次生成ID的时间截 */
	    private long lastTimestamp = -1L;
	    
	    private int backupStep = 0; //
	    
	    // ==============================Methods==========================================
	    /**
	     * 获得下一个ID (该方法是线程安全的)
	     * @return SnowflakeId
	     */
	    public synchronized long value() {
	        long curTimestamp = timeGen();
	        boolean isBackup = false;
	        //如果当前时间小于上一次ID生成的时间戳，说明系统时钟回退过这个时候应当抛出异常
	        if (curTimestamp < lastTimestamp) {
	        	long offset = lastTimestamp - curTimestamp;
	        	while (offset > 0 && offset <= MAX_BACKWARD_MILLS){
	                try {
	                    //睡（lastTimestamp - currentTimestamp）ms让其追上
	                    //LockSupport.parkNanos(TimeUnit.MILLISECONDS.toNanos(offset));
	                	Thread.sleep(offset);
	                    curTimestamp = timeGen();
                    	offset = lastTimestamp - curTimestamp;
                    	if (offset > MAX_BACKWARD_MILLS) { // 在判断时时间回拨了
                    		break;
                    	}
                    	if (offset < 0) {
                    		break;
                    	}
	                } catch (Exception e) {
	                    e.printStackTrace();
	                    break;
	                }
	            }
	        	if (offset > MAX_BACKWARD_MILLS) {
	        		isBackup = true;
	        	}
	        }
	        //如果是同一时间生成的，则进行毫秒内序列
	        if (lastTimestamp == curTimestamp) {
	            sequence = (sequence + 1) & sequenceMask;
	            //毫秒内序列溢出
	            if (sequence == 0) {
	                //阻塞到下一个毫秒,获得新的时间戳
	            	curTimestamp = tilNextMillis(lastTimestamp);
	            }
	        }
	        //时间戳改变，毫秒内序列重置
	        else {
	            sequence = 0L;
	        }

	        
	        if (isBackup) {
	        	backupStep = backupStep%BACKWARD.size();
	        	curTimestamp = tilMoveMillis(curTimestamp);
	        } else {
	        	//上次生成ID的时间截
	        	lastTimestamp = curTimestamp;
	        }
	        //移位并通过或运算拼到一起组成64位的ID
	        return ((curTimestamp - twepoch) << timestampLeftShift) //
	                | (processId << processIdShift) //
	                | (workerId << workerIdShift) //
	                | sequence;
	    }

	    /**
	     * 阻塞到下一个毫秒，直到获得新的时间戳
	     * @param lastTimestamp 上次生成ID的时间截
	     * @return 当前时间戳
	     */
	    protected long tilNextMillis(long lastTimestamp) {
	        long timestamp = timeGen();
	        while (timestamp <= lastTimestamp) {
	            timestamp = timeGen();
	        }
	        return timestamp;
	    }

	    /**
	     * 返回以毫秒为单位的当前时间
	     * @return 当前时间(毫秒)
	     */
	    protected long timeGen() {
	        return System.currentTimeMillis();
	    }
	    
	    /**
	     * 平移时间
	     * @param curTimestamp
	     * @return
	     * @author 肖志文
	     * 2020年11月4日 下午6:21:29
	     */
	    protected long tilMoveMillis(long curTimestamp) {
	        Calendar r = Calendar.getInstance();
	        r.setTimeInMillis(curTimestamp);
	        r.set(r.get(Calendar.YEAR), Calendar.JANUARY, 1, 0, 0, 0);
	        r.set(Calendar.MILLISECOND, 0);
	        
	        long subMills = curTimestamp - r.getTimeInMillis();
	        
        	backupStep = backupStep%BACKWARD.size();
        	curTimestamp = BACKWARD.get(backupStep) + subMills;
        	backupStep++;
        	return curTimestamp;
	    }
	}
	
//	
//	public static void main(String[] args) throws Exception {
//		int THREADS_CONUT =20;
//		Thread[] threads = new Thread[THREADS_CONUT];
//		for (int i = 0; i < THREADS_CONUT; i++) {
//			threads[i] = new Thread(new Runnable() {
//				@Override
//				public void run() {
//					for (int i = 0; i < 100; i++) {
//						System.out.println(UUID.getId("orders"));
//						System.out.println(UUID.getId("accntlog"));
//					}
//				}
//			});
//			threads[i].setName(String.format("%02d", i));
//			threads[i].start();
//		}
//		try {
//			Thread.sleep(1000);
//		} catch (InterruptedException e) {
//			e.printStackTrace();
//		}
//		while (true) {
//			char val = (char) System.in.read();
//			if (val == 'e')
//				break;
//		}
//		System.out.println("A");
//	}
}
