package com.efuture.ocp.common.annotation;

import java.util.Map;

import com.efuture.ocp.common.distributedLock.DistributedLockHandle;
import org.apache.log4j.Logger;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.StringUtils;

import com.alibaba.fastjson.JSONObject;
//import com.efuture.ocp.common.redis.DistributedRedisLock;
import com.efuture.ocp.common.cache.CacheUtils;
import com.efuture.ocp.common.util.MD5Utils;

@Aspect
@Component
public class AutoCacheAspect
{
    private static final Logger logger = Logger.getLogger(AutoCacheAspect.class);
    @Autowired
    DistributedLockHandle dLockSrv;

    private String getKey(ProceedingJoinPoint point, AutoCache around)
    {
        String Service = around.Service();
        String keyname = around.KeyName();
        String[] ExpKeys = around.ExpKeys().split(",");
        int argindex = around.KeyArgIndex();
        String className = point.getTarget().getClass().getSimpleName();
        String methodName = point.getSignature().getName();
        Object[] args = point.getArgs();
        StringBuffer sb = new StringBuffer();

        if (argindex != -1 && args.length > argindex) {
            Object arg = args[argindex];
            JSONObject jsonarg;

            if (arg instanceof JSONObject) {
                jsonarg = (JSONObject) arg;
            }
            else if (arg instanceof String) {
                jsonarg = new JSONObject();
                jsonarg.put(String.valueOf(argindex), arg);
            }
            else {
                jsonarg = (JSONObject) JSONObject.toJSON(arg);
            }

            if (StringUtils.isEmpty(keyname)) {
                if (ExpKeys != null && ExpKeys.length > 0) {
                    jsonarg = (JSONObject) jsonarg.clone();

                    for (String expKey : ExpKeys) {
                        if (jsonarg.containsKey( expKey )) {
                            jsonarg.remove(expKey);
                        }
                    }

                    sb.append("_").append(JSONObject.toJSON(jsonarg));
                }
                else {
                    sb.append("_").append(JSONObject.toJSON(arg));
                }
            }
            else {
                String[] keys = keyname.split(",");
                StringBuffer sbkey = new StringBuffer();

                for (String key : keys) {
                    if (key != null) {
                        Object value = jsonarg.get(key);

                        if (value != null) {
                            sbkey.append("-").append(key).append(":").append(value.toString());
                        }
                    }
                }

                if (sbkey.length() > 0) {
                    sb.append("_").append(sbkey.toString());
                }
                else {
                    sb.append("_").append(jsonarg.toJSONString());
                }
            }
        }
        else if (argindex == 99 && !StringUtils.isEmpty(keyname)) {
            // 常规类型
            String[] keys = keyname.split(",");
            StringBuffer sbkey = new StringBuffer();

            for (String key : keys) {
                String keyVal = null;

                if (ExpKeys != null && ExpKeys.length > 0) {
                    if (args[Integer.valueOf(key)] instanceof Map) {
                        Map dummy = (Map) args[Integer.valueOf(key)];

                        for (String expKey : ExpKeys) {
                            dummy.remove(expKey);
                        }

                        keyVal = dummy.toString();
                    }
                    else {
                        keyVal = args[Integer.valueOf(key)].toString();
                    }
                }
                else {
                    keyVal = args[Integer.valueOf(key)].toString();
                }

                if (sbkey.length() > 0) {
                    sb.append("_").append(args[Integer.valueOf(key)].toString());
                }
                else {
                    sb.append(args[Integer.valueOf(key)].toString());
                }
            }
        }
        else if (argindex == 100) {
            //nothing
            sb.append( "0" );
        }
        else {
            for (Object arg : args) {
                if (arg != null) {
                    sb.append("_").append(JSONObject.toJSON(arg));
                }
            }
        }

        return Service.concat(":").concat(className).concat(":").concat(methodName).concat(":").concat(MD5Utils.MD5(sb.toString()));
    }

    @Around("@annotation(around)")
    public Object round(ProceedingJoinPoint point, AutoCache around) throws Throwable
    {
        String className = point.getTarget().getClass().getSimpleName();
        String methodName = point.getSignature().getName();
        long starttime = System.currentTimeMillis();
        String cacheKey = getKey(point, around);
        Object result = CacheUtils.getCacheUtils(around.CacheLevel()).getData(cacheKey);

        if (!StringUtils.isEmpty(result)) {
            if ("NULL".equals(result)) {
                result = null;
            }

            return result;
        }

        String lockKey = cacheKey.concat( "-LOCK" );

        // 2020.8.16 兼容内存级别缓存
        synchronized (lockKey) {
            try {
                // 2020.4.30 开启缓存后的读取全局锁，避免缓存击穿
                if (!CacheUtils.CacheLevel.Memory.equalsIgnoreCase( around.CacheLevel() )) {
                    dLockSrv.tryLock( lockKey, 60, 1000 );
                    result = com.efuture.ocp.common.util.CacheUtils.getCacheUtils( around.CacheLevel() ).getData( cacheKey );

                    if (!StringUtils.isEmpty( result )) {
                        if ("NULL".equals( result )) {
                            result = null;
                        }

                        return result;
                    }
                }

                result = point.proceed();

                if (StringUtils.isEmpty( result )) {
                    CacheUtils.getCacheUtils( around.CacheLevel() ).putData( cacheKey, "NULL", CacheUtils.CacheTimeOut.Hour );
                }
                else {
                    int timeout = around.TimeOut() + (int) Math.round( Math.random() * 360 );
                    CacheUtils.getCacheUtils( around.CacheLevel() ).putData( cacheKey, result, timeout );

                    if (around.Readable()) {
                        String readKey = cacheKey.concat( "-READABLE" );
                        CacheUtils.getCacheUtils( around.CacheLevel() ).putDataText( readKey, result.toString(), timeout );
                    }
                }
            }
            catch (Throwable e) {
                throw e;
            }
            finally {
                if (!CacheUtils.CacheLevel.Memory.equalsIgnoreCase( around.CacheLevel() )) {
                    dLockSrv.unlock( lockKey );
                }
            }
        }

        return result;
    }

}
