package com.efuture.ocp.common.component.excel;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.efuture.ocp.common.billservice.ReportServiceImpl;
import com.efuture.ocp.common.component.BasicComponent;
import com.efuture.ocp.common.component.GlobRuleSrv;
import com.efuture.ocp.common.component.excel.uiconfig.UiClass;
import com.efuture.ocp.common.component.excel.uiconfig.UiClassSrv;
import com.efuture.ocp.common.component.excel.uiconfig.UiProperty;
import com.efuture.ocp.common.entity.FileImportObject;
import com.efuture.ocp.common.entity.ServiceResponse;
import com.efuture.ocp.common.entity.ServiceSession;
import com.efuture.ocp.common.exception.ServiceException;
import com.efuture.ocp.common.language.ResponseCode;
import com.efuture.ocp.common.rest.ServiceMethodReflect;
import com.efuture.ocp.common.util.*;
import com.efuture.omd.storage.FMybatisTemplate;
import com.github.pagehelper.Page;
import com.github.pagehelper.PageHelper;
import org.apache.poi.hssf.usermodel.HSSFCell;
import org.apache.poi.hssf.usermodel.HSSFCellStyle;
import org.apache.poi.hssf.usermodel.HSSFFont;
import org.apache.poi.ss.usermodel.*;
import org.apache.poi.xssf.streaming.SXSSFWorkbook;
import org.apache.poi.xssf.usermodel.XSSFCell;
import org.apache.poi.xssf.usermodel.XSSFRow;
import org.apache.poi.xssf.usermodel.XSSFSheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.StringUtils;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.text.DecimalFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.*;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;

@Component
public class ExcelComponent extends BasicComponent
{
    interface ERRCODE
    {
        final String NotNull = "1"; //非空校验
        final String NotRepeat = "2"; //重复校验
        final String FormatError = "3"; //格式错误
    }
    //excel导入读取起始行
    private int impReadRow = 1;
    private int maxRow = -1;
    private int maxErrRow = 20;

    //excel导出最大行数
    private int maxWriteRows = 100000;
    //excel单sheet最大行数
    private int maxWriteRowsSheet = 20000;

    private static ServiceMethodReflect rcm = new ServiceMethodReflect();
    @Autowired
    private ModuleImpConfigServiceImpl moduleImpConfigSrv;
    @Autowired
    private ExcelImportErrServiceImpl excelImpErrSrv;
    @Autowired
    BatchInsService batchInsSrv;
    @Autowired
    private GlobRuleSrv globrulesrv;
    @Autowired
    private UiClassSrv uiClassSrv;
    private static final ThreadLocal<Map<String, Object>> fields = new ThreadLocal<Map<String, Object>>();

    class CreateSheetThread extends Thread
    {
        private Sheet sheet;
        private List<UiClass> configs;
        private CellStyle headStyle;
        private List<CellStyle> detStyles;
        private String queryid;
        private Map<String, Object> mapparam;
        private int pageNo;

        public CreateSheetThread(Sheet sheet, List<UiClass> configs, CellStyle headStyle, List<CellStyle> detStyles, String queryid, Map<String, Object> mapparam, int pageNo)
        {
            this.sheet = sheet;
            this.configs = configs;
            this.headStyle = headStyle;
            this.detStyles = detStyles;
            this.queryid = queryid;
            this.mapparam = mapparam;
            this.pageNo = pageNo;
        }

        @Override
        public void run()
        {
            try {
                createSheet(sheet, configs, headStyle, detStyles, queryid, mapparam, pageNo);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }
    // 导出下载模版
    public Map<String, Object> exportTemplate(ServiceSession session, JSONObject jsonparam) throws Exception
    {
        checkPara(session, jsonparam);
        String billmoduleid = getParamWithCheck(jsonparam, "billmoduleid", true, "");
        String filename = billmoduleid + "-ImportTemplate";
        List<ModuleImpConfigHeadBean> list = moduleImpConfigSrv.getModuleImpConfigList(session.getEnt_id(), billmoduleid);
        SXSSFWorkbook sxssfWorkbook = new SXSSFWorkbook();
        sxssfWorkbook = createExcelTemplate(list, sxssfWorkbook);
        ByteArrayOutputStream output = null;
        InputStream inputStream = null;

        try {
            output = new ByteArrayOutputStream();
            sxssfWorkbook.write(output);
            inputStream = new ByteArrayInputStream(output.toByteArray());
            output.flush();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            try {
                if (output != null) {
                    output.close();

                    if (inputStream != null) {
                        inputStream.close();
                    }

                    if (sxssfWorkbook != null) {
                        //处理SXSSFWorkbook导出excel时，产生的临时文件
                        sxssfWorkbook.dispose();
                    }
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }

        Map<String, Object> map = new HashMap<String, Object>();
        map.put("inputStream", inputStream);
        map.put("filename", filename + ".xlsx");
        return map;
    }

    /**
     * 生成导入模板
     *
     * @param list
     */
    public SXSSFWorkbook createExcelTemplate(List<ModuleImpConfigHeadBean> list, SXSSFWorkbook sxssfWorkbook) throws Exception
    {
        for (ModuleImpConfigHeadBean config : list) {
            config = moduleImpConfigSrv.getModuleImpConfig(config.getEnt_id(), config.getEid());
            sxssfWorkbook = createExcel(null, config, sxssfWorkbook);
        }

        return sxssfWorkbook;
    }

    /**
     * 生成导入模板名称
     *
     * @param config
     * @return
     */
    public String createExcelSheetName(ModuleImpConfigHeadBean config)
    {
        //excel模板名称：模块号+ename
        String name = "模块" + config.getModuleid() + config.getEname() + "-Template";
        return name;
    }

    public SXSSFWorkbook createExcel(List<Map<String, Object>> list, ModuleImpConfigHeadBean config, SXSSFWorkbook sxssfWorkbook)
    {
        try {
            String sheetname = createExcelSheetName(config);
            Sheet sheet = sxssfWorkbook.createSheet(sheetname);
            // 冻结第一行
            sheet.createFreezePane(0, 1);
            // 创建第一行,作为header表头
            Row header = sheet.createRow(0);
            sheet = createExcelHead(config, header, sheet, sxssfWorkbook);
            return sxssfWorkbook;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
        }

        return null;
    }

    /**
     * 生成excel的标题列，并将对应的格式写入线程变量
     *
     * @param config
     * @param header
     * @param sheet
     */
    public Sheet createExcelHead(ModuleImpConfigHeadBean config, Row header, Sheet sheet, SXSSFWorkbook sxssfWorkbook)
    {
        //当创建过多的样式（格式）时容易发生bai单元格丢失问du题，所以需要严格控制单元格样式的创建和生成，同样的样式只创建1次，所有同样式
        List<ModuleImpConfigDetBean> fields = config.getModuleimpconfigdet().stream().filter(s -> !"Y".equalsIgnoreCase(s.getDefaultparam())).collect(
                Collectors.toList());
        fields.stream().sorted(Comparator.comparing(ModuleImpConfigDetBean::getIsorder));
        CellStyle cellHeadStyleRed = createHeadCellStyleRed(sxssfWorkbook);
        CellStyle cellHeadStyleNormal = createHeadCellStyleNormal(sxssfWorkbook);

        for (int cellnum = 0; cellnum < fields.size(); cellnum++) {
            Cell cell = header.createCell(cellnum);
            //cell.setCellStyle(getAndSetXSSFCellStyleHeader(sxssfWorkbook));//设置表头单元格样式,根据需要设置
            cell.setCellValue(fields.get(cellnum).getField_name());

            //判断是否非空，非空字体颜色标红
            if (!StringUtils.isEmpty(fields.get(cellnum).getIsnonullfield()) && "Y".equals(fields.get(cellnum).getIsnonullfield())) {
                cell.setCellStyle(cellHeadStyleRed);
            }
            else {
                cell.setCellStyle(cellHeadStyleNormal);
            }

            //设置每列固定宽度
            sheet.setColumnWidth(cellnum, 20 * 256);
        }

        return sheet;
    }

    /**
     * 生成标题行的通用样式
     *
     * @param sxssfWorkbook
     * @return
     */
    public CellStyle createHeadCellStyleRed(SXSSFWorkbook sxssfWorkbook)
    {
        //设置标题cell样式
        //设置垂直居中，文本居中
        CellStyle cellStyle = sxssfWorkbook.createCellStyle();
        cellStyle.setBorderTop(HSSFCellStyle.BORDER_THIN);// 上边框
        cellStyle.setBorderBottom(HSSFCellStyle.BORDER_THIN);// 下边框
        cellStyle.setBorderLeft(HSSFCellStyle.BORDER_THIN);// 左边框
        cellStyle.setBorderRight(HSSFCellStyle.BORDER_THIN);// 右边框
        cellStyle.setAlignment(HSSFCellStyle.ALIGN_CENTER);
        cellStyle.setVerticalAlignment(HSSFCellStyle.VERTICAL_CENTER);
        Font f = sxssfWorkbook.createFont();
        f.setFontHeightInPoints((short) 9);// 字号
        f.setBoldweight(HSSFFont.BOLDWEIGHT_BOLD);// BOLDWEIGHT_BOLD);// 加粗
        f.setColor(HSSFFont.COLOR_RED);
        cellStyle.setFont(f);
        cellStyle.setWrapText(true);
        return cellStyle;
    }

    /**
     * 生成标题行的通用样式
     *
     * @param sxssfWorkbook
     * @return
     */
    public CellStyle createHeadCellStyleNormal(SXSSFWorkbook sxssfWorkbook)
    {
        //设置标题cell样式
        //设置垂直居中，文本居中
        CellStyle cellStyle = sxssfWorkbook.createCellStyle();
        cellStyle.setBorderTop(HSSFCellStyle.BORDER_THIN);// 上边框
        cellStyle.setBorderBottom(HSSFCellStyle.BORDER_THIN);// 下边框
        cellStyle.setBorderLeft(HSSFCellStyle.BORDER_THIN);// 左边框
        cellStyle.setBorderRight(HSSFCellStyle.BORDER_THIN);// 右边框
        cellStyle.setAlignment(HSSFCellStyle.ALIGN_CENTER);
        cellStyle.setVerticalAlignment(HSSFCellStyle.VERTICAL_CENTER);
        Font f = sxssfWorkbook.createFont();
        f.setFontHeightInPoints((short) 9);// 字号
        f.setBoldweight(HSSFFont.BOLDWEIGHT_BOLD);// BOLDWEIGHT_BOLD);// 加粗
        f.setColor(HSSFFont.COLOR_NORMAL);
        cellStyle.setFont(f);
        cellStyle.setWrapText(true);
        return cellStyle;
    }

    /**
     * @param sxssfWorkbook
     * @return
     */
    public CellStyle createCellStyle(SXSSFWorkbook sxssfWorkbook)
    {
        //设置标题cell样式
        //默认设置垂直居中，文本左对齐
        //文本左对齐，数字右对齐，日期居中
        CellStyle cellStyle = sxssfWorkbook.createCellStyle();
        cellStyle.setBorderTop(HSSFCellStyle.BORDER_THIN);// 上边框
        cellStyle.setBorderBottom(HSSFCellStyle.BORDER_THIN);// 下边框
        cellStyle.setBorderLeft(HSSFCellStyle.BORDER_THIN);// 左边框
        cellStyle.setBorderRight(HSSFCellStyle.BORDER_THIN);// 右边框
        cellStyle.setVerticalAlignment(HSSFCellStyle.VERTICAL_CENTER);
        cellStyle.setAlignment(HSSFCellStyle.ALIGN_LEFT);
        cellStyle.setDataFormat(sxssfWorkbook.createDataFormat().getFormat("@"));
        cellStyle.setWrapText(true);
        return cellStyle;
    }

    /**
     * excel导入验证，校验重复
     *
     * @param session
     * @param param
     * @param srvname
     * @param list
     */
    public ServiceResponse importExcel(ServiceSession session, String param, String srvname, List<FileImportObject> list) throws Exception
    {
        JSONObject jsonparam = JSON.parseObject(param);
        checkPara(session, jsonparam);
        String billmoduleid = getParamWithCheck(jsonparam, "billmoduleid", true, "");
        String eid = getParamWithCheck(jsonparam, "eid", false, "");
        JSONObject jsonpara = JSONObject.parseObject(param);
        jsonpara.put("eid", eid);
        //存在一个模块对应多个导入模板，多个模块对应一个导入模板，如一个模块对应有多个模块，需传入eid
        ModuleImpConfigHeadBean config = moduleImpConfigSrv.getModuleImpConfig(session.getEnt_id(), eid, billmoduleid);
        //导入前操作，导入前的返回值加到参数透传给excel处理事件
        Object initvar = rcm.executeClassMethod(srvname + ".beforeExcelImport", session, jsonpara.toString());
        JSONObject json = null;
        jsonpara.put("initvar", initvar);

        for (FileImportObject fio : list) {
            if (fio.getFilename().toLowerCase().endsWith(".xlsx")) {
                json = Verify(session, jsonpara, srvname, fio.getStream(), config, maxRow);
            }
        }

        if (!StringUtils.isEmpty(json) && StringUtils.isEmpty(json.get("errcode"))) {
            //导入后操作
            rcm.executeClassMethod(srvname + ".afterExcelImport", session, jsonpara.toString());
        }

        return ServiceResponse.buildSuccess(json);
    }

    public JSONObject Verify(ServiceSession session, JSONObject param, String srvname, InputStream is, ModuleImpConfigHeadBean config, long maxrow) throws Exception
    {
        List<Map<String, Object>> list = new ArrayList<Map<String, Object>>();
        List<ImpErrMsgBean> errlist = new ArrayList<ImpErrMsgBean>();
        XSSFWorkbook hssfWorkbook = new XSSFWorkbook(is);
        List<ModuleImpConfigDetBean> fields = config.getModuleimpconfigdet();
        //获取有缺省值字段list
        List<ModuleImpConfigDetBean> defaultfields = fields.stream().filter(s -> "Y".equalsIgnoreCase(s.getDefaultparam())).collect(Collectors.toList());
        //非缺省值字段list
        List<ModuleImpConfigDetBean> normalfields = fields.stream().filter(s -> !"Y".equalsIgnoreCase(s.getDefaultparam())).collect(Collectors.toList());
        String uniquecols = config.getUniquecolumn();
        String norepeatcols = config.getIsnorepeatfield();
        Map<Object, Set<String>> basemap = new HashMap<Object, Set<String>>();
        // 循环工作表Sheet
        int total = 0;

        for (int numSheet = 0; numSheet < hssfWorkbook.getNumberOfSheets(); numSheet++) {
            XSSFSheet hssfSheet = hssfWorkbook.getSheetAt(numSheet);

            if (hssfSheet == null) {
                continue;
            }

            int celcount = hssfSheet.getRow(0).getPhysicalNumberOfCells();

            // 循环行Row,总行数为最后行数加1,第1行为标题,数据从第2行开始
            for (int rowNum = 1; rowNum < hssfSheet.getLastRowNum() + 1; rowNum++) {
                XSSFRow hssfRow = hssfSheet.getRow(rowNum);

                if (hssfRow == null) {
                    continue;
                }

                // 循环列Cell,缺省值自动加上
                JSONObject json = new JSONObject();
                total++;
                boolean success = true;

                for (int celNum = 0; celNum < celcount; celNum++) {
                    int col = celNum + 1;
                    //明细列表按order排序
                    List<ModuleImpConfigDetBean> det1 = normalfields.stream().filter(s -> s.getIsorder() == col).collect(Collectors.toList());

                    if (!StringUtils.isEmpty(det1) && det1.size() > 0) {
                        ModuleImpConfigDetBean det = det1.get(0);
                        String colkey = det.getField();
                        String colname = det.getField_name();
                        XSSFCell cell = hssfRow.getCell(celNum);
                        Object cellValue = "";

                        if (!StringUtils.isEmpty(cell)) {
                            //判断字段类型是否正确，S-字符N-数字D-日期
                            try {
                                if (cell.getCellType() == HSSFCell.CELL_TYPE_BLANK) {
                                }
                                else if (cell.getCellType() == HSSFCell.CELL_TYPE_ERROR) {
                                    throw new Exception("格式错误");
                                }
                                else if (cell.getCellType() == HSSFCell.CELL_TYPE_FORMULA) {
                                    throw new Exception("为表达式");
                                }
                                else if (cell.getCellType() == HSSFCell.CELL_TYPE_STRING) {
                                    if ("S".equalsIgnoreCase(det.getField_datatype())) {
                                        cellValue = cell.getStringCellValue();
                                    }
                                    else if ("N".equalsIgnoreCase(det.getField_datatype())) {
                                        cellValue = new DecimalFormat("#.######").format(Double.parseDouble(cell.getStringCellValue()));
                                    }
                                    else if ("D".equalsIgnoreCase(det.getField_datatype())) {
                                        cellValue = DateUtils.parseDateStrictly(cell.getStringCellValue(), StringUtils.isEmpty(det.getFormat()) ? "yyyy-MM-dd" : det.getFormat());
                                    }
                                    else {
                                        throw new Exception("格式错误");
                                    }
                                }
                                else if (cell.getCellType() == HSSFCell.CELL_TYPE_NUMERIC) {
                                    if ("S".equalsIgnoreCase(det.getField_datatype())) {
                                        cellValue = new DecimalFormat("#").format(cell.getNumericCellValue());
                                    }
                                    else if ("N".equalsIgnoreCase(det.getField_datatype())) {
                                        cellValue = new DecimalFormat("#.######").format(cell.getNumericCellValue());
                                    }
                                    else if ("D".equalsIgnoreCase(det.getField_datatype())) {
                                        cellValue = DateUtils.formatDateByFormat(cell.getDateCellValue(), StringUtils.isEmpty(det.getFormat()) ? "yyyy-MM-dd" : det.getFormat());
                                    }
                                    else {
                                        throw new Exception("格式错误");
                                    }
                                }
                                else {
                                    cellValue = cell.getStringCellValue();
                                }
                            }
                            catch (Exception e) {
                                success = false;
                                handleErrMsg(session, config, ERRCODE.FormatError, "第" + json.get(config.getTiprowcol()) + "行字段" + colname + e.getMessage(), errlist);
                                break;
                            }
                        }

                        if ("Y".equals(det.getIsnonullfield()) && StringUtils.isEmpty(cellValue)) {
                            //记录错误导入日志
                            success = false;
                            handleErrMsg(session, config, ERRCODE.NotNull, "第" + json.get(config.getTiprowcol()) + "行字段" + colname + "非空", errlist);
                            break;
                        }

                        json.put(colkey, cellValue);
                    }
                }

                //单字段校验失败
                if (!success) {
                    continue;
                }

                //添加默认值
                for (ModuleImpConfigDetBean field : defaultfields) {
                    json.put(field.getField(), field.getDefaultvalue());
                }

                //判断unique重复
                if (!repeatVerify(json, uniquecols, "unique", basemap)) {
                    String uniquecolsname = getColNames(uniquecols, fields);
                    handleErrMsg(session, config, ERRCODE.NotRepeat, "第" + json.get(config.getTiprowcol()) + "行数据" + uniquecolsname + "重复", errlist);
                    continue;
                }

                //判断isnorepeatfield重复
                if (!repeatVerify(json, norepeatcols, "norepeat", basemap)) {
                    String norepeatcolsname = getColNames(norepeatcols, fields);
                    handleErrMsg(session, config, ERRCODE.NotRepeat, "第" + json.get(config.getTiprowcol()) + "行数据" + norepeatcolsname + "重复", errlist);
                    continue;
                }

                Object retdata = rcm.executeClassMethodForObjectJSON(srvname + ".importExcelSingle", session, param, json);
                JSONObject retjson = (JSONObject) retdata;

                if (!StringUtils.isEmpty(retjson) && !StringUtils.isEmpty(retjson.get("errcode")) && !"0".equals(retjson.get("errcode"))) {
                    handleErrMsg(session, config, retjson.get("errcode").toString(), "第" + json.get(config.getTiprowcol()) + "行数据" + retjson.get("errmsg"), errlist);
                    continue;
                }

                list.add(json);
            }
        }

        JSONObject json = genrateRtnJSON(session.getEnt_id(), config, list, errlist, total);
        return json;
    }

    public static String getColNames(String cols, List<ModuleImpConfigDetBean> list)
    {
        List<String> collist = Arrays.asList(cols.split(","));
        String colsname = "";

        for (String col : collist) {
            List<ModuleImpConfigDetBean> det = list.stream().filter(s -> s.getField().equals(col)).collect(Collectors.toList());

            if (!StringUtils.isEmpty(det) && det.size() > 0) {
                colsname += det.get(0).getField_name() + ",";
            }
        }

        if (!StringUtils.isEmpty(colsname)) {
            colsname = colsname.substring(0, colsname.length() - 1);
        }

        return colsname;
    }

    public static String getColValue(JSONObject json, String[] cols)
    {
        StringBuffer buf = new StringBuffer();

        for (String col : cols) {
            Object object = json.get(col);

            if (!StringUtils.isEmpty(object)) {
                buf.append(object).append("-");
            }
        }

        return buf.toString();
    }

    /**
     * 重复校验
     *
     * @param json
     * @param cols
     * @param key
     * @param basemap
     * @return
     */
    public static boolean repeatVerify(JSONObject json, String cols, String key, Map<Object, Set<String>> basemap)
    {
        if (!StringUtils.isEmpty(cols)) {
            String s = getColValue(json, cols.split(","));
            Set<String> list = basemap.get(key);

            if (StringUtils.isEmpty(list)) {
                list = new HashSet<String>();
            }

            if (!list.add(s)) {
                return false;
            }

            basemap.put(key, list);
        }

        return true;
    }


    /**
     * 提示导入总条数，成功总条数，失败总条数
     * 失败如允许部分提交，则返回当前失败日志序号，ui调服务展示错误日志
     * 失败不允许部分提交，则校验报错条数达到maxErrRow直接返回
     */
    public JSONObject genrateRtnJSON(long ent_id, ModuleImpConfigHeadBean config, List<Map<String, Object>> list, List<ImpErrMsgBean> errlist,
                                     int total) throws Exception
    {
        JSONObject json = new JSONObject();

        if ("Y".equals(config.getEsubmit())) {
            batchInsSrv.batchInsert(getStorageOperations(FMybatisTemplate.class), list, config.getTemptable(), 1000);
            String tips = "excel导入总条数" + total + ",成功条数" + list.size();

            if (!StringUtils.isEmpty(errlist) && errlist.size() > 0) {
                long errseqno = globrulesrv.getnext(ent_id, "imperrseqno", "", "");
                errlist.forEach((err) -> {
                    err.setSeqno(errseqno);
                });
                excelImpErrSrv.batchInsertImpErr(errlist);
                json.put("seqno", errseqno);
                tips = tips + ",失败条数" + errlist.size();
            }

            json.put("msg", tips);
        }
        else {
            String tips = "";

            if (!StringUtils.isEmpty(errlist) && errlist.size() > 0) {
                tips = "存在错误行校验，导入终止。";

                if (errlist.size() > maxErrRow) {
                    tips = tips + "错误行数达到校验出错最大行数" + maxErrRow;
                }

                String msg = errlist.stream().map(p -> p.getErrmsg()).collect(Collectors.joining(","));
                json.put("errmsg", msg);
            }
            else {
                batchInsSrv.batchInsert(getStorageOperations(FMybatisTemplate.class), list, config.getTemptable(), 1000);
                tips = "excel导入成功总条数" + total;
            }

            json.put("msg", tips);
        }

        return json;
    }

    public void handleErrMsg(ServiceSession session, ModuleImpConfigHeadBean config, String errcode, String errmsg, List<ImpErrMsgBean> errlist)
    {
        ImpErrMsgBean err = new ImpErrMsgBean();
        err.setPh_key(UniqueID.getUniqueID());
        err.setPh_timestamp(new Date());
        err.setEnt_id(session.getEnt_id());
        err.setOperuser(session.getUser_code());
        err.setEid(config.getEid());
        err.setModuleid(config.getModuleid());
        err.setErrcode(errcode);
        err.setErrmsg(errmsg);

        if ("Y".equals(config.getEsubmit())) {
            errlist.add(err);
        }
        else {
            if (!StringUtils.isEmpty(errlist) && errlist.size() > maxErrRow) {
                return;
            }

            errlist.add(err);
        }
    }

    public String export(SXSSFWorkbook sxssfWorkbook, ServiceSession session, JSONObject jsonparam) throws Exception
    {
        long startTime = System.currentTimeMillis();
        SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMdd");
        checkPara(session, jsonparam);
        getParamWithCheck(jsonparam, "moduleCode", true, "");
        getParamWithCheck(jsonparam, "queryid", true, "");
        //获取报表配置
        List<UiClass> exportcolconfig = getExportConfig(session, jsonparam);
        //生成标题样式
        CellStyle headStyle = headStyle(sxssfWorkbook);
        //生成明细样式
        List<CellStyle> detStyles = detailStyles(sxssfWorkbook, exportcolconfig);
        // 查询总条数,根据设置判断是否需要分sheet,一个sheet一个线程
        Map<String, Object> mapparam = new HashMap<String, Object>();
        mapparam.put("ent_id", session.getEnt_id());

        for (String key : jsonparam.keySet()) {
            mapparam.put(key, jsonparam.get(key));
        }

        String queryid = jsonparam.getString("queryid");
        ReportServiceImpl reportSrv = SpringBeanFactory.getContext().getBean(ReportServiceImpl.class);
        //多个sheet分批查询
        long count = reportSrv.count(queryid, mapparam);
        int sheets = (int) Math.ceil((double) count / maxWriteRowsSheet);

        ExecutorService sheetsThreadPool = Executors.newFixedThreadPool(1);
        //        ExecutorService sheetsThreadPool=Executors.newCachedThreadPool();
        //        sheetsThreadPool = TtlExecutors.getTtlExecutorService(sheetsThreadPool);

        for (int pageNo = 1; pageNo <= sheets; pageNo++) {
            if (pageNo * maxWriteRowsSheet > maxWriteRows) {
                break;
            }

            int startRows = (pageNo - 1) * this.maxWriteRowsSheet + 1;
            int endRows = pageNo * this.maxWriteRowsSheet;

            if (endRows > count) {
                endRows = (int) count;
            }

            Sheet sheet = sxssfWorkbook.createSheet("Sheet" + pageNo + "(" + startRows + "-" + endRows + "条)");

            //多线程创建sheet会异常（A part with the name ‘/xl/worksheets/sheet1.xml‘ already exists），sheet提前创建
            sheetsThreadPool.execute(new CreateSheetThread(sheet, exportcolconfig, headStyle, detStyles, queryid, mapparam, pageNo));
        }

        sheetsThreadPool.shutdown();

        //        while (true) {//等待所有任务都执行结束
        //            if (sheetsThreadPool.isTerminated()) {//所有的子线程都结束了
        //                System.out.println("共耗时:" + (System.currentTimeMillis() - startTime) / 1000.0 + "s");
        //                break;
        //            }
        //        }
        try {
            boolean isStop = sheetsThreadPool.awaitTermination(1, TimeUnit.SECONDS);
            System.out.println("is pool finished: " + isStop);
            System.out.println("共耗时:" + (System.currentTimeMillis() - startTime) / 1000.0 + "s");
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }

        String[] sheetnames = new String[sxssfWorkbook.getNumberOfSheets()];

        for (int i = 0; i < sxssfWorkbook.getNumberOfSheets(); i++) {
            sheetnames[i] = sxssfWorkbook.getSheetName(i);
        }

        Arrays.sort(sheetnames);

        for (int i = 0; i < sheetnames.length; i++) {
            sxssfWorkbook.setSheetOrder(sheetnames[i], i);
        }

        String filename = jsonparam.get("moduleCode") + "_" + sdf.format(new Date()) + "(合计" + count + "条)" + ".xlsx";
        return filename;
    }
    //报表导出根据uiclasss/uiproperty生成excel标题样式,标题格式每个单个格式一致，
    public CellStyle headStyle(SXSSFWorkbook sxssfWorkbook)
    {
        CellStyle headStyle = sxssfWorkbook.createCellStyle();
        headStyle.setBorderTop(HSSFCellStyle.BORDER_THIN);// 上边框
        headStyle.setBorderBottom(HSSFCellStyle.BORDER_THIN);// 下边框
        headStyle.setBorderLeft(HSSFCellStyle.BORDER_THIN);// 左边框
        headStyle.setBorderRight(HSSFCellStyle.BORDER_THIN);// 右边框
        headStyle.setAlignment(HSSFCellStyle.ALIGN_CENTER);//左右对齐
        headStyle.setVerticalAlignment(HSSFCellStyle.VERTICAL_CENTER);//上下对齐
        headStyle.setDataFormat(sxssfWorkbook.createDataFormat().getFormat("@"));
        headStyle.setWrapText(true);
        Font f = sxssfWorkbook.createFont();
        f.setFontHeightInPoints((short) 9);// 字号
        f.setBoldweight(HSSFFont.BOLDWEIGHT_BOLD);// BOLDWEIGHT_BOLD);// 加粗
        headStyle.setFont(f);
        return headStyle;
    }
    //报表导出根据uiclasss/uiproperty生成excel内容样式
    public List<CellStyle> detailStyles(SXSSFWorkbook sxssfWorkbook, List<UiClass> exportconfigs)
    {
        List<CellStyle> detailStyles = new ArrayList<CellStyle>();

        for (int cellnum = 0; cellnum < exportconfigs.size(); cellnum++) {
            CellStyle cellstyle = sxssfWorkbook.createCellStyle();
            cellStyle(sxssfWorkbook, cellstyle, exportconfigs.get(cellnum).getPropertys());
            detailStyles.add(cellstyle);
        }

        return detailStyles;
    }

    public void  cellStyle(SXSSFWorkbook sxssfWorkbook, CellStyle cellStyle, List<UiProperty> properties)
    {

        cellStyle.setBorderBottom(HSSFCellStyle.BORDER_THIN);// 下边框
        cellStyle.setBorderLeft(HSSFCellStyle.BORDER_THIN);// 左边框
        cellStyle.setBorderRight(HSSFCellStyle.BORDER_THIN);// 右边框
        cellStyle.setBorderTop(HSSFCellStyle.BORDER_THIN);// 上边框
        cellStyle.setVerticalAlignment(HSSFCellStyle.VERTICAL_CENTER);
        cellStyle.setDataFormat(sxssfWorkbook.createDataFormat().getFormat("@"));

        //根据配置中是否设置contentAlign显示左右对齐，未设置时默认左对齐
        if (properties.stream().anyMatch(o ->"contentAlign".equals(o.getPropertyName()))) {
            UiProperty uiProperty = properties.stream().filter(o->"contentAlign".equals(o.getPropertyName())).collect(Collectors.toList()).get(0);

            if ("center".equals(uiProperty.getPropertyValue())) {
                cellStyle.setAlignment(HSSFCellStyle.ALIGN_CENTER);
            }
            else if ("left".equals(uiProperty.getPropertyValue())) {
                cellStyle.setAlignment(HSSFCellStyle.ALIGN_LEFT);
            }
            else if ("right".equals(uiProperty.getPropertyValue())) {
                cellStyle.setAlignment(HSSFCellStyle.ALIGN_RIGHT);
            }
            else {
                cellStyle.setAlignment(HSSFCellStyle.ALIGN_LEFT);
            }
        }
        else {
            cellStyle.setAlignment(HSSFCellStyle.ALIGN_LEFT);
        }

        cellStyle.setWrapText(true);
    }

    /**
     * 获取导出配置，取布局配置中的查询Grid项的配置
     * 字段配了isExport以该属性确定是否导出，不配默认导出
     * 精灵默认取textName的值来返回
     * @param session
     * @param jsonparam
     * @return
     */
    public List<UiClass>  getExportConfig(ServiceSession session, JSONObject jsonparam)
    {
        JSONObject rtnjson = null;

        try {
            ServiceResponse resp = RestClientUtils.getRestUtils().sendRequest(session, "efuture.uiconfig.getUiConfig", jsonparam.toJSONString());

            if (ResponseCode.SUCCESS.equalsIgnoreCase(resp.getReturncode())) {
                rtnjson = (JSONObject) resp.getData();
            }
            else {
                throw new ServiceException(resp.getReturncode(), resp.getData().toString());
            }
        }
        catch (Exception e) {
            throw new ServiceException( "50000", "获取模块导出配置错误:[{0}]-[{1}]", jsonparam.get("moduleCode"), e.getMessage() );
        }

        List<UiClass> uiclass = JSON.parseArray(rtnjson.getString("uiclass"), UiClass.class);
        List<UiProperty> uiproperty = JSON.parseArray(rtnjson.getString("uiproperty"), UiProperty.class);
        //从uiclass中找出字段配置
        List<UiClass> uidetailconfig = uiclass.stream()
                                       .filter(o -> o.getItemCode().equals("gridConfig") && o.getItemClass() == 2)
                                       // 给每个一级分类加子分类
                                       .peek(o -> o.setChildrens(uiClassSrv.getChildCategoryList(o, uiclass)))
                                       // 排序
                                       .sorted(Comparator.comparingInt(UiClass::getSort))
                                       // 收集
                                       .collect(Collectors.toList());
        List<UiClass> details = uidetailconfig.get(0).getChildrens().get(0).getChildrens();
        List<UiClass> exportcolconfig = new ArrayList<UiClass>();

        //获取property是否导出
        for (UiClass ui : details) {
            ui.setPropertys(uiproperty.stream().filter(o ->o.getItemId().equals(ui.getItemId())).collect(Collectors.toList()));

            if (!ui.getPropertys().stream().anyMatch(o ->"isExport".equals(o.getPropertyName()) && "N".equals(o.getPropertyValue()))) {
                //精灵展示渲染之后的数据为textName配置的字段，导入时，直接取结果集中的该字段
                if (ui.getPropertys().stream().anyMatch(o ->"textName".equals(o.getPropertyName()))) {
                    UiProperty uiProperty = ui.getPropertys().stream().filter(o->"textName".equals(o.getPropertyName())).collect(Collectors.toList()).get(0);
                    ui.setItemCode(uiProperty.getPropertyValue());
                }

                exportcolconfig.add(ui);
            }
        }

        return exportcolconfig;
    }

    public void createSheet(Sheet sheet, List<UiClass> configs, CellStyle headStyle, List<CellStyle> detStyles, String queryid, Map<String, Object> mapparam, int pageNo) throws Exception
    {
        ReportServiceImpl reportSrv = SpringBeanFactory.getContext().getBean(ReportServiceImpl.class);
        Page page = PageHelper.startPage(pageNo, maxWriteRowsSheet, false);
        List<Map<String, Object>> list = reportSrv.doQuery(queryid, mapparam, null, null);

        if (!StringUtils.isEmpty(list) && list.size() > 0) {
            // 冻结第一行
            sheet.createFreezePane(0, 1);
            // 创建第一行,作为header表头
            Row header = sheet.createRow(0);        // 循环创建header单元格

            for (int cellnum = 0; cellnum < configs.size(); cellnum++) {
                Cell cell = header.createCell(cellnum);
                cell.setCellValue(configs.get(cellnum).getItemName());
                //设置head样式
                cell.setCellStyle(headStyle);
            }

            // 遍历创建行,导出数据
            for (int rownum = 0; rownum < list.size(); rownum++) {
                Row row = sheet.createRow(rownum + 1);
                Map<String, Object> map = list.get(rownum);

                // 循环创建单元格
                for (int cellnum = 0; cellnum < configs.size(); cellnum++) {
                    Cell cell = row.createCell(cellnum);
                    cell.setCellStyle(detStyles.get(cellnum));
                    setCellsValue(cell, configs.get(cellnum).getPropertys(), map.get(configs.get(cellnum).getItemCode()));
                }
            }

            //自适应每列列宽
            for (int cellnum = 0; cellnum < configs.size(); cellnum++) {
                sheet.autoSizeColumn((short)cellnum); //调整每列宽度
            }
        }
    }
    public Sheet createSheetNew(Sheet sheet, List<UiClass> configs, CellStyle headStyle, List<CellStyle> detStyles, String queryid, Map<String, Object> mapparam, int pageNo) throws Exception
    {
        ReportServiceImpl reportSrv = SpringBeanFactory.getContext().getBean(ReportServiceImpl.class);
        Page page = PageHelper.startPage(pageNo, maxWriteRowsSheet, false);
        List<Map<String, Object>> list = reportSrv.doQuery(queryid, mapparam, null, null);

        if (!StringUtils.isEmpty(list) && list.size() > 0) {
            // 冻结第一行
            sheet.createFreezePane(0, 1);
            // 创建第一行,作为header表头
            Row header = sheet.createRow(0);        // 循环创建header单元格

            for (int cellnum = 0; cellnum < configs.size(); cellnum++) {
                Cell cell = header.createCell(cellnum);
                cell.setCellValue(configs.get(cellnum).getItemName());
                //设置head样式
                cell.setCellStyle(headStyle);
            }

            // 遍历创建行,导出数据
            for (int rownum = 0; rownum < list.size(); rownum++) {
                Row row = sheet.createRow(rownum + 1);
                Map<String, Object> map = list.get(rownum);

                // 循环创建单元格
                for (int cellnum = 0; cellnum < configs.size(); cellnum++) {
                    Cell cell = row.createCell(cellnum);
                    cell.setCellStyle(detStyles.get(cellnum));
                    setCellsValue(cell, configs.get(cellnum).getPropertys(), map.get(configs.get(cellnum).getItemCode()));
                }
            }

            //自适应每列列宽
            for (int cellnum = 0; cellnum < configs.size(); cellnum++) {
                sheet.autoSizeColumn((short)cellnum); //调整每列宽度
            }
        }

        return sheet;
    }
    public void setCellsValue(Cell cell, List<UiProperty> properties, Object object)
    {
        if (!StringUtils.isEmpty(object)) {
            if (properties.stream().anyMatch(o ->"fieldType".equals(o.getPropertyName()))) {
                UiProperty uiProperty = properties.stream().filter(o->"fieldType".equals(o.getPropertyName())).collect(Collectors.toList()).get(0);

                //日期型,优先取format，没有format，date默认yyyy-MM-dd,datetime默认yyyy-MM-dd HH:mm:ss
                if (uiProperty.getPropertyValue().contains("D")) {

                    SimpleDateFormat sdf = null;
                    List<UiProperty> formats =  properties.stream().filter(o->"format".equals(o.getPropertyValue())).collect(Collectors.toList());

                    if (!StringUtils.isEmpty(formats) && formats.size() > 0) {
                        sdf = new SimpleDateFormat(formats.get(0).getPropertyValue());
                    }
                    else {
                        if ("date".equals(properties.stream().filter(o->"vtype".equals(o.getPropertyName())).collect(Collectors.toList()).get(0).getPropertyValue())) {
                            sdf = new SimpleDateFormat("yyyy-MM-dd");
                        }
                        else if ("datetime".equals(properties.stream().filter(o->"vtype".equals(o.getPropertyName())).collect(Collectors.toList()).get(0).getPropertyValue())) {
                            sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                        }
                        else {
                            sdf = new SimpleDateFormat("yyyy-MM-dd");
                        }
                    }

                    try {
                        Date date  = sdf.parse(object.toString());
                        cell.setCellValue(sdf.format(date));
                    }
                    catch (ParseException e) {
                        // TODO Auto-generated catch block
                        e.printStackTrace();
                    }

                }
                else if (uiProperty.getPropertyValue().contains("N")) {
                    List<UiProperty> formats =  properties.stream().filter(o->"format".equals(o.getPropertyName())).collect(Collectors.toList());

                    if (!StringUtils.isEmpty(formats) && formats.size() > 0) {
                        cell.setCellValue(numberFormat(formats.get(0).getPropertyValue(), Double.parseDouble(object.toString())));
                    }
                    else {
                        cell.setCellValue(object.toString());
                    }
                }
                else {
                    cell.setCellValue(object.toString());
                }

            }
            else {
                cell.setCellValue(object.toString());
            }
        }
    }
    public String numberFormat(String format, double object)
    {
        String pattern = null;

        if (format.startsWith("n")) {
            int length = Integer.parseInt(format.substring(1));
            pattern = "#";

            if (length > 0) {
                pattern += ".";

                for (int i = 0; i < length; i++) {
                    pattern += "#";
                }
            }
        }
        else if (format.startsWith("c")) {
            int length = Integer.parseInt(format.substring(1));
            pattern = "#,###";

            if (length > 0) {
                pattern += ".";

                for (int i = 0; i < length; i++) {
                    pattern += "#";
                }
            }
        }
        else if (format.startsWith("p")) {
            int length = Integer.parseInt(format.substring(1));
            pattern = "##";

            if (length > 0) {
                pattern += ".";

                for (int i = 0; i < length; i++) {
                    pattern += "0";
                }
            }

            pattern += "%";
        }

        DecimalFormat df = new DecimalFormat(pattern);
        return df.format(object);
    }
}
