package com.efuture.ocp.common.fileio;

import com.efuture.ocp.common.entity.AbstractEntityBean;
import org.springframework.data.mongodb.core.mapping.Document;

import javax.validation.constraints.Min;
import javax.validation.constraints.NotNull;
import java.util.Date;

@Document(collection = ("dataimportconfig"))
public class DataImportConfigBean extends AbstractEntityBean {
    private static final long serialVersionUID = -3558980514306062654L;
    static final String ID_KEY = "ph_key";
    @Min(value = 1)
    private long ph_key; // 物理主键
    private Date ph_timestamp; // 时间戳
    @NotNull
    private long ent_id;//企业ID

    private long seqno;                    //序号
    private String eid;                    //导入编号
    private String ename;                //中文简短描述
    private String temptable;            //来源表（非必需）
    private String impfields;            //导入(字段)格式
    private String impfields_name;        //导入(字段)格式中文描述
    private String impfields_datatype;    //导入(字段)格式数据类型
    private String uniquecolumn;        //
    private String nonullfields;        //不可为空列
    private String norepeatfields;        //不可重复列
    private String workservice;            //导入服务（非必需）
    private String multithread;            //多线程
    private String esubmit;                //提交方式（全部提交/部分提交）
    private String status;                //是否空闲
    private String isbilldet;            //是否单据
    private String billno;                //单据号
    private String moduleid;            //模块号
    private String defaultparam;        //默认参数
    private String defaultvalue;        //默认参数值


    public long getSeqno() {
        return seqno;
    }

    public void setSeqno(long seqno) {
        this.seqno = seqno;
    }

    public String getEid() {
        return eid;
    }

    public void setEid(String eid) {
        this.eid = eid;
    }

    public String getTemptable() {
        return temptable;
    }

    public void setTemptable(String temptable) {
        this.temptable = temptable;
    }

    public String getImpfields() {
        return impfields;
    }

    public void setImpfields(String impfields) {
        this.impfields = impfields;
    }

    public String getImpfields_name() {
        return impfields_name;
    }

    public void setImpfields_name(String impfields_name) {
        this.impfields_name = impfields_name;
    }

    public String getImpfields_datatype() {
        return impfields_datatype;
    }

    public void setImpfields_datatype(String impfields_datatype) {
        this.impfields_datatype = impfields_datatype;
    }

    public String getNonullfields() {
        return nonullfields;
    }

    public void setNonullfields(String nonullfields) {
        this.nonullfields = nonullfields;
    }

    public String getNorepeatfields() {
        return norepeatfields;
    }

    public void setNorepeatfields(String norepeatfields) {
        this.norepeatfields = norepeatfields;
    }

    public String getMultithread() {
        return multithread;
    }

    public void setMultithread(String multithread) {
        this.multithread = multithread;
    }

    public String getStatus() {
        return status;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public String getEname() {
        return ename;
    }

    public void setEname(String ename) {
        this.ename = ename;
    }

    public String getUniquecolumn() {
        return uniquecolumn;
    }

    public void setUniquecolumn(String uniquecolumn) {
        this.uniquecolumn = uniquecolumn;
    }

    public String getEsubmit() {
        return esubmit;
    }

    public void setEsubmit(String esubmit) {
        this.esubmit = esubmit;
    }

    public String getWorkservice() {
        return workservice;
    }

    public void setWorkservice(String workservice) {
        this.workservice = workservice;
    }

    public String getBillno() {
        return billno;
    }

    public void setBillno(String billno) {
        this.billno = billno;
    }

    public String getModuleid() {
        return moduleid;
    }

    public void setModuleid(String moduleid) {
        this.moduleid = moduleid;
    }

    public String getIsbilldet() {
        return isbilldet;
    }

    public void setIsbilldet(String isbilldet) {
        this.isbilldet = isbilldet;
    }

    public long getPh_key() {
        return ph_key;
    }

    public void setPh_key(long ph_key) {
        this.ph_key = ph_key;
    }

    public Date getPh_timestamp() {
        return ph_timestamp;
    }

    public void setPh_timestamp(Date ph_timestamp) {
        this.ph_timestamp = ph_timestamp;
    }

    public long getEnt_id() {
        return ent_id;
    }

    public void setEnt_id(long ent_id) {
        this.ent_id = ent_id;
    }


    public String getDefaultparam() {
        return defaultparam;
    }

    public void setDefaultparam(String defaultparam) {
        this.defaultparam = defaultparam;
    }

    public String getDefaultvalue() {
        return defaultvalue;
    }

    public void setDefaultvalue(String defaultvalue) {
        this.defaultvalue = defaultvalue;
    }

}
