package com.efuture.ocp.common.util;

import java.util.Map;

import com.efuture.ocp.common.exception.ServiceException;

public class BeanField implements Comparable
{

    int colID;
    String colType;
    String colName;
    java.lang.reflect.Field field;

    @Override
    public boolean equals(Object obj)
    {
        System.out.println( this + "---equals---" + obj );
        if (obj instanceof BeanField)
        {
            BeanField p = (BeanField) obj;
            return this.colName.equals( p.colName );
        }
        else
        {
            return false;
        }
    }

    @Override
    public int compareTo(Object o)
    {
        if (o instanceof BeanField)
        {
            BeanField p = (BeanField) o;
            if (this.colID > p.getColID())
            {
                return 1;
            }
            else
            {
                return -1;
            }
        }
        else
        {
            return 0;
        }
    }

    @Override
    public int hashCode()
    {
        return this.colName.hashCode();
    }

    @SuppressWarnings("rawtypes")
    public Object getColValue(Object bean) throws RuntimeException, IllegalAccessException
    {
        if (bean instanceof Map)
        {
            Map map = (Map) bean;
            return map.get( this.colName );
        }
        else if (field != null)
        {
            return field.get( bean );
        }
        else
        {
            throw new ServiceException( "5000", "获取列值错误" );
        }
    }

    public int getColID()
    {
        return colID;
    }

    public void setColID(int colID)
    {
        this.colID = colID;
    }

    public String getColType()
    {
        return colType;
    }

    public void setColType(String colType)
    {
        this.colType = colType;
    }

    public String getColName()
    {
        return colName;
    }

    public void setColName(String colName)
    {
        this.colName = colName;
    }

    public java.lang.reflect.Field getField()
    {
        return field;
    }

    public void setField(java.lang.reflect.Field field)
    {
        this.field = field;
    }


}
