package com.efuture.ocp.common.util;

import java.io.IOException;
import java.security.GeneralSecurityException;
import java.security.MessageDigest;

public class MD5Utils
{
    public final static String MD5(String s)
    {
        byte[] btInput = s.getBytes();
        
        return MD5(btInput);
    }

    /**
     * byte[]数组 MD5成字符串
     * 
     * @param btInput
     *            byte[]数组
     * @return 字符串
     */
    public final static String MD5(byte[] btInput)
    {
        char hexDigits[] =
        {
                '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'
        };
        
        try
        {
            MessageDigest mdInst = MessageDigest.getInstance("MD5");
            
            mdInst.update(btInput);
            byte[] md = mdInst.digest();
            int j = md.length;
            char str[] = new char[j * 2];
            int k = 0;
            for (int i = 0; i < j; i++)
            {
                byte byte0 = md[i];
                str[k++] = hexDigits[byte0 >>> 4 & 0xf];
                str[k++] = hexDigits[byte0 & 0xf];
            }
            return new String(str);
        }
        catch (Exception e)
        {
            e.printStackTrace();
            return null;
        }
    }
    
    public static byte[] encryptMD5(String data) throws IOException {
		return encryptMD5(data.getBytes("UTF-8"));
	}

	public static byte[] encryptMD5(byte[] data) throws IOException {
		byte[] bytes = null;
		try {
			MessageDigest md = MessageDigest.getInstance("MD5");
			bytes = md.digest(data);
		} catch (GeneralSecurityException gse) {
			throw new IOException(gse.toString());
		}
		return bytes;
	}

	public static String byte2hex(byte[] bytes) {
		StringBuilder sign = new StringBuilder();
		for (int i = 0; i < bytes.length; i++) {
			String hex = Integer.toHexString(bytes[i] & 0xFF);
			if (hex.length() == 1) {
				sign.append("0");
			}
			sign.append(hex.toUpperCase());
		}
		return sign.toString();
	}

    public static String MD5(String content, String salt) throws Exception {
        if (salt != null && salt.length() > 0) {
            content = content + "{" + salt + "}";
        }

        return MD5(content);
    }

    public static String MD5(String content, String salt, Integer times) throws Exception {
        if (content != null && content.length() != 0) {
            if (times == null) {
                return MD5(content, salt);
            } else {
                String sign = content;

                for(int i = 0; i < times; ++i) {
                    sign = MD5(sign, salt);
                }

                return sign;
            }
        } else {
            return null;
        }
    }
}
