package com.efuture.ocp.common.component;

import com.efuture.ocp.common.util.DataUtils;
import org.springframework.data.annotation.Transient;
import org.springframework.util.StringUtils;

import java.io.Serializable;
import java.util.Date;
import java.util.Map;

public class GlobRuleBean implements Serializable
{
    String ph_key;//bigint(20) not null comment '物理主键',
    Date ph_timestamp;//datetime not null comment '时间戳',
    long ent_id;//bigint(20) not null comment '企业代码',
    String ruleid;//varchar(20) not null comment '编码规则代码',
    String rulename;//varchar(20) not null comment '编码规则名称',
    String ruleislen;//varchar(1) not null comment '是否定长',
    int rulemaxlen;//int(11) not null comment '最大长度',
    int rulesyslen;//int(11) not null comment '定义长度',
    String rulemode;//varchar(1) not null comment '模式 0-手工输入  1-自动生成',
    String ruleisrule;//varchar(1) not null comment '是否有规则',
    int rulemaxcls;//int(11) not null comment '最大级次',
    String ruledef;//varchar(60) not null comment '当前规则(多级规则用-分割)',
    String ruletypecol;//varchar(60) null default null comment '类型字段(用逗号分隔)',
    String ruletable;//varchar(60) null default null comment '对应表名',
    String rulecol;//varchar(60) null default null comment '对应字典',
    String rulestatus;//varchar(1) not null comment '状态',
    String rulememo;//varchar(60) null default null comment '备注',


    // input param
    @Transient
    String preStr;
    @Transient
    String levelStr;
    @Transient
    Map<String, Object> fields;

    public String getPreStr() {
        return preStr;
    }

    public void setPreStr(String preStr) {
        this.preStr = preStr;
    }

    public String getLevelStr() {
        return levelStr;
    }

    public void setLevelStr(String levelStr) {
        this.levelStr = levelStr;
    }

    public Map<String, Object> getFields() {
        return fields;
    }

    public void setFields(Map<String, Object> fields) {
        this.fields = fields;
    }

    //return value
    @Transient
    String ruleCodeStr; //返回的规则编码
    @Transient
    String ruleTypeDay; //返回的日期字段值
    @Transient
    String ruleTypeStr; //返回的编码类别

    public String getRuleTypeStr() {
        return ruleTypeStr;
    }

    public void setRuleTypeStr(String ruleTypeStr) {
        this.ruleTypeStr = ruleTypeStr;
    }

    public String getRuleCodeStr() {
        return ruleCodeStr;
    }

    public void setRuleCodeStr(String ruleCodeStr) {
        this.ruleCodeStr = ruleCodeStr;
    }

    public String getRuleTypeDay() {
        return ruleTypeDay;
    }

    public void setRuleTypeDay(String ruleTypeDay) {
        this.ruleTypeDay = ruleTypeDay;
    }

    public String getPh_key() {
        return ph_key;
    }

    public void setPh_key(String ph_key) {
        this.ph_key = ph_key;
    }

    public Date getPh_timestamp() {
        return ph_timestamp;
    }

    public void setPh_timestamp(Date ph_timestamp) {
        this.ph_timestamp = ph_timestamp;
    }

    public long getEnt_id() {
        return ent_id;
    }

    public void setEnt_id(long ent_id) {
        this.ent_id = ent_id;
    }

    public String getRuleid() {
        return ruleid;
    }

    public void setRuleid(String ruleid) {
        this.ruleid = ruleid;
    }

    public String getRulename() {
        return rulename;
    }

    public void setRulename(String rulename) {
        this.rulename = rulename;
    }

    public String getRuleislen() {
        return ruleislen;
    }

    public void setRuleislen(String ruleislen) {
        this.ruleislen = ruleislen;
    }

    public int getRulemaxlen() {
        return rulemaxlen;
    }

    public void setRulemaxlen(int rulemaxlen) {
        this.rulemaxlen = rulemaxlen;
    }

    public int getRulesyslen() {
        return rulesyslen;
    }

    public void setRulesyslen(int rulesyslen) {
        this.rulesyslen = rulesyslen;
    }

    public String getRulemode() {
        return rulemode;
    }

    public void setRulemode(String rulemode) {
        this.rulemode = rulemode;
    }

    public String getRuleisrule() {
        if(StringUtils.isEmpty(ruleisrule)){
            return "Y";
        }
        else
        {
            return ruleisrule;
        }

    }


    public void setRuleisrule(String ruleisrule) {
        this.ruleisrule = ruleisrule;
    }

    public int getRulemaxcls() {
        return rulemaxcls;
    }

    public void setRulemaxcls(int rulemaxcls) {
        this.rulemaxcls = rulemaxcls;
    }

    public String getRuledef() {
        return ruledef;
    }

    public void setRuledef(String ruledef) {
        this.ruledef = ruledef;
    }

    public String getRuletypecol() {
        return ruletypecol;
    }

    public void setRuletypecol(String ruletypecol) {
        this.ruletypecol = ruletypecol;
    }

    public String getRuletable() {
        return ruletable;
    }

    public void setRuletable(String ruletable) {
        this.ruletable = ruletable;
    }

    public String getRulecol() {
        return rulecol;
    }

    public void setRulecol(String rulecol) {
        this.rulecol = rulecol;
    }

    public String getRulestatus() {
        return rulestatus;
    }

    public void setRulestatus(String rulestatus) {
        this.rulestatus = rulestatus;
    }

    public String getRulememo() {
        return rulememo;
    }

    public void setRulememo(String rulememo) {
        this.rulememo = rulememo;
    }

    @Override
    public String toString()
    {
        try
        {
            return DataUtils.parseJSONObject( this ).toJSONString();
        }
        catch (Exception ex)
        {
            return super.toString();
        }
    }

}
