package com.efuture.ocp.common.restclientext;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.efuture.ocp.common.annotation.AutoCache;
import com.efuture.ocp.common.entity.ServiceResponse;
import com.efuture.ocp.common.entity.ServiceSession;
import com.efuture.ocp.common.exception.ServiceException;
import com.efuture.ocp.common.language.ResponseCode;
import com.efuture.ocp.common.rest.ServiceVersion;
import com.efuture.ocp.common.util.DataUtils;
import com.efuture.ocp.common.util.HttpUtils;
import com.efuture.ocp.common.util.MD5Utils;
import com.efuture.ocp.common.util.RestClientUtils;

import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Component;
import org.springframework.util.StringUtils;

import java.util.HashMap;
import java.util.Map;
@Lazy(true)
@Component("RestClientUtils_OCMVX")
public class RestClientUtils_OCMVX extends RestClientUtils
{

    /*
    *  VX API 网关，需要定义的参数
     *  vxAuthUrl   获取token的URL
     *  vxAppKey    签名用户
     *  vxSecret    签名密码
    * */
    @Override
    public Map<String, Object> doOverWrite(Object session, String method, String url, Object param) throws Exception
    {
        if (!method.startsWith("http")) {
            return super.doOverWrite(session, method, url, param);
        }
        else {
            long entId = 0L;

            if (session != null && session instanceof ServiceSession) {
                entId = ((ServiceSession) session).getEnt_id();
            }
            else if (session != null && session instanceof Long) {
                entId = (Long) session;
            }
            else {
                throw new ServiceException( ResponseCode.EXCEPTION, "未传入企业编号");
            }

            String token = getVXToken(entId);
            String signStr = ent.getSrvConfig("vxAppKey", true) + "=" + ent.getSrvConfig("vxSecret", true) + "&body=" + param.toString();
            String sign = MD5Utils.MD5(signStr);
            url = url.concat("&app_key=").concat(ent.getSrvConfig("vxAppKey", true))
                  .concat("&token=").concat(token)
                  .concat("&sign=").concat(sign);
            // 重写返回
            Map<String, Object> map = new HashMap<String, Object>();
            map.put("method", method);
            map.put("url", url);
            map.put("param", param);
            return map;
        }
    }

    @AutoCache(Service = "HGO", KeyArgIndex = 0)
    public String getVXToken(long ent_id) throws Exception
    {
        String token_Url = ent.getSrvConfig("vxAuthUrl", true);
        JSONObject result = JSONObject.parseObject( HttpUtils.getRequest(token_Url));
        return DataUtils.getJsonData(result, "apiToken", true, "");
    }

    @Override
    public ServiceResponse sendRequest(Object session, String method, Object param) throws Exception
    {
        return sendRequest(session, method, param, "");
    }

    @Override
    public ServiceResponse sendRequest(Object session, String method, Object param, String traceprex) throws Exception
    {
        String url;
        ServiceSession ss = null;

        if (session instanceof ServiceSession) {
            ss = (ServiceSession) session;
        }

        // 根据method找到URL
        if (method.toLowerCase().startsWith("http")) {
            url = method;
        }
        else {
            url = queryServiceURI(ss.getEnt_id(), method);

            if (org.springframework.util.StringUtils.isEmpty(url)) {
                throw new Exception("can't find method service url:" + method);
            }
        }

        Map<String, Object> map = doOverWrite(session, method, url, param);
        url = map.get("url").toString();
        param = map.get("param");
        Object result = RestClientUtils.getRestUtils().sendRequest(session, url, param,
                        new RestClientUtils.defaultRequestCallback(), traceprex);
        ServiceResponse response = null;

        if (result != null) {
            JSONObject json;

            try {
                json = JSON.parseObject((String) result);
            }
            catch (Exception ex) {
                json = new JSONObject();
                json.put("returncode", ResponseCode.EXCEPTION);
                json.put("data", result);
            }

            response = JSON.toJavaObject(json, ServiceResponse.class);
        }

        if (response == null) {
            throw new ServiceException(ResponseCode.EXCEPTION, (String) result);
        }

        return response;
    }

    //    @Override
    //    public ServiceResponse sendRequest(Object session, String method, Object param, String traceprex) throws Exception {
    //        Object result = sendRequest(session, method, param,
    //                new RestClientUtils.defaultRequestCallback(), traceprex);
    //        ServiceResponse response = null;
    //        if (result != null) {
    //
    //            JSONObject json = null;
    //            try {
    //                json = JSON.parseObject((String) result);
    //            }
    //            catch (Exception ex)
    //            {
    //                json = new JSONObject();
    //                json.put("returncode", ResponseCode.EXCEPTION);
    //                json.put("data", (String) result);
    //            }
    //
    //            response = JSON.toJavaObject(json, ServiceResponse.class);
    //            if (ServiceVersion.getInstance().isLogstatus() && !StringUtils.isEmpty(traceprex)) {
    //                StringBuffer sb = new StringBuffer();
    //                sb.append("[" + traceprex + "]: ");
    //                sb.append(method + " , ");
    //                sb.append("RESPONSE: " + json.toJSONString());
    //                logger.info(sb.toString());
    //            }
    //        }
    //        if (response == null)
    //            throw new ServiceException( ResponseCode.EXCEPTION, (String) result);
    //
    //        if (!"0".equals(response.getReturncode()))
    //            throw new ServiceException(response.getReturncode(), response.getData().toString());
    //        else {
    //            return response;
    //        }
    //    }

}
