/**
 * Copyright (C), 2007-2014, eFuture 北京富基融通科技有限公司
 * FileName:	CacheUtilsMemcached.java
 * Author:		亮
 * Date:		2014-9-16 下午4:50:31
 * Description:
 * History:
 * <author>		<time>			<version>		<description>
 *
 */
package com.efuture.ocp.common.cache;

import com.efuture.ocp.common.SerializeUtil.SerializeUtil;
import com.efuture.ocp.common.util.Utils;
import com.efuture.ocp.common.util.WebPathUtils;
import org.apache.log4j.Logger;
import org.springframework.util.StringUtils;
import redis.clients.jedis.HostAndPort;
import redis.clients.jedis.JedisCluster;
import redis.clients.jedis.JedisPoolConfig;
import redis.clients.jedis.Protocol;

import java.io.*;
import java.util.LinkedHashSet;
import java.util.Properties;


/**
 * @author 亮
 * @description
 *
 */

public class CacheUtilsRedisCluster extends CacheUtilsRediscached implements Serializable
{
    private JedisCluster jedispool;
    private String cfgFile = null;
    private int cachetime = -1;
    public Logger logger = Logger.getLogger(CacheUtilsRedisCluster.class);

    public CacheUtilsRedisCluster()
    {
        this(null);
    }

    public CacheUtilsRedisCluster(String config)
    {
        this(config, -1);
    }

    public CacheUtilsRedisCluster(String config, int cachetime)
    {
        this.cfgFile = config;
        this.cachetime = cachetime;
    }

    private JedisCluster getJedis()
    {
        try {
            if (jedispool == null) {
                try {
                    jedispool = CreateJedisPool();
                }
                catch (FileNotFoundException e) {
                    e.printStackTrace();
                    return null;
                }
                catch (IOException e) {
                    e.printStackTrace();
                    return null;
                }
            }

            return jedispool;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return null;
        }
    }
    /**
     *  返回释放Jedis
     * @param jedis
     */
    private void returnJedis(JedisCluster jedis)
    {
        if (jedis != null) {
            jedis.close();
        }
    }
    @Override
    public String putData(String key, Object object, int timeout)
    {
        JedisCluster jedis = getJedis();

        if (jedis == null) {
            return null;
        }

        // set
        try {
            if (timeout < 0) {
                timeout = (cachetime > 0 ? cachetime : 0);
            }

            // jedis.set(key.getBytes(),SerializeUtil.serialize(object));
            jedis.setex(key.getBytes(), timeout, SerializeUtil.serialize(object));
            return key;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
        finally {
            returnJedis(jedis);
        }
    }

    /**
     * 缓存取值
     *
     * @param key
     *            键值
     * @return
     */
    @Override
    public Object getData(String key)
    {
        JedisCluster jedis = getJedis();

        if (jedis == null) {
            return null;
        }

        // get
        Object result = null;

        try {
            byte[] obj = jedis.get((key).getBytes());
            result = SerializeUtil.unserialize(obj);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            returnJedis(jedis);
        }

        return result;
    }

    /**
     * 缓存删除
     *
     * @param key
     *            键值
     */
    @Override
    public boolean deleteData(String key)
    {
        JedisCluster jedis = getJedis();

        if (jedis == null) {
            return false;
        }

        // delete
        try {
            jedis.del(key);
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
        finally {
            returnJedis(jedis);
        }

        return true;
    }

    /**
     * 创建redis缓存客户端
     *
     * @return Memcached客户端对象
     * @throws FileNotFoundException
     * @throws IOException
     */
    private synchronized JedisCluster CreateJedisPool() throws FileNotFoundException, IOException
    {
        if (jedispool != null) {
            return jedispool;
        }

        if (this.config != null) {
            logger.info("Redis client is creating with configuration.");
            JedisPoolConfig poolConfig = new JedisPoolConfig();
            poolConfig.setTestOnBorrow(this.config.isRedisTestOnBorrow());
            poolConfig.setMaxTotal(this.config.getRedisMaxActive());
            poolConfig.setMaxIdle(this.config.getRedisMaxIdle());
            poolConfig.setMinIdle(this.config.getRedisMinIdle());
            poolConfig.setMaxWaitMillis(this.config.getRedisMaxWait());
            LinkedHashSet<HostAndPort> node_set = new LinkedHashSet<HostAndPort>();
            String[] str_nodes = this.config.getRedisNodes().split( "," );

            for (String str : str_nodes) {
                String l_host = str.split( ":" )[0];
                int l_port = Integer.valueOf( str.split( ":" )[1] );
                node_set.add( new HostAndPort( l_host, l_port ) );
            }

            //jedispool = new JedisCluster(node_set, timeout, 0, 0, password, config);
            jedispool = new JedisCluster( node_set, this.config.getRedisTimeout(), 0, 0, this.config.getRedisPassword(), poolConfig );
        }
        else {
            // 取redis.ini中的redis服务器配置
            String ini = null, ini0 = null;

            if (StringUtils.isEmpty( cfgFile )) {
                String p = WebPathUtils.getWebRootClassPath();
                ini = p + "/redisCluster.ini"; // （原来的）
                ini0 = p + "/conf/redisCluster.ini";
                // *****************解决有的配置文件存储在/WEB-INF/classes/conf 下***********//
            }
            else {
                if (cfgFile.startsWith( "\\" ) || cfgFile.startsWith( "/" )) {
                    String p = WebPathUtils.getWebRootClassPath();
                    ini = p + cfgFile;
                    ini0 = p + "/conf" + cfgFile;
                }
                else {
                    ini = cfgFile;
                }
            }

            int maxActive = 100;
            int timeout = 5000;
            int maxIdle = 30;
            int minIdle = 10;
            boolean testOnBorrow = true;
            String nodes = "";
            String host = "localhost";
            int port = 6379;
            int database = Protocol.DEFAULT_DATABASE;
            int maxWait = 5000;
            File input = new File( ini );

            // 如果classes目录下没有查找classes/conf目录
            if (ini0 != null && !input.exists()) {
                input = new File( ini0 );
            }

            logger.info( "redisCluster.ini path:" + ini );

            if (input.exists()) {
                InputStream is = new FileInputStream( input );
                Properties p = new Properties();
                p.load( is );
                is.close();
                String sNodes = Utils.getEnvValue( p.getProperty( "redis.nodes" ) );

                if (sNodes != null) {
                    nodes = sNodes.trim();
                }

                String sServer = Utils.getEnvValue( p.getProperty( "redis.host" ) );

                if (sServer != null) {
                    host = sServer.trim();
                }

                String smaxActive = p.getProperty( "redis.maxActive" );

                if (smaxActive != null) {
                    maxActive = Integer.parseInt( smaxActive );
                }

                String stimeout = p.getProperty( "redis.timeout" );

                if (stimeout != null) {
                    timeout = Integer.parseInt( stimeout );
                }

                String smaxIdle = p.getProperty( "redis.maxIdle" );

                if (smaxIdle != null) {
                    maxIdle = Integer.parseInt( smaxIdle );
                }

                String sminIdle = p.getProperty( "redis.minIdle" );

                if (sminIdle != null) {
                    minIdle = Integer.parseInt( sminIdle );
                }

                String stestOnBorrow = p.getProperty( "redis.testOnBorrow" );

                if (stestOnBorrow != null) {
                    testOnBorrow = ((stestOnBorrow != null && stestOnBorrow.equalsIgnoreCase( "false" )) ? false : true);
                }

                String sport = Utils.getEnvValue( p.getProperty( "redis.port" ) );

                if (sport != null) {
                    port = Integer.parseInt( sport );
                }

                String smaxWait = p.getProperty( "redis.maxWait" );

                if (smaxWait != null) {
                    maxWait = Integer.parseInt( smaxWait );
                }

                String password_prop = p.getProperty( "redis.password" );
                String password = Utils.getEnvValue( password_prop );

                if (password != null) {
                    password = password.trim();
                }

                String sdatabase = Utils.getEnvValue( p.getProperty( "redis.database" ) );

                if (sdatabase != null) {
                    database = Integer.parseInt( sdatabase );
                }

                //logger.info("rediscached server:" + host + ":" +sport + "(" + sdatabase + "):" + Utils.nvl(password_prop, "N/A") + "/" + Utils.nvl(password,"N/A"));
                logger.info( "rediscached server:" + sNodes );
                JedisPoolConfig config = new JedisPoolConfig();
                config.setTestOnBorrow( true );
                config.setMaxTotal( maxActive );
                config.setMaxIdle( maxIdle );
                config.setMinIdle( minIdle );
                config.setMaxWaitMillis( maxWait );
                LinkedHashSet<HostAndPort> node_set = new LinkedHashSet<HostAndPort>();
                String[] str_nodes = nodes.split( "," );

                for (String str : str_nodes) {
                    String l_host = str.split( ":" )[0];
                    int l_port = Integer.valueOf( str.split( ":" )[1] );
                    node_set.add( new HostAndPort( l_host, l_port ) );
                }

                //jedispool = new JedisCluster(node_set, timeout, 0, 0, password, config);
                jedispool = new JedisCluster( node_set, timeout, 0, 0, null, config );
            }
            else {
                logger.warn( "redis.ini not exits!" );
                JedisPoolConfig config = new JedisPoolConfig();
                config.setTestOnBorrow( true );
                config.setMaxTotal( maxActive );
                config.setMaxIdle( maxIdle );
                config.setMinIdle( minIdle );
                config.setMaxWaitMillis( maxWait );
                HostAndPort node = new HostAndPort( host, port );
                jedispool = new JedisCluster( node, config );
                System.out.println( "rediscached server-地址:" + "localhost:" + port );
            }
        }

        return jedispool;
    }




}
