package com.efuture.ocp.common.component;

import com.alibaba.fastjson.JSONObject;
import com.efuture.ocp.common.annotation.AutoCache;
import com.efuture.ocp.common.entity.AccessLimitBean;
import com.efuture.ocp.common.entity.ServiceResponse;
import com.efuture.ocp.common.entity.ServiceSession;
import com.efuture.ocp.common.util.CacheUtils;
import com.efuture.ocp.common.util.DataUtils;
import com.efuture.ocp.common.util.SpringBeanFactory;
import com.efuture.omd.storage.FStorageOperations;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.stereotype.Component;

@Component(value = "globalconfig")
public class GlobalConfig extends BasicComponent
{
    private final String GlobalSOP = "GlobalStorageOperation";

    public static GlobalConfig getInstance()
    {
        return SpringBeanFactory.getContext().getBean( GlobalConfig.class );
    }

    @Override
    public FStorageOperations getStorageOperations()
    {
        if (SpringBeanFactory.containsBean( GlobalSOP )) {
            return SpringBeanFactory.getBean( GlobalSOP, FStorageOperations.class );
        }
        else {
            return super.getStorageOperations();
        }
    }

    @AutoCache(Service = "OCP", KeyArgIndex = 1, CacheLevel = CacheUtils.CacheLevel.Memory, TimeOut = CacheUtils.CacheTimeOut.Hour * 6)
    public AccessLimitBean getAndSetAccessLimit(long ent_id, String limitkey, int mode, int time, int maxLimit) throws Exception
    {
        try {
            FStorageOperations storage = getStorageOperations();
            Query query = new Query( Criteria.where("ent_id").is(ent_id).and("limitkey").is(limitkey ) );
            AccessLimitBean limitBean = storage.selectOne( query, AccessLimitBean.class );

            if (limitBean == null) {
                limitBean = new AccessLimitBean();
                limitBean.setEnt_id( ent_id );
                limitBean.setLimitKey(limitkey);
                limitBean.setLimitMode(mode);
                limitBean.setPermitsPerSecond(maxLimit);
                limitBean.setWarmUpPeriod(time);
                limitBean.setTcrd( System.currentTimeMillis() / 1000 );
                limitBean.setTmdd( System.currentTimeMillis() / 1000 );
                storage.insert( limitBean );
            }

            return limitBean;
        }
        catch (Exception ex) {
            return null;
        }
    }

    public ServiceResponse flush(ServiceSession session, JSONObject jsonparam) throws Exception
    {
        String key = DataUtils.getJsonData(jsonparam, "key", false, "OCP:GlobalConfig");
        return ServiceResponse.buildSuccess(CacheUtils.getInMemUtils().deleteBatch(key));
    }

}
