package com.efuture.ocp.common.datasync;

import com.alibaba.fastjson.JSONObject;
import com.efuture.ocp.common.component.BasicComponent;
import com.efuture.ocp.common.entity.ServiceResponse;
import com.efuture.ocp.common.entity.ServiceSession;
import com.efuture.ocp.common.exception.ServiceException;
import com.efuture.ocp.common.language.ResponseCode;
import com.efuture.ocp.common.util.DataUtils;
import org.springframework.util.StringUtils;

import java.util.List;
import java.util.Map;

/*
  数据同步基类：适用于Model的ModelSync处理对象
  输入参数：
        mastertable : 主表
        store       : 可选分门店
        tmdd        : datatmdd > tmdd
        maxtmdd     : datatmdd <= maxtmdd
        billid      : 可选自定义参数
        page_no     : 主表分页参数
        page_size   : 主表分页参数
        sub_pageno  : 可选子表分页（metadata中返回next_page=Y）
        sub_pagesize: 可选子表分页（metadata中返回next_page=Y）
  输出参数：
        tablename : List<Map>
        metadata  :
            tableName : keyCol
            next_page : 子表有分页返回Y，默认N
            slice     : 分片信息（默认null）

* */
public abstract class DataSyncBaseService extends BasicComponent
{

    public DataSyncPara initPara(long ent_id, JSONObject jsonparam) throws Exception
    {
        DataSyncPara para = JSONObject.parseObject( jsonparam.toJSONString(), DataSyncPara.class );
        para.setEnt_id( ent_id );
        // CheckValid
        DataUtils.checkNull(para.getMastertable(), "mastertable");
        DataUtils.checkNull(para.getTmdd(), "tmdd");
        DataUtils.checkNull(para.getMaxtmdd(), "maxtmdd");
        para.setPage_no( DataUtils.nvl( para.getPage_no(), 1 ) );
        para.setPage_size( DataUtils.nvl( para.getPage_size(), 50 ) );
        para.setSub_pageno( DataUtils.nvl( para.getSub_pageno(), 1 ) );
        para.setSub_pagesize( DataUtils.nvl( para.getSub_pagesize(), 10000 ) );
        return para;
    }

    public ServiceResponse getlist(ServiceSession session, JSONObject jsonparam) throws Exception
    {
        try {
            this.checkPara( session, jsonparam );
            DataSyncPara para = initPara( session.getEnt_id(), jsonparam );
            JSONObject result = new JSONObject();
            JSONObject metadata = new JSONObject();
            result.put( para.getMastertable(), getDataList( para, para.getMastertable() ) );
            metadata.put( para.getMastertable(), getKeyCols( para, para.getMastertable() ) );

            if (!StringUtils.isEmpty( para.getSub_table() )) {
                String[] sub_Tables = para.getSub_table().split( "," );

                for (String sub_tab : sub_Tables) {
                    result.put( sub_tab, getDataList( para, sub_tab ) );
                    metadata.put( sub_tab, getKeyCols( para, sub_tab ) );
                }
            }

            result.put( "metadata", metadata );
            return ServiceResponse.buildSuccess( result );
        }
        catch (Exception ex) {
            if (ex instanceof ServiceException) {
                throw ex;
            }
            else {
                throw new ServiceException( ResponseCode.EXCEPTION, ex.getMessage() );
            }
        }
    }

    // 需子类重载实现
    public abstract  List<Map<String, Object>> getDataList(DataSyncPara para, String tableName) throws Exception;

    // 需子类重载实现
    public abstract String getKeyCols(DataSyncPara para, String tableName) throws Exception;

}
