package com.efuture.ocp.common.rest;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.efuture.ocp.common.billservice.FileServiceImpl;
import com.efuture.ocp.common.cache.CacheUtils;
import com.efuture.ocp.common.component.excel.ExcelComponent;
import com.efuture.ocp.common.entity.*;
import com.efuture.ocp.common.exception.ServiceException;
import com.efuture.ocp.common.language.MessageUtils;
import com.efuture.ocp.common.language.ResponseCode;
import com.efuture.ocp.common.proxy.EnterpriseProxy;
import com.efuture.ocp.common.rest.taobao.CheckResult;
import com.efuture.ocp.common.rest.taobao.TaobaoResponse;
import com.efuture.ocp.common.rest.taobao.TaobaoSession;
import com.efuture.ocp.common.rest.taobao.SpiUtils;
import com.efuture.ocp.common.rest.userinterface.InitSession;
import com.efuture.ocp.common.user.UserDataRangeSrv;
import com.efuture.ocp.common.util.*;
import com.efuture.ocp.user.UserTokenInfo;
import com.sun.jersey.api.core.HttpContext;
import com.sun.jersey.api.representation.Form;
import com.sun.jersey.multipart.FormDataBodyPart;
import com.sun.jersey.multipart.FormDataMultiPart;
import org.apache.commons.configuration.beanutils.BeanHelper;
import org.apache.commons.io.IOUtils;
import org.apache.poi.xssf.streaming.SXSSFWorkbook;
import org.dom4j.bean.BeanAttribute;
import org.dom4j.bean.BeanAttributeList;
import org.springframework.cglib.beans.BeanMap;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;

import javax.imageio.ImageIO;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.ws.rs.*;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.Response.ResponseBuilder;
import java.awt.image.BufferedImage;
import java.io.*;
import java.lang.management.ManagementFactory;
import java.lang.management.RuntimeMXBean;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.text.SimpleDateFormat;
import java.util.*;

@Path("/")
public class ServiceRestReflect
{
    @Context
    HttpServletRequest request;
    @Context
    HttpServletResponse response;

    private static ServiceMethodReflect rcm = new ServiceMethodReflect();
    private static final ThreadLocal<ServiceSession> locale = new ThreadLocal<ServiceSession>();

    public static ThreadLocal<ServiceSession> getLocale()
    {
        if (locale == null || locale.get() == null) {
            locale.set(new ServiceSession());
        }

        return locale;
    }

    public static void pushlocale(ServiceSession session)
    {
        locale.set(session);
    }

    public static void removeLocale(ServiceSession session)
    {
        if (session != null && !StringUtils.isEmpty(session.getMethod()) && session.getStarttime() > 0) {
            ServiceVersion.getInstance().writeElapsed(session.getMethod(), System.currentTimeMillis() - session.getStarttime());
        }

        locale.remove();
    }

    @GET
    @Produces("text/html;charset=UTF-8")
    @Path("/")
    public String test(@QueryParam("status") String status)
    {
        String uri = request.getRequestURI();

        if (uri.startsWith("/") || uri.startsWith("\\")) {
            uri = uri.substring(1);
        }

        if (uri.endsWith("/") || uri.endsWith("\\")) {
            uri = uri.substring(0, uri.length() - 1);
        }

        if ("check".equalsIgnoreCase(status)) {
            return uri + " success";
        }
        else if ("info".equalsIgnoreCase(status)) {
            JSONObject json = new JSONObject();
            RuntimeMXBean run = ManagementFactory.getRuntimeMXBean();
            json.put("pid", run.getName().split("@")[0]);
            json.put("server", run.getName().split("@")[1]);
            json.put("startTime", new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(run.getStartTime()));
            return json.toJSONString();
        }
        else if ("statis".equalsIgnoreCase(status)) {
            try {
                return ServiceVersion.getInstance().printElapsed();
            }
            catch (Exception e) {
                return e.getMessage();
            }
        }
        else if ("clear".equalsIgnoreCase(status)) {
            try {
                ServiceVersion.getInstance().cleanElapsed();
                return "ok";
            }
            catch (Exception e) {
                return e.getMessage();
            }
        }
        else {
            ServiceVersion sv = ServiceVersion.getInstance();

            if ("openlog".equalsIgnoreCase(status)) {
                sv.setLogstatus(true);
            }

            if ("closelog".equalsIgnoreCase(status)) {
                sv.setLogstatus(false);
            }

            return uri + " version " + sv.getVer() + " (LogStatus: " + (sv.isLogstatus() ? "Y" : "N") + ")\n";
        }
    }

    @GET
    @Produces("text/html;charset=UTF-8")
    @Path("/env")
    public String env(@QueryParam("key") String key)
    {
        if (StringUtils.isEmpty(key)) {
            return "require key";
        }

        String[] keys = key.split(",");
        JSONObject json = EnviromentUtil.followEnvironment(null, keys);

        if (json != null) {
            return json.toJSONString();
        }
        else {
            return "";
        }
    }

    @SuppressWarnings("rawtypes")
    private Map<String, String> getParameter()
    {
        Map<String, String> rtn = new HashMap<String, String>();
        Enumeration e = request.getParameterNames();

        while (e.hasMoreElements()) {
            String key = (String) e.nextElement();
            String[] values = request.getParameterValues(key);

            if (values != null && values.length > 0 && !StringUtils.isEmpty(values[0])) {
                String value = values[0];
                rtn.put(key, value);
            }
        }

        return rtn;
    }

    private void setSessionbycongou(ServiceSession session, String key, String value)
    {
        setSession(session, key, value);

        if ("token".equalsIgnoreCase(key)) {
            session.setToken(value);
            UserDataRangeSrv.setlocaltoken(value);
            UserTokenInfo info = UserDataRangeSrv.getlocaluser();

            if (info != null) {
                session.setEnt_id(Long.parseLong(info.getEntid()));
                session.setUser_id(Long.parseLong(info.getUserid()));
                session.setUser_code(info.getUseraccount());
                session.setUser_name(info.getUsername());
                session.setDeptcode(info.getDeptid());
                session.setDeptrealcode(info.getDeptcode());
                session.setRoleid(info.getOrgid());
                session.setRolecode(info.getOrgcode());
                session.setPostid(info.getPostid());
            }
        }
    }

    private void setSession(ServiceSession session, String key, String value)
    {
        if ("ent_id".equalsIgnoreCase(key) && session.getEnt_id() == 0L) {
            session.setEnt_id(Long.parseLong(value));
        }

        if ("user_id".equalsIgnoreCase(key)) {
            session.setUser_id(Long.parseLong(value));
        }

        if ("user_code".equalsIgnoreCase(key)) {
            session.setUser_code(value);
        }

        if ("user_name".equalsIgnoreCase(key)) {
            session.setUser_name(value);
        }

        if ("debug_status".equalsIgnoreCase(key)) {
            session.setDebug_status(value);
        }

        if ("token".equalsIgnoreCase(key)) {
            session.setToken(value);
        }

        if ("postid".equalsIgnoreCase(key)) {
            session.setPostid(value);
        }

        if ("parentkey".equalsIgnoreCase(key)) {
            session.setParentkey(value);
        }

        if ("rootkey".equalsIgnoreCase(key)) {
            session.setRootkey(value);
        }

        if ("market".equalsIgnoreCase(key)) {
            session.setMarket(value);
        }

        if ("shop_code".equalsIgnoreCase(key) || "shopCode".equalsIgnoreCase(key)) {
            session.setMarket(value);
        }

        if ("slice".equalsIgnoreCase(key)) {
            session.setSlice(value);
        }

        if ("dataRangeId".equalsIgnoreCase(key)) {
            session.setDataRangeId(value);
        }

        if ("stationId".equalsIgnoreCase(key)) {
            session.setPostid(value);
        }

        if ("roleId".equalsIgnoreCase(key)) {
            session.setRoleid(value);
        }

        if ("locale".equalsIgnoreCase(key)) {
            session.setLocale(value);
            MessageUtils.setSimpleLocale(value);
        }

        if ("orderkey".equalsIgnoreCase(key)) {
            session.setOrderkey(Integer.valueOf(value));
        }
    }

    @SuppressWarnings("rawtypes")
    private String addQueryParamToJsonParam(ServiceSession session, String param, String... ignores)
    {
        Map<String, Object> map = new HashMap<String, Object>();
        // OpneAPI请求关键,webinAPI忽略这些字段不作为参
        String[] openkey = new String[] {"token", "access_token", "method", "app_key", "timestamp", "format", "ver", "version", "sign_method", "sign", "signature_method", "signature", "postid",
                                         "portalkey", "shopCode", "shop_code", "dataRangeId", "stationId", "roleId", "accessid"
                                        };
        String[] ss = null;

        if (session != null) {
            StringBuffer sb = new StringBuffer();
            String[] s = AbstractEntityBean.fetchAllDeclaredField(session.getClass(), sb).toString().split(",");
            ss = new String[openkey.length + s.length];

            for (int i = 0; i < openkey.length; i++) {
                ss[i] = openkey[i];
            }

            for (int i = 0; i < s.length; i++) {
                ss[openkey.length + i] = s[i];
            }
        }
        else {
            ss = openkey;
        }

        Map<String, String> rp = getParameter();
        //String portalkey = rp.get("portalkey");
        //boolean iscongouportal = false;
        //if (!StringUtils.isEmpty(portalkey) && portalkey.equalsIgnoreCase("congou")) {
        //	iscongouportal = true;
        //}
        String portalkey = DataUtils.nvl((String) rp.get("portalkey"), UserDataRangeSrv.getPortalkey());
        boolean iscongouportal = false;

        if (!StringUtils.isEmpty(portalkey) && portalkey.equalsIgnoreCase("congou")) {
            iscongouportal = true;
        }

        Iterator iter = rp.entrySet().iterator();

        while (iter.hasNext()) {
            Map.Entry entry = (Map.Entry) iter.next();
            String key = (String) entry.getKey();

            if (Utils.stringArrayContainsKey(ignores, key, true)) {
                continue;
            }

            String[] values = request.getParameterValues(key);

            if (values != null && values.length > 0 && !StringUtils.isEmpty(values[0])) {
                String value = values[0];

                if (ss != null && Utils.stringArrayContainsKey(ss, key, true)) {
                    if (iscongouportal) {
                        setSessionbycongou(session, key, value);
                    }
                    else {
                        setSession(session, key, value);
                    }
                }
                else {
                    if ((value.startsWith("{") && value.endsWith("}")) || (value.startsWith("[") && value.endsWith("]"))) {
                        try {
                            map.put(key, JSON.parse(value));
                        }
                        catch (Exception ex) {
                            map.put(key, value);
                        }
                    }
                    else {
                        map.put(key, value);
                    }
                }
            }
        }

        // URL中有KEY=VALUE模式的参,加入到JSON参数
        if (map != null && map.size() > 0) {
            JSONObject jsonparam = null;

            if (StringUtils.isEmpty(param)) {
                jsonparam = new JSONObject();
            }
            else {
                try {
                    jsonparam = JSON.parseObject(param);
                }
                catch (Exception ex) {
                    return param;
                }
            }

            for (String key : map.keySet()) {
                if (!jsonparam.containsKey(key)) {
                    jsonparam.put(key, map.get(key));
                }
            }

            param = jsonparam.toJSONString();
        }

        //dataRangeId为空，token不空时根据token重新查询dataRangeId
        if (!StringUtils.isEmpty(session.getToken()) && StringUtils.isEmpty(session.getDataRangeId())) {
            String key = "session:" + session.getToken();

            try {
                JSONObject json =  JSONObject.parseObject((String) CacheUtils.getCacheUtils().getCacheData(key));

                if (!StringUtils.isEmpty(json) && !StringUtils.isEmpty(json.get("dataRangeId"))) {
                    session.setDataRangeId(json.get("dataRangeId").toString());
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }

        if (SpringBeanFactory.containsBean("initSession_" + portalkey)) {
            InitSession init = SpringBeanFactory.getBean("initSession_" + portalkey, InitSession.class);
            init.init(session);
        }

        // httpuri
        if (session != null) {
            session.setHttp_uri(request.getScheme() + "://" + request.getServerName() + ":" + request.getServerPort());
        }

        return param;
    }

    @SuppressWarnings("rawtypes")
    private String addQueryParamToJsonParamByCall(ServiceSession session, String param, String... ignores)
    {
        Map<String, Object> map = new HashMap<String, Object>();

        String[] ss = null;

        Map<String, String> rp = getParameter();

        Iterator iter = rp.entrySet().iterator();

        while (iter.hasNext()) {
            Map.Entry entry = (Map.Entry) iter.next();
            String key = (String) entry.getKey();

            if (Utils.stringArrayContainsKey(ignores, key, true)) {
                continue;
            }

            String[] values = request.getParameterValues(key);

            if (values != null && values.length > 0 && !StringUtils.isEmpty(values[0])) {
                String value = values[0];
                if ((value.startsWith("{") && value.endsWith("}")) || (value.startsWith("[") && value.endsWith("]"))) {
                    try {
                        map.put(key, JSON.parse(value));
                    }
                    catch (Exception ex) {
                        map.put(key, value);
                    }
                }
                else {
                    map.put(key, value);
                }
            }
        }

        // URL中有KEY=VALUE模式的参,加入到JSON参数
        if (map != null && map.size() > 0) {
            JSONObject jsonparam = null;

            if (StringUtils.isEmpty(param)) {
                jsonparam = new JSONObject();
            }
            else {
                try {
                    jsonparam = JSON.parseObject(param);
                }
                catch (Exception ex) {
                    return param;
                }
            }

            for (String key : map.keySet()) {
                if (!jsonparam.containsKey(key)) {
                    jsonparam.put(key, map.get(key));
                }
            }

            param = jsonparam.toJSONString();
        }

        // httpuri
        if (session != null) {
            session.setHttp_uri(request.getScheme() + "://" + request.getServerName() + ":" + request.getServerPort());
        }

        return param;
    }

    private boolean isEffective(String remoteAddr)
    {
        if ((null != remoteAddr) && (!"".equals(remoteAddr.trim())) && (!"unknown".equalsIgnoreCase(remoteAddr.trim()))) {
            return true;
        }
        else {
            return false;
        }
    }

    private String getRemoteAddr()
    {
        try {
            String remoteAddr = request.getHeader("X-Forwarded-For");

            // 如果通过多级反向代理，X-Forwarded-For的值不止一个，而是一串用逗号分隔的IP值，此时取X-Forwarded-For中第一个非unknown的有效IP字符
            if (isEffective(remoteAddr) && (remoteAddr.indexOf(",") > -1)) {
                String[] array = remoteAddr.split(",");

                for (String element : array) {
                    if (isEffective(element)) {
                        remoteAddr = element;
                        break;
                    }
                }
            }

            if (!isEffective(remoteAddr)) {
                remoteAddr = request.getHeader("X-Real-IP");
            }

            if (!isEffective(remoteAddr)) {
                remoteAddr = request.getRemoteAddr();
            }

            if (remoteAddr != null && remoteAddr.indexOf(".") > 0) {
                return remoteAddr;
            }
            else {
                return "";
            }
        }
        catch (Exception e) {
            return "";
        }
    }

    @POST
    @Produces("application/json;charset=UTF-8")
    @Path("/qimen")
    public String callQimenService(@QueryParam("cmd") String method, String body) throws Exception {
        String result = "";
        String rtncode = "0";
        String remoteaddr = "";
        String url = "";
        long logkey = 0;
        long startTime = System.currentTimeMillis();

        String queryMsg = String.format("Qimen_REQ:%s :%s :%s", method, body, request.getQueryString());
        ServiceLogs.debuglog(ServiceLogs.LOGTYPE.REQUEST, queryMsg, startTime);

        if (ServiceVersion.getInstance().isLogstatus()) {
            remoteaddr = getRemoteAddr();
            logkey = UniqueID.getUniqueID();
            url = request.getQueryString();
        }

        TaobaoSession session = new TaobaoSession();
        addQueryParamToJsonParam(session, body);
        ServiceSession sessionobj = new ServiceSession();

        sessionobj.setEnt_id(session.getEnt_id());
        sessionobj.setStarttime(startTime);
        sessionobj.setRemoteaddr(remoteaddr);
        sessionobj.setLogkey(String.valueOf(logkey));
        sessionobj.setMethod(method);

        if (!StringUtils.isEmpty(session.getRequest_id())) {
            sessionobj.setParentkey(session.getRequest_id());
            sessionobj.setRootkey(session.getRequest_id());
        }

        if (StringUtils.isEmpty(sessionobj.getRootkey())) {
            sessionobj.setRootkey(String.valueOf(logkey));
        }

        sessionobj.setUrl(url);
        pushlocale(sessionobj);

        //验签
        JSONObject sat_res = checkSign(session, body);
        //签名错误直接返回
        if (sat_res.containsKey("success")
                && "false".equalsIgnoreCase(sat_res.getString("success")))
        {
            ServiceLogs.debuglog( ServiceLogs.LOGTYPE.RESPONSE, "RESP:" + sat_res.toJSONString(), startTime);
            return sat_res.toJSONString();
        }

        // 记录传入参数
        if (ServiceVersion.getInstance().isLogstatus()) {
            ServiceLogs.logRequest(body);
        }

        try {
            Object retdata = rcm.executeClassMethodByTaobao(method, session, body);

            if (retdata instanceof TaobaoResponse) {
                TaobaoResponse response = (TaobaoResponse) retdata;
                rtncode = response.getErr_code();
            }

            if (retdata == null) {
                result = "";
            } else if (retdata instanceof String) {
                result = (String) retdata;
            }
            else {
                result = JSON.toJSONString(Utils.toNormalJSONObject(retdata));
            }

            return result;

        } catch (ServiceException ex) {
            ex.printStackTrace();
            result = JSON.toJSONString(TaobaoResponse.buildFailure(ex.getErrorCode(), ex.getMessage()));
            rtncode = ex.getErrorCode();
            return result;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            result = JSON.toJSONString(TaobaoResponse.buildFailure(ResponseCode.EXCEPTION, Utils.getLastExceptionMessage(ex)));
            rtncode = "555";
            return result;
        } finally {
            // 记录输入输出参数
            if (ServiceVersion.getInstance().isLogstatus()) {
                ServiceLogs.logResponse(result, rtncode);
            }

            UserDataRangeSrv.setlocaltoken("");
            removeLocale(sessionobj);
        }
    }

    @POST
    @Produces("text/plain;charset=UTF-8")
    @Path("/rest")
    public String callRestService(@QueryParam("method") String method, @QueryParam("session") String session, @QueryParam("param") String param, String postparam)
    {
        String result = null;
        String remoteaddr = "";
        String rtncode = "0";
        long logkey = 0;
        String url = "";
        // 将URL中KEY=VALUE模式的参数转换到JSON参数
        ServiceSession sessionobj = null;
        // 记录开始时
        long start_time = System.currentTimeMillis();

        try {
            // POST的数据为空则取URL中的param
            if (StringUtils.isEmpty(postparam)) {
                postparam = param;
            }

            UserDataRangeSrv.setlocaltoken("");

            if (ServiceVersion.getInstance().isLogstatus()) {
                remoteaddr = getRemoteAddr();
                logkey = UniqueID.getUniqueID();
                url = request.getQueryString();
            }

            if (StringUtils.isEmpty(session)) {
                sessionobj = new ServiceSession();
            }
            else {
                try {
                    sessionobj = JSON.parseObject(session, ServiceSession.class);
                }
                catch (Exception ex1) {
                    try {
                        session = URLDecoder.decode(session, "UTF-8");
                        sessionobj = JSON.parseObject(session, ServiceSession.class);
                    }
                    catch (Exception ex2) {
                        throw new Exception("Session:" + session + ", Error:" + ex2.getMessage());
                    }
                }
            }

            postparam = addQueryParamToJsonParam(sessionobj, postparam, "method", "session", "param");
            //sessionobj.setLocale("TR");
            sessionobj.setStarttime(start_time);
            sessionobj.setRemoteaddr(remoteaddr);
            sessionobj.setLogkey(String.valueOf(logkey));
            sessionobj.setMethod(method);

            if (StringUtils.isEmpty(sessionobj.getParentkey())) {
                sessionobj.setParentkey(String.valueOf(logkey));
            }

            if (StringUtils.isEmpty(sessionobj.getRootkey())) {
                sessionobj.setRootkey(String.valueOf(logkey));
            }

            sessionobj.setUrl(url);
            pushlocale(sessionobj);

            // 记录传入参数
            if (ServiceVersion.getInstance().isLogstatus()) {
                //				StringBuffer sb = new StringBuffer();
                //				sb.append("[" + remoteaddr + " - " + logkey + "]: ");
                //				sb.append(method + " , ");
                //				sb.append("REQUEST  : ");
                //				sb.append(postparam);
                //				sb.append(" , url : ");
                //				sb.append(url);
                ServiceLogs.logRequest(postparam);
            }

            // 反射调用
            Object retdata = rcm.executeClassMethod(method, sessionobj, postparam);
            // 记录结束时间
            long end_time = System.currentTimeMillis();

            if (retdata instanceof ServiceResponse) {
                ServiceResponse response = (ServiceResponse) retdata;
                response.addElapsed("总耗时", start_time, end_time);
                response.setLogkey(sessionobj.getLogkey());

                // 非调试状态不输出日志
                if (sessionobj != null && !"Y".equalsIgnoreCase(sessionobj.getDebug_status())) {
                    // 记录输入输出日志时总是记录耗时数据
                    if (!ServiceVersion.getInstance().isLogstatus()) {
                        response.setElapsed(null);
                    }

                    response.setWarnmsg(null);
                }

                rtncode = response.getReturncode();
            }

            if (retdata == null) {
                result = "";
            }
            else if (retdata instanceof String) {
                result = (String) retdata;
            }
            else {
                result = JSON.toJSONString(Utils.toNormalJSONObject(retdata));
            }

            return result;
        }
        catch (ServiceException ex) {
            ex.printStackTrace();
            result = JSON.toJSONString(ServiceResponse.buildFailure(sessionobj, ex.getErrorCode(), ex.getMessage(), ex.getErrorArgs()));
            rtncode = ex.getErrorCode();
            return result;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            result = JSON.toJSONString(ServiceResponse.buildFailure(sessionobj, ResponseCode.EXCEPTION, Utils.getLastExceptionMessage(ex)));
            rtncode = "555";
            return result;
        }
        finally {
            // 记录输入输出参数
            if (ServiceVersion.getInstance().isLogstatus()) {
                //				StringBuffer sb = new StringBuffer();
                //				sb.append("[" + remoteaddr + " - " + logkey + "]: ");
                //				sb.append(method + " , ");
                //				sb.append("ELAPSED  : " + (System.currentTimeMillis() - start_time) + " ms , ");
                //				sb.append("RESPONSE : ");
                //				sb.append(result);
                //ServiceVersion.getInstance().debugLog(sb.toString());
                ServiceLogs.logResponse(result, rtncode);
            }

            UserDataRangeSrv.setlocaltoken("");
            removeLocale(sessionobj);
        }
    }

    @POST
    @Produces("text/plain;charset=UTF-8")
    @Path("/restomni")
    public String callRestService_omni(@QueryParam("method") String method, @QueryParam("session") String session, @QueryParam("param") String param,
                                       String postparam)
    {
        String result = null;
        String remoteaddr = "";
        long logkey = 0;
        String url = "";
        // 记录开始时间
        long start_time = System.currentTimeMillis();

        try {
            // POST的数据为空则取URL中的param
            if (StringUtils.isEmpty(postparam)) {
                postparam = param;
            }

            UserDataRangeSrv.setlocaltoken("");

            if (ServiceVersion.getInstance().isLogstatus()) {
                remoteaddr = getRemoteAddr();
                logkey = UniqueID.getUniqueID();
                url = request.getQueryString();
            }

            // 将URL中KEY=VALUE模式的参数转换到JSON参数
            ServiceSession sessionobj = null;

            if (StringUtils.isEmpty(session)) {
                sessionobj = new ServiceSession();
            }
            else {
                sessionobj = JSON.parseObject(session, ServiceSession.class);
            }

            postparam = addQueryParamToJsonParam(sessionobj, postparam, "method", "session", "param");
            sessionobj.setEnt_id(0);
            sessionobj.setToken("");
            UserDataRangeSrv.setlocaltoken("");

            // 记录传入参数
            if (ServiceVersion.getInstance().isLogstatus()) {
                StringBuffer sb = new StringBuffer();
                sb.append("[" + remoteaddr + " - " + logkey + "]: ");
                sb.append(method + " , ");
                sb.append("REQUEST  : ");
                sb.append(postparam);
                sb.append(" , url : ");
                sb.append(url);
                ServiceVersion.getInstance().debugLog(sb.toString());
            }

            // 反射调用
            Object retdata = rcm.executeClassMethod(method, sessionobj, postparam);
            // 记录结束时间
            long end_time = System.currentTimeMillis();
            ServiceResponse response = null;

            if (retdata instanceof ServiceResponse) {
                response = (ServiceResponse) retdata;
                response.addElapsed("总耗时", start_time, end_time);

                // 非调试状态不输出日志
                if (sessionobj != null && !"Y".equalsIgnoreCase(sessionobj.getDebug_status())) {
                    // 记录输入输出日志时总是记录耗时数据
                    if (!ServiceVersion.getInstance().isLogstatus()) {
                        response.setElapsed(null);
                    }

                    response.setWarnmsg(null);
                }
            }
            else {
                if (retdata == null) {
                    retdata = "";
                }

                response = ServiceResponse.buildSuccess(retdata);
            }

            result = JSON.toJSONString(Utils.toNormalJSONObject(response));
            return result;
        }
        catch (ServiceException ex) {
            ex.printStackTrace();
            result = JSON.toJSONString(ServiceResponse.buildFailure(null, ex.getErrorCode(), ex.getMessage(), ex.getErrorArgs()));
            return result;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            result = JSON.toJSONString(ServiceResponse.buildFailure(null, ResponseCode.EXCEPTION, Utils.getLastExceptionMessage(ex)));
            return result;
        }
        finally {
            // 记录输入输出参数
            if (ServiceVersion.getInstance().isLogstatus()) {
                StringBuffer sb = new StringBuffer();
                sb.append("[" + remoteaddr + " - " + logkey + "]: ");
                sb.append(method + " , ");
                sb.append("ELAPSED  : " + (System.currentTimeMillis() - start_time) + " ms , ");
                sb.append("RESPONSE : ");
                sb.append(result);
                ServiceVersion.getInstance().debugLog(sb.toString());
            }

            UserDataRangeSrv.setlocaltoken("");
        }
    }

    @GET
    @Produces("text/plain;charset=UTF-8")
    @Path("/call")
    public String callServiceByGet(@QueryParam("service") String service, @QueryParam("method") String method, @QueryParam("session") String session, @QueryParam("param") String param)
    {
        return callServiceByPOST(service, method, session, param, null);
    }

    @POST
    @Produces("text/plain;charset=UTF-8")
    @Path("/call")
    public String callServiceByPOST(@QueryParam("service") String service, @QueryParam("method") String method, @QueryParam("session") String session, @QueryParam("param") String param, String postparam)
    {
        String result = null;
        String remoteaddr = "";
        String rtncode = "0";
        long logkey = 0;
        String url = "";
        // 将URL中KEY=VALUE模式的参数转换到JSON参数
        ServiceSession sessionobj = null;
        // 记录开始时
        long start_time = System.currentTimeMillis();

        try {
            // POST的数据为空则取URL中的param
            if (StringUtils.isEmpty(postparam)) {
                postparam = param;
            }

            UserDataRangeSrv.setlocaltoken("");

            if (ServiceVersion.getInstance().isLogstatus()) {
                remoteaddr = getRemoteAddr();
                logkey = UniqueID.getUniqueID();
                url = request.getQueryString();
            }

            if (StringUtils.isEmpty(session)) {
                sessionobj = new ServiceSession();
            }
            else {
                try {
                    sessionobj = JSON.parseObject(session, ServiceSession.class);
                }
                catch (Exception ex1) {
                    try {
                        session = URLDecoder.decode(session, "UTF-8");
                        sessionobj = JSON.parseObject(session, ServiceSession.class);
                    }
                    catch (Exception ex2) {
                        throw new Exception("Session:" + session + ", Error:" + ex2.getMessage());
                    }
                }
            }

            JSONObject jsonparam;
            if (StringUtils.isEmpty(postparam)) {
                jsonparam = new JSONObject();
                jsonparam.put("service", service);
            } else {
                jsonparam = JSON.parseObject(postparam);
            }
            jsonparam.put("service", service);

            postparam = addQueryParamToJsonParamByCall(sessionobj, jsonparam.toJSONString(), "method", "session", "param");
            sessionobj.setStarttime(start_time);
            sessionobj.setRemoteaddr(remoteaddr);
            sessionobj.setLogkey(String.valueOf(logkey));
            sessionobj.setMethod(method);

            if (StringUtils.isEmpty(sessionobj.getParentkey())) {
                sessionobj.setParentkey(String.valueOf(logkey));
            }

            if (StringUtils.isEmpty(sessionobj.getRootkey())) {
                sessionobj.setRootkey(String.valueOf(logkey));
            }

            //过滤service参数
            if (url.indexOf("service") > -1) {
                Map queryParam = SignUtils.urlToMap(url, "UTF-8");
                queryParam.remove("service");
                url = getURLParamStrFromMap(queryParam);
            }
            sessionobj.setUrl(url);
            pushlocale(sessionobj);

            // 记录传入参数
            if (ServiceVersion.getInstance().isLogstatus()) {
                ServiceLogs.logRequest(postparam);
            }

            // 反射调用
            Object retdata = rcm.executeClassMethod("efuture.service.proxy.call", sessionobj, postparam);
            // 记录结束时间
            long end_time = System.currentTimeMillis();

            if (retdata instanceof ServiceResponse) {
                ServiceResponse response = (ServiceResponse) retdata;
                response.addElapsed("总耗时", start_time, end_time);
                response.setLogkey(sessionobj.getLogkey());

                // 非调试状态不输出日志
                if (sessionobj != null && !"Y".equalsIgnoreCase(sessionobj.getDebug_status())) {
                    // 记录输入输出日志时总是记录耗时数据
                    if (!ServiceVersion.getInstance().isLogstatus()) {
                        response.setElapsed(null);
                    }

                    response.setWarnmsg(null);
                }
                rtncode = response.getReturncode();
            }

            if (retdata == null) {
                result = "";
            }
            else if (retdata instanceof String) {
                result = (String) retdata;
            }
            else {
                result = JSON.toJSONString(Utils.toNormalJSONObject(retdata));
            }

            return result;
        }
        catch (ServiceException ex) {
            ex.printStackTrace();
            result = JSON.toJSONString(ServiceResponse.buildFailure(sessionobj, ex.getErrorCode(), ex.getMessage(), ex.getErrorArgs()));
            rtncode = ex.getErrorCode();
            return result;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            result = JSON.toJSONString(ServiceResponse.buildFailure(sessionobj, ResponseCode.EXCEPTION, Utils.getLastExceptionMessage(ex)));
            rtncode = "555";
            return result;
        }
        finally {
            // 记录输入输出参数
            if (ServiceVersion.getInstance().isLogstatus()) {
                //				StringBuffer sb = new StringBuffer();
                //				sb.append("[" + remoteaddr + " - " + logkey + "]: ");
                //				sb.append(method + " , ");
                //				sb.append("ELAPSED  : " + (System.currentTimeMillis() - start_time) + " ms , ");
                //				sb.append("RESPONSE : ");
                //				sb.append(result);
                //ServiceVersion.getInstance().debugLog(sb.toString());
                ServiceLogs.logResponse(result, rtncode);
            }

            UserDataRangeSrv.setlocaltoken("");
            removeLocale(sessionobj);
        }
    }

    @POST
    @Produces("text/plain;charset=UTF-8")
    @Path("/ptrest")
    public String callRestService_pt(@QueryParam("method") String method, @QueryParam("session") String session, @QueryParam("param") String param,
                                     String postparam)
    {
        String result = null;
        String remoteaddr = "";
        long logkey = 0;
        String url = "";
        // 记录开始时
        long start_time = System.currentTimeMillis();

        try {
            // POST的数据为空则取URL中的param
            if (StringUtils.isEmpty(postparam)) {
                postparam = param;
            }

            UserDataRangeSrv.setlocaltoken("");

            if (ServiceVersion.getInstance().isLogstatus()) {
                remoteaddr = getRemoteAddr();
                logkey = UniqueID.getUniqueID();
                url = request.getQueryString();
            }

            // 将URL中KEY=VALUE模式的参数转换到JSON参数
            ServiceSession sessionobj = null;

            if (StringUtils.isEmpty(session)) {
                sessionobj = new ServiceSession();
            }
            else {
                sessionobj = JSON.parseObject(session, ServiceSession.class);
            }

            postparam = addQueryParamToJsonParam(sessionobj, postparam, "method", "session", "param");

            // 记录传入参数
            if (ServiceVersion.getInstance().isLogstatus()) {
                StringBuffer sb = new StringBuffer();
                sb.append("[" + remoteaddr + " - " + logkey + "]: ");
                sb.append(method + " , ");
                sb.append("REQUEST  : ");
                sb.append(postparam);
                sb.append(" , url : ");
                sb.append(url);
                ServiceVersion.getInstance().debugLog(sb.toString());
            }

            // 反射调用
            Object retdata = rcm.executeClassMethod(method, sessionobj, postparam);
            // 记录结束时间
            long end_time = System.currentTimeMillis();
            ServiceResponse response = null;

            if (retdata instanceof ServiceResponse) {
                response = (ServiceResponse) retdata;
                response.addElapsed("总耗时", start_time, end_time);

                // 非调试状态不输出日志
                if (sessionobj != null && !"Y".equalsIgnoreCase(sessionobj.getDebug_status())) {
                    // 记录输入输出日志时总是记录耗时数据
                    if (!ServiceVersion.getInstance().isLogstatus()) {
                        response.setElapsed(null);
                    }

                    response.setWarnmsg(null);
                }
            }
            else {
                if (retdata == null) {
                    retdata = "";
                }

                response = ServiceResponse.buildSuccess(retdata);
            }

            result = JSON.toJSONString(Utils.toNormalJSONObject(response));
            return result;
        }
        catch (ServiceException ex) {
            ex.printStackTrace();
            result = JSON.toJSONString(ServiceResponse.buildFailure_ex(null, ex.getErrorCode(), ex.getMessage(), ex.getErrorArgs()));
            return result;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            result = JSON.toJSONString(ServiceResponse.buildFailure_ex(null, ResponseCode.EXCEPTION, Utils.getLastExceptionMessage(ex)));
            return result;
        }
        finally {
            // 记录输入输出参数
            if (ServiceVersion.getInstance().isLogstatus()) {
                StringBuffer sb = new StringBuffer();
                sb.append("[" + remoteaddr + " - " + logkey + "]: ");
                sb.append(method + " , ");
                sb.append("ELAPSED  : " + (System.currentTimeMillis() - start_time) + " ms , ");
                sb.append("RESPONSE : ");
                sb.append(result);
                ServiceVersion.getInstance().debugLog(sb.toString());
            }

            UserDataRangeSrv.setlocaltoken("");
        }
    }

    @GET
    @Produces("text/plain;charset=UTF-8")
    @Path("/rest")
    public String callRestServiceByGET(@QueryParam("method") String method, @QueryParam("session") String session, @QueryParam("param") String param)
    {
        return callRestService(method, session, param, null);
    }

    @POST
    @Path("/import")
    @Produces("text/plain;charset=UTF-8")
    @Consumes({MediaType.MULTIPART_FORM_DATA})
    public String callImportService(@QueryParam("method") String method, @QueryParam("session") String session, @QueryParam("param") String param,
                                    FormDataMultiPart form)
    {
        List<FileImportObject> list = new ArrayList<FileImportObject>();

        try {
            ServiceVersion.getInstance().debugLog("start import.");
            Map<String, ?> mapFormData = form.getFields();
            Set<String> sets = (Set<String>) mapFormData.keySet();

            for (String key : sets) {
                List<?> parts = (List<?>) mapFormData.get(key);

                for (int i = 0; i < parts.size(); i++) {
                    FormDataBodyPart part = (FormDataBodyPart) parts.get(i);
                    String filename = part.getContentDisposition().getFileName();
                    System.out.println(key + ":" + filename);

                    if (StringUtils.isEmpty(filename)) {
                        continue;
                    }

                    FileImportObject fio = new FileImportObject();
                    fio.setFilename(filename);
                    fio.setStream(part.getValueAs(InputStream.class));
                    fio.setServletrequest(request);
                    list.add(fio);
                }
            }

            // 加强decode�?
            param = URLDecoder.decode(param);
            // 将URL中KEY=VALUE模式的参数转换到JSON参数
            ServiceSession sessionobj = null;

            if (StringUtils.isEmpty(session)) {
                sessionobj = new ServiceSession();
            }
            else {
                sessionobj = JSON.parseObject(session, ServiceSession.class);
            }

            param = addQueryParamToJsonParam(sessionobj, param, "method", "session", "param");
            Object retdata = rcm.executeClassMethodForListParam(method, sessionobj, param, list);

            if (retdata == null) {
                return "";
            }
            else if (retdata instanceof String) {
                return (String) retdata;
            }
            else {
                return JSON.toJSONString(Utils.toNormalJSONObject(retdata));
            }
        }
        catch (ServiceException ex) {
            ex.printStackTrace();
            return JSON.toJSONString(ServiceResponse.buildFailure(null, ex.getErrorCode(), ex.getMessage(), ex.getErrorArgs()));
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return JSON.toJSONString(ServiceResponse.buildFailure(null, ResponseCode.EXCEPTION, Utils.getLastExceptionMessage(ex)));
        }
        finally {
            for (FileImportObject fio : list) {
                try {
                    InputStream in = fio.getStream();

                    if (in != null) {
                        in.close();
                    }
                }
                catch (Exception ex) {
                }
            }
        }
    }
    @POST
    @Path("/importExcel")
    @Produces("text/plain;charset=UTF-8")
    @Consumes({MediaType.MULTIPART_FORM_DATA})
    public String callImportExcelService(@QueryParam("srvname") String srvname, @QueryParam("session") String session, @QueryParam("param") String param,
                                         FormDataMultiPart form)
    {
        List<FileImportObject> list = new ArrayList<FileImportObject>();

        try {
            ServiceVersion.getInstance().debugLog("start import.");
            Map<String, ?> mapFormData = form.getFields();
            Set<String> sets = (Set<String>) mapFormData.keySet();

            for (String key : sets) {
                List<?> parts = (List<?>) mapFormData.get(key);

                for (int i = 0; i < parts.size(); i++) {
                    FormDataBodyPart part = (FormDataBodyPart) parts.get(i);
                    String filename = part.getContentDisposition().getFileName();
                    System.out.println(key + ":" + filename);

                    if (StringUtils.isEmpty(filename)) {
                        continue;
                    }

                    FileImportObject fio = new FileImportObject();
                    fio.setFilename(filename);
                    fio.setStream(part.getValueAs(InputStream.class));
                    fio.setServletrequest(request);
                    list.add(fio);
                }
            }

            // 加强decode�?
            param = URLDecoder.decode(param);
            // 将URL中KEY=VALUE模式的参数转换到JSON参数
            ServiceSession sessionobj = null;

            if (StringUtils.isEmpty(session)) {
                sessionobj = new ServiceSession();
            }
            else {
                sessionobj = JSON.parseObject(session, ServiceSession.class);
            }

            param = addQueryParamToJsonParam(sessionobj, param, "method", "session", "param");
            ExcelComponent excel = SpringBeanFactory.getContext().getBean(ExcelComponent.class);
            Object retdata = excel.importExcel(sessionobj, param, srvname, list);

            if (retdata == null) {
                return "";
            }
            else if (retdata instanceof String) {
                return (String) retdata;
            }
            else {
                return JSON.toJSONString(Utils.toNormalJSONObject(retdata));
            }
        }
        catch (ServiceException ex) {
            ex.printStackTrace();
            return JSON.toJSONString(ServiceResponse.buildFailure(null, ex.getErrorCode(), ex.getMessage(), ex.getErrorArgs()));
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return JSON.toJSONString(ServiceResponse.buildFailure(null, ResponseCode.EXCEPTION, Utils.getLastExceptionMessage(ex)));
        }
        finally {
            for (FileImportObject fio : list) {
                try {
                    InputStream in = fio.getStream();

                    if (in != null) {
                        in.close();
                    }
                }
                catch (Exception ex) {
                }
            }
        }
    }
    @POST
    @Produces("text/plain;charset=UTF-8")
    @Path("/export")
    public Response callExportService(@QueryParam("method") String method, @QueryParam("session") String session, @QueryParam("param") String param,
                                      String postparam,
                                      @QueryParam("filename") String filename, @Context HttpHeaders headers)
    {
        try {
            // POST的数据为空则取URL中的param
            if (StringUtils.isEmpty(postparam)) {
                postparam = param;
            }

            // 加强decode�?
            if (UrlEncoderUtils.hasUrlEncoded(postparam)) {
                postparam = URLDecoder.decode(postparam);
            }

            // 将URL中KEY=VALUE模式的参数转换到JSON参数
            ServiceSession sessionobj = null;

            if (StringUtils.isEmpty(session)) {
                sessionobj = new ServiceSession();
            }
            else {
                sessionobj = JSON.parseObject(session, ServiceSession.class);
            }

            postparam = addQueryParamToJsonParam(sessionobj, postparam, "method", "session", "param", "filename");
            // 执行导出服务
            Object retdata = rcm.executeClassMethod(method, sessionobj, postparam);

            // 返回String表示生成XLS的XML描述,可用XLS打开
            if (retdata == null) {
                return Response.ok("", "text/plain;charset=UTF-8").build();
            }
            else if (retdata instanceof ServiceResponse) {
                return Response.ok(JSON.toJSONString(retdata), "text/plain;charset=UTF-8").build();
            }
            else {
                // Firefox需要对中文文件名进行编
                //				if (StringUtils.isEmpty(filename))
                //					filename = "export.xls";
                //				java.io.StringReader stream = new StringReader(retdata.toString());
                //				ResponseBuilder builder = Response.ok(stream);
                //				builder.header("Pragma", "No-cache");
                //				builder.header("Cache-Control", "No-cache");
                //				response.setDateHeader("Expires", 0);
                //				builder.header("Content-Disposition", Utils.builderContentDispositionFileName(headers, filename));
                //				if (retdata instanceof String) {
                //					response.setCharacterEncoding("UTF-8"); // 设置输出流为UTF-8
                //					builder.type("application/ms-excel"); // 设置输出文件类型为excel文件
                //				} else {
                //					builder.type("application/octet-stream"); // 设置文件
                //				}
                //
                //				return builder.build();
                if (StringUtils.isEmpty(filename)) {
                    filename = "export.xls";
                }

                String headType = "application/octet-stream";
                ResponseBuilder builder;

                if (retdata instanceof String) { //文件名称
                    String s = String.valueOf(retdata).toLowerCase();

                    if (s.endsWith(".xls") || s.endsWith(".xlsx")) {
                        headType = "application/ms-excel";
                    }

                    File fp = new File(s);
                    filename = fp.getName();
                    builder = Response.ok(fp);
                }
                else {
                    java.io.StringReader stream = new StringReader(retdata.toString());
                    builder = Response.ok(stream);
                }

                builder.header("Pragma", "No-cache");
                builder.header("Cache-Control", "No-cache");
                response.setDateHeader("Expires", 0);
                builder.header("Content-Disposition", Utils.builderContentDispositionFileName(headers, filename));
                response.setCharacterEncoding("UTF-8"); // 设置输出流为UTF-8
                builder.type(headType);
                return builder.build();
            }
        }
        catch (ServiceException ex) {
            ex.printStackTrace();
            String error = JSON.toJSONString(ServiceResponse.buildFailure(null, ex.getErrorCode(), ex.getMessage(), ex.getErrorArgs()));
            return Response.ok(error, "text/plain;charset=UTF-8").build();
        }
        catch (Exception ex) {
            ex.printStackTrace();
            String error = JSON.toJSONString(ServiceResponse.buildFailure(null, ResponseCode.EXCEPTION, Utils.getLastExceptionMessage(ex)));
            return Response.ok(error, "text/plain;charset=UTF-8").build();
        }
    }

    @GET
    @Produces("text/plain;charset=UTF-8")
    @Path("/exportocm")
    public Response callExportServiceOcm(@QueryParam("method") String method, @QueryParam("session") String session, @QueryParam("param") String param,
                                         String postparam,
                                         @QueryParam("filename") String filename, @Context HttpHeaders headers)
    {
        try {
            // POST的数据为空则取URL中的param
            if (StringUtils.isEmpty(postparam)) {
                postparam = param;
            }

            // 加强decode�?
            if (UrlEncoderUtils.hasUrlEncoded(postparam)) {
                postparam = URLDecoder.decode(postparam);
            }

            // 将URL中KEY=VALUE模式的参数转换到JSON参数
            ServiceSession sessionobj = null;

            if (StringUtils.isEmpty(session)) {
                sessionobj = new ServiceSession();
            }
            else {
                sessionobj = JSON.parseObject(session, ServiceSession.class);
            }

            JSONObject json = JSONObject.parseObject(postparam);
            File fp = new File(json.getString("filename"));
            System.out.println(fp.getAbsolutePath());
            // Firefox需要对中文文件名进行编
            // 读取filename文件内容
            InputStreamReader inputReader = null;
            InputStream inputStream = new FileInputStream(fp);
            inputReader = new InputStreamReader(inputStream);
            BufferedReader bufferReader = new BufferedReader(inputReader);
            // 读取一�?
            String line = null;
            StringBuffer strBuffer = new StringBuffer();

            while ((line = bufferReader.readLine()) != null) {
                strBuffer.append(line).append("\r\n");
            }

            inputStream.close();
            Object retdata = strBuffer.toString();

            if (StringUtils.isEmpty(filename)) {
                filename = postparam;
            }

            ResponseBuilder builder = Response.ok(retdata);
            builder.header("Pragma", "No-cache");
            builder.header("Cache-Control", "No-cache");
            response.setDateHeader("Expires", 0);
            builder.header("Content-Disposition", Utils.builderContentDispositionFileName(headers, fp.getName()));
            response.setCharacterEncoding("UTF-8"); // 设置输出流为UTF-8
            // 设置输出文件类型为excel文件
            builder.type("text/plain");
            return builder.build();
        }
        catch (ServiceException ex) {
            ex.printStackTrace();
            String error = JSON.toJSONString(ServiceResponse.buildFailure(null, ex.getErrorCode(), ex.getMessage(), ex.getErrorArgs()));
            return Response.ok(error, "text/plain;charset=UTF-8").build();
        }
        catch (Exception ex) {
            ex.printStackTrace();
            String error = JSON.toJSONString(ServiceResponse.buildFailure(null, ResponseCode.EXCEPTION, Utils.getLastExceptionMessage(ex)));
            return Response.ok(error, "text/plain;charset=UTF-8").build();
        }
    }

    @GET
    @Produces("text/plain;charset=UTF-8")
    @Path("/exportTxt")
    public Response callExportServiceTxt(@QueryParam("method") String method, @QueryParam("session") String session, @QueryParam("param") String param,
                                         String postparam,
                                         @QueryParam("filename") String filename, @Context HttpHeaders headers)
    {
        try {
            // POST的数据为空则取URL中的param
            if (StringUtils.isEmpty(postparam)) {
                postparam = param;
            }

            // 加强decode�?
            if (UrlEncoderUtils.hasUrlEncoded(postparam)) {
                postparam = URLDecoder.decode(postparam);
            }

            // 将URL中KEY=VALUE模式的参数转换到JSON参数�?
            ServiceSession sessionobj = null;

            if (StringUtils.isEmpty(session)) {
                sessionobj = new ServiceSession();
            }
            else {
                sessionobj = JSON.parseObject(session, ServiceSession.class);
            }

            postparam = addQueryParamToJsonParam(sessionobj, postparam, "method", "session", "param", "filename");
            // 执行导出服务
            Object retdata = rcm.executeClassMethod(method, sessionobj, postparam);

            // 返回String表示生成XLS的XML描述,可用XLS打开
            if (retdata == null) {
                return Response.ok("", "text/plain;charset=UTF-8").build();
            }
            else if (retdata instanceof ServiceResponse) {
                return Response.ok(JSON.toJSONString(retdata), "text/plain;charset=UTF-8").build();
            }
            else {
                // Firefox需要对中文文件名进行编
                if (StringUtils.isEmpty(filename)) {
                    filename = "export.xls";
                }

                ResponseBuilder builder = Response.ok(retdata);
                builder.header("Pragma", "No-cache");
                builder.header("Cache-Control", "No-cache");
                response.setDateHeader("Expires", 0);
                builder.header("Content-Disposition", Utils.builderContentDispositionFileName(headers, filename));

                if (retdata instanceof String) {
                    response.setCharacterEncoding("UTF-8"); // 设置输出流为UTF-8
                    response.setContentType("text/plain");
                }
                else {
                    builder.type("application/octet-stream"); // 设置文件
                }

                return builder.build();
            }
        }
        catch (ServiceException ex) {
            ex.printStackTrace();
            String error = JSON.toJSONString(ServiceResponse.buildFailure(null, ex.getErrorCode(), ex.getMessage(), ex.getErrorArgs()));
            return Response.ok(error, "text/plain;charset=UTF-8").build();
        }
        catch (Exception ex) {
            ex.printStackTrace();
            String error = JSON.toJSONString(ServiceResponse.buildFailure(null, ResponseCode.EXCEPTION, Utils.getLastExceptionMessage(ex)));
            return Response.ok(error, "text/plain;charset=UTF-8").build();
        }
    }

    @GET
    @Produces("text/plain;charset=UTF-8")
    @Path("/export")
    public Response callExportServiceByGET(@QueryParam("method") String method, @QueryParam("session") String session, @QueryParam("param") String param,
                                           @QueryParam("filename") String filename,
                                           @Context HttpHeaders headers)
    {
        return callExportService(method, session, param, null, filename, headers);
    }

    @GET
    @Produces("text/plain;charset=GBK")
    @Path("/exportrar")
    public Response callExportServiceOcmrar(@QueryParam("method") String method, @QueryParam("session") String session, @QueryParam("param") String param,
                                            String postparam,
                                            @QueryParam("filename") String filename, @Context HttpHeaders headers)
    {
        try {
            // POST的数据为空则取URL中的param
            if (StringUtils.isEmpty(postparam)) {
                postparam = param;
            }

            // 加强decode
            if (UrlEncoderUtils.hasUrlEncoded(postparam)) {
                postparam = URLDecoder.decode(postparam);
            }

            // 将URL中KEY=VALUE模式的参数转换到JSON参数
            ServiceSession sessionobj = null;

            if (StringUtils.isEmpty(session)) {
                sessionobj = new ServiceSession();
            }
            else {
                sessionobj = JSON.parseObject(session, ServiceSession.class);
            }

            JSONObject json = JSONObject.parseObject(postparam);
            File fp = new File(json.getString("filename"));
            System.out.println(fp.getAbsolutePath());
            // Firefox需要对中文文件名进行编
            // 读取filename文件内容
            InputStream fis = new BufferedInputStream(new FileInputStream(fp.getPath()));
            byte[] buffer = new byte[fis.available()];
            fis.read(buffer);
            fis.close();
            // 清空response
            response.reset();
            ResponseBuilder builder = Response.ok(buffer);
            builder.header("Pragma", "No-cache");
            builder.header("Cache-Control", "No-cache");
            response.setDateHeader("Expires", 0);
            builder.header("Content-Disposition", Utils.builderContentDispositionFileName(headers, fp.getName()));
            response.setCharacterEncoding("GBK"); // 设置输出流为UTF-8
            // 设置输出文件类型为excel文件
            builder.type("text/plain");
            return builder.build();
        }
        catch (ServiceException ex) {
            ex.printStackTrace();
            String error = JSON.toJSONString(ServiceResponse.buildFailure(null, ex.getErrorCode(), ex.getMessage(), ex.getErrorArgs()));
            return Response.ok(error, "text/plain;charset=GBK").build();
        }
        catch (Exception ex) {
            ex.printStackTrace();
            String error = JSON.toJSONString(ServiceResponse.buildFailure(null, ResponseCode.EXCEPTION, Utils.getLastExceptionMessage(ex)));
            return Response.ok(error, "text/plain;charset=GBK").build();
        }
    }

    /**
     * http://localhost:8082/mall-report-webin/exportReportInfo?method=mall.common.report.getrptinfo&ent_id=0&&param=%7B%22page_no%22:1,%22page_size%22:20,%22isstatus%22:%22Y%22,%22expireddate%22:%222021-12-31%22,%22wmid%22:%225%22,%22queryid%22:%22query_200210%22,%22business%22:%22work%22,%22moduleCode%22:%22200210%22,%22exporttype%22:%22excel%22%7D
     * @param method
     * @param session
     * @param param
     * @param postparam
     * @param headers
     * @return
     */
    @GET
    @Produces("text/plain;charset=UTF-8")
    @Path("/exportReportInfo")
    public Response callExportReportInfoService(@QueryParam("method") String method, @QueryParam("session") String session, @QueryParam("param") String param,
            String postparam,
            @Context HttpHeaders headers)
    {

        try {
            if (StringUtils.isEmpty(postparam)) {
                postparam = param;
            }

            if (UrlEncoderUtils.hasUrlEncoded(postparam)) {
                postparam = URLDecoder.decode(postparam);
            }

            // 将URL中KEY=VALUE模式的参数转换到JSON参数
            ServiceSession sessionobj = null;

            if (StringUtils.isEmpty(session)) {
                sessionobj = new ServiceSession();
            }
            else {
                sessionobj = JSON.parseObject(session, ServiceSession.class);
            }

            postparam = addQueryParamToJsonParam(sessionobj, postparam, "method", "session", "param", "filename");

            JSONObject json = JSONObject.parseObject(postparam);

            Object retdata = rcm.executeClassMethod(method, sessionobj, postparam);

            if (retdata instanceof ServiceResponse) {
                ServiceResponse res = (ServiceResponse) retdata;
                JSONObject  obj = (JSONObject) res.getData();
                String in = obj.getString("rptinfo");
                String filename = obj.getString("modulecode");
                BufferedOutputStream bos = null;
                response.setHeader("Content-disposition", "attachment;filename=Module_" + filename + ".txt");

                try {
                    bos = new BufferedOutputStream(response.getOutputStream());
                    byte[] buff = in.getBytes("utf-8");
                    bos.write(buff);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                finally {
                    if (bos != null) {
                        bos.close();
                    }
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }

        return null;
    }
    /**
     * http://localhost:8082/mall-report-webin/exportReport?method=mall.common.report.query&ent_id=0&token=f7a291d4-e173-4089-add1-b9c0d9550207&timestamp=1603261406787&format=json&app_key=mallui&ver=1.0&portalkey=cloud&sign_method=MD5&sign=203bf887fca91ea5b12fdfb60dc2d660&param=%7B%22page_no%22:1,%22page_size%22:20,%22muid%22:%22A0003%22,%22ismz%22:%22N%22,%22queryid%22:%22query_800515%22,%22business%22:%22work%22,%22summary_fld%22:%22hje%22,%22exporttype%22:%22Excel%22,%22moduleCode%22:%22800515%22%7D
     * @param method
     * @param session
     * @param param
     * @param postparam
     * @param headers
     * @return
     */
    @GET
    @Produces({"application/json", "application/octet-stream"})
    @Path("/exportReport")
    public Response callExportReportService(@QueryParam("method") String method, @QueryParam("session") String session, @QueryParam("param") String param,
                                            String postparam,
                                            @Context HttpHeaders headers)
    {

        try {
            if (StringUtils.isEmpty(postparam)) {
                postparam = param;
            }

            if (UrlEncoderUtils.hasUrlEncoded(postparam)) {
                postparam = URLDecoder.decode(postparam);
            }

            // 将URL中KEY=VALUE模式的参数转换到JSON参数
            ServiceSession sessionobj = null;

            if (StringUtils.isEmpty(session)) {
                sessionobj = new ServiceSession();
            }
            else {
                sessionobj = JSON.parseObject(session, ServiceSession.class);
            }

            postparam = addQueryParamToJsonParam(sessionobj, postparam, "method", "session", "param", "filename");

            JSONObject json = JSONObject.parseObject(postparam);

            SXSSFWorkbook sxssfWorkbook = null;
            OutputStream os = null;

            try {
                os = response.getOutputStream();

                if ("Excel".equalsIgnoreCase(json.getString("exporttype"))) {
                    sxssfWorkbook = new SXSSFWorkbook(1024);
                    ExcelComponent excel = SpringBeanFactory.getContext().getBean(ExcelComponent.class);
                    // 获取SXSSFWorkbook
                    String filename = excel.export(sxssfWorkbook, sessionobj, json);
                    response.setHeader("Content-Disposition", "attachment;filename=" + URLEncoder.encode(filename, "UTF-8"));
                    sxssfWorkbook.write(os);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            finally {
                try {
                    if (sxssfWorkbook != null) {
                        //处理SXSSFWorkbook导出excel时，产生的临时文件
                        sxssfWorkbook.dispose();
                    }

                    if (os != null) {
                        os.close();
                    }
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }

        return null;
    }

    @GET
    @Produces("text/plain;charset=UTF-8")
    @Path("/getphoto")
    public Response callGetphotoService(@QueryParam("method") String method, @QueryParam("session") String session, @QueryParam("param") String param,
                                        @QueryParam("filename") String filename,
                                        @Context HttpHeaders headers)
    {
        try {
            String postparam = null;

            // POST的数据为空则取URL中的param
            if (StringUtils.isEmpty(postparam)) {
                postparam = param;
            }

            // 将URL中KEY=VALUE模式的参数转换到JSON参数
            ServiceSession sessionobj = null;

            if (StringUtils.isEmpty(session)) {
                sessionobj = new ServiceSession();
            }
            else {
                sessionobj = JSON.parseObject(session, ServiceSession.class);
            }

            postparam = addQueryParamToJsonParam(sessionobj, postparam, "method", "session", "param", "filename");
            Object retdata = rcm.executeClassMethod(method, sessionobj, postparam);

            if (retdata == null) {
                return Response.ok("", "text/plain;charset=UTF-8").build();
            }
            else if (retdata instanceof ServiceResponse) {
                return Response.ok(JSON.toJSONString(retdata)).build();
            }
            else {
                ResponseBuilder builder = (ResponseBuilder) retdata;
                return builder.build();
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return Response.ok(Utils.getLastExceptionMessage(ex), "text/plain;charset=UTF-8").build();
        }
    }

    private Map<String, Object> getParameters(Form form)
    {
        Map<String, Object> result = new HashMap();

        for (Map.Entry<String, List<String>> entry : form.entrySet()) {
            List<String> value = (List) entry.getValue();

            if (!value.isEmpty()) {
                if (value.size() == 1) {
                    result.put(entry.getKey(), value.get(0));
                }
                else {
                    result.put(entry.getKey(), value);
                }
            }
        }

        return result;
    }

    private String addParamToJsonParam(ServiceSession session, HttpContext context, String... ignores)
    {
        Map<String, Object> map = new HashMap();
        String[] openkey = {"token", "access_token", "method", "app_key", "timestamp", "format", "ver", "version", "sign_method", "sign", "signature_method", "signature", "postid", "portalkey", "accessid"};
        String[] ss = null;

        if (session != null) {
            StringBuffer sb = new StringBuffer();
            String[] s = AbstractEntityBean.fetchAllDeclaredField(session.getClass(), sb).toString().split(",");
            ss = new String[openkey.length + s.length];

            for (int i = 0; i < openkey.length; i++) {
                ss[i] = openkey[i];
            }

            for (int i = 0; i < s.length; i++) {
                ss[(openkey.length + i)] = s[i];
            }
        }
        else {
            ss = openkey;
        }

        Map<String, String> rp = getParameter();
        //String portalkey = (String) rp.get("portalkey");
        //boolean iscongouportal = false;
        //if ((!StringUtils.isEmpty(portalkey)) && (portalkey.equalsIgnoreCase("congou"))) {
        //	iscongouportal = true;
        //}
        String portalkey = DataUtils.nvl((String) rp.get("portalkey"), UserDataRangeSrv.getPortalkey());
        boolean iscongouportal = false;

        if (!StringUtils.isEmpty(portalkey) && portalkey.equalsIgnoreCase("congou")) {
            iscongouportal = true;
        }

        Form form = context.getRequest().getFormParameters();
        Map<String, Object> rps = getParameters(form);
        map.putAll(rps);
        Iterator iter = rp.entrySet().iterator();

        while (iter.hasNext()) {
            Map.Entry entry = (Map.Entry) iter.next();
            String key = (String) entry.getKey();

            if (!Utils.stringArrayContainsKey(ignores, key, true)) {
                String[] values = this.request.getParameterValues(key);

                if ((values != null) && (values.length > 0) && (!StringUtils.isEmpty(values[0]))) {
                    String value = values[0];

                    if ((ss != null) && (Utils.stringArrayContainsKey(ss, key, true))) {
                        if (iscongouportal) {
                            setSessionbycongou(session, key, value);
                        }
                        else {
                            setSession(session, key, value);
                        }
                    }
                    else if (((value.startsWith("{")) && (value.endsWith("}"))) || ((value.startsWith("[")) && (value.endsWith("]")))) {
                        try {
                            map.put(key, JSON.parse(value));
                        }
                        catch (Exception ex) {
                            map.put(key, value);
                        }
                    }
                    else {
                        map.put(key, value);
                    }
                }
            }
        }

        if (SpringBeanFactory.containsBean("initSession_" + portalkey)) {
            InitSession init = SpringBeanFactory.getBean("initSession_" + portalkey, InitSession.class);
            init.init(session);
        }

        return JSONObject.toJSONString(map);
    }

    @POST
    @Produces({"text/plain;charset=UTF-8"})
    @Path("/restful")
    public String callRestServiceful(@QueryParam("method") String method, @QueryParam("session") String session, @QueryParam("param") String param,
                                     @Context HttpContext context)
    {
        String result = null;
        String remoteaddr = "";
        long logkey = 0L;
        String url = "";
        long start_time = System.currentTimeMillis();

        try {
            UserDataRangeSrv.setlocaltoken("");

            if (ServiceVersion.getInstance().isLogstatus()) {
                remoteaddr = getRemoteAddr();
                logkey = UniqueID.getUniqueID();
                url = this.request.getQueryString();
            }

            ServiceSession sessionobj = null;

            if (StringUtils.isEmpty(session)) {
                sessionobj = new ServiceSession();
            }
            else {
                sessionobj = (ServiceSession) JSON.parseObject(session, ServiceSession.class);
            }

            String postparam = addParamToJsonParam(sessionobj, context, new String[] {"method", "session", "param"});

            if (ServiceVersion.getInstance().isLogstatus()) {
                StringBuffer sb = new StringBuffer();
                sb.append("[" + remoteaddr + " - " + logkey + "]: ");
                sb.append(method + " , ");
                sb.append("REQUEST  : ");
                sb.append(postparam);
                sb.append(" , url : ");
                sb.append(url);
                ServiceVersion.getInstance().debugLog(sb.toString());
            }

            Object retdata = rcm.executeClassMethod(method, sessionobj, postparam);
            long end_time = System.currentTimeMillis();
            ServiceResponse response;

            if ((retdata instanceof ServiceResponse)) {
                response = (ServiceResponse) retdata;
                response.addElapsed("总耗时", start_time, end_time);

                if ((sessionobj != null) && (!"Y".equalsIgnoreCase(sessionobj.getDebug_status()))) {
                    if (!ServiceVersion.getInstance().isLogstatus()) {
                        response.setElapsed(null);
                    }

                    response.setWarnmsg(null);
                }
            }

            if (retdata == null) {
                result = "";
            }
            else if ((retdata instanceof String)) {
                result = (String) retdata;
            }
            else {
                result = JSON.toJSONString(Utils.toNormalJSONObject(retdata));
            }

            return result;
        }
        catch (ServiceException ex) {
            ex.printStackTrace();
            result = JSON.toJSONString(ServiceResponse.buildFailure(null, ex.getErrorCode(), ex.getMessage(), ex.getErrorArgs()));
            return result;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            result = JSON.toJSONString(ServiceResponse.buildFailure(null, "50000", Utils.getLastExceptionMessage(ex), new Object[0]));
            return result;
        }
        finally {
            if (ServiceVersion.getInstance().isLogstatus()) {
                StringBuffer sb = new StringBuffer();
                sb.append("[" + remoteaddr + " - " + logkey + "]: ");
                sb.append(method + " , ");
                sb.append("ELAPSED  : " + (System.currentTimeMillis() - start_time) + " ms , ");
                sb.append("RESPONSE : ");
                sb.append(result);
                ServiceVersion.getInstance().debugLog(sb.toString());
            }

            UserDataRangeSrv.setlocaltoken("");
        }
    }

    private FileServiceImpl createFileServiceImpl()
    {
        return SpringBeanFactory.getBean("fileExportService", FileServiceImpl.class);
    }

    @GET
    @Produces({"application/json", "application/octet-stream"})
    @Path("/exportExcel")
    public Response callExportExcelService(@QueryParam("method") String method, @QueryParam("session") String session, @QueryParam("param") String param,
                                           String postparam,
                                           @Context HttpHeaders headers)
    {
        String remoteaddr = "";
        long logkey = 0;
        String url = "";

        try {
            // POST的数据为空则取URL中的param
            if (StringUtils.isEmpty(postparam)) {
                postparam = param;
            }

            // 加强decode
            //			if (UrlEncoderUtils.hasUrlEncoded(postparam))
            //            {
            //                postparam = URLDecoder.decode(postparam);
            UserDataRangeSrv.setlocaltoken("");

            if (ServiceVersion.getInstance().isLogstatus()) {
                remoteaddr = getRemoteAddr();
                logkey = UniqueID.getUniqueID();
                url = request.getQueryString();
            }

            // 将URL中KEY=VALUE模式的参数转换到JSON参数
            ServiceSession sessionobj = null;

            if (StringUtils.isEmpty(session)) {
                sessionobj = new ServiceSession();
            }
            else {
                try {
                    sessionobj = JSON.parseObject(session, ServiceSession.class);
                }
                catch (Exception ex1) {
                    try {
                        session = URLDecoder.decode(session, "UTF-8");
                        sessionobj = JSON.parseObject(session, ServiceSession.class);
                    }
                    catch (Exception ex2) {
                        throw new Exception("Session:" + session + ", Error:" + ex2.getMessage());
                    }
                }
            }

            postparam = addQueryParamToJsonParam(sessionobj, postparam, "method", "session", "param");
            JSONObject json = JSONObject.parseObject(postparam);
            sessionobj.setRemoteaddr(remoteaddr);
            sessionobj.setLogkey(String.valueOf(logkey));
            sessionobj.setMethod(method);

            if (StringUtils.isEmpty(sessionobj.getParentkey())) {
                sessionobj.setParentkey(String.valueOf(logkey));
            }

            if (StringUtils.isEmpty(sessionobj.getRootkey())) {
                sessionobj.setRootkey(String.valueOf(logkey));
            }

            sessionobj.setUrl(url);
            locale.set(sessionobj);
            FileServiceImpl temp = createFileServiceImpl();
            //String head = request.getSession().getServletContext().getRealPath("/");
            String head = "/opt/logs/";
            temp.setHead(head);
            //生成文件
            String fileaname = temp.export(sessionobj, json);
            File fp = new File(fileaname);
            System.out.println(fp.getAbsolutePath());
            InputStream fis = new BufferedInputStream(new FileInputStream(fp.getPath()));
            byte[] buffer = new byte[fis.available()];
            fis.read(buffer);
            fis.close();
            // 清空response
            response.reset();

            // 4.删除压缩文件
            if (fp.exists() && fp.isFile()) {
                fp.delete();
            }

            ResponseBuilder builder = Response.ok(buffer);
            builder.header("Pragma", "No-cache");
            builder.header("Cache-Control", "No-cache");
            response.setDateHeader("Expires", 0);
            builder.header("Content-Disposition", Utils.builderContentDispositionFileName(headers, fp.getName()));
            response.setCharacterEncoding("UTF-8"); // 设置输出流为UTF-8
            builder.type("application/octet-stream");
            return builder.build();
        }
        catch (ServiceException ex) {
            ex.printStackTrace();
            String error = JSON.toJSONString(ServiceResponse.buildFailure(null, ex.getErrorCode(), ex.getMessage(), ex.getErrorArgs()));
            return Response.ok(error, "text/plain;charset=UTF-8").build();
        }
        catch (Exception ex) {
            ex.printStackTrace();
            String error = JSON.toJSONString(ServiceResponse.buildFailure(null, ResponseCode.EXCEPTION, Utils.getLastExceptionMessage(ex)));
            return Response.ok(error, "text/plain;charset=UTF-8").build();
        }
    }

    @GET
    @Produces({"application/json", "application/octet-stream"})
    @Path("/exportTemplate")
    public Response callExportTemplateService(@QueryParam("method") String method, @QueryParam("session") String session, @QueryParam("param") String param,
            String postparam,
            @Context HttpHeaders headers)
    {
        try {
            // POST的数据为空则取URL中的param
            if (StringUtils.isEmpty(postparam)) {
                postparam = param;
            }

            // 加强decode
            if (UrlEncoderUtils.hasUrlEncoded(postparam)) {
                postparam = URLDecoder.decode(postparam);
            }

            // 将URL中KEY=VALUE模式的参数转换到JSON参数
            ServiceSession sessionobj = null;

            if (StringUtils.isEmpty(session)) {
                sessionobj = new ServiceSession();
            }
            else {
                sessionobj = JSON.parseObject(session, ServiceSession.class);
            }

            JSONObject json = JSONObject.parseObject(postparam);
            FileServiceImpl temp = createFileServiceImpl();
            String head = request.getSession().getServletContext().getRealPath("/");
            temp.setHead(head);
            temp.setFilePath(head);
            //生成文件
            String fileaname = temp.exportTemplate(sessionobj, json);
            File fp = new File(fileaname);
            System.out.println(fp.getAbsolutePath());
            InputStream fis = new BufferedInputStream(new FileInputStream(fp.getPath()));
            byte[] buffer = new byte[fis.available()];
            fis.read(buffer);
            fis.close();
            // 清空response
            response.reset();

            // 4.删除压缩文件
            if (fp.exists() && fp.isFile()) {
                fp.delete();
            }

            ResponseBuilder builder = Response.ok(buffer);
            builder.header("Pragma", "No-cache");
            builder.header("Cache-Control", "No-cache");
            response.setDateHeader("Expires", 0);
            builder.header("Content-Disposition", Utils.builderContentDispositionFileName(headers, fp.getName()));
            response.setCharacterEncoding("UTF-8"); // 设置输出流为UTF-8
            builder.type("application/octet-stream");
            return builder.build();
        }
        catch (ServiceException ex) {
            ex.printStackTrace();
            String error = JSON.toJSONString(ServiceResponse.buildFailure(null, ex.getErrorCode(), ex.getMessage(), ex.getErrorArgs()));
            return Response.ok(error, "text/plain;charset=UTF-8").build();
        }
        catch (Exception ex) {
            ex.printStackTrace();
            String error = JSON.toJSONString(ServiceResponse.buildFailure(null, ResponseCode.EXCEPTION, Utils.getLastExceptionMessage(ex)));
            return Response.ok(error, "text/plain;charset=UTF-8").build();
        }
    }

    @GET
    @Produces({"application/json", "application/octet-stream"})
    @Path("/exportExcelTemplate")
    public Response callExportExcelTemplateService(@QueryParam("method") String method, @QueryParam("session") String session, @QueryParam("param") String param,
            String postparam,
            @Context HttpHeaders headers)
    {
        try {
            // POST的数据为空则取URL中的param
            if (StringUtils.isEmpty(postparam)) {
                postparam = param;
            }

            // 加强decode
            if (UrlEncoderUtils.hasUrlEncoded(postparam)) {
                postparam = URLDecoder.decode(postparam);
            }

            // 将URL中KEY=VALUE模式的参数转换到JSON参数
            ServiceSession sessionobj = null;

            if (StringUtils.isEmpty(session)) {
                sessionobj = new ServiceSession();
            }
            else {
                sessionobj = JSON.parseObject(session, ServiceSession.class);
            }

            JSONObject json = JSONObject.parseObject(postparam);
            ExcelComponent excel = SpringBeanFactory.getContext().getBean(ExcelComponent.class);
            Map<String, Object> map = excel.exportTemplate(sessionobj, json);
            InputStream fis = (InputStream) map.get("inputStream");
            String filename = (String) map.get("filename");
            byte[] buffer = new byte[fis.available()];
            fis.read(buffer);
            fis.close();
            // 清空response
            response.reset();
            ResponseBuilder builder = Response.ok(buffer);
            builder.header("Pragma", "No-cache");
            builder.header("Cache-Control", "No-cache");
            response.setDateHeader("Expires", 0);
            builder.header("Content-Disposition", Utils.builderContentDispositionFileName(headers, filename));
            response.setCharacterEncoding("UTF-8"); // 设置输出流为UTF-8
            builder.type("application/octet-stream");
            return builder.build();
        }
        catch (ServiceException ex) {
            ex.printStackTrace();
            String error = JSON.toJSONString(ServiceResponse.buildFailure(null, ex.getErrorCode(), ex.getMessage(), ex.getErrorArgs()));
            return Response.ok(error, "text/plain;charset=UTF-8").build();
        }
        catch (Exception ex) {
            ex.printStackTrace();
            String error = JSON.toJSONString(ServiceResponse.buildFailure(null, ResponseCode.EXCEPTION, Utils.getLastExceptionMessage(ex)));
            return Response.ok(error, "text/plain;charset=UTF-8").build();
        }
    }

    @GET
    @Produces({"application/json", "application/octet-stream"})
    @Path("/exportLC")
    public Response callExportLCService(@QueryParam("method") String method, @QueryParam("session") String session, @QueryParam("param") String param,
                                        String postparam,
                                        @Context HttpHeaders headers)
    {
        try {
            // POST的数据为空则取URL中的param
            if (StringUtils.isEmpty(postparam)) {
                postparam = param;
            }

            // 加强decode
            if (UrlEncoderUtils.hasUrlEncoded(postparam)) {
                postparam = URLDecoder.decode(postparam);
            }

            // 将URL中KEY=VALUE模式的参数转换到JSON参数
            ServiceSession sessionobj = null;

            if (StringUtils.isEmpty(session)) {
                sessionobj = new ServiceSession();
            }
            else {
                sessionobj = JSON.parseObject(session, ServiceSession.class);
            }

            JSONObject json = JSONObject.parseObject(postparam);
            FileServiceImpl temp = createFileServiceImpl();
            String head = request.getSession().getServletContext().getRealPath("/");
            temp.setHead(head);
            temp.setFilePath(head);
            //生成文件
            String fileaname = temp.exportLC(sessionobj, json);
            File fp = new File(fileaname);
            System.out.println(fp.getAbsolutePath());
            InputStream fis = new BufferedInputStream(new FileInputStream(fp.getPath()));
            byte[] buffer = new byte[fis.available()];
            fis.read(buffer);
            fis.close();
            // 清空response
            response.reset();

            // 4.删除压缩文件
            if (fp.exists() && fp.isFile()) {
                fp.delete();
            }

            ResponseBuilder builder = Response.ok(buffer);
            builder.header("Pragma", "No-cache");
            builder.header("Cache-Control", "No-cache");
            response.setDateHeader("Expires", 0);
            builder.header("Content-Disposition", Utils.builderContentDispositionFileName(headers, fp.getName()));
            response.setCharacterEncoding("UTF-8"); // 设置输出流为UTF-8
            builder.type("application/octet-stream");
            return builder.build();
        }
        catch (ServiceException ex) {
            ex.printStackTrace();
            String error = JSON.toJSONString(ServiceResponse.buildFailure(null, ex.getErrorCode(), ex.getMessage(), ex.getErrorArgs()));
            return Response.ok(error, "text/plain;charset=UTF-8").build();
        }
        catch (Exception ex) {
            ex.printStackTrace();
            String error = JSON.toJSONString(ServiceResponse.buildFailure(null, ResponseCode.EXCEPTION, Utils.getLastExceptionMessage(ex)));
            return Response.ok(error, "text/plain;charset=UTF-8").build();
        }
    }

    @GET
    @Produces({"application/json", "application/octet-stream"})
    @Path("/exportNC")
    public Response callExportNCService(@QueryParam("method") String method, @QueryParam("session") String session, @QueryParam("param") String param,
                                        String postparam,
                                        @Context HttpHeaders headers)
    {
        try {
            // POST的数据为空则取URL中的param
            if (StringUtils.isEmpty(postparam)) {
                postparam = param;
            }

            // 加强decode
            if (UrlEncoderUtils.hasUrlEncoded(postparam)) {
                postparam = URLDecoder.decode(postparam);
            }

            // 将URL中KEY=VALUE模式的参数转换到JSON参数
            ServiceSession sessionobj = null;

            if (StringUtils.isEmpty(session)) {
                sessionobj = new ServiceSession();
            }
            else {
                sessionobj = JSON.parseObject(session, ServiceSession.class);
            }

            JSONObject json = JSONObject.parseObject(postparam);
            FileServiceImpl temp = createFileServiceImpl();
            String head = request.getSession().getServletContext().getRealPath("/");
            temp.setHead(head);
            temp.setFilePath(head);
            //生成文件
            String fileaname = temp.exportNC(sessionobj, json);
            File fp = new File(fileaname);
            System.out.println(fp.getAbsolutePath());
            InputStream fis = new BufferedInputStream(new FileInputStream(fp.getPath()));
            byte[] buffer = new byte[fis.available()];
            fis.read(buffer);
            fis.close();
            // 清空response
            response.reset();

            // 4.删除压缩文件
            if (fp.exists() && fp.isFile()) {
                fp.delete();
            }

            ResponseBuilder builder = Response.ok(buffer);
            builder.header("Pragma", "No-cache");
            builder.header("Cache-Control", "No-cache");
            response.setDateHeader("Expires", 0);
            builder.header("Content-Disposition", Utils.builderContentDispositionFileName(headers, fp.getName()));
            response.setCharacterEncoding("UTF-8"); // 设置输出流为UTF-8
            builder.type("application/octet-stream");
            return builder.build();
        }
        catch (ServiceException ex) {
            ex.printStackTrace();
            String error = JSON.toJSONString(ServiceResponse.buildFailure(null, ex.getErrorCode(), ex.getMessage(), ex.getErrorArgs()));
            return Response.ok(error, "text/plain;charset=UTF-8").build();
        }
        catch (Exception ex) {
            ex.printStackTrace();
            String error = JSON.toJSONString(ServiceResponse.buildFailure(null, ResponseCode.EXCEPTION, Utils.getLastExceptionMessage(ex)));
            return Response.ok(error, "text/plain;charset=UTF-8").build();
        }
    }

    @GET
    @Produces({"application/json", "application/octet-stream"})
    @Path("/exportPrint")
    public Response callExportPrintService(@QueryParam("method") String method, @QueryParam("session") String session, @QueryParam("param") String param,
                                           String postparam,
                                           @Context HttpHeaders headers)
    {
        try {
            // POST的数据为空则取URL中的param
            if (StringUtils.isEmpty(postparam)) {
                postparam = param;
            }

            // 加强decode
            if (UrlEncoderUtils.hasUrlEncoded(postparam)) {
                postparam = URLDecoder.decode(postparam);
            }

            // 将URL中KEY=VALUE模式的参数转换到JSON参数
            ServiceSession sessionobj = null;

            if (StringUtils.isEmpty(session)) {
                sessionobj = new ServiceSession();
            }
            else {
                sessionobj = JSON.parseObject(session, ServiceSession.class);
            }

            JSONObject json = JSONObject.parseObject(postparam);
            String fileaname = json.getString("data");
            File fp = new File(fileaname);
            System.out.println(fp.getAbsolutePath());
            InputStream fis = new BufferedInputStream(new FileInputStream(fp.getPath()));
            byte[] buffer = new byte[fis.available()];
            fis.read(buffer);
            fis.close();
            // 清空response
            response.reset();

            // 4.删除压缩文件
            if (fp.exists() && fp.isFile()) {
                fp.delete();
            }

            ResponseBuilder builder = Response.ok(buffer);
            builder.header("Pragma", "No-cache");
            builder.header("Cache-Control", "No-cache");
            response.setDateHeader("Expires", 0);
            builder.header("Content-Disposition", Utils.builderContentDispositionFileName(headers, fp.getName()));
            response.setCharacterEncoding("UTF-8"); // 设置输出流为UTF-8
            builder.type("application/octet-stream");
            return builder.build();
        }
        catch (ServiceException ex) {
            ex.printStackTrace();
            String error = JSON.toJSONString(ServiceResponse.buildFailure(null, ex.getErrorCode(), ex.getMessage(), ex.getErrorArgs()));
            return Response.ok(error, "text/plain;charset=UTF-8").build();
        }
        catch (Exception ex) {
            ex.printStackTrace();
            String error = JSON.toJSONString(ServiceResponse.buildFailure(null, ResponseCode.EXCEPTION, Utils.getLastExceptionMessage(ex)));
            return Response.ok(error, "text/plain;charset=UTF-8").build();
        }
    }

    @POST
    @Produces("text/plain;charset=UTF-8")
    @Path("/createExcel")
    public String callcreateExcelService(@QueryParam("method") String method, @QueryParam("session") String session, @QueryParam("param") String param,
                                         String postparam)
    {
        String result = null;
        String remoteaddr = "";
        String rtncode = "0";

        try {
            // POST的数据为空则取URL中的param
            if (StringUtils.isEmpty(postparam)) {
                postparam = param;
            }

            // 加强decode
            if (UrlEncoderUtils.hasUrlEncoded(postparam)) {
                postparam = URLDecoder.decode(postparam);
            }

            // 将URL中KEY=VALUE模式的参数转换到JSON参数
            ServiceSession sessionobj = null;

            if (StringUtils.isEmpty(session)) {
                sessionobj = new ServiceSession();
            }
            else {
                sessionobj = JSON.parseObject(session, ServiceSession.class);
            }

            JSONObject json = JSONObject.parseObject(postparam);
            FileServiceImpl temp = createFileServiceImpl();
            String head = request.getSession().getServletContext().getRealPath("/");
            temp.setHead(head);
            temp.setFilePath(head);
            //生成文件
            String retdata = temp.exportExcelPrint(sessionobj, json);
            Map<String, String> m = new HashMap<String, String>();
            m.put("data", retdata);
            m.put("returncode", rtncode);
            result = JSON.toJSONString(Utils.toNormalJSONObject(m));
            return result;
        }
        catch (ServiceException ex) {
            ex.printStackTrace();
            result = JSON.toJSONString(ServiceResponse.buildFailure(null, ex.getErrorCode(), ex.getMessage(), ex.getErrorArgs()));
            rtncode = ex.getErrorCode();
            return result;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            result = JSON.toJSONString(ServiceResponse.buildFailure(null, ResponseCode.EXCEPTION, Utils.getLastExceptionMessage(ex)));
            rtncode = "555";
            return result;
        }
        finally {
            locale.remove();
        }
    }

    /*Pdf文件预览*/
    @GET
    @Produces({"application/json", "application/octet-stream"})
    @Path("/previewPdf")
    public Response callPreviewPdfService(@QueryParam("method") String method, @QueryParam("session") String session, @QueryParam("param") String param,
                                          String postparam,
                                          @Context HttpHeaders headers)
    {
        try {
            // POST的数据为空则取URL中的param
            if (StringUtils.isEmpty(postparam)) {
                postparam = param;
            }

            // 加强decode�?
            if (UrlEncoderUtils.hasUrlEncoded(postparam)) {
                postparam = URLDecoder.decode(postparam);
            }

            // 将URL中KEY=VALUE模式的参数转换到JSON参数
            ServiceSession sessionobj = null;

            if (StringUtils.isEmpty(session)) {
                sessionobj = new ServiceSession();
            }
            else {
                sessionobj = JSON.parseObject(session, ServiceSession.class);
            }

            postparam = addQueryParamToJsonParam(sessionobj, postparam, "method", "session", "param", "filename");
            // 执行导出服务
            Object retdata = rcm.executeClassMethod(method, sessionobj, postparam);
            ServiceResponse resultParam = (ServiceResponse) retdata;
            JSONObject para = (JSONObject) resultParam.getData();

            if (!"1".equals(para.getString("flag"))) {
                return (Response) retdata;
            }

            String filename = para.getString("filename");
            File file = new File(filename);
            System.out.println(file.getAbsolutePath());
            response.reset(); // 清空response
            response.setDateHeader("Expires", 0);
            response.setCharacterEncoding("UTF-8"); // 设置输出流为UTF-8
            FileInputStream fileInputStream = new FileInputStream(file);
            response.setHeader("Content-Type", "application/pdf");
            OutputStream outputStream = response.getOutputStream();
            IOUtils.write(IOUtils.toByteArray(fileInputStream), outputStream);
            outputStream.flush();
            outputStream.close();
            fileInputStream.close();

            if (file.exists() && file.isFile()) {
                boolean result = file.delete();
                int tryCount = 0;

                while (!result && tryCount++ < 10) {
                    System.gc();    //回收资源
                    result = file.delete();
                }
            }

            return null;
        }
        catch (ServiceException ex) {
            ex.printStackTrace();
            String error = JSON.toJSONString(ServiceResponse.buildFailure(null, ex.getErrorCode(), ex.getMessage(), ex.getErrorArgs()));
            return Response.ok(error, "text/plain;charset=UTF-8").build();
        }
        catch (Exception ex) {
            ex.printStackTrace();
            String error = JSON.toJSONString(ServiceResponse.buildFailure(null, ResponseCode.EXCEPTION, Utils.getLastExceptionMessage(ex)));
            return Response.ok(error, "text/plain;charset=UTF-8").build();
        }
    }

    @GET
    @Produces("text/plain;charset=UTF-8")
    @Path("/exportbyfile")
    public Response callExportByFileService(@QueryParam("method") String method, @QueryParam("session") String session, @QueryParam("param") String param,
                                            String postparam,
                                            @QueryParam("filename") String filename, @Context HttpHeaders headers)
    {
        try {
            // POST的数据为空则取URL中的param
            if (StringUtils.isEmpty(postparam)) {
                postparam = param;
            }

            // 加强decode�?
            if (UrlEncoderUtils.hasUrlEncoded(postparam)) {
                postparam = URLDecoder.decode(postparam);
            }

            // 将URL中KEY=VALUE模式的参数转换到JSON参数
            ServiceSession sessionobj = null;

            if (StringUtils.isEmpty(session)) {
                sessionobj = new ServiceSession();
            }
            else {
                sessionobj = JSON.parseObject(session, ServiceSession.class);
            }

            postparam = addQueryParamToJsonParam(sessionobj, postparam, "method", "session", "param", "filename");
            // 执行导出服务
            Object retdata = rcm.executeClassMethod(method, sessionobj, postparam);

            // 返回String表示生成XLS的XML描述,可用XLS打开
            if (retdata == null) {
                return Response.ok("", "text/plain;charset=UTF-8").build();
            }
            else if (retdata instanceof ServiceResponse) {
                return Response.ok(JSON.toJSONString(retdata), "text/plain;charset=UTF-8").build();
            }
            else {
                // Firefox需要对中文文件名进行编
                //filename = "export.xls";
                String headType = "application/octet-stream";
                String s = String.valueOf(retdata).toLowerCase();
                //				if (s.endsWith(".xls") || s.endsWith(".xlsx")) {
                //					headType = "application/ms-excel";
                //				}
                File fp = new File(s);
                filename = fp.getName();
                ResponseBuilder builder = null;

                if (filename.endsWith(".xls") || filename.endsWith(".xlsx") || filename.endsWith(".rar") || filename.endsWith("txt")) {
                    builder = Response.ok(fp);
                }
                else {
                    builder = Response.ok(retdata);
                    filename = "export.xls";
                }

                builder.header("Pragma", "No-cache");
                builder.header("Cache-Control", "No-cache");
                response.setDateHeader("Expires", 0);
                builder.header("Content-Disposition", Utils.builderContentDispositionFileName(headers, filename));

                //				response.setCharacterEncoding("UTF-8"); // 设置输出流为UTF-8
                //				response.addHeader("Content-Length", String.valueOf(fp.length()));
                //				builder.type(headType);
                if (retdata instanceof String) {
                    response.setCharacterEncoding("UTF-8"); // 设置输出流为UTF-8
                    //response.addHeader("Content-Length", String.valueOf(fp.length()));
                    response.setContentType("text/plain");
                    builder.type("application/octet-stream"); // 设置文件
                }
                else {
                    builder.type("application/octet-stream"); // 设置文件
                }

                return builder.build();
            }
        }
        catch (ServiceException ex) {
            ex.printStackTrace();
            String error = JSON.toJSONString(ServiceResponse.buildFailure(null, ex.getErrorCode(), ex.getMessage(), ex.getErrorArgs()));
            return Response.ok(error, "text/plain;charset=UTF-8").build();
        }
        catch (Exception ex) {
            ex.printStackTrace();
            String error = JSON.toJSONString(ServiceResponse.buildFailure(null, ResponseCode.EXCEPTION, Utils.getLastExceptionMessage(ex)));
            return Response.ok(error, "text/plain;charset=UTF-8").build();
        }
    }

    @GET
    @Produces("text/plain;charset=GBK")
    @Path("/exportcustomrar")
    public Response callExportServiceOcmCustomrar(@QueryParam("method") String method, @QueryParam("session") String session, @QueryParam("param") String param,
            String postparam,
            @Context HttpHeaders headers)
    {
        try {
            // POST的数据为空则取URL中的param
            if (StringUtils.isEmpty(postparam)) {
                postparam = param;
            }

            // 加强decode
            if (UrlEncoderUtils.hasUrlEncoded(postparam)) {
                postparam = URLDecoder.decode(postparam);
            }

            // 将URL中KEY=VALUE模式的参数转换到JSON参数
            ServiceSession sessionobj = null;

            if (StringUtils.isEmpty(session)) {
                sessionobj = new ServiceSession();
            }
            else {
                sessionobj = JSON.parseObject(session, ServiceSession.class);
            }

            postparam = addQueryParamToJsonParam(sessionobj, postparam, "method", "session", "param", "filename");
            // 执行导出服务
            Object retdata = rcm.executeClassMethod(method, sessionobj, postparam);
            ServiceResponse resultParam = (ServiceResponse) retdata;
            JSONObject para = (JSONObject) resultParam.getData();
            String filename = para.getString("filename");
            File file = new File(filename);
            System.out.println(file.getAbsolutePath());
            // Firefox需要对中文文件名进行编
            // 读取filename文件内容
            InputStream fis = new BufferedInputStream(new FileInputStream(file.getPath()));
            byte[] buffer = new byte[fis.available()];
            fis.read(buffer);
            fis.close();
            // 清空response
            response.reset();

            if (file.exists() && file.isFile()) {
                boolean result = file.delete();
                int tryCount = 0;

                while (!result && tryCount++ < 10) {
                    System.gc();    //回收资源
                    result = file.delete();
                }
            }

            ResponseBuilder builder = Response.ok(buffer);
            builder.header("Pragma", "No-cache");
            builder.header("Cache-Control", "No-cache");
            response.setDateHeader("Expires", 0);
            builder.header("Content-Disposition", Utils.builderContentDispositionFileName(headers, file.getName()));
            response.setCharacterEncoding("GBK"); // 设置输出流为UTF-8
            // 设置输出文件类型
            builder.type("text/plain");
            return builder.build();
        }
        catch (ServiceException ex) {
            ex.printStackTrace();
            String error = JSON.toJSONString(ServiceResponse.buildFailure(null, ex.getErrorCode(), ex.getMessage(), ex.getErrorArgs()));
            return Response.ok(error, "text/plain;charset=GBK").build();
        }
        catch (Exception ex) {
            ex.printStackTrace();
            String error = JSON.toJSONString(ServiceResponse.buildFailure(null, ResponseCode.EXCEPTION, Utils.getLastExceptionMessage(ex)));
            return Response.ok(error, "text/plain;charset=GBK").build();
        }
    }

    @GET
    @Produces({"application/json", "application/octet-stream"})
    @Path("/exportComplexExcel")
    public Response callExportComplexExcelService(@QueryParam("method") String method, @QueryParam("session") String session, @QueryParam("param") String param,
            String postparam,
            @Context HttpHeaders headers)
    {
        String remoteaddr = "";
        long logkey = 0;
        String url = "";

        try {
            // POST的数据为空则取URL中的param
            if (StringUtils.isEmpty(postparam)) {
                postparam = param;
            }

            // 加强decode
            //			if (UrlEncoderUtils.hasUrlEncoded(postparam))
            //            {
            //                postparam = URLDecoder.decode(postparam);
            UserDataRangeSrv.setlocaltoken("");

            if (ServiceVersion.getInstance().isLogstatus()) {
                remoteaddr = getRemoteAddr();
                logkey = UniqueID.getUniqueID();
                url = request.getQueryString();
            }

            // 将URL中KEY=VALUE模式的参数转换到JSON参数
            ServiceSession sessionobj = null;

            if (StringUtils.isEmpty(session)) {
                sessionobj = new ServiceSession();
            }
            else {
                try {
                    sessionobj = JSON.parseObject(session, ServiceSession.class);
                }
                catch (Exception ex1) {
                    try {
                        session = URLDecoder.decode(session, "UTF-8");
                        sessionobj = JSON.parseObject(session, ServiceSession.class);
                    }
                    catch (Exception ex2) {
                        throw new Exception("Session:" + session + ", Error:" + ex2.getMessage());
                    }
                }
            }

            postparam = addQueryParamToJsonParam(sessionobj, postparam, "method", "session", "param");
            JSONObject json = JSONObject.parseObject(postparam);
            sessionobj.setRemoteaddr(remoteaddr);
            sessionobj.setLogkey(String.valueOf(logkey));
            sessionobj.setMethod(method);

            if (StringUtils.isEmpty(sessionobj.getParentkey())) {
                sessionobj.setParentkey(String.valueOf(logkey));
            }

            if (StringUtils.isEmpty(sessionobj.getRootkey())) {
                sessionobj.setRootkey(String.valueOf(logkey));
            }

            sessionobj.setUrl(url);
            locale.set(sessionobj);
            // 执行导出服务
            Object retdata = rcm.executeClassMethod(method, sessionobj, postparam);
            ServiceResponse resultParam = (ServiceResponse) retdata;
            JSONObject para = (JSONObject) resultParam.getData();
            List<Map<String, Object>> report = (List<Map<String, Object>>) para.get("report");

            if (report == null) {
                report = new ArrayList<Map<String, Object>>();
            }

            FileServiceImpl fileSrv = createFileServiceImpl();
            String filePath = request.getSession().getServletContext().getRealPath("/");
            fileSrv.setFilePath(filePath);
            //生成文件
            String fileaname = fileSrv.exportComplex(sessionobj, json, report);
            File fp = new File(fileaname);
            System.out.println(fp.getAbsolutePath());
            InputStream fis = new BufferedInputStream(new FileInputStream(fp.getPath()));
            byte[] buffer = new byte[fis.available()];
            fis.read(buffer);
            fis.close();
            // 清空response
            response.reset();

            // 4.删除压缩文件
            if (fp.exists() && fp.isFile()) {
                fp.delete();
            }

            ResponseBuilder builder = Response.ok(buffer);
            builder.header("Pragma", "No-cache");
            builder.header("Cache-Control", "No-cache");
            response.setDateHeader("Expires", 0);
            builder.header("Content-Disposition", Utils.builderContentDispositionFileName(headers, fp.getName()));
            response.setCharacterEncoding("UTF-8"); // 设置输出流为UTF-8
            builder.type("application/octet-stream");
            return builder.build();
        }
        catch (ServiceException ex) {
            ex.printStackTrace();
            String error = JSON.toJSONString(ServiceResponse.buildFailure(null, ex.getErrorCode(), ex.getMessage(), ex.getErrorArgs()));
            return Response.ok(error, "text/plain;charset=UTF-8").build();
        }
        catch (Exception ex) {
            ex.printStackTrace();
            String error = JSON.toJSONString(ServiceResponse.buildFailure(null, ResponseCode.EXCEPTION, Utils.getLastExceptionMessage(ex)));
            return Response.ok(error, "text/plain;charset=UTF-8").build();
        }
    }

    @POST
    @Path("/upload")
    @Produces("text/plain;charset=UTF-8")
    @Consumes({MediaType.MULTIPART_FORM_DATA})
    public String upLoadFile(FormDataMultiPart form, @QueryParam("method") String method, @QueryParam("session") String session) throws Exception
    {
        String result = null;
        String rtncode = "0";
        // 将URL中KEY=VALUE模式的参数转换到JSON参数
        ServiceSession sessionobj = null;
        // 记录开始时
        long start_time = System.currentTimeMillis();

        try {
            if (StringUtils.isEmpty(session)) {
                sessionobj = new ServiceSession();
            }
            else {
                sessionobj = JSON.parseObject(session, ServiceSession.class);
            }

            Map<String, List<FormDataBodyPart>> mapFormData = form.getFields();
            Set<String> keys = mapFormData.keySet();
            JSONObject jsonparam = new JSONObject();
            List<FormDataBodyPart> fileparts = new ArrayList<FormDataBodyPart>();

            for (Iterator<String> it = keys.iterator(); it.hasNext();) {
                String key = (String) it.next();
                List<FormDataBodyPart> parts = mapFormData.get(key);

                for (int i = 0; i < parts.size(); i++) {
                    FormDataBodyPart part = parts.get(i);
                    String filename = part.getContentDisposition().getFileName();

                    if (part != null && filename != null) {
                        fileparts.add(parts.get(i));
                        System.out.println(key + ":" + filename);
                    }
                    else {
                        jsonparam.put(key, parts.get(0).getValue());
                    }
                }
            }

            Object retdata = rcm.executeClassMethodForJSONListParam(method, sessionobj, jsonparam, fileparts);
            // 记录结束时间
            long end_time = System.currentTimeMillis();

            if (retdata instanceof ServiceResponse) {
                ServiceResponse response = (ServiceResponse) retdata;
                response.addElapsed("总耗时", start_time, end_time);
                response.setLogkey(sessionobj.getLogkey());

                // 非调试状态不输出日志
                if (sessionobj != null && !"Y".equalsIgnoreCase(sessionobj.getDebug_status())) {
                    // 记录输入输出日志时总是记录耗时数据
                    if (!ServiceVersion.getInstance().isLogstatus()) {
                        response.setElapsed(null);
                    }

                    response.setWarnmsg(null);
                }

                rtncode = response.getReturncode();
            }

            if (retdata == null) {
                result = "";
            }
            else if (retdata instanceof String) {
                result = (String) retdata;
            }
            else {
                result = JSON.toJSONString(Utils.toNormalJSONObject(retdata));
            }

            return result;
        }
        catch (ServiceException ex) {
            ex.printStackTrace();
            result = JSON.toJSONString(ServiceResponse.buildFailure(sessionobj, ex.getErrorCode(), ex.getMessage(), ex.getErrorArgs()));
            rtncode = ex.getErrorCode();
            return result;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            result = JSON.toJSONString(ServiceResponse.buildFailure(sessionobj, ResponseCode.EXCEPTION, Utils.getLastExceptionMessage(ex)));
            rtncode = "555";
            return result;
        }
    }

    @GET
    @Path("/exportFile")
    @Produces({"application/json", "application/octet-stream"})
    public Response exportFile(@QueryParam("method") String method, @QueryParam("session") String session, @QueryParam("param") String param,
                               @Context HttpHeaders headers) throws Exception
    {
        ResponseBuilder builder = null;
        JSONObject param2 = JSON.parseObject(param);
        param2.put("filepathhead", request.getSession().getServletContext().getRealPath("/"));
        String temp = callRestService(method, session, param2.toJSONString(), null);

        if (temp == null || StringUtils.isEmpty(temp)) {
            return Response.ok("下载失败", "text/plain;charset=UTF-8").build();
        }

        JSONObject result = JSON.parseObject(temp);
        JSONObject jsonparam = JSON.parseObject(param);
        String contentDisposition = "attachment; ";

        if (!result.containsKey("filename") || StringUtils.isEmpty(result.getString("filename"))) {
            return Response.ok("下载失败", "text/plain;charset=UTF-8").build();
        }

        String filename = result.getString("filename");
        String browser = headers.getRequestHeader(HttpHeaders.USER_AGENT).toString();
        byte[] buffer = null;

        if (browser != null && browser.toLowerCase().indexOf("firefox") > 0) {
            contentDisposition += "filename*=UTF-8''" + filename;
        }
        else {
            contentDisposition += "filename=" + filename;
        }

        if ((!result.containsKey("filepath") || StringUtils.isEmpty(result.get("filepath"))) && (!result.containsKey("file")
                || StringUtils.isEmpty(result.get("file")))) {
            return Response.ok("下载失败", "text/plain;charset=UTF-8").build();
        }

        if (!StringUtils.isEmpty(result.get("filepath"))) {
            File fp = new File(result.getString("filepath"));
            InputStream fis = new BufferedInputStream(new FileInputStream(fp.getPath()));
            buffer = new byte[fis.available()];
            fis.read(buffer);
            fis.close();

            // 删除压缩文件
            if (fp.exists() && fp.isFile()) {
                fp.delete();
            }
        }
        else {
            buffer = result.getBytes("file");
        }

        if (!StringUtils.isEmpty(jsonparam.get("encoded"))) {
            builder = Response.ok(new String(buffer, jsonparam.getString("encoded")));
        }
        else {
            if (filename.endsWith("txt") || filename.endsWith("TXT")) {
                builder = Response.ok(new String(buffer, "GBK"));
            }
            else {
                builder = Response.ok(buffer);
            }
        }

        builder.header("Content-Disposition", contentDisposition);
        builder.type("application/octet-stream");
        return builder.build();
    }

    @GET
    @Produces("text/plain;charset=UTF-8")
    @Path("/exportgroup")
    public Response callExportServiceGrpGET(@QueryParam("method") String method, @QueryParam("session") String session,
                                            @QueryParam("param") String param, @QueryParam("filename") String filename, @Context HttpHeaders headers)
    {
        return callExportServiceGrpPost(method, session, param, null, filename, headers);
    }

    @POST
    @Produces("text/plain;charset=UTF-8")
    @Path("/exportgroup")
    public Response callExportServiceGrpPost(@QueryParam("method") String method, @QueryParam("session") String session,
            @QueryParam("param") String param, String postparam, @QueryParam("filename") String filename,
            @Context HttpHeaders headers)
    {
        try {
            // POST的数据为空则取URL中的param
            if (StringUtils.isEmpty(postparam)) {
                postparam = param;
            }

            // 将URL中KEY=VALUE模式的参数转换到JSON参数中
            ServiceSession sessionobj = null;

            if (StringUtils.isEmpty(session)) {
                sessionobj = new ServiceSession();
            }
            else {
                sessionobj = JSON.parseObject(session, ServiceSession.class);
            }

            postparam = addQueryParamToJsonParam(sessionobj, postparam, "method", "session", "param", "filename");
            // 执行导出服务
            Object retdata = rcm.executeClassMethod(method, sessionobj, postparam);

            // 返回String表示生成XLS的XML描述串,可用XLS打开
            if (retdata == null) {
                return Response.ok("", "text/plain;charset=UTF-8").build();
            }
            else if (retdata instanceof ServiceResponse) {
                return Response.ok(JSON.toJSONString(retdata), "text/plain;charset=UTF-8").build();
            }
            else {
                if (StringUtils.isEmpty(filename)) {
                    filename = "custgroup.xls";
                }

                String headType = "application/octet-stream";
                String s = String.valueOf(retdata).toLowerCase();

                if (s.endsWith(".xls") || s.endsWith(".xlsx")) {
                    headType = "application/ms-excel";
                }

                File fp = new File(s);
                filename = fp.getName();
                ResponseBuilder builder = Response.ok(fp);
                builder.header("Pragma", "No-cache");
                builder.header("Cache-Control", "No-cache");
                response.setDateHeader("Expires", 0);
                builder.header("Content-Disposition", Utils.builderContentDispositionFileName(headers, filename));
                response.setCharacterEncoding("UTF-8"); // 设置输出流为UTF-8
                builder.type(headType);
                return builder.build();
            }
        }
        catch (ServiceException ex) {
            ex.printStackTrace();
            String error = JSON.toJSONString(
                               ServiceResponse.buildFailure(null, ex.getErrorCode(), ex.getMessage(), ex.getErrorArgs()));
            return Response.ok(error, "text/plain;charset=UTF-8").build();
        }
        catch (Exception ex) {
            ex.printStackTrace();
            String error = JSON.toJSONString(
                               ServiceResponse.buildFailure(null, ResponseCode.EXCEPTION, Utils.getLastExceptionMessage(ex)));
            return Response.ok(error, "text/plain;charset=UTF-8").build();
        }
    }

    @GET
    @Path("/captcha")
    @Produces({"application/octet-stream"})
    public Response previewCaptcha(@QueryParam("method") String method, @QueryParam("session") String session, @QueryParam("param") String param,
                                   @Context HttpHeaders headers, @Context HttpContext context) throws Exception
    {
        long start_time = System.currentTimeMillis();
        ServiceSession sessionobj = null;

        if (StringUtils.isEmpty(session)) {
            sessionobj = new ServiceSession();
        }
        else {
            sessionobj = JSON.parseObject(session, ServiceSession.class);
        }

        String postparam = addParamToJsonParam(sessionobj, context.getRequest().getFormParameters(), new String[] {"method", "session", "param"});
        response.setDateHeader("Expires", 0);
        // Set standard HTTP/1.1 no-cache headers.
        response.setHeader("Cache-Control", "no-store, no-cache, must-revalidate");
        // Set IE extended HTTP/1.1 no-cache headers (use addHeader).
        response.addHeader("Cache-Control", "post-check=0, pre-check=0");
        // Set standard HTTP/1.0 no-cache header.
        response.setHeader("Pragma", "no-cache");
        // return a jpeg
        response.setContentType("image/jpeg");
        Object retdata = rcm.executeClassMethod(method, sessionobj, postparam);

        if (retdata instanceof ServiceResponse && ((ServiceResponse) retdata).getReturncode().equals(ResponseCode.SUCCESS)) {
            JSONObject data = (JSONObject) ((ServiceResponse) retdata).getData();

            if (data.containsKey("capBuff") && data.get("capBuff") instanceof BufferedImage) {
                BufferedImage bi = (BufferedImage) data.get("capBuff");
                ServletOutputStream out = response.getOutputStream();
                // write the data out
                ImageIO.write(bi, "jpg", out);

                try {
                    out.flush();
                }
                finally {
                    out.close();
                }
            }
        }

        return null;
    }

    private static String getURLParamStrFromMap(Map<String, Object> params) {
        StringBuilder sb = new StringBuilder();
        if ((params != null) && (!params.isEmpty())) {
            String[] keys = params.keySet().toArray(new String[0]);
            Arrays.sort(keys);
            for (int i = 0; i < keys.length; i++) {
                String name = keys[i];
                if (sb.length() > 0) {
                    sb.append("&");
                }
                sb.append(name);
                sb.append("=");
                sb.append((String) params.get(name));
            }
        }
        return sb.toString();
    }

    private String addParamToJsonParam(ServiceSession session, Form form, String... ignores)
    {
        Map<String, Object> map = new HashMap();
        String[] openkey = {"token", "access_token", "method", "app_key", "timestamp", "format", "ver", "version", "sign_method", "sign", "signature_method", "signature", "postid", "portalkey", "accessid"};
        String[] ss = null;

        if (session != null) {
            StringBuffer sb = new StringBuffer();
            String[] s = AbstractEntityBean.fetchAllDeclaredField(session.getClass(), sb).toString().split(",");
            ss = new String[openkey.length + s.length];

            for (int i = 0; i < openkey.length; i++) {
                ss[i] = openkey[i];
            }

            for (int i = 0; i < s.length; i++) {
                ss[(openkey.length + i)] = s[i];
            }
        }
        else {
            ss = openkey;
        }

        Map<String, String> rp = getParameter();
        //		String portalkey = getPortalKey();
        String portalkey = UserDataRangeSrv.getPortalkey();
        boolean iscongouportal = false;

        if ((!StringUtils.isEmpty(portalkey)) && (portalkey.equalsIgnoreCase("congou"))) {
            iscongouportal = true;
        }

        Map<String, Object> rps = getParameters(form);
        map.putAll(rps);
        Iterator iter = rp.entrySet().iterator();

        while (iter.hasNext()) {
            Map.Entry entry = (Map.Entry) iter.next();
            String key = (String) entry.getKey();

            if (!Utils.stringArrayContainsKey(ignores, key, true)) {
                String[] values = this.request.getParameterValues(key);

                if ((values != null) && (values.length > 0) && (!StringUtils.isEmpty(values[0]))) {
                    String value = values[0];

                    if ((ss != null) && (Utils.stringArrayContainsKey(ss, key, true))) {
                        if (iscongouportal) {
                            setSessionbycongou(session, key, value);
                        }
                        else {
                            setSession(session, key, value);
                        }
                    }
                    else if (((value.startsWith("{")) && (value.endsWith("}"))) || ((value.startsWith("[")) && (value.endsWith("]")))) {
                        try {
                            map.put(key, JSON.parse(value));
                        }
                        catch (Exception ex) {
                            map.put(key, value);
                        }
                    }
                    else {
                        map.put(key, value);
                    }
                }
            }
        }

        if (SpringBeanFactory.containsBean("initSession_" + portalkey)) {
            InitSession init = SpringBeanFactory.getBean("initSession_" + portalkey, InitSession.class);
            init.init(session);
        }

        return JSONObject.toJSONString(map);
    }

    private String addQueryParamToJsonParam(TaobaoSession session, String param)
    {
        Map<String, String> rp = getParameter();
        Iterator iter = rp.entrySet().iterator();
        while (iter.hasNext()) {
            Map.Entry entry = (Map.Entry) iter.next();
            String key = (String) entry.getKey();
            String[] values = request.getParameterValues(key);
            if (values != null && values.length > 0 && !StringUtils.isEmpty(values[0])) {
                String value = values[0];
                if (session == null) {
                    session = new TaobaoSession();
                }
                if ("ent_id".equalsIgnoreCase(key)) session.setEnt_id(Long.parseLong(value));
                if ("app_key".equalsIgnoreCase(key)) session.setApp_key(value);
                if ("target_appkey".equalsIgnoreCase(key)) session.setTarget_appkey(value);
                if ("source_appkey".equalsIgnoreCase(key)) session.setSource_appkey(value);
                if ("method".equalsIgnoreCase(key)) session.setMethod(value);
                if ("cmd".equalsIgnoreCase(key)) session.setCmd(value);
                if ("request_id".equalsIgnoreCase(key)) session.setRequest_id(value);
                if ("timestamp".equalsIgnoreCase(key)) session.setTimestamp(value);
                if ("format".equalsIgnoreCase(key)) session.setFormat(value);
                if ("sign_method".equalsIgnoreCase(key)) session.setSign_method(value);
                if ("sign".equalsIgnoreCase(key)) session.setSign(value);
            }
        }
        if (!StringUtils.isEmpty(param)) {
            try {
                JSONObject jsonparam = JSON.parseObject(param);
                if (jsonparam != null && jsonparam.containsKey("merchant_code")) {
                    session.setEnt_id(jsonparam.getLong("merchant_code"));
                }
            } catch (Exception ex) {
                ServiceLogs.debuglog("qimen_req", "qimen接口入参格式不正确", 0);
            }
        }
        return "";
    }

    public JSONObject checkSign(TaobaoSession session, String body)
    {
        JSONObject result = new JSONObject();
        try
        {
            String appSecretKey = EnterpriseProxy.getInstance().getEnterpriseConfig(session.getEnt_id(), "qimenAppSecretKey", true, "");
            if (appSecretKey == null)
            {
                return result;
            }
            CheckResult res = SpiUtils.checkSign(request, appSecretKey, body, "JSON");
            if (!res.isSuccess())
            {
                result.put("success", "false");
                result.put("err_code", "sign-check-failure");
                result.put("err_msg", "Illegal request");
                return result;
            }
            return result;
        }
        catch (ServiceException e) {
            ServiceLogs.errLog("Qimen_CheckSign", e, "奇门网关签名验证失败");
            result.put("success", "false");
            result.put("err_code", "sign-check-failure");
            result.put("err_msg", "Illegal request");
            return result;
        }
        catch (Exception ex)
        {
            ServiceLogs.errLog("Qimen_CheckSign", ex, "奇门网关签名验证失败");
            result.put("success", "false");
            result.put("err_code", "sign-check-failure");
            result.put("err_msg", "Illegal request");
            return result;
        }
    }
}
